import { IEventData } from "../Interfaces/Contracts/IEventData";
import { ISerializable } from "../Interfaces/Telemetry/ISerializable";
import { FieldType } from "../Enums";
import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
export declare class Event implements IEventData, ISerializable {
    static envelopeType: string;
    static dataType: string;
    aiDataContract: {
        ver: FieldType;
        name: FieldType;
        properties: FieldType;
        measurements: FieldType;
    };
    /**
     * Schema version
     */
    ver: number;
    /**
     * Event name. Keep it low cardinality to allow proper grouping and useful metrics.
     */
    name: string;
    /**
     * Collection of custom properties.
     */
    properties: any;
    /**
     * Collection of custom measurements.
     */
    measurements: any;
    /**
     * Constructs a new instance of the EventTelemetry object
     */
    constructor(logger: IDiagnosticLogger, name: string, properties?: any, measurements?: any);
}
