import { IDataPoint } from "../../Interfaces/Contracts/IDataPoint";
import { ISerializable } from "../../Interfaces/Telemetry/ISerializable";
import { FieldType } from "../../Enums";
import { DataPointType } from "../../Interfaces/Contracts/DataPointType";
export declare class DataPoint implements IDataPoint, ISerializable {
    /**
     * The data contract for serializing this object.
     */
    aiDataContract: {
        name: FieldType;
        kind: FieldType;
        value: FieldType;
        count: FieldType;
        min: FieldType;
        max: FieldType;
        stdDev: FieldType;
    };
    /**
     * Name of the metric.
     */
    name: string;
    /**
     * Metric type. Single measurement or the aggregated value.
     */
    kind: DataPointType;
    /**
     * Single value for measurement. Sum of individual measurements for the aggregation.
     */
    value: number;
    /**
     * Metric weight of the aggregated metric. Should not be set for a measurement.
     */
    count: number;
    /**
     * Minimum value of the aggregated metric. Should not be set for a measurement.
     */
    min: number;
    /**
     * Maximum value of the aggregated metric. Should not be set for a measurement.
     */
    max: number;
    /**
     * Standard deviation of the aggregated metric. Should not be set for a measurement.
     */
    stdDev: number;
}
