export interface IRequestHeaders {
    /**
     * Request-Context header
     */
    requestContextHeader: string;
    /**
     * Target instrumentation header that is added to the response and retrieved by the
     * calling application when processing incoming responses.
     */
    requestContextTargetKey: string;
    /**
     * Request-Context appId format
     */
    requestContextAppIdFormat: string;
    /**
     * Request-Id header
     */
    requestIdHeader: string;
    /**
     * W3C distributed tracing protocol header
     */
    traceParentHeader: string;
    /**
     * W3C distributed tracing protocol state header
     */
    traceStateHeader: string;
    /**
     * Sdk-Context header
     * If this header passed with appId in content then appId will be returned back by the backend.
     */
    sdkContextHeader: string;
    /**
     * String to pass in header for requesting appId back from the backend.
     */
    sdkContextHeaderAppIdRequest: string;
    requestContextHeaderLowerCase: string;
}
export declare const enum eRequestHeaders {
    requestContextHeader = 0,
    requestContextTargetKey = 1,
    requestContextAppIdFormat = 2,
    requestIdHeader = 3,
    traceParentHeader = 4,
    traceStateHeader = 5,
    sdkContextHeader = 6,
    sdkContextHeaderAppIdRequest = 7,
    requestContextHeaderLowerCase = 8
}
export declare const RequestHeaders: IRequestHeaders & {
    requestContextHeader: "Request-Context";
    requestContextTargetKey: "appId";
    requestContextAppIdFormat: "appId=cid-v1:";
    requestIdHeader: "Request-Id";
    traceParentHeader: "traceparent";
    traceStateHeader: "tracestate";
    sdkContextHeader: "Sdk-Context";
    sdkContextHeaderAppIdRequest: "appId";
    requestContextHeaderLowerCase: "request-context";
    0: "Request-Context";
    1: "appId";
    2: "appId=cid-v1:";
    3: "Request-Id";
    4: "traceparent";
    5: "tracestate";
    6: "Sdk-Context";
    7: "appId";
    8: "request-context";
};
