/*
 * Application Insights JavaScript SDK - Common, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { dataSanitizeString } from "./Telemetry/Common/DataSanitizer";
import { objForEachKey, isNullOrUndefined, toISOString, throwError } from "@microsoft/applicationinsights-core-js";
import { strNotSpecified, strIkey } from "./Constants";
/**
 * Create a telemetry item that the 1DS channel understands
 * @param item domain specific properties; part B
 * @param baseType telemetry item type. ie PageViewData
 * @param envelopeName name of the envelope. ie Microsoft.ApplicationInsights.<instrumentation key>.PageView
 * @param customProperties user defined custom properties; part C
 * @param systemProperties system properties that are added to the context; part A
 * @returns ITelemetryItem that is sent to channel
 */
export function createTelemetryItem(item, baseType, envelopeName, logger, customProperties, systemProperties) {
    envelopeName = dataSanitizeString(logger, envelopeName) || strNotSpecified;
    if (isNullOrUndefined(item) ||
        isNullOrUndefined(baseType) ||
        isNullOrUndefined(envelopeName)) {
        throwError("Input doesn't contain all required fields");
    }
    var iKey = "";
    if (item[strIkey]) {
        iKey = item[strIkey];
        delete item[strIkey];
    }
    var telemetryItem = {
        name: envelopeName,
        time: toISOString(new Date()),
        iKey: iKey,
        ext: systemProperties ? systemProperties : {},
        tags: [],
        data: {},
        baseType: baseType,
        baseData: item // Part B
    };
    // Part C
    if (!isNullOrUndefined(customProperties)) {
        objForEachKey(customProperties, function (prop, value) {
            telemetryItem.data[prop] = value;
        });
    }
    return telemetryItem;
}
var TelemetryItemCreator = /** @class */ (function () {
    function TelemetryItemCreator() {
    }
    /**
     * Create a telemetry item that the 1DS channel understands
     * @param item domain specific properties; part B
     * @param baseType telemetry item type. ie PageViewData
     * @param envelopeName name of the envelope. ie Microsoft.ApplicationInsights.<instrumentation key>.PageView
     * @param customProperties user defined custom properties; part C
     * @param systemProperties system properties that are added to the context; part A
     * @returns ITelemetryItem that is sent to channel
     */
    TelemetryItemCreator.create = createTelemetryItem;
    return TelemetryItemCreator;
}());
export { TelemetryItemCreator };
//# sourceMappingURL=TelemetryItemCreator.js.map