/*
 * Application Insights JavaScript SDK - Common, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { dataSanitizeString, dataSanitizeProperties, dataSanitizeMeasurements } from "./Common/DataSanitizer";
import { strNotSpecified } from "../Constants";
var Event = /** @class */ (function () {
    /**
     * Constructs a new instance of the EventTelemetry object
     */
    function Event(logger, name, properties, measurements) {
        this.aiDataContract = {
            ver: 1 /* FieldType.Required */,
            name: 1 /* FieldType.Required */,
            properties: 0 /* FieldType.Default */,
            measurements: 0 /* FieldType.Default */
        };
        var _self = this;
        _self.ver = 2;
        _self.name = dataSanitizeString(logger, name) || strNotSpecified;
        _self.properties = dataSanitizeProperties(logger, properties);
        _self.measurements = dataSanitizeMeasurements(logger, measurements);
    }
    Event.envelopeType = "Microsoft.ApplicationInsights.{0}.Event";
    Event.dataType = "EventData";
    return Event;
}());
export { Event };
//# sourceMappingURL=Event.js.map