/*
 * Microsoft Application Insights JavaScript SDK Channel, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 *
 * Microsoft Application Insights Team
 * https://github.com/microsoft/ApplicationInsights-JS#readme
 *
 * ---------------------------------------------------------------------------
 * This is a single combined (rollup) declaration file for the package,
 * use this version if your build environment doesn't support the using the
 * individual *.d.ts files or default namespace wrapped version.
 * - Namespaced version: applicationinsights-channel-js.d.ts
 * ---------------------------------------------------------------------------
 */

import { BaseTelemetryPlugin } from '@microsoft/applicationinsights-core-js';
import { IAppInsightsCore } from '@microsoft/applicationinsights-core-js';
import { IChannelControlsAI } from '@microsoft/applicationinsights-common';
import { IConfig } from '@microsoft/applicationinsights-common';
import { IConfiguration } from '@microsoft/applicationinsights-core-js';
import { IDiagnosticLogger } from '@microsoft/applicationinsights-core-js';
import { IEnvelope } from '@microsoft/applicationinsights-common';
import { IPlugin } from '@microsoft/applicationinsights-core-js';
import { IProcessTelemetryContext } from '@microsoft/applicationinsights-core-js';
import { ISample } from '@microsoft/applicationinsights-common';
import { ITelemetryItem } from '@microsoft/applicationinsights-core-js';
import { ITelemetryPluginChain } from '@microsoft/applicationinsights-core-js';
import { SendRequestReason } from '@microsoft/applicationinsights-core-js';

declare interface IBackendResponse {
    /**
     * Number of items received by the backend
     */
    readonly itemsReceived: number;
    /**
     * Number of items succesfuly accepted by the backend
     */
    readonly itemsAccepted: number;
    /**
     * List of errors for items which were not accepted
     */
    readonly errors: IResponseError[];
    /**
     * App id returned by the backend - not necessary returned, but we don't need it with each response.
     */
    readonly appId?: string;
}

declare interface IResponseError {
    readonly index: number;
    readonly statusCode: number;
    readonly message: string;
}

declare interface ISendBuffer {
    /**
     * Enqueue the payload
     */
    enqueue: (payload: string) => void;
    /**
     * Returns the number of elements in the buffer
     */
    count: () => number;
    /**
     * Returns the current size of the serialized buffer
     */
    size: () => number;
    /**
     * Clears the buffer
     */
    clear: () => void;
    /**
     * Returns items stored in the buffer
     */
    getItems: () => string[];
    /**
     * Build a batch of all elements in the payload array
     */
    batchPayloads: (payload: string[]) => string;
    /**
     * Moves items to the SENT_BUFFER.
     * The buffer holds items which were sent, but we haven't received any response from the backend yet.
     */
    markAsSent: (payload: string[]) => void;
    /**
     * Removes items from the SENT_BUFFER. Should be called on successful response from the backend.
     */
    clearSent: (payload: string[]) => void;
}

declare interface ISenderConfig {
    /**
     * The url to which payloads will be sent
     */
    endpointUrl: () => string;
    /**
     * The JSON format (normal vs line delimited). True means line delimited JSON.
     */
    emitLineDelimitedJson: () => boolean;
    /**
     * The maximum size of a batch in bytes
     */
    maxBatchSizeInBytes: () => number;
    /**
     * The maximum interval allowed between calls to batchInvoke
     */
    maxBatchInterval: () => number;
    /**
     * The master off switch.  Do not send any data if set to TRUE
     */
    disableTelemetry: () => boolean;
    /**
     * Store a copy of a send buffer in the session storage
     */
    enableSessionStorageBuffer: () => boolean;
    /**
     * Is retry handler disabled.
     * If enabled, retry on 206 (partial success), 408 (timeout), 429 (too many requests), 500 (internal server error) and 503 (service unavailable).
     */
    isRetryDisabled: () => boolean;
    isBeaconApiDisabled: () => boolean;
    /**
     * Don't use XMLHttpRequest or XDomainRequest (for IE < 9) by default instead attempt to use fetch() or sendBeacon.
     * If no other transport is available it will still use XMLHttpRequest
     */
    disableXhr: () => boolean;
    /**
     * If fetch keepalive is supported do not use it for sending events during unload, it may still fallback to fetch() without keepalive
     */
    onunloadDisableFetch: () => boolean;
    /**
     * Is beacon disabled on page unload.
     * If enabled, flush events through beaconSender.
     */
    onunloadDisableBeacon: () => boolean;
    /**
     * (Optional) Override the instrumentation key that this channel instance sends to
     */
    instrumentationKey: () => string;
    namePrefix: () => string;
    samplingPercentage: () => number;
    /**
     * (Optional) The ability for the user to provide extra headers
     */
    customHeaders: () => [{
        header: string;
        value: string;
    }];
    /**
     * (Optional) Provide user an option to convert undefined field to user defined value.
     */
    convertUndefined: () => any;
    /**
     * (Optional) The number of events that can be kept in memory before the SDK starts to drop events. By default, this is 10,000.
     */
    eventsLimitInMem: () => number;
}

export declare class Sender extends BaseTelemetryPlugin implements IChannelControlsAI {
    static constructEnvelope(orig: ITelemetryItem, iKey: string, logger: IDiagnosticLogger, convertUndefined?: any): IEnvelope;
    readonly priority: number;
    readonly identifier: string;
    /**
     * The configuration for this sender instance
     */
    readonly _senderConfig: ISenderConfig;
    /**
     * A method which will cause data to be send to the url
     */
    _sender: SenderFunction;
    /**
     * A send buffer object
     */
    _buffer: ISendBuffer;
    /**
     * AppId of this component parsed from some backend response.
     */
    _appId: string;
    protected _sample: ISample;
    constructor();
    /**
     * Pause the sending (transmission) of events, this will cause all events to be batched only until the maximum limits are
     * hit at which point new events are dropped. Will also cause events to NOT be sent during page unload, so if Session storage
     * is disabled events will be lost.
     * SessionStorage Limit is 2000 events, In-Memory (Array) Storage is 10,000 events (can be configured via the eventsLimitInMem).
     */
    pause(): void;
    /**
     * Resume the sending (transmission) of events, this will restart the timer and any batched events will be sent using the normal
     * send interval.
     */
    resume(): void;
    /**
     * Flush the batched events immediately (not synchronously).
     * Will not flush if the Sender has been paused.
     */
    flush(): void;
    /**
     * Flush the batched events synchronously (if possible -- based on configuration).
     * Will not flush if the Send has been paused.
     */
    onunloadFlush(): void;
    initialize(config: IConfiguration & IConfig, core: IAppInsightsCore, extensions: IPlugin[], pluginChain?: ITelemetryPluginChain): void;
    processTelemetry(telemetryItem: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
    /**
     * xhr state changes
     */
    _xhrReadyStateChange(xhr: XMLHttpRequest, payload: string[], countOfItemsInPayload: number): void;
    /**
     * Immediately send buffered data
     * @param async {boolean} - Indicates if the events should be sent asynchronously
     * @param forcedSender {SenderFunction} - Indicates the forcedSender, undefined if not passed
     */
    triggerSend(async?: boolean, forcedSender?: SenderFunction, sendReason?: SendRequestReason): void;
    /**
     * error handler
     */
    _onError(payload: string[], message: string, event?: ErrorEvent): void;
    /**
     * partial success handler
     */
    _onPartialSuccess(payload: string[], results: IBackendResponse): void;
    /**
     * success handler
     */
    _onSuccess(payload: string[], countOfItemsInPayload: number): void;
    /**
     * xdr state changes
     */
    _xdrOnLoad(xdr: XDomainRequest, payload: string[]): void;
    /**
     * Add header to request
     * @param name   - Header name.
     * @param value  - Header value.
     */
    addHeader(name: string, value: string): void;
}

declare type SenderFunction = (payload: string[], isAsync: boolean) => void;

declare interface XDomainRequest extends XMLHttpRequestEventTarget {
    readonly responseText: string;
    send(payload: string): void;
    open(method: string, url: string): void;
}

export { }