/*!
 * Application Insights JavaScript SDK - Channel, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */
(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
    typeof define === 'function' && define.amd ? define(['exports'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory((global.Microsoft = global.Microsoft || {}, global.Microsoft.ApplicationInsights = global.Microsoft.ApplicationInsights || {})));
})(this, (function (exports) { 'use strict';

    var strShimFunction = "function";
    var strShimObject = "object";
    var strShimUndefined = "undefined";
    var strShimPrototype = "prototype";
    var strShimHasOwnProperty = "hasOwnProperty";
    var ObjClass = Object;
    var ObjProto = ObjClass[strShimPrototype];
    var ObjAssign = ObjClass["assign"];
    var ObjCreate = ObjClass["create"];
    var ObjDefineProperty = ObjClass["defineProperty"];
    var ObjHasOwnProperty = ObjProto[strShimHasOwnProperty];

    var _cachedGlobal = null;
    function getGlobal(useCached) {
        if (useCached === void 0) { useCached = true; }
        if (!_cachedGlobal || !useCached) {
            if (typeof globalThis !== strShimUndefined && globalThis) {
                _cachedGlobal = globalThis;
            }
            if (typeof self !== strShimUndefined && self) {
                _cachedGlobal = self;
            }
            if (typeof window !== strShimUndefined && window) {
                _cachedGlobal = window;
            }
            if (typeof global !== strShimUndefined && global) {
                _cachedGlobal = global;
            }
        }
        return _cachedGlobal;
    }
    function throwTypeError(message) {
        throw new TypeError(message);
    }
    function objCreateFn(obj) {
        var func = ObjCreate;
        if (func) {
            return func(obj);
        }
        if (obj == null) {
            return {};
        }
        var type = typeof obj;
        if (type !== strShimObject && type !== strShimFunction) {
            throwTypeError("Object prototype may only be an Object:" + obj);
        }
        function tmpFunc() { }
        tmpFunc[strShimPrototype] = obj;
        return new tmpFunc();
    }

    (getGlobal() || {})["Symbol"];
    (getGlobal() || {})["Reflect"];
    var __objAssignFnImpl = function (t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) {
                if (ObjProto[strShimHasOwnProperty].call(s, p)) {
                    t[p] = s[p];
                }
            }
        }
        return t;
    };
    var __assignFn = ObjAssign || __objAssignFnImpl;
    var extendStaticsFn = function (d, b) {
        extendStaticsFn = ObjClass["setPrototypeOf"] ||
            ({ __proto__: [] } instanceof Array && function (d, b) {
                d.__proto__ = b;
            }) ||
            function (d, b) {
                for (var p in b) {
                    if (b[strShimHasOwnProperty](p)) {
                        d[p] = b[p];
                    }
                }
            };
        return extendStaticsFn(d, b);
    };
    function __extendsFn(d, b) {
        if (typeof b !== strShimFunction && b !== null) {
            throwTypeError("Class extends value " + String(b) + " is not a constructor or null");
        }
        extendStaticsFn(d, b);
        function __() {
            this.constructor = d;
        }
        d[strShimPrototype] = b === null ? objCreateFn(b) : (__[strShimPrototype] = b[strShimPrototype], new __());
    }

    var strEmpty$1 = "";
    var strSetNextPlugin = "setNextPlugin";
    var strIsInitialized = "isInitialized";
    var strTeardown = "teardown";
    var strCore = "core";
    var strUpdate = "update";
    var strDisabled = "disabled";
    var strDoTeardown = "_doTeardown";

    var strToISOString = "toISOString";
    var strIndexOf = "indexOf";
    var strMap = "map";
    var cStrTrim = "trim";
    var strToString = "toString";
    var str__Proto$1 = "__proto__";
    var strConstructor = "constructor";
    var _objDefineProperty$1 = ObjDefineProperty;
    var _objFreeze = ObjClass.freeze;
    var _objKeys = ObjClass.keys;
    var StringProto = String[strShimPrototype];
    var _strTrim = StringProto[cStrTrim];
    var DateProto = Date[strShimPrototype];
    var _dataToISOString = DateProto[strToISOString];
    var _isArray = Array.isArray;
    var _objToString = ObjProto[strToString];
    var _fnToString = ObjHasOwnProperty[strToString];
    var _objFunctionString = _fnToString.call(ObjClass);
    var rCamelCase = /-([a-z])/g;
    var rNormalizeInvalid = /([^\w\d_$])/g;
    var rLeadingNumeric = /^(\d+[\w\d_$])/;
    var _objGetPrototypeOf$1 = Object["getPrototypeOf"];
    function _getObjProto$1(target) {
        if (target) {
            if (_objGetPrototypeOf$1) {
                return _objGetPrototypeOf$1(target);
            }
            var newProto = target[str__Proto$1] || target[strShimPrototype] || target[strConstructor];
            if (newProto) {
                return newProto;
            }
        }
        return null;
    }
    function isUndefined(value) {
        return value === undefined || typeof value === strShimUndefined;
    }
    function isNullOrUndefined(value) {
        return (value === null || isUndefined(value));
    }
    function isObject(value) {
        return !!(value && typeof value === strShimObject);
    }
    function isFunction(value) {
        return !!(value && typeof value === strShimFunction);
    }
    function normalizeJsName(name) {
        var value = name;
        if (value && isString(value)) {
            value = value.replace(rCamelCase, function (_all, letter) {
                return letter.toUpperCase();
            });
            value = value.replace(rNormalizeInvalid, "_");
            value = value.replace(rLeadingNumeric, function (_all, match) {
                return "_" + match;
            });
        }
        return value;
    }
    function objForEachKey(target, callbackfn) {
        if (target) {
            for (var prop in target) {
                if (ObjHasOwnProperty.call(target, prop)) {
                    callbackfn.call(target, prop, target[prop]);
                }
            }
        }
    }
    function strContains(value, search) {
        if (value && search) {
            return value.indexOf(search) !== -1;
        }
        return false;
    }
    var isArray = _isArray || _isArrayPoly;
    function _isArrayPoly(obj) {
        return !!(obj && _objToString.call(obj) === "[object Array]");
    }
    function isError(obj) {
        return !!(obj && _objToString.call(obj) === "[object Error]");
    }
    function isString(value) {
        return typeof value === "string";
    }
    function isNumber(value) {
        return typeof value === "number";
    }
    function isBoolean(value) {
        return typeof value === "boolean";
    }
    function isPlainObject(value) {
        var result = false;
        if (value && typeof value === "object") {
            var proto = _objGetPrototypeOf$1 ? _objGetPrototypeOf$1(value) : _getObjProto$1(value);
            if (!proto) {
                result = true;
            }
            else {
                if (proto[strConstructor] && ObjHasOwnProperty.call(proto, strConstructor)) {
                    proto = proto[strConstructor];
                }
                result = typeof proto === strShimFunction && _fnToString.call(proto) === _objFunctionString;
            }
        }
        return result;
    }
    function toISOString(date) {
        if (date) {
            return _dataToISOString ? date[strToISOString]() : _toISOStringPoly(date);
        }
    }
    function _toISOStringPoly(date) {
        if (date && date.getUTCFullYear) {
            var pad = function (num) {
                var r = String(num);
                if (r.length === 1) {
                    r = "0" + r;
                }
                return r;
            };
            return date.getUTCFullYear()
                + "-" + pad(date.getUTCMonth() + 1)
                + "-" + pad(date.getUTCDate())
                + "T" + pad(date.getUTCHours())
                + ":" + pad(date.getUTCMinutes())
                + ":" + pad(date.getUTCSeconds())
                + "." + String((date.getUTCMilliseconds() / 1000).toFixed(3)).slice(2, 5)
                + "Z";
        }
    }
    function arrForEach(arr, callbackfn, thisArg) {
        var len = arr.length;
        try {
            for (var idx = 0; idx < len; idx++) {
                if (idx in arr) {
                    if (callbackfn.call(thisArg || arr, arr[idx], idx, arr) === -1) {
                        break;
                    }
                }
            }
        }
        catch (e) {
        }
    }
    function arrIndexOf(arr, searchElement, fromIndex) {
        if (arr) {
            if (arr[strIndexOf]) {
                return arr[strIndexOf](searchElement, fromIndex);
            }
            var len = arr.length;
            var from = fromIndex || 0;
            try {
                for (var lp = Math.max(from >= 0 ? from : len - Math.abs(from), 0); lp < len; lp++) {
                    if (lp in arr && arr[lp] === searchElement) {
                        return lp;
                    }
                }
            }
            catch (e) {
            }
        }
        return -1;
    }
    function arrMap(arr, callbackfn, thisArg) {
        var results;
        if (arr) {
            if (arr[strMap]) {
                return arr[strMap](callbackfn, thisArg);
            }
            var len = arr.length;
            var _this = thisArg || arr;
            results = new Array(len);
            try {
                for (var lp = 0; lp < len; lp++) {
                    if (lp in arr) {
                        results[lp] = callbackfn.call(_this, arr[lp], arr);
                    }
                }
            }
            catch (e) {
            }
        }
        return results;
    }
    function strTrim(str) {
        if (str) {
            str = (_strTrim && str[cStrTrim]) ? str[cStrTrim]() : (str.replace ? str.replace(/^\s+|\s+$/g, "") : str);
        }
        return str;
    }
    var _objKeysHasDontEnumBug = !({ toString: null }).propertyIsEnumerable("toString");
    var _objKeysDontEnums = [
        "toString",
        "toLocaleString",
        "valueOf",
        "hasOwnProperty",
        "isPrototypeOf",
        "propertyIsEnumerable",
        "constructor"
    ];
    function objKeys(obj) {
        var objType = typeof obj;
        if (objType !== strShimFunction && (objType !== strShimObject || obj === null)) {
            throwTypeError("objKeys called on non-object");
        }
        if (!_objKeysHasDontEnumBug && _objKeys) {
            return _objKeys(obj);
        }
        var result = [];
        for (var prop in obj) {
            if (obj && ObjHasOwnProperty.call(obj, prop)) {
                result.push(prop);
            }
        }
        if (_objKeysHasDontEnumBug) {
            var dontEnumsLength = _objKeysDontEnums.length;
            for (var lp = 0; lp < dontEnumsLength; lp++) {
                if (obj && ObjHasOwnProperty.call(obj, _objKeysDontEnums[lp])) {
                    result.push(_objKeysDontEnums[lp]);
                }
            }
        }
        return result;
    }
    function objDefineAccessors(target, prop, getProp, setProp) {
        if (_objDefineProperty$1) {
            try {
                var descriptor = {
                    enumerable: true,
                    configurable: true
                };
                if (getProp) {
                    descriptor.get = getProp;
                }
                if (setProp) {
                    descriptor.set = setProp;
                }
                _objDefineProperty$1(target, prop, descriptor);
                return true;
            }
            catch (e) {
            }
        }
        return false;
    }
    function _doNothing(value) {
        return value;
    }
    function deepFreeze(obj) {
        if (_objFreeze) {
            objForEachKey(obj, function (name, value) {
                if (isArray(value) || isObject(value)) {
                    _objFreeze(value);
                }
            });
        }
        return objFreeze(obj);
    }
    var objFreeze = _objFreeze || _doNothing;
    function dateNow() {
        var dt = Date;
        return dt.now ? dt.now() : new dt().getTime();
    }
    function getExceptionName(object) {
        if (isError(object)) {
            return object.name;
        }
        return strEmpty$1;
    }
    function setValue(target, field, value, valChk, srcChk) {
        var theValue = value;
        if (target) {
            theValue = target[field];
            if (theValue !== value && (!srcChk || srcChk(theValue)) && (!valChk || valChk(value))) {
                theValue = value;
                target[field] = theValue;
            }
        }
        return theValue;
    }
    function isTruthy(value) {
        return !!value;
    }
    function _createProxyFunction(source, funcName) {
        var srcFunc = null;
        var src = null;
        if (isFunction(source)) {
            srcFunc = source;
        }
        else {
            src = source;
        }
        return function () {
            var originalArguments = arguments;
            if (srcFunc) {
                src = srcFunc();
            }
            if (src) {
                return src[funcName].apply(src, originalArguments);
            }
        };
    }
    function proxyFunctionAs(target, name, source, theFunc, overwriteTarget) {
        if (target && name && source) {
            if (overwriteTarget !== false || isUndefined(target[name])) {
                target[name] = _createProxyFunction(source, theFunc);
            }
        }
    }
    function createClassFromInterface(defaults) {
        return /** @class */ (function () {
            function class_1() {
                var _this_1 = this;
                if (defaults) {
                    objForEachKey(defaults, function (field, value) {
                        _this_1[field] = value;
                    });
                }
            }
            return class_1;
        }());
    }
    function optimizeObject(theObject) {
        if (theObject && ObjAssign) {
            theObject = ObjClass(ObjAssign({}, theObject));
        }
        return theObject;
    }
    function objExtend(obj1, obj2, obj3, obj4, obj5, obj6) {
        var theArgs = arguments;
        var extended = theArgs[0] || {};
        var argLen = theArgs.length;
        var deep = false;
        var idx = 1;
        if (argLen > 0 && isBoolean(extended)) {
            deep = extended;
            extended = theArgs[idx] || {};
            idx++;
        }
        if (!isObject(extended)) {
            extended = {};
        }
        for (; idx < argLen; idx++) {
            var arg = theArgs[idx];
            var isArgArray = isArray(arg);
            var isArgObj = isObject(arg);
            for (var prop in arg) {
                var propOk = (isArgArray && (prop in arg)) || (isArgObj && (ObjHasOwnProperty.call(arg, prop)));
                if (!propOk) {
                    continue;
                }
                var newValue = arg[prop];
                var isNewArray = void 0;
                if (deep && newValue && ((isNewArray = isArray(newValue)) || isPlainObject(newValue))) {
                    var clone = extended[prop];
                    if (isNewArray) {
                        if (!isArray(clone)) {
                            clone = [];
                        }
                    }
                    else if (!isPlainObject(clone)) {
                        clone = {};
                    }
                    newValue = objExtend(deep, clone, newValue);
                }
                if (newValue !== undefined) {
                    extended[prop] = newValue;
                }
            }
        }
        return extended;
    }

    function createEnumStyle(values) {
        var enumClass = {};
        objForEachKey(values, function (field, value) {
            enumClass[field] = value;
            enumClass[value] = field;
        });
        return deepFreeze(enumClass);
    }
    function createValueMap(values) {
        var mapClass = {};
        objForEachKey(values, function (field, value) {
            mapClass[field] = value[1];
            mapClass[value[0]] = value[1];
        });
        return deepFreeze(mapClass);
    }

    /*!
     * Microsoft Dynamic Proto Utility, 1.1.6
     * Copyright (c) Microsoft and contributors. All rights reserved.
     */
    var Constructor = 'constructor';
    var Prototype = 'prototype';
    var strFunction = 'function';
    var DynInstFuncTable = '_dynInstFuncs';
    var DynProxyTag = '_isDynProxy';
    var DynClassName = '_dynClass';
    var DynClassNamePrefix = '_dynCls$';
    var DynInstChkTag = '_dynInstChk';
    var DynAllowInstChkTag = DynInstChkTag;
    var DynProtoDefaultOptions = '_dfOpts';
    var UnknownValue = '_unknown_';
    var str__Proto = "__proto__";
    var DynProtoBaseProto = "_dyn" + str__Proto;
    var DynProtoCurrent = "_dynInstProto";
    var strUseBaseInst = 'useBaseInst';
    var strSetInstFuncs = 'setInstFuncs';
    var Obj = Object;
    var _objGetPrototypeOf = Obj["getPrototypeOf"];
    var _objGetOwnProps = Obj["getOwnPropertyNames"];
    var _dynamicNames = 0;
    function _hasOwnProperty(obj, prop) {
        return obj && Obj[Prototype].hasOwnProperty.call(obj, prop);
    }
    function _isObjectOrArrayPrototype(target) {
        return target && (target === Obj[Prototype] || target === Array[Prototype]);
    }
    function _isObjectArrayOrFunctionPrototype(target) {
        return _isObjectOrArrayPrototype(target) || target === Function[Prototype];
    }
    function _getObjProto(target) {
        var newProto;
        if (target) {
            if (_objGetPrototypeOf) {
                return _objGetPrototypeOf(target);
            }
            var curProto = target[str__Proto] || target[Prototype] || (target[Constructor] ? target[Constructor][Prototype] : null);
            newProto = target[DynProtoBaseProto] || curProto;
            if (!_hasOwnProperty(target, DynProtoBaseProto)) {
                delete target[DynProtoCurrent];
                newProto = target[DynProtoBaseProto] = target[DynProtoCurrent] || target[DynProtoBaseProto];
                target[DynProtoCurrent] = curProto;
            }
        }
        return newProto;
    }
    function _forEachProp(target, func) {
        var props = [];
        if (_objGetOwnProps) {
            props = _objGetOwnProps(target);
        }
        else {
            for (var name_1 in target) {
                if (typeof name_1 === "string" && _hasOwnProperty(target, name_1)) {
                    props.push(name_1);
                }
            }
        }
        if (props && props.length > 0) {
            for (var lp = 0; lp < props.length; lp++) {
                func(props[lp]);
            }
        }
    }
    function _isDynamicCandidate(target, funcName, skipOwn) {
        return (funcName !== Constructor && typeof target[funcName] === strFunction && (skipOwn || _hasOwnProperty(target, funcName)));
    }
    function _throwTypeError(message) {
        throw new TypeError("DynamicProto: " + message);
    }
    function _getInstanceFuncs(thisTarget) {
        var instFuncs = {};
        _forEachProp(thisTarget, function (name) {
            if (!instFuncs[name] && _isDynamicCandidate(thisTarget, name, false)) {
                instFuncs[name] = thisTarget[name];
            }
        });
        return instFuncs;
    }
    function _hasVisited(values, value) {
        for (var lp = values.length - 1; lp >= 0; lp--) {
            if (values[lp] === value) {
                return true;
            }
        }
        return false;
    }
    function _getBaseFuncs(classProto, thisTarget, instFuncs, useBaseInst) {
        function _instFuncProxy(target, funcHost, funcName) {
            var theFunc = funcHost[funcName];
            if (theFunc[DynProxyTag] && useBaseInst) {
                var instFuncTable = target[DynInstFuncTable] || {};
                if (instFuncTable[DynAllowInstChkTag] !== false) {
                    theFunc = (instFuncTable[funcHost[DynClassName]] || {})[funcName] || theFunc;
                }
            }
            return function () {
                return theFunc.apply(target, arguments);
            };
        }
        var baseFuncs = {};
        _forEachProp(instFuncs, function (name) {
            baseFuncs[name] = _instFuncProxy(thisTarget, instFuncs, name);
        });
        var baseProto = _getObjProto(classProto);
        var visited = [];
        while (baseProto && !_isObjectArrayOrFunctionPrototype(baseProto) && !_hasVisited(visited, baseProto)) {
            _forEachProp(baseProto, function (name) {
                if (!baseFuncs[name] && _isDynamicCandidate(baseProto, name, !_objGetPrototypeOf)) {
                    baseFuncs[name] = _instFuncProxy(thisTarget, baseProto, name);
                }
            });
            visited.push(baseProto);
            baseProto = _getObjProto(baseProto);
        }
        return baseFuncs;
    }
    function _getInstFunc(target, funcName, proto, currentDynProtoProxy) {
        var instFunc = null;
        if (target && _hasOwnProperty(proto, DynClassName)) {
            var instFuncTable = target[DynInstFuncTable] || {};
            instFunc = (instFuncTable[proto[DynClassName]] || {})[funcName];
            if (!instFunc) {
                _throwTypeError("Missing [" + funcName + "] " + strFunction);
            }
            if (!instFunc[DynInstChkTag] && instFuncTable[DynAllowInstChkTag] !== false) {
                var canAddInst = !_hasOwnProperty(target, funcName);
                var objProto = _getObjProto(target);
                var visited = [];
                while (canAddInst && objProto && !_isObjectArrayOrFunctionPrototype(objProto) && !_hasVisited(visited, objProto)) {
                    var protoFunc = objProto[funcName];
                    if (protoFunc) {
                        canAddInst = (protoFunc === currentDynProtoProxy);
                        break;
                    }
                    visited.push(objProto);
                    objProto = _getObjProto(objProto);
                }
                try {
                    if (canAddInst) {
                        target[funcName] = instFunc;
                    }
                    instFunc[DynInstChkTag] = 1;
                }
                catch (e) {
                    instFuncTable[DynAllowInstChkTag] = false;
                }
            }
        }
        return instFunc;
    }
    function _getProtoFunc(funcName, proto, currentDynProtoProxy) {
        var protoFunc = proto[funcName];
        if (protoFunc === currentDynProtoProxy) {
            protoFunc = _getObjProto(proto)[funcName];
        }
        if (typeof protoFunc !== strFunction) {
            _throwTypeError("[" + funcName + "] is not a " + strFunction);
        }
        return protoFunc;
    }
    function _populatePrototype(proto, className, target, baseInstFuncs, setInstanceFunc) {
        function _createDynamicPrototype(proto, funcName) {
            var dynProtoProxy = function () {
                var instFunc = _getInstFunc(this, funcName, proto, dynProtoProxy) || _getProtoFunc(funcName, proto, dynProtoProxy);
                return instFunc.apply(this, arguments);
            };
            dynProtoProxy[DynProxyTag] = 1;
            return dynProtoProxy;
        }
        if (!_isObjectOrArrayPrototype(proto)) {
            var instFuncTable = target[DynInstFuncTable] = target[DynInstFuncTable] || {};
            var instFuncs_1 = instFuncTable[className] = (instFuncTable[className] || {});
            if (instFuncTable[DynAllowInstChkTag] !== false) {
                instFuncTable[DynAllowInstChkTag] = !!setInstanceFunc;
            }
            _forEachProp(target, function (name) {
                if (_isDynamicCandidate(target, name, false) && target[name] !== baseInstFuncs[name]) {
                    instFuncs_1[name] = target[name];
                    delete target[name];
                    if (!_hasOwnProperty(proto, name) || (proto[name] && !proto[name][DynProxyTag])) {
                        proto[name] = _createDynamicPrototype(proto, name);
                    }
                }
            });
        }
    }
    function _checkPrototype(classProto, thisTarget) {
        if (_objGetPrototypeOf) {
            var visited = [];
            var thisProto = _getObjProto(thisTarget);
            while (thisProto && !_isObjectArrayOrFunctionPrototype(thisProto) && !_hasVisited(visited, thisProto)) {
                if (thisProto === classProto) {
                    return true;
                }
                visited.push(thisProto);
                thisProto = _getObjProto(thisProto);
            }
            return false;
        }
        return true;
    }
    function _getObjName(target, unknownValue) {
        if (_hasOwnProperty(target, Prototype)) {
            return target.name || unknownValue || UnknownValue;
        }
        return (((target || {})[Constructor]) || {}).name || unknownValue || UnknownValue;
    }
    function dynamicProto(theClass, target, delegateFunc, options) {
        if (!_hasOwnProperty(theClass, Prototype)) {
            _throwTypeError("theClass is an invalid class definition.");
        }
        var classProto = theClass[Prototype];
        if (!_checkPrototype(classProto, target)) {
            _throwTypeError("[" + _getObjName(theClass) + "] is not in class hierarchy of [" + _getObjName(target) + "]");
        }
        var className = null;
        if (_hasOwnProperty(classProto, DynClassName)) {
            className = classProto[DynClassName];
        }
        else {
            className = DynClassNamePrefix + _getObjName(theClass, "_") + "$" + _dynamicNames;
            _dynamicNames++;
            classProto[DynClassName] = className;
        }
        var perfOptions = dynamicProto[DynProtoDefaultOptions];
        var useBaseInst = !!perfOptions[strUseBaseInst];
        if (useBaseInst && options && options[strUseBaseInst] !== undefined) {
            useBaseInst = !!options[strUseBaseInst];
        }
        var instFuncs = _getInstanceFuncs(target);
        var baseFuncs = _getBaseFuncs(classProto, target, instFuncs, useBaseInst);
        delegateFunc(target, baseFuncs);
        var setInstanceFunc = !!_objGetPrototypeOf && !!perfOptions[strSetInstFuncs];
        if (setInstanceFunc && options) {
            setInstanceFunc = !!options[strSetInstFuncs];
        }
        _populatePrototype(classProto, className, target, instFuncs, setInstanceFunc !== false);
    }
    var perfDefaults = {
        setInstFuncs: true,
        useBaseInst: true
    };
    dynamicProto[DynProtoDefaultOptions] = perfDefaults;

    var strWindow = "window";
    var strDocument = "document";
    var strDocumentMode = "documentMode";
    var strNavigator = "navigator";
    var strConsole = "console";
    var strJSON = "JSON";
    var strCrypto = "crypto";
    var strMsCrypto = "msCrypto";
    var strMsie = "msie";
    var strTrident = "trident/";
    var strXMLHttpRequest = "XMLHttpRequest";
    var _isTrident = null;
    var _navUserAgentCheck = null;
    var _useXDomainRequest = null;
    var _beaconsSupported = null;
    function _hasProperty(theClass, property) {
        var supported = false;
        if (theClass) {
            try {
                supported = property in theClass;
                if (!supported) {
                    var proto = theClass[strShimPrototype];
                    if (proto) {
                        supported = property in proto;
                    }
                }
            }
            catch (e) {
            }
            if (!supported) {
                try {
                    var tmp = new theClass();
                    supported = !isUndefined(tmp[property]);
                }
                catch (e) {
                }
            }
        }
        return supported;
    }
    function getGlobalInst(name) {
        var gbl = getGlobal();
        if (gbl && gbl[name]) {
            return gbl[name];
        }
        if (name === strWindow && hasWindow()) {
            return window;
        }
        return null;
    }
    function hasWindow() {
        return Boolean(typeof window === strShimObject && window);
    }
    function getWindow() {
        if (hasWindow()) {
            return window;
        }
        return getGlobalInst(strWindow);
    }
    function hasDocument() {
        return Boolean(typeof document === strShimObject && document);
    }
    function getDocument() {
        if (hasDocument()) {
            return document;
        }
        return getGlobalInst(strDocument);
    }
    function hasNavigator() {
        return Boolean(typeof navigator === strShimObject && navigator);
    }
    function getNavigator() {
        if (hasNavigator()) {
            return navigator;
        }
        return getGlobalInst(strNavigator);
    }
    function getConsole() {
        if (typeof console !== strShimUndefined) {
            return console;
        }
        return getGlobalInst(strConsole);
    }
    function hasJSON() {
        return Boolean((typeof JSON === strShimObject && JSON) || getGlobalInst(strJSON) !== null);
    }
    function getJSON() {
        if (hasJSON()) {
            return JSON || getGlobalInst(strJSON);
        }
        return null;
    }
    function getCrypto() {
        return getGlobalInst(strCrypto);
    }
    function getMsCrypto() {
        return getGlobalInst(strMsCrypto);
    }
    function isIE() {
        var nav = getNavigator();
        if (nav && (nav.userAgent !== _navUserAgentCheck || _isTrident === null)) {
            _navUserAgentCheck = nav.userAgent;
            var userAgent = (_navUserAgentCheck || strEmpty$1).toLowerCase();
            _isTrident = (strContains(userAgent, strMsie) || strContains(userAgent, strTrident));
        }
        return _isTrident;
    }
    function getIEVersion(userAgentStr) {
        if (userAgentStr === void 0) { userAgentStr = null; }
        if (!userAgentStr) {
            var navigator_1 = getNavigator() || {};
            userAgentStr = navigator_1 ? (navigator_1.userAgent || strEmpty$1).toLowerCase() : strEmpty$1;
        }
        var ua = (userAgentStr || strEmpty$1).toLowerCase();
        if (strContains(ua, strMsie)) {
            var doc = getDocument() || {};
            return Math.max(parseInt(ua.split(strMsie)[1]), (doc[strDocumentMode] || 0));
        }
        else if (strContains(ua, strTrident)) {
            var tridentVer = parseInt(ua.split(strTrident)[1]);
            if (tridentVer) {
                return tridentVer + 4;
            }
        }
        return null;
    }
    function dumpObj(object) {
        var objectTypeDump = Object[strShimPrototype].toString.call(object);
        var propertyValueDump = strEmpty$1;
        if (objectTypeDump === "[object Error]") {
            propertyValueDump = "{ stack: '" + object.stack + "', message: '" + object.message + "', name: '" + object.name + "'";
        }
        else if (hasJSON()) {
            propertyValueDump = getJSON().stringify(object);
        }
        return objectTypeDump + propertyValueDump;
    }
    function isBeaconsSupported() {
        if (_beaconsSupported === null) {
            _beaconsSupported = hasNavigator() && Boolean(getNavigator().sendBeacon);
        }
        return _beaconsSupported;
    }
    function isFetchSupported(withKeepAlive) {
        var isSupported = false;
        try {
            isSupported = !!getGlobalInst("fetch");
            var request = getGlobalInst("Request");
            if (isSupported && withKeepAlive && request) {
                isSupported = _hasProperty(request, "keepalive");
            }
        }
        catch (e) {
        }
        return isSupported;
    }
    function useXDomainRequest() {
        if (_useXDomainRequest === null) {
            _useXDomainRequest = (typeof XDomainRequest !== strShimUndefined);
            if (_useXDomainRequest && isXhrSupported()) {
                _useXDomainRequest = _useXDomainRequest && !_hasProperty(getGlobalInst(strXMLHttpRequest), "withCredentials");
            }
        }
        return _useXDomainRequest;
    }
    function isXhrSupported() {
        var isSupported = false;
        try {
            var xmlHttpRequest = getGlobalInst(strXMLHttpRequest);
            isSupported = !!xmlHttpRequest;
        }
        catch (e) {
        }
        return isSupported;
    }

    var _aiNamespace = null;
    function _getExtensionNamespace() {
        var target = getGlobalInst("Microsoft");
        if (target) {
            _aiNamespace = target["ApplicationInsights"];
        }
        return _aiNamespace;
    }
    function getDebugExt(config) {
        var ns = _aiNamespace;
        if (!ns && config.disableDbgExt !== true) {
            ns = _aiNamespace || _getExtensionNamespace();
        }
        return ns ? ns["ChromeDbgExt"] : null;
    }

    var AiNonUserActionablePrefix = "AI (Internal): ";
    var AiUserActionablePrefix = "AI: ";
    var AIInternalMessagePrefix = "AITR_";
    var strErrorToConsole = "errorToConsole";
    var strWarnToConsole = "warnToConsole";
    function _sanitizeDiagnosticText(text) {
        if (text) {
            return "\"" + text.replace(/\"/g, strEmpty$1) + "\"";
        }
        return strEmpty$1;
    }
    function _logToConsole(func, message) {
        var theConsole = getConsole();
        if (!!theConsole) {
            var logFunc = "log";
            if (theConsole[func]) {
                logFunc = func;
            }
            if (isFunction(theConsole[logFunc])) {
                theConsole[logFunc](message);
            }
        }
    }
    var _InternalLogMessage = /** @class */ (function () {
        function _InternalLogMessage(msgId, msg, isUserAct, properties) {
            if (isUserAct === void 0) { isUserAct = false; }
            var _self = this;
            _self.messageId = msgId;
            _self.message =
                (isUserAct ? AiUserActionablePrefix : AiNonUserActionablePrefix) +
                    msgId;
            var strProps = strEmpty$1;
            if (hasJSON()) {
                strProps = getJSON().stringify(properties);
            }
            var diagnosticText = (msg ? " message:" + _sanitizeDiagnosticText(msg) : strEmpty$1) +
                (properties ? " props:" + _sanitizeDiagnosticText(strProps) : strEmpty$1);
            _self.message += diagnosticText;
        }
        _InternalLogMessage.dataType = "MessageData";
        return _InternalLogMessage;
    }());
    function safeGetLogger(core, config) {
        return (core || {}).logger || new DiagnosticLogger(config);
    }
    var DiagnosticLogger = /** @class */ (function () {
        function DiagnosticLogger(config) {
            this.identifier = "DiagnosticLogger";
            this.queue = [];
            var _messageCount = 0;
            var _messageLogged = {};
            dynamicProto(DiagnosticLogger, this, function (_self) {
                if (isNullOrUndefined(config)) {
                    config = {};
                }
                _self.consoleLoggingLevel = function () { return _getConfigValue("loggingLevelConsole", 0); };
                _self.telemetryLoggingLevel = function () { return _getConfigValue("loggingLevelTelemetry", 1); };
                _self.maxInternalMessageLimit = function () { return _getConfigValue("maxMessageLimit", 25); };
                _self.enableDebugExceptions = function () { return _getConfigValue("enableDebugExceptions", false); };
                _self.throwInternal = function (severity, msgId, msg, properties, isUserAct) {
                    if (isUserAct === void 0) { isUserAct = false; }
                    var message = new _InternalLogMessage(msgId, msg, isUserAct, properties);
                    if (_self.enableDebugExceptions()) {
                        throw dumpObj(message);
                    }
                    else {
                        var logFunc = severity === 1  ? strErrorToConsole : strWarnToConsole;
                        if (!isUndefined(message.message)) {
                            var logLevel = _self.consoleLoggingLevel();
                            if (isUserAct) {
                                var messageKey = +message.messageId;
                                if (!_messageLogged[messageKey] && logLevel >= severity) {
                                    _self[logFunc](message.message);
                                    _messageLogged[messageKey] = true;
                                }
                            }
                            else {
                                if (logLevel >= severity) {
                                    _self[logFunc](message.message);
                                }
                            }
                            _self.logInternalMessage(severity, message);
                        }
                        else {
                            _debugExtMsg("throw" + (severity === 1  ? "Critical" : "Warning"), message);
                        }
                    }
                };
                _self.warnToConsole = function (message) {
                    _logToConsole("warn", message);
                    _debugExtMsg("warning", message);
                };
                _self.errorToConsole = function (message) {
                    _logToConsole("error", message);
                    _debugExtMsg("error", message);
                };
                _self.resetInternalMessageCount = function () {
                    _messageCount = 0;
                    _messageLogged = {};
                };
                _self.logInternalMessage = function (severity, message) {
                    if (_areInternalMessagesThrottled()) {
                        return;
                    }
                    var logMessage = true;
                    var messageKey = AIInternalMessagePrefix + message.messageId;
                    if (_messageLogged[messageKey]) {
                        logMessage = false;
                    }
                    else {
                        _messageLogged[messageKey] = true;
                    }
                    if (logMessage) {
                        if (severity <= _self.telemetryLoggingLevel()) {
                            _self.queue.push(message);
                            _messageCount++;
                            _debugExtMsg((severity === 1  ? "error" : "warn"), message);
                        }
                        if (_messageCount === _self.maxInternalMessageLimit()) {
                            var throttleLimitMessage = "Internal events throttle limit per PageView reached for this app.";
                            var throttleMessage = new _InternalLogMessage(23 , throttleLimitMessage, false);
                            _self.queue.push(throttleMessage);
                            if (severity === 1 ) {
                                _self.errorToConsole(throttleLimitMessage);
                            }
                            else {
                                _self.warnToConsole(throttleLimitMessage);
                            }
                        }
                    }
                };
                function _getConfigValue(name, defValue) {
                    var value = config[name];
                    if (!isNullOrUndefined(value)) {
                        return value;
                    }
                    return defValue;
                }
                function _areInternalMessagesThrottled() {
                    return _messageCount >= _self.maxInternalMessageLimit();
                }
                function _debugExtMsg(name, data) {
                    var dbgExt = getDebugExt(config);
                    if (dbgExt && dbgExt.diagLog) {
                        dbgExt.diagLog(name, data);
                    }
                }
            });
        }
        return DiagnosticLogger;
    }());
    function _getLogger(logger) {
        return (logger || new DiagnosticLogger());
    }
    function _throwInternal(logger, severity, msgId, msg, properties, isUserAct) {
        if (isUserAct === void 0) { isUserAct = false; }
        (logger || new DiagnosticLogger()).throwInternal(severity, msgId, msg, properties, isUserAct);
    }
    function _warnToConsole(logger, message) {
        _getLogger(logger).warnToConsole(message);
    }

    var strExecutionContextKey = "ctx";
    var PerfEvent = /** @class */ (function () {
        function PerfEvent(name, payloadDetails, isAsync) {
            var _self = this;
            var accessorDefined = false;
            _self.start = dateNow();
            _self.name = name;
            _self.isAsync = isAsync;
            _self.isChildEvt = function () { return false; };
            if (isFunction(payloadDetails)) {
                var theDetails_1;
                accessorDefined = objDefineAccessors(_self, "payload", function () {
                    if (!theDetails_1 && isFunction(payloadDetails)) {
                        theDetails_1 = payloadDetails();
                        payloadDetails = null;
                    }
                    return theDetails_1;
                });
            }
            _self.getCtx = function (key) {
                if (key) {
                    if (key === PerfEvent.ParentContextKey || key === PerfEvent.ChildrenContextKey) {
                        return _self[key];
                    }
                    return (_self[strExecutionContextKey] || {})[key];
                }
                return null;
            };
            _self.setCtx = function (key, value) {
                if (key) {
                    if (key === PerfEvent.ParentContextKey) {
                        if (!_self[key]) {
                            _self.isChildEvt = function () { return true; };
                        }
                        _self[key] = value;
                    }
                    else if (key === PerfEvent.ChildrenContextKey) {
                        _self[key] = value;
                    }
                    else {
                        var ctx = _self[strExecutionContextKey] = _self[strExecutionContextKey] || {};
                        ctx[key] = value;
                    }
                }
            };
            _self.complete = function () {
                var childTime = 0;
                var childEvts = _self.getCtx(PerfEvent.ChildrenContextKey);
                if (isArray(childEvts)) {
                    for (var lp = 0; lp < childEvts.length; lp++) {
                        var childEvt = childEvts[lp];
                        if (childEvt) {
                            childTime += childEvt.time;
                        }
                    }
                }
                _self.time = dateNow() - _self.start;
                _self.exTime = _self.time - childTime;
                _self.complete = function () { };
                if (!accessorDefined && isFunction(payloadDetails)) {
                    _self.payload = payloadDetails();
                }
            };
        }
        PerfEvent.ParentContextKey = "parent";
        PerfEvent.ChildrenContextKey = "childEvts";
        return PerfEvent;
    }());
    var doPerfActiveKey = "CoreUtils.doPerf";
    function doPerf(mgrSource, getSource, func, details, isAsync) {
        if (mgrSource) {
            var perfMgr = mgrSource;
            if (isFunction(perfMgr["getPerfMgr"])) {
                perfMgr = perfMgr["getPerfMgr"]();
            }
            if (perfMgr) {
                var perfEvt = void 0;
                var currentActive = perfMgr.getCtx(doPerfActiveKey);
                try {
                    perfEvt = perfMgr.create(getSource(), details, isAsync);
                    if (perfEvt) {
                        if (currentActive && perfEvt.setCtx) {
                            perfEvt.setCtx(PerfEvent.ParentContextKey, currentActive);
                            if (currentActive.getCtx && currentActive.setCtx) {
                                var children = currentActive.getCtx(PerfEvent.ChildrenContextKey);
                                if (!children) {
                                    children = [];
                                    currentActive.setCtx(PerfEvent.ChildrenContextKey, children);
                                }
                                children.push(perfEvt);
                            }
                        }
                        perfMgr.setCtx(doPerfActiveKey, perfEvt);
                        return func(perfEvt);
                    }
                }
                catch (ex) {
                    if (perfEvt && perfEvt.setCtx) {
                        perfEvt.setCtx("exception", ex);
                    }
                }
                finally {
                    if (perfEvt) {
                        perfMgr.fire(perfEvt);
                    }
                    perfMgr.setCtx(doPerfActiveKey, currentActive);
                }
            }
        }
        return func();
    }

    var UInt32Mask = 0x100000000;
    var MaxUInt32 = 0xffffffff;
    var _mwcSeeded = false;
    var _mwcW = 123456789;
    var _mwcZ = 987654321;
    function _mwcSeed(seedValue) {
        if (seedValue < 0) {
            seedValue >>>= 0;
        }
        _mwcW = (123456789 + seedValue) & MaxUInt32;
        _mwcZ = (987654321 - seedValue) & MaxUInt32;
        _mwcSeeded = true;
    }
    function _autoSeedMwc() {
        try {
            var now = dateNow() & 0x7fffffff;
            _mwcSeed(((Math.random() * UInt32Mask) ^ now) + now);
        }
        catch (e) {
        }
    }
    function random32(signed) {
        var value = 0;
        var c = getCrypto() || getMsCrypto();
        if (c && c.getRandomValues) {
            value = c.getRandomValues(new Uint32Array(1))[0] & MaxUInt32;
        }
        if (value === 0 && isIE()) {
            if (!_mwcSeeded) {
                _autoSeedMwc();
            }
            value = mwcRandom32() & MaxUInt32;
        }
        if (value === 0) {
            value = Math.floor((UInt32Mask * Math.random()) | 0);
        }
        if (!signed) {
            value >>>= 0;
        }
        return value;
    }
    function mwcRandom32(signed) {
        _mwcZ = (36969 * (_mwcZ & 0xFFFF) + (_mwcZ >> 16)) & MaxUInt32;
        _mwcW = (18000 * (_mwcW & 0xFFFF) + (_mwcW >> 16)) & MaxUInt32;
        var value = (((_mwcZ << 16) + (_mwcW & 0xFFFF)) >>> 0) & MaxUInt32 | 0;
        if (!signed) {
            value >>>= 0;
        }
        return value;
    }
    function newId(maxLength) {
        if (maxLength === void 0) { maxLength = 22; }
        var base64chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        var number = random32() >>> 0;
        var chars = 0;
        var result = strEmpty$1;
        while (result.length < maxLength) {
            chars++;
            result += base64chars.charAt(number & 0x3F);
            number >>>= 6;
            if (chars === 5) {
                number = (((random32() << 2) & 0xFFFFFFFF) | (number & 0x03)) >>> 0;
                chars = 0;
            }
        }
        return result;
    }

    var _objDefineProperty = ObjDefineProperty;
    var version = "2.8.4";
    var instanceName = "." + newId(6);
    var _dataUid = 0;
    function _createAccessor(target, prop, value) {
        if (_objDefineProperty) {
            try {
                _objDefineProperty(target, prop, {
                    value: value,
                    enumerable: false,
                    configurable: true
                });
                return true;
            }
            catch (e) {
            }
        }
        return false;
    }
    function _canAcceptData(target) {
        return target.nodeType === 1 || target.nodeType === 9 || !(+target.nodeType);
    }
    function _getCache(data, target) {
        var theCache = target[data.id];
        if (!theCache) {
            theCache = {};
            try {
                if (_canAcceptData(target)) {
                    if (!_createAccessor(target, data.id, theCache)) {
                        target[data.id] = theCache;
                    }
                }
            }
            catch (e) {
            }
        }
        return theCache;
    }
    function createUniqueNamespace(name, includeVersion) {
        if (includeVersion === void 0) { includeVersion = false; }
        return normalizeJsName(name + (_dataUid++) + (includeVersion ? "." + version : "") + instanceName);
    }
    function createElmNodeData(name) {
        var data = {
            id: createUniqueNamespace("_aiData-" + (name || "") + "." + version),
            accept: function (target) {
                return _canAcceptData(target);
            },
            get: function (target, name, defValue, addDefault) {
                var theCache = target[data.id];
                if (!theCache) {
                    if (addDefault) {
                        theCache = _getCache(data, target);
                        theCache[normalizeJsName(name)] = defValue;
                    }
                    return defValue;
                }
                return theCache[normalizeJsName(name)];
            },
            kill: function (target, name) {
                if (target && target[name]) {
                    try {
                        delete target[name];
                    }
                    catch (e) {
                    }
                }
            }
        };
        return data;
    }

    var strOnPrefix = "on";
    var strAttachEvent = "attachEvent";
    var strAddEventHelper = "addEventListener";
    var strDetachEvent = "detachEvent";
    var strRemoveEventListener = "removeEventListener";
    var strEvents = "events";
    createUniqueNamespace("aiEvtPageHide");
    createUniqueNamespace("aiEvtPageShow");
    var rRemoveEmptyNs = /\.[\.]+/g;
    var rRemoveTrailingEmptyNs = /[\.]+$/;
    var _guid = 1;
    var elmNodeData = createElmNodeData("events");
    var eventNamespace = /^([^.]*)(?:\.(.+)|)/;
    function _normalizeNamespace(name) {
        if (name && name.replace) {
            return name.replace(/^\s*\.*|\.*\s*$/g, "");
        }
        return name;
    }
    function _getEvtNamespace(eventName, evtNamespace) {
        if (evtNamespace) {
            var theNamespace_1 = "";
            if (isArray(evtNamespace)) {
                theNamespace_1 = "";
                arrForEach(evtNamespace, function (name) {
                    name = _normalizeNamespace(name);
                    if (name) {
                        if (name[0] !== ".") {
                            name = "." + name;
                        }
                        theNamespace_1 += name;
                    }
                });
            }
            else {
                theNamespace_1 = _normalizeNamespace(evtNamespace);
            }
            if (theNamespace_1) {
                if (theNamespace_1[0] !== ".") {
                    theNamespace_1 = "." + theNamespace_1;
                }
                eventName = (eventName || "") + theNamespace_1;
            }
        }
        var parsedEvent = (eventNamespace.exec(eventName || "") || []);
        return {
            type: parsedEvent[1],
            ns: ((parsedEvent[2] || "").replace(rRemoveEmptyNs, ".").replace(rRemoveTrailingEmptyNs, "").split(".").sort()).join(".")
        };
    }
    function _getRegisteredEvents(target, evtName, addDefault) {
        if (addDefault === void 0) { addDefault = true; }
        var aiEvts = elmNodeData.get(target, strEvents, {}, addDefault);
        var registeredEvents = aiEvts[evtName];
        if (!registeredEvents) {
            registeredEvents = aiEvts[evtName] = [];
        }
        return registeredEvents;
    }
    function _doDetach(obj, evtName, handlerRef, useCapture) {
        if (obj && evtName && evtName.type) {
            if (obj[strRemoveEventListener]) {
                obj[strRemoveEventListener](evtName.type, handlerRef, useCapture);
            }
            else if (obj[strDetachEvent]) {
                obj[strDetachEvent](strOnPrefix + evtName.type, handlerRef);
            }
        }
    }
    function _doAttach(obj, evtName, handlerRef, useCapture) {
        var result = false;
        if (obj && evtName && evtName.type && handlerRef) {
            if (obj[strAddEventHelper]) {
                obj[strAddEventHelper](evtName.type, handlerRef, useCapture);
                result = true;
            }
            else if (obj[strAttachEvent]) {
                obj[strAttachEvent](strOnPrefix + evtName.type, handlerRef);
                result = true;
            }
        }
        return result;
    }
    function _doUnregister(target, events, evtName, unRegFn) {
        var idx = events.length;
        while (idx--) {
            var theEvent = events[idx];
            if (theEvent) {
                if (!evtName.ns || evtName.ns === theEvent.evtName.ns) {
                    if (!unRegFn || unRegFn(theEvent)) {
                        _doDetach(target, theEvent.evtName, theEvent.handler, theEvent.capture);
                        events.splice(idx, 1);
                    }
                }
            }
        }
    }
    function _unregisterEvents(target, evtName, unRegFn) {
        if (evtName.type) {
            _doUnregister(target, _getRegisteredEvents(target, evtName.type), evtName, unRegFn);
        }
        else {
            var eventCache = elmNodeData.get(target, strEvents, {});
            objForEachKey(eventCache, function (evtType, events) {
                _doUnregister(target, events, evtName, unRegFn);
            });
            if (objKeys(eventCache).length === 0) {
                elmNodeData.kill(target, strEvents);
            }
        }
    }
    function mergeEvtNamespace(theNamespace, namespaces) {
        var newNamespaces;
        if (namespaces) {
            if (isArray(namespaces)) {
                newNamespaces = [theNamespace].concat(namespaces);
            }
            else {
                newNamespaces = [theNamespace, namespaces];
            }
            newNamespaces = (_getEvtNamespace("xx", newNamespaces).ns).split(".");
        }
        else {
            newNamespaces = theNamespace;
        }
        return newNamespaces;
    }
    function eventOn(target, eventName, handlerRef, evtNamespace, useCapture) {
        if (useCapture === void 0) { useCapture = false; }
        var result = false;
        if (target) {
            try {
                var evtName = _getEvtNamespace(eventName, evtNamespace);
                result = _doAttach(target, evtName, handlerRef, useCapture);
                if (result && elmNodeData.accept(target)) {
                    var registeredEvent = {
                        guid: _guid++,
                        evtName: evtName,
                        handler: handlerRef,
                        capture: useCapture
                    };
                    _getRegisteredEvents(target, evtName.type).push(registeredEvent);
                }
            }
            catch (e) {
            }
        }
        return result;
    }
    function eventOff(target, eventName, handlerRef, evtNamespace, useCapture) {
        if (useCapture === void 0) { useCapture = false; }
        if (target) {
            try {
                var evtName_1 = _getEvtNamespace(eventName, evtNamespace);
                var found_1 = false;
                _unregisterEvents(target, evtName_1, function (regEvent) {
                    if ((evtName_1.ns && !handlerRef) || regEvent.handler === handlerRef) {
                        found_1 = true;
                        return true;
                    }
                    return false;
                });
                if (!found_1) {
                    _doDetach(target, evtName_1, handlerRef, useCapture);
                }
            }
            catch (e) {
            }
        }
    }

    var pluginStateData = createElmNodeData("plugin");
    function _getPluginState(plugin) {
        return pluginStateData.get(plugin, "state", {}, true);
    }

    var strTelemetryPluginChain = "TelemetryPluginChain";
    var strHasRunFlags = "_hasRun";
    var strGetTelCtx = "_getTelCtx";
    var _chainId = 0;
    function _getNextProxyStart(proxy, core, startAt) {
        while (proxy) {
            if (proxy.getPlugin() === startAt) {
                return proxy;
            }
            proxy = proxy.getNext();
        }
        return createTelemetryProxyChain([startAt], core.config || {}, core);
    }
    function _createInternalContext(telemetryChain, config, core, startAt) {
        var _nextProxy = null;
        var _onComplete = [];
        if (startAt !== null) {
            _nextProxy = startAt ? _getNextProxyStart(telemetryChain, core, startAt) : telemetryChain;
        }
        var context = {
            _next: _moveNext,
            ctx: {
                core: function () {
                    return core;
                },
                diagLog: function () {
                    return safeGetLogger(core, config);
                },
                getCfg: function () {
                    return config;
                },
                getExtCfg: _getExtCfg,
                getConfig: _getConfig,
                hasNext: function () {
                    return !!_nextProxy;
                },
                getNext: function () {
                    return _nextProxy;
                },
                setNext: function (nextPlugin) {
                    _nextProxy = nextPlugin;
                },
                iterate: _iterateChain,
                onComplete: _addOnComplete
            }
        };
        function _addOnComplete(onComplete, that) {
            var args = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                args[_i - 2] = arguments[_i];
            }
            if (onComplete) {
                _onComplete.push({
                    func: onComplete,
                    self: !isUndefined(that) ? that : context.ctx,
                    args: args
                });
            }
        }
        function _moveNext() {
            var nextProxy = _nextProxy;
            _nextProxy = nextProxy ? nextProxy.getNext() : null;
            if (!nextProxy) {
                var onComplete = _onComplete;
                if (onComplete && onComplete.length > 0) {
                    arrForEach(onComplete, function (completeDetails) {
                        try {
                            completeDetails.func.call(completeDetails.self, completeDetails.args);
                        }
                        catch (e) {
                            _throwInternal(core.logger, 2 , 73 , "Unexpected Exception during onComplete - " + dumpObj(e));
                        }
                    });
                    _onComplete = [];
                }
            }
            return nextProxy;
        }
        function _getExtCfg(identifier, defaultValue, mergeDefault) {
            if (defaultValue === void 0) { defaultValue = {}; }
            if (mergeDefault === void 0) { mergeDefault = 0 ; }
            var theConfig;
            if (config) {
                var extConfig = config.extensionConfig;
                if (extConfig && identifier) {
                    theConfig = extConfig[identifier];
                }
            }
            if (!theConfig) {
                theConfig = defaultValue;
            }
            else if (isObject(defaultValue)) {
                if (mergeDefault !== 0 ) {
                    var newConfig_1 = objExtend(true, defaultValue, theConfig);
                    if (config && mergeDefault === 2 ) {
                        objForEachKey(defaultValue, function (field) {
                            if (isNullOrUndefined(newConfig_1[field])) {
                                var cfgValue = config[field];
                                if (!isNullOrUndefined(cfgValue)) {
                                    newConfig_1[field] = cfgValue;
                                }
                            }
                        });
                    }
                    theConfig = newConfig_1;
                }
            }
            return theConfig;
        }
        function _getConfig(identifier, field, defaultValue) {
            if (defaultValue === void 0) { defaultValue = false; }
            var theValue;
            var extConfig = _getExtCfg(identifier, null);
            if (extConfig && !isNullOrUndefined(extConfig[field])) {
                theValue = extConfig[field];
            }
            else if (config && !isNullOrUndefined(config[field])) {
                theValue = config[field];
            }
            return !isNullOrUndefined(theValue) ? theValue : defaultValue;
        }
        function _iterateChain(cb) {
            var nextPlugin;
            while (!!(nextPlugin = context._next())) {
                var plugin = nextPlugin.getPlugin();
                if (plugin) {
                    cb(plugin);
                }
            }
        }
        return context;
    }
    function createProcessTelemetryContext(telemetryChain, config, core, startAt) {
        var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
        var context = internalContext.ctx;
        function _processNext(env) {
            var nextPlugin = internalContext._next();
            nextPlugin && nextPlugin.processTelemetry(env, context);
            return !nextPlugin;
        }
        function _createNew(plugins, startAt) {
            if (plugins === void 0) { plugins = null; }
            if (isArray(plugins)) {
                plugins = createTelemetryProxyChain(plugins, config, core, startAt);
            }
            return createProcessTelemetryContext(plugins || context.getNext(), config, core, startAt);
        }
        context.processNext = _processNext;
        context.createNew = _createNew;
        return context;
    }
    function createProcessTelemetryUnloadContext(telemetryChain, core, startAt) {
        var config = core.config || {};
        var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
        var context = internalContext.ctx;
        function _processNext(unloadState) {
            var nextPlugin = internalContext._next();
            nextPlugin && nextPlugin.unload(context, unloadState);
            return !nextPlugin;
        }
        function _createNew(plugins, startAt) {
            if (plugins === void 0) { plugins = null; }
            if (isArray(plugins)) {
                plugins = createTelemetryProxyChain(plugins, config, core, startAt);
            }
            return createProcessTelemetryUnloadContext(plugins || context.getNext(), core, startAt);
        }
        context.processNext = _processNext;
        context.createNew = _createNew;
        return context;
    }
    function createProcessTelemetryUpdateContext(telemetryChain, core, startAt) {
        var config = core.config || {};
        var internalContext = _createInternalContext(telemetryChain, config, core, startAt);
        var context = internalContext.ctx;
        function _processNext(updateState) {
            return context.iterate(function (plugin) {
                if (isFunction(plugin.update)) {
                    plugin.update(context, updateState);
                }
            });
        }
        function _createNew(plugins, startAt) {
            if (plugins === void 0) { plugins = null; }
            if (isArray(plugins)) {
                plugins = createTelemetryProxyChain(plugins, config, core, startAt);
            }
            return createProcessTelemetryUpdateContext(plugins || context.getNext(), core, startAt);
        }
        context.processNext = _processNext;
        context.createNew = _createNew;
        return context;
    }
    function createTelemetryProxyChain(plugins, config, core, startAt) {
        var firstProxy = null;
        var add = startAt ? false : true;
        if (isArray(plugins) && plugins.length > 0) {
            var lastProxy_1 = null;
            arrForEach(plugins, function (thePlugin) {
                if (!add && startAt === thePlugin) {
                    add = true;
                }
                if (add && thePlugin && isFunction(thePlugin.processTelemetry)) {
                    var newProxy = createTelemetryPluginProxy(thePlugin, config, core);
                    if (!firstProxy) {
                        firstProxy = newProxy;
                    }
                    if (lastProxy_1) {
                        lastProxy_1._setNext(newProxy);
                    }
                    lastProxy_1 = newProxy;
                }
            });
        }
        if (startAt && !firstProxy) {
            return createTelemetryProxyChain([startAt], config, core);
        }
        return firstProxy;
    }
    function createTelemetryPluginProxy(plugin, config, core) {
        var nextProxy = null;
        var hasProcessTelemetry = isFunction(plugin.processTelemetry);
        var hasSetNext = isFunction(plugin.setNextPlugin);
        var chainId;
        if (plugin) {
            chainId = plugin.identifier + "-" + plugin.priority + "-" + _chainId++;
        }
        else {
            chainId = "Unknown-0-" + _chainId++;
        }
        var proxyChain = {
            getPlugin: function () {
                return plugin;
            },
            getNext: function () {
                return nextProxy;
            },
            processTelemetry: _processTelemetry,
            unload: _unloadPlugin,
            update: _updatePlugin,
            _id: chainId,
            _setNext: function (nextPlugin) {
                nextProxy = nextPlugin;
            }
        };
        function _getTelCtx() {
            var itemCtx;
            if (plugin && isFunction(plugin[strGetTelCtx])) {
                itemCtx = plugin[strGetTelCtx]();
            }
            if (!itemCtx) {
                itemCtx = createProcessTelemetryContext(proxyChain, config, core);
            }
            return itemCtx;
        }
        function _processChain(itemCtx, processPluginFn, name, details, isAsync) {
            var hasRun = false;
            var identifier = plugin ? plugin.identifier : strTelemetryPluginChain;
            var hasRunContext = itemCtx[strHasRunFlags];
            if (!hasRunContext) {
                hasRunContext = itemCtx[strHasRunFlags] = {};
            }
            itemCtx.setNext(nextProxy);
            if (plugin) {
                doPerf(itemCtx[strCore](), function () { return identifier + ":" + name; }, function () {
                    hasRunContext[chainId] = true;
                    try {
                        var nextId = nextProxy ? nextProxy._id : strEmpty$1;
                        if (nextId) {
                            hasRunContext[nextId] = false;
                        }
                        hasRun = processPluginFn(itemCtx);
                    }
                    catch (error) {
                        var hasNextRun = nextProxy ? hasRunContext[nextProxy._id] : true;
                        if (hasNextRun) {
                            hasRun = true;
                        }
                        if (!nextProxy || !hasNextRun) {
                            _throwInternal(itemCtx.diagLog(), 1 , 73 , "Plugin [" + identifier + "] failed during " + name + " - " + dumpObj(error) + ", run flags: " + dumpObj(hasRunContext));
                        }
                    }
                }, details, isAsync);
            }
            return hasRun;
        }
        function _processTelemetry(env, itemCtx) {
            itemCtx = itemCtx || _getTelCtx();
            function _callProcessTelemetry(itemCtx) {
                if (!plugin || !hasProcessTelemetry) {
                    return false;
                }
                var pluginState = _getPluginState(plugin);
                if (pluginState.teardown || pluginState[strDisabled]) {
                    return false;
                }
                if (hasSetNext) {
                    plugin.setNextPlugin(nextProxy);
                }
                plugin.processTelemetry(env, itemCtx);
                return true;
            }
            if (!_processChain(itemCtx, _callProcessTelemetry, "processTelemetry", function () { return ({ item: env }); }, !(env.sync))) {
                itemCtx.processNext(env);
            }
        }
        function _unloadPlugin(unloadCtx, unloadState) {
            function _callTeardown() {
                var hasRun = false;
                if (plugin) {
                    var pluginState = _getPluginState(plugin);
                    var pluginCore = plugin[strCore] || pluginState.core;
                    if (plugin && (!pluginCore || pluginCore === unloadCtx[strCore]()) && !pluginState[strTeardown]) {
                        pluginState[strCore] = null;
                        pluginState[strTeardown] = true;
                        pluginState[strIsInitialized] = false;
                        if (plugin[strTeardown] && plugin[strTeardown](unloadCtx, unloadState) === true) {
                            hasRun = true;
                        }
                    }
                }
                return hasRun;
            }
            if (!_processChain(unloadCtx, _callTeardown, "unload", function () { }, unloadState.isAsync)) {
                unloadCtx.processNext(unloadState);
            }
        }
        function _updatePlugin(updateCtx, updateState) {
            function _callUpdate() {
                var hasRun = false;
                if (plugin) {
                    var pluginState = _getPluginState(plugin);
                    var pluginCore = plugin[strCore] || pluginState.core;
                    if (plugin && (!pluginCore || pluginCore === updateCtx[strCore]()) && !pluginState[strTeardown]) {
                        if (plugin[strUpdate] && plugin[strUpdate](updateCtx, updateState) === true) {
                            hasRun = true;
                        }
                    }
                }
                return hasRun;
            }
            if (!_processChain(updateCtx, _callUpdate, "update", function () { }, false)) {
                updateCtx.processNext(updateState);
            }
        }
        return objFreeze(proxyChain);
    }

    var strExtensionConfig = "extensionConfig";

    function createUnloadHandlerContainer() {
        var handlers = [];
        function _addHandler(handler) {
            if (handler) {
                handlers.push(handler);
            }
        }
        function _runHandlers(unloadCtx, unloadState) {
            arrForEach(handlers, function (handler) {
                try {
                    handler(unloadCtx, unloadState);
                }
                catch (e) {
                    _throwInternal(unloadCtx.diagLog(), 2 , 73 , "Unexpected error calling unload handler - " + dumpObj(e));
                }
            });
            handlers = [];
        }
        return {
            add: _addHandler,
            run: _runHandlers
        };
    }

    var strGetPlugin = "getPlugin";
    var BaseTelemetryPlugin = /** @class */ (function () {
        function BaseTelemetryPlugin() {
            var _self = this;
            var _isinitialized;
            var _rootCtx;
            var _nextPlugin;
            var _unloadHandlerContainer;
            var _hooks;
            _initDefaults();
            dynamicProto(BaseTelemetryPlugin, _self, function (_self) {
                _self.initialize = function (config, core, extensions, pluginChain) {
                    _setDefaults(config, core, pluginChain);
                    _isinitialized = true;
                };
                _self.teardown = function (unloadCtx, unloadState) {
                    var core = _self.core;
                    if (!core || (unloadCtx && core !== unloadCtx.core())) {
                        return;
                    }
                    var result;
                    var unloadDone = false;
                    var theUnloadCtx = unloadCtx || createProcessTelemetryUnloadContext(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                    var theUnloadState = unloadState || {
                        reason: 0 ,
                        isAsync: false
                    };
                    function _unloadCallback() {
                        if (!unloadDone) {
                            unloadDone = true;
                            _unloadHandlerContainer.run(theUnloadCtx, unloadState);
                            arrForEach(_hooks, function (fn) {
                                fn.rm();
                            });
                            _hooks = [];
                            if (result === true) {
                                theUnloadCtx.processNext(theUnloadState);
                            }
                            _initDefaults();
                        }
                    }
                    if (!_self[strDoTeardown] || _self[strDoTeardown](theUnloadCtx, theUnloadState, _unloadCallback) !== true) {
                        _unloadCallback();
                    }
                    else {
                        result = true;
                    }
                    return result;
                };
                _self.update = function (updateCtx, updateState) {
                    var core = _self.core;
                    if (!core || (updateCtx && core !== updateCtx.core())) {
                        return;
                    }
                    var result;
                    var updateDone = false;
                    var theUpdateCtx = updateCtx || createProcessTelemetryUpdateContext(null, core, _nextPlugin && _nextPlugin[strGetPlugin] ? _nextPlugin[strGetPlugin]() : _nextPlugin);
                    var theUpdateState = updateState || {
                        reason: 0
                    };
                    function _updateCallback() {
                        if (!updateDone) {
                            updateDone = true;
                            _setDefaults(theUpdateCtx.getCfg(), theUpdateCtx.core(), theUpdateCtx.getNext());
                        }
                    }
                    if (!_self._doUpdate || _self._doUpdate(theUpdateCtx, theUpdateState, _updateCallback) !== true) {
                        _updateCallback();
                    }
                    else {
                        result = true;
                    }
                    return result;
                };
                _self._addHook = function (hooks) {
                    if (hooks) {
                        if (isArray(hooks)) {
                            _hooks = _hooks.concat(hooks);
                        }
                        else {
                            _hooks.push(hooks);
                        }
                    }
                };
                proxyFunctionAs(_self, "_addUnloadCb", function () { return _unloadHandlerContainer; }, "add");
            });
            _self.diagLog = function (itemCtx) {
                return _getTelCtx(itemCtx).diagLog();
            };
            _self[strIsInitialized] = function () {
                return _isinitialized;
            };
            _self.setInitialized = function (isInitialized) {
                _isinitialized = isInitialized;
            };
            _self[strSetNextPlugin] = function (next) {
                _nextPlugin = next;
            };
            _self.processNext = function (env, itemCtx) {
                if (itemCtx) {
                    itemCtx.processNext(env);
                }
                else if (_nextPlugin && isFunction(_nextPlugin.processTelemetry)) {
                    _nextPlugin.processTelemetry(env, null);
                }
            };
            _self._getTelCtx = _getTelCtx;
            function _getTelCtx(currentCtx) {
                if (currentCtx === void 0) { currentCtx = null; }
                var itemCtx = currentCtx;
                if (!itemCtx) {
                    var rootCtx = _rootCtx || createProcessTelemetryContext(null, {}, _self.core);
                    if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                        itemCtx = rootCtx.createNew(null, _nextPlugin[strGetPlugin]);
                    }
                    else {
                        itemCtx = rootCtx.createNew(null, _nextPlugin);
                    }
                }
                return itemCtx;
            }
            function _setDefaults(config, core, pluginChain) {
                if (config) {
                    setValue(config, strExtensionConfig, [], null, isNullOrUndefined);
                }
                if (!pluginChain && core) {
                    pluginChain = core.getProcessTelContext().getNext();
                }
                var nextPlugin = _nextPlugin;
                if (_nextPlugin && _nextPlugin[strGetPlugin]) {
                    nextPlugin = _nextPlugin[strGetPlugin]();
                }
                _self.core = core;
                _rootCtx = createProcessTelemetryContext(pluginChain, config, core, nextPlugin);
            }
            function _initDefaults() {
                _isinitialized = false;
                _self.core = null;
                _rootCtx = null;
                _nextPlugin = null;
                _hooks = [];
                _unloadHandlerContainer = createUnloadHandlerContainer();
            }
        }
        return BaseTelemetryPlugin;
    }());

    var RequestHeaders = createValueMap({
        requestContextHeader: [0 , "Request-Context"],
        requestContextTargetKey: [1 , "appId"],
        requestContextAppIdFormat: [2 , "appId=cid-v1:"],
        requestIdHeader: [3 , "Request-Id"],
        traceParentHeader: [4 , "traceparent"],
        traceStateHeader: [5 , "tracestate"],
        sdkContextHeader: [6 , "Sdk-Context"],
        sdkContextHeaderAppIdRequest: [7 , "appId"],
        requestContextHeaderLowerCase: [8 , "request-context"]
    });

    function dataSanitizeKeyAndAddUniqueness(logger, key, map) {
        var origLength = key.length;
        var field = dataSanitizeKey(logger, key);
        if (field.length !== origLength) {
            var i = 0;
            var uniqueField = field;
            while (map[uniqueField] !== undefined) {
                i++;
                uniqueField = field.substring(0, 150  - 3) + dsPadNumber(i);
            }
            field = uniqueField;
        }
        return field;
    }
    function dataSanitizeKey(logger, name) {
        var nameTrunc;
        if (name) {
            name = strTrim(name.toString());
            if (name.length > 150 ) {
                nameTrunc = name.substring(0, 150 );
                _throwInternal(logger, 2 , 57 , "name is too long.  It has been truncated to " + 150  + " characters.", { name: name }, true);
            }
        }
        return nameTrunc || name;
    }
    function dataSanitizeString(logger, value, maxLength) {
        if (maxLength === void 0) { maxLength = 1024 ; }
        var valueTrunc;
        if (value) {
            maxLength = maxLength ? maxLength : 1024 ;
            value = strTrim(value);
            if (value.toString().length > maxLength) {
                valueTrunc = value.toString().substring(0, maxLength);
                _throwInternal(logger, 2 , 61 , "string value is too long. It has been truncated to " + maxLength + " characters.", { value: value }, true);
            }
        }
        return valueTrunc || value;
    }
    function dataSanitizeUrl(logger, url) {
        return dataSanitizeInput(logger, url, 2048 , 66 );
    }
    function dataSanitizeMessage(logger, message) {
        var messageTrunc;
        if (message) {
            if (message.length > 32768 ) {
                messageTrunc = message.substring(0, 32768 );
                _throwInternal(logger, 2 , 56 , "message is too long, it has been truncated to " + 32768  + " characters.", { message: message }, true);
            }
        }
        return messageTrunc || message;
    }
    function dataSanitizeException(logger, exception) {
        var exceptionTrunc;
        if (exception) {
            var value = "" + exception;
            if (value.length > 32768 ) {
                exceptionTrunc = value.substring(0, 32768 );
                _throwInternal(logger, 2 , 52 , "exception is too long, it has been truncated to " + 32768  + " characters.", { exception: exception }, true);
            }
        }
        return exceptionTrunc || exception;
    }
    function dataSanitizeProperties(logger, properties) {
        if (properties) {
            var tempProps_1 = {};
            objForEachKey(properties, function (prop, value) {
                if (isObject(value) && hasJSON()) {
                    try {
                        value = getJSON().stringify(value);
                    }
                    catch (e) {
                        _throwInternal(logger, 2 , 49 , "custom property is not valid", { exception: e }, true);
                    }
                }
                value = dataSanitizeString(logger, value, 8192 );
                prop = dataSanitizeKeyAndAddUniqueness(logger, prop, tempProps_1);
                tempProps_1[prop] = value;
            });
            properties = tempProps_1;
        }
        return properties;
    }
    function dataSanitizeMeasurements(logger, measurements) {
        if (measurements) {
            var tempMeasurements_1 = {};
            objForEachKey(measurements, function (measure, value) {
                measure = dataSanitizeKeyAndAddUniqueness(logger, measure, tempMeasurements_1);
                tempMeasurements_1[measure] = value;
            });
            measurements = tempMeasurements_1;
        }
        return measurements;
    }
    function dataSanitizeId(logger, id) {
        return id ? dataSanitizeInput(logger, id, 128 , 69 ).toString() : id;
    }
    function dataSanitizeInput(logger, input, maxLength, _msgId) {
        var inputTrunc;
        if (input) {
            input = strTrim(input);
            if (input.length > maxLength) {
                inputTrunc = input.substring(0, maxLength);
                _throwInternal(logger, 2 , _msgId, "input is too long, it has been truncated to " + maxLength + " characters.", { data: input }, true);
            }
        }
        return inputTrunc || input;
    }
    function dsPadNumber(num) {
        var s = "00" + num;
        return s.substr(s.length - 3);
    }

    var strEmpty = "";
    function msToTimeSpan(totalms) {
        if (isNaN(totalms) || totalms < 0) {
            totalms = 0;
        }
        totalms = Math.round(totalms);
        var ms = strEmpty + totalms % 1000;
        var sec = strEmpty + Math.floor(totalms / 1000) % 60;
        var min = strEmpty + Math.floor(totalms / (1000 * 60)) % 60;
        var hour = strEmpty + Math.floor(totalms / (1000 * 60 * 60)) % 24;
        var days = Math.floor(totalms / (1000 * 60 * 60 * 24));
        ms = ms.length === 1 ? "00" + ms : ms.length === 2 ? "0" + ms : ms;
        sec = sec.length < 2 ? "0" + sec : sec;
        min = min.length < 2 ? "0" + min : min;
        hour = hour.length < 2 ? "0" + hour : hour;
        return (days > 0 ? days + "." : strEmpty) + hour + ":" + min + ":" + sec + "." + ms;
    }

    var DisabledPropertyName = "Microsoft_ApplicationInsights_BypassAjaxInstrumentation";
    var SampleRate = "sampleRate";
    var ProcessLegacy = "ProcessLegacy";
    var HttpMethod = "http.method";
    var strNotSpecified = "not_specified";

    var StorageType = createEnumStyle({
        LocalStorage: 0 ,
        SessionStorage: 1
    });
    createEnumStyle({
        AI: 0 ,
        AI_AND_W3C: 1 ,
        W3C: 2
    });

    var _canUseSessionStorage = undefined;
    function _getVerifiedStorageObject(storageType) {
        try {
            if (isNullOrUndefined(getGlobal())) {
                return null;
            }
            var uid = (new Date).toString();
            var storage = getGlobalInst(storageType === StorageType.LocalStorage ? "localStorage" : "sessionStorage");
            storage.setItem(uid, uid);
            var fail = storage.getItem(uid) !== uid;
            storage.removeItem(uid);
            if (!fail) {
                return storage;
            }
        }
        catch (exception) {
        }
        return null;
    }
    function _getSessionStorageObject() {
        if (utlCanUseSessionStorage()) {
            return _getVerifiedStorageObject(StorageType.SessionStorage);
        }
        return null;
    }
    function utlCanUseSessionStorage(reset) {
        if (reset || _canUseSessionStorage === undefined) {
            _canUseSessionStorage = !!_getVerifiedStorageObject(StorageType.SessionStorage);
        }
        return _canUseSessionStorage;
    }
    function utlGetSessionStorage(logger, name) {
        var storage = _getSessionStorageObject();
        if (storage !== null) {
            try {
                return storage.getItem(name);
            }
            catch (e) {
                _canUseSessionStorage = false;
                _throwInternal(logger, 2 , 2 , "Browser failed read of session storage. " + getExceptionName(e), { exception: dumpObj(e) });
            }
        }
        return null;
    }
    function utlSetSessionStorage(logger, name, data) {
        var storage = _getSessionStorageObject();
        if (storage !== null) {
            try {
                storage.setItem(name, data);
                return true;
            }
            catch (e) {
                _canUseSessionStorage = false;
                _throwInternal(logger, 2 , 4 , "Browser failed write to session storage. " + getExceptionName(e), { exception: dumpObj(e) });
            }
        }
        return false;
    }

    var _document = getDocument() || {};
    var _htmlAnchorIdx = 0;
    var _htmlAnchorElement = [null, null, null, null, null];
    function urlParseUrl(url) {
        var anchorIdx = _htmlAnchorIdx;
        var anchorCache = _htmlAnchorElement;
        var tempAnchor = anchorCache[anchorIdx];
        if (!_document.createElement) {
            tempAnchor = { host: urlParseHost(url, true) };
        }
        else if (!anchorCache[anchorIdx]) {
            tempAnchor = anchorCache[anchorIdx] = _document.createElement("a");
        }
        tempAnchor.href = url;
        anchorIdx++;
        if (anchorIdx >= anchorCache.length) {
            anchorIdx = 0;
        }
        _htmlAnchorIdx = anchorIdx;
        return tempAnchor;
    }
    function urlParseHost(url, inclPort) {
        var fullHost = urlParseFullHost(url, inclPort) || "";
        if (fullHost) {
            var match = fullHost.match(/(www[0-9]?\.)?(.[^/:]+)(\:[\d]+)?/i);
            if (match != null && match.length > 3 && isString(match[2]) && match[2].length > 0) {
                return match[2] + (match[3] || "");
            }
        }
        return fullHost;
    }
    function urlParseFullHost(url, inclPort) {
        var result = null;
        if (url) {
            var match = url.match(/(\w*):\/\/(.[^/:]+)(\:[\d]+)?/i);
            if (match != null && match.length > 2 && isString(match[2]) && match[2].length > 0) {
                result = match[2] || "";
                if (inclPort && match.length > 2) {
                    var protocol = (match[1] || "").toLowerCase();
                    var port = match[3] || "";
                    if (protocol === "http" && port === ":80") {
                        port = "";
                    }
                    else if (protocol === "https" && port === ":443") {
                        port = "";
                    }
                    result += port;
                }
            }
        }
        return result;
    }

    var _internalEndpoints = [
        "https://dc.services.visualstudio.com/v2/track",
        "https://breeze.aimon.applicationinsights.io/v2/track",
        "https://dc-int.services.visualstudio.com/v2/track"
    ];
    function isInternalApplicationInsightsEndpoint(endpointUrl) {
        return arrIndexOf(_internalEndpoints, endpointUrl.toLowerCase()) !== -1;
    }
    function AjaxHelperParseDependencyPath(logger, absoluteUrl, method, commandName) {
        var target, name = commandName, data = commandName;
        if (absoluteUrl && absoluteUrl.length > 0) {
            var parsedUrl = urlParseUrl(absoluteUrl);
            target = parsedUrl.host;
            if (!name) {
                if (parsedUrl.pathname != null) {
                    var pathName = (parsedUrl.pathname.length === 0) ? "/" : parsedUrl.pathname;
                    if (pathName.charAt(0) !== "/") {
                        pathName = "/" + pathName;
                    }
                    data = parsedUrl.pathname;
                    name = dataSanitizeString(logger, method ? method + " " + pathName : pathName);
                }
                else {
                    name = dataSanitizeString(logger, absoluteUrl);
                }
            }
        }
        else {
            target = commandName;
            name = commandName;
        }
        return {
            target: target,
            name: name,
            data: data
        };
    }

    var Envelope = /** @class */ (function () {
        function Envelope(logger, data, name) {
            var _this = this;
            var _self = this;
            _self.ver = 1;
            _self.sampleRate = 100.0;
            _self.tags = {};
            _self.name = dataSanitizeString(logger, name) || strNotSpecified;
            _self.data = data;
            _self.time = toISOString(new Date());
            _self.aiDataContract = {
                time: 1 ,
                iKey: 1 ,
                name: 1 ,
                sampleRate: function () {
                    return (_this.sampleRate === 100) ? 4  : 1 ;
                },
                tags: 1 ,
                data: 1
            };
        }
        return Envelope;
    }());

    var Event = /** @class */ (function () {
        function Event(logger, name, properties, measurements) {
            this.aiDataContract = {
                ver: 1 ,
                name: 1 ,
                properties: 0 ,
                measurements: 0
            };
            var _self = this;
            _self.ver = 2;
            _self.name = dataSanitizeString(logger, name) || strNotSpecified;
            _self.properties = dataSanitizeProperties(logger, properties);
            _self.measurements = dataSanitizeMeasurements(logger, measurements);
        }
        Event.envelopeType = "Microsoft.ApplicationInsights.{0}.Event";
        Event.dataType = "EventData";
        return Event;
    }());

    var NoMethod = "<no_method>";
    var strError = "error";
    var strStack = "stack";
    var strStackDetails = "stackDetails";
    var strErrorSrc = "errorSrc";
    var strMessage = "message";
    var strDescription = "description";
    function _stringify(value, convertToString) {
        var result = value;
        if (result && !isString(result)) {
            if (JSON && JSON.stringify) {
                result = JSON.stringify(value);
                if (convertToString && (!result || result === "{}")) {
                    if (isFunction(value.toString)) {
                        result = value.toString();
                    }
                    else {
                        result = "" + value;
                    }
                }
            }
            else {
                result = "" + value + " - (Missing JSON.stringify)";
            }
        }
        return result || "";
    }
    function _formatMessage(theEvent, errorType) {
        var evtMessage = theEvent;
        if (theEvent) {
            if (evtMessage && !isString(evtMessage)) {
                evtMessage = theEvent[strMessage] || theEvent[strDescription] || evtMessage;
            }
            if (evtMessage && !isString(evtMessage)) {
                evtMessage = _stringify(evtMessage, true);
            }
            if (theEvent["filename"]) {
                evtMessage = evtMessage + " @" + (theEvent["filename"] || "") + ":" + (theEvent["lineno"] || "?") + ":" + (theEvent["colno"] || "?");
            }
        }
        if (errorType && errorType !== "String" && errorType !== "Object" && errorType !== "Error" && (evtMessage || "").indexOf(errorType) === -1) {
            evtMessage = errorType + ": " + evtMessage;
        }
        return evtMessage || "";
    }
    function _isExceptionDetailsInternal(value) {
        try {
            if (isObject(value)) {
                return "hasFullStack" in value && "typeName" in value;
            }
        }
        catch (e) {
        }
        return false;
    }
    function _isExceptionInternal(value) {
        try {
            if (isObject(value)) {
                return ("ver" in value && "exceptions" in value && "properties" in value);
            }
        }
        catch (e) {
        }
        return false;
    }
    function _isStackDetails(details) {
        return details && details.src && isString(details.src) && details.obj && isArray(details.obj);
    }
    function _convertStackObj(errorStack) {
        var src = errorStack || "";
        if (!isString(src)) {
            if (isString(src[strStack])) {
                src = src[strStack];
            }
            else {
                src = "" + src;
            }
        }
        var items = src.split("\n");
        return {
            src: src,
            obj: items
        };
    }
    function _getOperaStack(errorMessage) {
        var stack = [];
        var lines = errorMessage.split("\n");
        for (var lp = 0; lp < lines.length; lp++) {
            var entry = lines[lp];
            if (lines[lp + 1]) {
                entry += "@" + lines[lp + 1];
                lp++;
            }
            stack.push(entry);
        }
        return {
            src: errorMessage,
            obj: stack
        };
    }
    function _getStackFromErrorObj(errorObj) {
        var details = null;
        if (errorObj) {
            try {
                if (errorObj[strStack]) {
                    details = _convertStackObj(errorObj[strStack]);
                }
                else if (errorObj[strError] && errorObj[strError][strStack]) {
                    details = _convertStackObj(errorObj[strError][strStack]);
                }
                else if (errorObj["exception"] && errorObj.exception[strStack]) {
                    details = _convertStackObj(errorObj.exception[strStack]);
                }
                else if (_isStackDetails(errorObj)) {
                    details = errorObj;
                }
                else if (_isStackDetails(errorObj[strStackDetails])) {
                    details = errorObj[strStackDetails];
                }
                else if (window && window["opera"] && errorObj[strMessage]) {
                    details = _getOperaStack(errorObj.message);
                }
                else if (isString(errorObj)) {
                    details = _convertStackObj(errorObj);
                }
                else {
                    var evtMessage = errorObj[strMessage] || errorObj[strDescription] || "";
                    if (isString(errorObj[strErrorSrc])) {
                        if (evtMessage) {
                            evtMessage += "\n";
                        }
                        evtMessage += " from " + errorObj[strErrorSrc];
                    }
                    if (evtMessage) {
                        details = _convertStackObj(evtMessage);
                    }
                }
            }
            catch (e) {
                details = _convertStackObj(e);
            }
        }
        return details || {
            src: "",
            obj: null
        };
    }
    function _formatStackTrace(stackDetails) {
        var stack = "";
        if (stackDetails) {
            if (stackDetails.obj) {
                arrForEach(stackDetails.obj, function (entry) {
                    stack += entry + "\n";
                });
            }
            else {
                stack = stackDetails.src || "";
            }
        }
        return stack;
    }
    function _parseStack(stack) {
        var parsedStack;
        var frames = stack.obj;
        if (frames && frames.length > 0) {
            parsedStack = [];
            var level_1 = 0;
            var totalSizeInBytes_1 = 0;
            arrForEach(frames, function (frame) {
                var theFrame = frame.toString();
                if (_StackFrame.regex.test(theFrame)) {
                    var parsedFrame = new _StackFrame(theFrame, level_1++);
                    totalSizeInBytes_1 += parsedFrame.sizeInBytes;
                    parsedStack.push(parsedFrame);
                }
            });
            var exceptionParsedStackThreshold = 32 * 1024;
            if (totalSizeInBytes_1 > exceptionParsedStackThreshold) {
                var left = 0;
                var right = parsedStack.length - 1;
                var size = 0;
                var acceptedLeft = left;
                var acceptedRight = right;
                while (left < right) {
                    var lSize = parsedStack[left].sizeInBytes;
                    var rSize = parsedStack[right].sizeInBytes;
                    size += lSize + rSize;
                    if (size > exceptionParsedStackThreshold) {
                        var howMany = acceptedRight - acceptedLeft + 1;
                        parsedStack.splice(acceptedLeft, howMany);
                        break;
                    }
                    acceptedLeft = left;
                    acceptedRight = right;
                    left++;
                    right--;
                }
            }
        }
        return parsedStack;
    }
    function _getErrorType(errorType) {
        var typeName = "";
        if (errorType) {
            typeName = errorType.typeName || errorType.name || "";
            if (!typeName) {
                try {
                    var funcNameRegex = /function (.{1,200})\(/;
                    var results = (funcNameRegex).exec((errorType).constructor.toString());
                    typeName = (results && results.length > 1) ? results[1] : "";
                }
                catch (e) {
                }
            }
        }
        return typeName;
    }
    function _formatErrorCode(errorObj) {
        if (errorObj) {
            try {
                if (!isString(errorObj)) {
                    var errorType = _getErrorType(errorObj);
                    var result = _stringify(errorObj, false);
                    if (!result || result === "{}") {
                        if (errorObj[strError]) {
                            errorObj = errorObj[strError];
                            errorType = _getErrorType(errorObj);
                        }
                        result = _stringify(errorObj, true);
                    }
                    if (result.indexOf(errorType) !== 0 && errorType !== "String") {
                        return errorType + ":" + result;
                    }
                    return result;
                }
            }
            catch (e) {
            }
        }
        return "" + (errorObj || "");
    }
    var Exception = /** @class */ (function () {
        function Exception(logger, exception, properties, measurements, severityLevel, id) {
            this.aiDataContract = {
                ver: 1 ,
                exceptions: 1 ,
                severityLevel: 0 ,
                properties: 0 ,
                measurements: 0
            };
            var _self = this;
            _self.ver = 2;
            if (!_isExceptionInternal(exception)) {
                if (!properties) {
                    properties = {};
                }
                _self.exceptions = [new _ExceptionDetails(logger, exception, properties)];
                _self.properties = dataSanitizeProperties(logger, properties);
                _self.measurements = dataSanitizeMeasurements(logger, measurements);
                if (severityLevel) {
                    _self.severityLevel = severityLevel;
                }
                if (id) {
                    _self.id = id;
                }
            }
            else {
                _self.exceptions = exception.exceptions || [];
                _self.properties = exception.properties;
                _self.measurements = exception.measurements;
                if (exception.severityLevel) {
                    _self.severityLevel = exception.severityLevel;
                }
                if (exception.id) {
                    _self.id = exception.id;
                }
                if (exception.problemGroup) {
                    _self.problemGroup = exception.problemGroup;
                }
                if (!isNullOrUndefined(exception.isManual)) {
                    _self.isManual = exception.isManual;
                }
            }
        }
        Exception.CreateAutoException = function (message, url, lineNumber, columnNumber, error, evt, stack, errorSrc) {
            var errorType = _getErrorType(error || evt || message);
            return {
                message: _formatMessage(message, errorType),
                url: url,
                lineNumber: lineNumber,
                columnNumber: columnNumber,
                error: _formatErrorCode(error || evt || message),
                evt: _formatErrorCode(evt || message),
                typeName: errorType,
                stackDetails: _getStackFromErrorObj(stack || error || evt),
                errorSrc: errorSrc
            };
        };
        Exception.CreateFromInterface = function (logger, exception, properties, measurements) {
            var exceptions = exception.exceptions
                && arrMap(exception.exceptions, function (ex) { return _ExceptionDetails.CreateFromInterface(logger, ex); });
            var exceptionData = new Exception(logger, __assignFn(__assignFn({}, exception), { exceptions: exceptions }), properties, measurements);
            return exceptionData;
        };
        Exception.prototype.toInterface = function () {
            var _a = this, exceptions = _a.exceptions, properties = _a.properties, measurements = _a.measurements, severityLevel = _a.severityLevel, problemGroup = _a.problemGroup, id = _a.id, isManual = _a.isManual;
            var exceptionDetailsInterface = exceptions instanceof Array
                && arrMap(exceptions, function (exception) { return exception.toInterface(); })
                || undefined;
            return {
                ver: "4.0",
                exceptions: exceptionDetailsInterface,
                severityLevel: severityLevel,
                properties: properties,
                measurements: measurements,
                problemGroup: problemGroup,
                id: id,
                isManual: isManual
            };
        };
        Exception.CreateSimpleException = function (message, typeName, assembly, fileName, details, line) {
            return {
                exceptions: [
                    {
                        hasFullStack: true,
                        message: message,
                        stack: details,
                        typeName: typeName
                    }
                ]
            };
        };
        Exception.envelopeType = "Microsoft.ApplicationInsights.{0}.Exception";
        Exception.dataType = "ExceptionData";
        Exception.formatError = _formatErrorCode;
        return Exception;
    }());
    var _ExceptionDetails = /** @class */ (function () {
        function _ExceptionDetails(logger, exception, properties) {
            this.aiDataContract = {
                id: 0 ,
                outerId: 0 ,
                typeName: 1 ,
                message: 1 ,
                hasFullStack: 0 ,
                stack: 0 ,
                parsedStack: 2
            };
            var _self = this;
            if (!_isExceptionDetailsInternal(exception)) {
                var error = exception;
                var evt = error && error.evt;
                if (!isError(error)) {
                    error = error[strError] || evt || error;
                }
                _self.typeName = dataSanitizeString(logger, _getErrorType(error)) || strNotSpecified;
                _self.message = dataSanitizeMessage(logger, _formatMessage(exception || error, _self.typeName)) || strNotSpecified;
                var stack = exception[strStackDetails] || _getStackFromErrorObj(exception);
                _self.parsedStack = _parseStack(stack);
                _self[strStack] = dataSanitizeException(logger, _formatStackTrace(stack));
                _self.hasFullStack = isArray(_self.parsedStack) && _self.parsedStack.length > 0;
                if (properties) {
                    properties.typeName = properties.typeName || _self.typeName;
                }
            }
            else {
                _self.typeName = exception.typeName;
                _self.message = exception.message;
                _self[strStack] = exception[strStack];
                _self.parsedStack = exception.parsedStack || [];
                _self.hasFullStack = exception.hasFullStack;
            }
        }
        _ExceptionDetails.prototype.toInterface = function () {
            var _self = this;
            var parsedStack = _self.parsedStack instanceof Array
                && arrMap(_self.parsedStack, function (frame) { return frame.toInterface(); });
            var exceptionDetailsInterface = {
                id: _self.id,
                outerId: _self.outerId,
                typeName: _self.typeName,
                message: _self.message,
                hasFullStack: _self.hasFullStack,
                stack: _self[strStack],
                parsedStack: parsedStack || undefined
            };
            return exceptionDetailsInterface;
        };
        _ExceptionDetails.CreateFromInterface = function (logger, exception) {
            var parsedStack = (exception.parsedStack instanceof Array
                && arrMap(exception.parsedStack, function (frame) { return _StackFrame.CreateFromInterface(frame); }))
                || exception.parsedStack;
            var exceptionDetails = new _ExceptionDetails(logger, __assignFn(__assignFn({}, exception), { parsedStack: parsedStack }));
            return exceptionDetails;
        };
        return _ExceptionDetails;
    }());
    var _StackFrame = /** @class */ (function () {
        function _StackFrame(sourceFrame, level) {
            this.aiDataContract = {
                level: 1 ,
                method: 1 ,
                assembly: 0 ,
                fileName: 0 ,
                line: 0
            };
            var _self = this;
            _self.sizeInBytes = 0;
            if (typeof sourceFrame === "string") {
                var frame = sourceFrame;
                _self.level = level;
                _self.method = NoMethod;
                _self.assembly = strTrim(frame);
                _self.fileName = "";
                _self.line = 0;
                var matches = frame.match(_StackFrame.regex);
                if (matches && matches.length >= 5) {
                    _self.method = strTrim(matches[2]) || _self.method;
                    _self.fileName = strTrim(matches[4]);
                    _self.line = parseInt(matches[5]) || 0;
                }
            }
            else {
                _self.level = sourceFrame.level;
                _self.method = sourceFrame.method;
                _self.assembly = sourceFrame.assembly;
                _self.fileName = sourceFrame.fileName;
                _self.line = sourceFrame.line;
                _self.sizeInBytes = 0;
            }
            _self.sizeInBytes += _self.method.length;
            _self.sizeInBytes += _self.fileName.length;
            _self.sizeInBytes += _self.assembly.length;
            _self.sizeInBytes += _StackFrame.baseSize;
            _self.sizeInBytes += _self.level.toString().length;
            _self.sizeInBytes += _self.line.toString().length;
        }
        _StackFrame.CreateFromInterface = function (frame) {
            return new _StackFrame(frame, null );
        };
        _StackFrame.prototype.toInterface = function () {
            var _self = this;
            return {
                level: _self.level,
                method: _self.method,
                assembly: _self.assembly,
                fileName: _self.fileName,
                line: _self.line
            };
        };
        _StackFrame.regex = /^([\s]+at)?[\s]{0,50}([^\@\()]+?)[\s]{0,50}(\@|\()([^\(\n]+):([0-9]+):([0-9]+)(\)?)$/;
        _StackFrame.baseSize = 58;
        return _StackFrame;
    }());

    var DataPoint = /** @class */ (function () {
        function DataPoint() {
            this.aiDataContract = {
                name: 1 ,
                kind: 0 ,
                value: 1 ,
                count: 0 ,
                min: 0 ,
                max: 0 ,
                stdDev: 0
            };
            this.kind = 0 ;
        }
        return DataPoint;
    }());

    var Metric = /** @class */ (function () {
        function Metric(logger, name, value, count, min, max, stdDev, properties, measurements) {
            this.aiDataContract = {
                ver: 1 ,
                metrics: 1 ,
                properties: 0
            };
            var _self = this;
            _self.ver = 2;
            var dataPoint = new DataPoint();
            dataPoint.count = count > 0 ? count : undefined;
            dataPoint.max = isNaN(max) || max === null ? undefined : max;
            dataPoint.min = isNaN(min) || min === null ? undefined : min;
            dataPoint.name = dataSanitizeString(logger, name) || strNotSpecified;
            dataPoint.value = value;
            dataPoint.stdDev = isNaN(stdDev) || stdDev === null ? undefined : stdDev;
            _self.metrics = [dataPoint];
            _self.properties = dataSanitizeProperties(logger, properties);
            _self.measurements = dataSanitizeMeasurements(logger, measurements);
        }
        Metric.envelopeType = "Microsoft.ApplicationInsights.{0}.Metric";
        Metric.dataType = "MetricData";
        return Metric;
    }());

    var PageView = /** @class */ (function () {
        function PageView(logger, name, url, durationMs, properties, measurements, id) {
            this.aiDataContract = {
                ver: 1 ,
                name: 0 ,
                url: 0 ,
                duration: 0 ,
                properties: 0 ,
                measurements: 0 ,
                id: 0
            };
            var _self = this;
            _self.ver = 2;
            _self.id = dataSanitizeId(logger, id);
            _self.url = dataSanitizeUrl(logger, url);
            _self.name = dataSanitizeString(logger, name) || strNotSpecified;
            if (!isNaN(durationMs)) {
                _self.duration = msToTimeSpan(durationMs);
            }
            _self.properties = dataSanitizeProperties(logger, properties);
            _self.measurements = dataSanitizeMeasurements(logger, measurements);
        }
        PageView.envelopeType = "Microsoft.ApplicationInsights.{0}.Pageview";
        PageView.dataType = "PageviewData";
        return PageView;
    }());

    var RemoteDependencyData = /** @class */ (function () {
        function RemoteDependencyData(logger, id, absoluteUrl, commandName, value, success, resultCode, method, requestAPI, correlationContext, properties, measurements) {
            if (requestAPI === void 0) { requestAPI = "Ajax"; }
            this.aiDataContract = {
                id: 1 ,
                ver: 1 ,
                name: 0 ,
                resultCode: 0 ,
                duration: 0 ,
                success: 0 ,
                data: 0 ,
                target: 0 ,
                type: 0 ,
                properties: 0 ,
                measurements: 0 ,
                kind: 0 ,
                value: 0 ,
                count: 0 ,
                min: 0 ,
                max: 0 ,
                stdDev: 0 ,
                dependencyKind: 0 ,
                dependencySource: 0 ,
                commandName: 0 ,
                dependencyTypeName: 0
            };
            var _self = this;
            _self.ver = 2;
            _self.id = id;
            _self.duration = msToTimeSpan(value);
            _self.success = success;
            _self.resultCode = resultCode + "";
            _self.type = dataSanitizeString(logger, requestAPI);
            var dependencyFields = AjaxHelperParseDependencyPath(logger, absoluteUrl, method, commandName);
            _self.data = dataSanitizeUrl(logger, commandName) || dependencyFields.data;
            _self.target = dataSanitizeString(logger, dependencyFields.target);
            if (correlationContext) {
                _self.target = "".concat(_self.target, " | ").concat(correlationContext);
            }
            _self.name = dataSanitizeString(logger, dependencyFields.name);
            _self.properties = dataSanitizeProperties(logger, properties);
            _self.measurements = dataSanitizeMeasurements(logger, measurements);
        }
        RemoteDependencyData.envelopeType = "Microsoft.ApplicationInsights.{0}.RemoteDependency";
        RemoteDependencyData.dataType = "RemoteDependencyData";
        return RemoteDependencyData;
    }());

    var Trace = /** @class */ (function () {
        function Trace(logger, message, severityLevel, properties, measurements) {
            this.aiDataContract = {
                ver: 1 ,
                message: 1 ,
                severityLevel: 0 ,
                properties: 0
            };
            var _self = this;
            _self.ver = 2;
            message = message || strNotSpecified;
            _self.message = dataSanitizeMessage(logger, message);
            _self.properties = dataSanitizeProperties(logger, properties);
            _self.measurements = dataSanitizeMeasurements(logger, measurements);
            if (severityLevel) {
                _self.severityLevel = severityLevel;
            }
        }
        Trace.envelopeType = "Microsoft.ApplicationInsights.{0}.Message";
        Trace.dataType = "MessageData";
        return Trace;
    }());

    var PageViewPerformance = /** @class */ (function () {
        function PageViewPerformance(logger, name, url, unused, properties, measurements, cs4BaseData) {
            this.aiDataContract = {
                ver: 1 ,
                name: 0 ,
                url: 0 ,
                duration: 0 ,
                perfTotal: 0 ,
                networkConnect: 0 ,
                sentRequest: 0 ,
                receivedResponse: 0 ,
                domProcessing: 0 ,
                properties: 0 ,
                measurements: 0
            };
            var _self = this;
            _self.ver = 2;
            _self.url = dataSanitizeUrl(logger, url);
            _self.name = dataSanitizeString(logger, name) || strNotSpecified;
            _self.properties = dataSanitizeProperties(logger, properties);
            _self.measurements = dataSanitizeMeasurements(logger, measurements);
            if (cs4BaseData) {
                _self.domProcessing = cs4BaseData.domProcessing;
                _self.duration = cs4BaseData.duration;
                _self.networkConnect = cs4BaseData.networkConnect;
                _self.perfTotal = cs4BaseData.perfTotal;
                _self.receivedResponse = cs4BaseData.receivedResponse;
                _self.sentRequest = cs4BaseData.sentRequest;
            }
        }
        PageViewPerformance.envelopeType = "Microsoft.ApplicationInsights.{0}.PageviewPerformance";
        PageViewPerformance.dataType = "PageviewPerformanceData";
        return PageViewPerformance;
    }());

    var Data = /** @class */ (function () {
        function Data(baseType, data) {
            this.aiDataContract = {
                baseType: 1 ,
                baseData: 1
            };
            this.baseType = baseType;
            this.baseData = data;
        }
        return Data;
    }());

    function _aiNameFunc(baseName) {
        var aiName = "ai." + baseName + ".";
        return function (name) {
            return aiName + name;
        };
    }
    var _aiApplication = _aiNameFunc("application");
    var _aiDevice = _aiNameFunc("device");
    var _aiLocation = _aiNameFunc("location");
    var _aiOperation = _aiNameFunc("operation");
    var _aiSession = _aiNameFunc("session");
    var _aiUser = _aiNameFunc("user");
    var _aiCloud = _aiNameFunc("cloud");
    var _aiInternal = _aiNameFunc("internal");
    var ContextTagKeys = /** @class */ (function (_super) {
        __extendsFn(ContextTagKeys, _super);
        function ContextTagKeys() {
            return _super.call(this) || this;
        }
        return ContextTagKeys;
    }(createClassFromInterface({
        applicationVersion: _aiApplication("ver"),
        applicationBuild: _aiApplication("build"),
        applicationTypeId: _aiApplication("typeId"),
        applicationId: _aiApplication("applicationId"),
        applicationLayer: _aiApplication("layer"),
        deviceId: _aiDevice("id"),
        deviceIp: _aiDevice("ip"),
        deviceLanguage: _aiDevice("language"),
        deviceLocale: _aiDevice("locale"),
        deviceModel: _aiDevice("model"),
        deviceFriendlyName: _aiDevice("friendlyName"),
        deviceNetwork: _aiDevice("network"),
        deviceNetworkName: _aiDevice("networkName"),
        deviceOEMName: _aiDevice("oemName"),
        deviceOS: _aiDevice("os"),
        deviceOSVersion: _aiDevice("osVersion"),
        deviceRoleInstance: _aiDevice("roleInstance"),
        deviceRoleName: _aiDevice("roleName"),
        deviceScreenResolution: _aiDevice("screenResolution"),
        deviceType: _aiDevice("type"),
        deviceMachineName: _aiDevice("machineName"),
        deviceVMName: _aiDevice("vmName"),
        deviceBrowser: _aiDevice("browser"),
        deviceBrowserVersion: _aiDevice("browserVersion"),
        locationIp: _aiLocation("ip"),
        locationCountry: _aiLocation("country"),
        locationProvince: _aiLocation("province"),
        locationCity: _aiLocation("city"),
        operationId: _aiOperation("id"),
        operationName: _aiOperation("name"),
        operationParentId: _aiOperation("parentId"),
        operationRootId: _aiOperation("rootId"),
        operationSyntheticSource: _aiOperation("syntheticSource"),
        operationCorrelationVector: _aiOperation("correlationVector"),
        sessionId: _aiSession("id"),
        sessionIsFirst: _aiSession("isFirst"),
        sessionIsNew: _aiSession("isNew"),
        userAccountAcquisitionDate: _aiUser("accountAcquisitionDate"),
        userAccountId: _aiUser("accountId"),
        userAgent: _aiUser("userAgent"),
        userId: _aiUser("id"),
        userStoreRegion: _aiUser("storeRegion"),
        userAuthUserId: _aiUser("authUserId"),
        userAnonymousUserAcquisitionDate: _aiUser("anonUserAcquisitionDate"),
        userAuthenticatedUserAcquisitionDate: _aiUser("authUserAcquisitionDate"),
        cloudName: _aiCloud("name"),
        cloudRole: _aiCloud("role"),
        cloudRoleVer: _aiCloud("roleVer"),
        cloudRoleInstance: _aiCloud("roleInstance"),
        cloudEnvironment: _aiCloud("environment"),
        cloudLocation: _aiCloud("location"),
        cloudDeploymentUnit: _aiCloud("deploymentUnit"),
        internalNodeName: _aiInternal("nodeName"),
        internalSdkVersion: _aiInternal("sdkVersion"),
        internalAgentVersion: _aiInternal("agentVersion"),
        internalSnippet: _aiInternal("snippet"),
        internalSdkSrc: _aiInternal("sdkSrc")
    })));

    var CtxTagKeys = new ContextTagKeys();

    var BreezeChannelIdentifier = "AppInsightsChannelPlugin";

    var BaseSendBuffer = /** @class */ (function () {
        function BaseSendBuffer(logger, config) {
            var _buffer = [];
            var _bufferFullMessageSent = false;
            this._get = function () {
                return _buffer;
            };
            this._set = function (buffer) {
                _buffer = buffer;
                return _buffer;
            };
            dynamicProto(BaseSendBuffer, this, function (_self) {
                _self.enqueue = function (payload) {
                    if (_self.count() >= config.eventsLimitInMem()) {
                        if (!_bufferFullMessageSent) {
                            _throwInternal(logger, 2 , 105 , "Maximum in-memory buffer size reached: " + _self.count(), true);
                            _bufferFullMessageSent = true;
                        }
                        return;
                    }
                    _buffer.push(payload);
                };
                _self.count = function () {
                    return _buffer.length;
                };
                _self.size = function () {
                    var size = _buffer.length;
                    for (var lp = 0; lp < _buffer.length; lp++) {
                        size += _buffer[lp].length;
                    }
                    if (!config.emitLineDelimitedJson()) {
                        size += 2;
                    }
                    return size;
                };
                _self.clear = function () {
                    _buffer = [];
                    _bufferFullMessageSent = false;
                };
                _self.getItems = function () {
                    return _buffer.slice(0);
                };
                _self.batchPayloads = function (payload) {
                    if (payload && payload.length > 0) {
                        var batch = config.emitLineDelimitedJson() ?
                            payload.join("\n") :
                            "[" + payload.join(",") + "]";
                        return batch;
                    }
                    return null;
                };
            });
        }
        return BaseSendBuffer;
    }());
    var ArraySendBuffer = /** @class */ (function (_super) {
        __extendsFn(ArraySendBuffer, _super);
        function ArraySendBuffer(logger, config) {
            var _this = _super.call(this, logger, config) || this;
            dynamicProto(ArraySendBuffer, _this, function (_self, _base) {
                _self.markAsSent = function (payload) {
                    _base.clear();
                };
                _self.clearSent = function (payload) {
                };
            });
            return _this;
        }
        return ArraySendBuffer;
    }(BaseSendBuffer));
    var SessionStorageSendBuffer = /** @class */ (function (_super) {
        __extendsFn(SessionStorageSendBuffer, _super);
        function SessionStorageSendBuffer(logger, config) {
            var _this = _super.call(this, logger, config) || this;
            var _bufferFullMessageSent = false;
            dynamicProto(SessionStorageSendBuffer, _this, function (_self, _base) {
                var bufferItems = _getBuffer(SessionStorageSendBuffer.BUFFER_KEY);
                var notDeliveredItems = _getBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY);
                var buffer = _self._set(bufferItems.concat(notDeliveredItems));
                if (buffer.length > SessionStorageSendBuffer.MAX_BUFFER_SIZE) {
                    buffer.length = SessionStorageSendBuffer.MAX_BUFFER_SIZE;
                }
                _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, []);
                _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, buffer);
                _self.enqueue = function (payload) {
                    if (_self.count() >= SessionStorageSendBuffer.MAX_BUFFER_SIZE) {
                        if (!_bufferFullMessageSent) {
                            _throwInternal(logger, 2 , 67 , "Maximum buffer size reached: " + _self.count(), true);
                            _bufferFullMessageSent = true;
                        }
                        return;
                    }
                    _base.enqueue(payload);
                    _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, _self._get());
                };
                _self.clear = function () {
                    _base.clear();
                    _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, _self._get());
                    _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, []);
                    _bufferFullMessageSent = false;
                };
                _self.markAsSent = function (payload) {
                    _setBuffer(SessionStorageSendBuffer.BUFFER_KEY, _self._set(_removePayloadsFromBuffer(payload, _self._get())));
                    var sentElements = _getBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY);
                    if (sentElements instanceof Array && payload instanceof Array) {
                        sentElements = sentElements.concat(payload);
                        if (sentElements.length > SessionStorageSendBuffer.MAX_BUFFER_SIZE) {
                            _throwInternal(logger, 1 , 67 , "Sent buffer reached its maximum size: " + sentElements.length, true);
                            sentElements.length = SessionStorageSendBuffer.MAX_BUFFER_SIZE;
                        }
                        _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, sentElements);
                    }
                };
                _self.clearSent = function (payload) {
                    var sentElements = _getBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY);
                    sentElements = _removePayloadsFromBuffer(payload, sentElements);
                    _setBuffer(SessionStorageSendBuffer.SENT_BUFFER_KEY, sentElements);
                };
                function _removePayloadsFromBuffer(payloads, buffer) {
                    var remaining = [];
                    arrForEach(buffer, function (value) {
                        if (!isFunction(value) && arrIndexOf(payloads, value) === -1) {
                            remaining.push(value);
                        }
                    });
                    return remaining;
                }
                function _getBuffer(key) {
                    var prefixedKey = key;
                    try {
                        prefixedKey = config.namePrefix && config.namePrefix() ? config.namePrefix() + "_" + prefixedKey : prefixedKey;
                        var bufferJson = utlGetSessionStorage(logger, prefixedKey);
                        if (bufferJson) {
                            var buffer_1 = getJSON().parse(bufferJson);
                            if (isString(buffer_1)) {
                                buffer_1 = getJSON().parse(buffer_1);
                            }
                            if (buffer_1 && isArray(buffer_1)) {
                                return buffer_1;
                            }
                        }
                    }
                    catch (e) {
                        _throwInternal(logger, 1 , 42 , " storage key: " + prefixedKey + ", " + getExceptionName(e), { exception: dumpObj(e) });
                    }
                    return [];
                }
                function _setBuffer(key, buffer) {
                    var prefixedKey = key;
                    try {
                        prefixedKey = config.namePrefix && config.namePrefix() ? config.namePrefix() + "_" + prefixedKey : prefixedKey;
                        var bufferJson = JSON.stringify(buffer);
                        utlSetSessionStorage(logger, prefixedKey, bufferJson);
                    }
                    catch (e) {
                        utlSetSessionStorage(logger, prefixedKey, JSON.stringify([]));
                        _throwInternal(logger, 2 , 41 , " storage key: " + prefixedKey + ", " + getExceptionName(e) + ". Buffer cleared", { exception: dumpObj(e) });
                    }
                }
            });
            return _this;
        }
        SessionStorageSendBuffer.BUFFER_KEY = "AI_buffer";
        SessionStorageSendBuffer.SENT_BUFFER_KEY = "AI_sentBuffer";
        SessionStorageSendBuffer.MAX_BUFFER_SIZE = 2000;
        return SessionStorageSendBuffer;
    }(BaseSendBuffer));

    var strBaseType = "baseType";
    var strBaseData = "baseData";
    var strProperties = "properties";
    var strTrue = "true";
    function _setValueIf(target, field, value) {
        return setValue(target, field, value, isTruthy);
    }
    function _extractPartAExtensions(logger, item, env) {
        var envTags = env.tags = env.tags || {};
        var itmExt = item.ext = item.ext || {};
        var itmTags = item.tags = item.tags || [];
        var extUser = itmExt.user;
        if (extUser) {
            _setValueIf(envTags, CtxTagKeys.userAuthUserId, extUser.authId);
            _setValueIf(envTags, CtxTagKeys.userId, extUser.id || extUser.localId);
        }
        var extApp = itmExt.app;
        if (extApp) {
            _setValueIf(envTags, CtxTagKeys.sessionId, extApp.sesId);
        }
        var extDevice = itmExt.device;
        if (extDevice) {
            _setValueIf(envTags, CtxTagKeys.deviceId, extDevice.id || extDevice.localId);
            _setValueIf(envTags, CtxTagKeys.deviceType, extDevice.deviceClass);
            _setValueIf(envTags, CtxTagKeys.deviceIp, extDevice.ip);
            _setValueIf(envTags, CtxTagKeys.deviceModel, extDevice.model);
            _setValueIf(envTags, CtxTagKeys.deviceType, extDevice.deviceType);
        }
        var web = item.ext.web;
        if (web) {
            _setValueIf(envTags, CtxTagKeys.deviceLanguage, web.browserLang);
            _setValueIf(envTags, CtxTagKeys.deviceBrowserVersion, web.browserVer);
            _setValueIf(envTags, CtxTagKeys.deviceBrowser, web.browser);
            var envData = env.data = env.data || {};
            var envBaseData = envData[strBaseData] = envData[strBaseData] || {};
            var envProps = envBaseData[strProperties] = envBaseData[strProperties] || {};
            _setValueIf(envProps, "domain", web.domain);
            _setValueIf(envProps, "isManual", web.isManual ? strTrue : null);
            _setValueIf(envProps, "screenRes", web.screenRes);
            _setValueIf(envProps, "userConsent", web.userConsent ? strTrue : null);
        }
        var extOs = itmExt.os;
        if (extOs) {
            _setValueIf(envTags, CtxTagKeys.deviceOS, extOs.name);
        }
        var extTrace = itmExt.trace;
        if (extTrace) {
            _setValueIf(envTags, CtxTagKeys.operationParentId, extTrace.parentID);
            _setValueIf(envTags, CtxTagKeys.operationName, dataSanitizeString(logger, extTrace.name));
            _setValueIf(envTags, CtxTagKeys.operationId, extTrace.traceID);
        }
        var tgs = {};
        for (var i = itmTags.length - 1; i >= 0; i--) {
            var tg = itmTags[i];
            objForEachKey(tg, function (key, value) {
                tgs[key] = value;
            });
            itmTags.splice(i, 1);
        }
        objForEachKey(itmTags, function (tg, value) {
            tgs[tg] = value;
        });
        var theTags = __assignFn(__assignFn({}, envTags), tgs);
        if (!theTags[CtxTagKeys.internalSdkVersion]) {
            theTags[CtxTagKeys.internalSdkVersion] = "javascript:".concat(EnvelopeCreator.Version);
        }
        env.tags = optimizeObject(theTags);
    }
    function _extractPropsAndMeasurements(data, properties, measurements) {
        if (!isNullOrUndefined(data)) {
            objForEachKey(data, function (key, value) {
                if (isNumber(value)) {
                    measurements[key] = value;
                }
                else if (isString(value)) {
                    properties[key] = value;
                }
                else if (hasJSON()) {
                    properties[key] = getJSON().stringify(value);
                }
            });
        }
    }
    function _convertPropsUndefinedToCustomDefinedValue(properties, customUndefinedValue) {
        if (!isNullOrUndefined(properties)) {
            objForEachKey(properties, function (key, value) {
                properties[key] = value || customUndefinedValue;
            });
        }
    }
    function _createEnvelope(logger, envelopeType, telemetryItem, data) {
        var envelope = new Envelope(logger, data, envelopeType);
        _setValueIf(envelope, "sampleRate", telemetryItem[SampleRate]);
        if ((telemetryItem[strBaseData] || {}).startTime) {
            envelope.time = toISOString(telemetryItem[strBaseData].startTime);
        }
        envelope.iKey = telemetryItem.iKey;
        var iKeyNoDashes = telemetryItem.iKey.replace(/-/g, "");
        envelope.name = envelope.name.replace("{0}", iKeyNoDashes);
        _extractPartAExtensions(logger, telemetryItem, envelope);
        telemetryItem.tags = telemetryItem.tags || [];
        return optimizeObject(envelope);
    }
    function EnvelopeCreatorInit(logger, telemetryItem) {
        if (isNullOrUndefined(telemetryItem[strBaseData])) {
            _throwInternal(logger, 1 , 46 , "telemetryItem.baseData cannot be null.");
        }
    }
    var EnvelopeCreator = {
        Version: "2.8.4"
    };
    function DependencyEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
        EnvelopeCreatorInit(logger, telemetryItem);
        var customMeasurements = telemetryItem[strBaseData].measurements || {};
        var customProperties = telemetryItem[strBaseData][strProperties] || {};
        _extractPropsAndMeasurements(telemetryItem.data, customProperties, customMeasurements);
        if (!isNullOrUndefined(customUndefinedValue)) {
            _convertPropsUndefinedToCustomDefinedValue(customProperties, customUndefinedValue);
        }
        var bd = telemetryItem[strBaseData];
        if (isNullOrUndefined(bd)) {
            _warnToConsole(logger, "Invalid input for dependency data");
            return null;
        }
        var method = bd[strProperties] && bd[strProperties][HttpMethod] ? bd[strProperties][HttpMethod] : "GET";
        var remoteDepData = new RemoteDependencyData(logger, bd.id, bd.target, bd.name, bd.duration, bd.success, bd.responseCode, method, bd.type, bd.correlationContext, customProperties, customMeasurements);
        var data = new Data(RemoteDependencyData.dataType, remoteDepData);
        return _createEnvelope(logger, RemoteDependencyData.envelopeType, telemetryItem, data);
    }
    function EventEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
        EnvelopeCreatorInit(logger, telemetryItem);
        var customProperties = {};
        var customMeasurements = {};
        if (telemetryItem[strBaseType] !== Event.dataType) {
            customProperties["baseTypeSource"] = telemetryItem[strBaseType];
        }
        if (telemetryItem[strBaseType] === Event.dataType) {
            customProperties = telemetryItem[strBaseData][strProperties] || {};
            customMeasurements = telemetryItem[strBaseData].measurements || {};
        }
        else {
            if (telemetryItem[strBaseData]) {
                _extractPropsAndMeasurements(telemetryItem[strBaseData], customProperties, customMeasurements);
            }
        }
        _extractPropsAndMeasurements(telemetryItem.data, customProperties, customMeasurements);
        if (!isNullOrUndefined(customUndefinedValue)) {
            _convertPropsUndefinedToCustomDefinedValue(customProperties, customUndefinedValue);
        }
        var eventName = telemetryItem[strBaseData].name;
        var eventData = new Event(logger, eventName, customProperties, customMeasurements);
        var data = new Data(Event.dataType, eventData);
        return _createEnvelope(logger, Event.envelopeType, telemetryItem, data);
    }
    function ExceptionEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
        EnvelopeCreatorInit(logger, telemetryItem);
        var customMeasurements = telemetryItem[strBaseData].measurements || {};
        var customProperties = telemetryItem[strBaseData][strProperties] || {};
        _extractPropsAndMeasurements(telemetryItem.data, customProperties, customMeasurements);
        if (!isNullOrUndefined(customUndefinedValue)) {
            _convertPropsUndefinedToCustomDefinedValue(customProperties, customUndefinedValue);
        }
        var bd = telemetryItem[strBaseData];
        var exData = Exception.CreateFromInterface(logger, bd, customProperties, customMeasurements);
        var data = new Data(Exception.dataType, exData);
        return _createEnvelope(logger, Exception.envelopeType, telemetryItem, data);
    }
    function MetricEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
        EnvelopeCreatorInit(logger, telemetryItem);
        var baseData = telemetryItem[strBaseData];
        var props = baseData[strProperties] || {};
        var measurements = baseData.measurements || {};
        _extractPropsAndMeasurements(telemetryItem.data, props, measurements);
        if (!isNullOrUndefined(customUndefinedValue)) {
            _convertPropsUndefinedToCustomDefinedValue(props, customUndefinedValue);
        }
        var baseMetricData = new Metric(logger, baseData.name, baseData.average, baseData.sampleCount, baseData.min, baseData.max, baseData.stdDev, props, measurements);
        var data = new Data(Metric.dataType, baseMetricData);
        return _createEnvelope(logger, Metric.envelopeType, telemetryItem, data);
    }
    function PageViewEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
        EnvelopeCreatorInit(logger, telemetryItem);
        var strDuration = "duration";
        var duration;
        var baseData = telemetryItem[strBaseData];
        if (!isNullOrUndefined(baseData) &&
            !isNullOrUndefined(baseData[strProperties]) &&
            !isNullOrUndefined(baseData[strProperties][strDuration])) {
            duration = baseData[strProperties][strDuration];
            delete baseData[strProperties][strDuration];
        }
        else if (!isNullOrUndefined(telemetryItem.data) &&
            !isNullOrUndefined(telemetryItem.data[strDuration])) {
            duration = telemetryItem.data[strDuration];
            delete telemetryItem.data[strDuration];
        }
        var bd = telemetryItem[strBaseData];
        var currentContextId;
        if (((telemetryItem.ext || {}).trace || {}).traceID) {
            currentContextId = telemetryItem.ext.trace.traceID;
        }
        var id = bd.id || currentContextId;
        var name = bd.name;
        var url = bd.uri;
        var properties = bd[strProperties] || {};
        var measurements = bd.measurements || {};
        if (!isNullOrUndefined(bd.refUri)) {
            properties["refUri"] = bd.refUri;
        }
        if (!isNullOrUndefined(bd.pageType)) {
            properties["pageType"] = bd.pageType;
        }
        if (!isNullOrUndefined(bd.isLoggedIn)) {
            properties["isLoggedIn"] = bd.isLoggedIn.toString();
        }
        if (!isNullOrUndefined(bd[strProperties])) {
            var pageTags = bd[strProperties];
            objForEachKey(pageTags, function (key, value) {
                properties[key] = value;
            });
        }
        _extractPropsAndMeasurements(telemetryItem.data, properties, measurements);
        if (!isNullOrUndefined(customUndefinedValue)) {
            _convertPropsUndefinedToCustomDefinedValue(properties, customUndefinedValue);
        }
        var pageViewData = new PageView(logger, name, url, duration, properties, measurements, id);
        var data = new Data(PageView.dataType, pageViewData);
        return _createEnvelope(logger, PageView.envelopeType, telemetryItem, data);
    }
    function PageViewPerformanceEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
        EnvelopeCreatorInit(logger, telemetryItem);
        var bd = telemetryItem[strBaseData];
        var name = bd.name;
        var url = bd.uri || bd.url;
        var properties = bd[strProperties] || {};
        var measurements = bd.measurements || {};
        _extractPropsAndMeasurements(telemetryItem.data, properties, measurements);
        if (!isNullOrUndefined(customUndefinedValue)) {
            _convertPropsUndefinedToCustomDefinedValue(properties, customUndefinedValue);
        }
        var baseData = new PageViewPerformance(logger, name, url, undefined, properties, measurements, bd);
        var data = new Data(PageViewPerformance.dataType, baseData);
        return _createEnvelope(logger, PageViewPerformance.envelopeType, telemetryItem, data);
    }
    function TraceEnvelopeCreator(logger, telemetryItem, customUndefinedValue) {
        EnvelopeCreatorInit(logger, telemetryItem);
        var message = telemetryItem[strBaseData].message;
        var severityLevel = telemetryItem[strBaseData].severityLevel;
        var props = telemetryItem[strBaseData][strProperties] || {};
        var measurements = telemetryItem[strBaseData].measurements || {};
        _extractPropsAndMeasurements(telemetryItem.data, props, measurements);
        if (!isNullOrUndefined(customUndefinedValue)) {
            _convertPropsUndefinedToCustomDefinedValue(props, customUndefinedValue);
        }
        var baseData = new Trace(logger, message, severityLevel, props, measurements);
        var data = new Data(Trace.dataType, baseData);
        return _createEnvelope(logger, Trace.envelopeType, telemetryItem, data);
    }

    var Serializer = /** @class */ (function () {
        function Serializer(logger) {
            dynamicProto(Serializer, this, function (_self) {
                _self.serialize = function (input) {
                    var output = _serializeObject(input, "root");
                    try {
                        return getJSON().stringify(output);
                    }
                    catch (e) {
                        _throwInternal(logger, 1 , 48 , (e && isFunction(e.toString)) ? e.toString() : "Error serializing object", null, true);
                    }
                };
                function _serializeObject(source, name) {
                    var circularReferenceCheck = "__aiCircularRefCheck";
                    var output = {};
                    if (!source) {
                        _throwInternal(logger, 1 , 48 , "cannot serialize object because it is null or undefined", { name: name }, true);
                        return output;
                    }
                    if (source[circularReferenceCheck]) {
                        _throwInternal(logger, 2 , 50 , "Circular reference detected while serializing object", { name: name }, true);
                        return output;
                    }
                    if (!source.aiDataContract) {
                        if (name === "measurements") {
                            output = _serializeStringMap(source, "number", name);
                        }
                        else if (name === "properties") {
                            output = _serializeStringMap(source, "string", name);
                        }
                        else if (name === "tags") {
                            output = _serializeStringMap(source, "string", name);
                        }
                        else if (isArray(source)) {
                            output = _serializeArray(source, name);
                        }
                        else {
                            _throwInternal(logger, 2 , 49 , "Attempting to serialize an object which does not implement ISerializable", { name: name }, true);
                            try {
                                getJSON().stringify(source);
                                output = source;
                            }
                            catch (e) {
                                _throwInternal(logger, 1 , 48 , (e && isFunction(e.toString)) ? e.toString() : "Error serializing object", null, true);
                            }
                        }
                        return output;
                    }
                    source[circularReferenceCheck] = true;
                    objForEachKey(source.aiDataContract, function (field, contract) {
                        var isRequired = (isFunction(contract)) ? (contract() & 1 ) : (contract & 1 );
                        var isHidden = (isFunction(contract)) ? (contract() & 4 ) : (contract & 4 );
                        var isArray = contract & 2 ;
                        var isPresent = source[field] !== undefined;
                        var isObj = isObject(source[field]) && source[field] !== null;
                        if (isRequired && !isPresent && !isArray) {
                            _throwInternal(logger, 1 , 24 , "Missing required field specification. The field is required but not present on source", { field: field, name: name });
                        }
                        else if (!isHidden) {
                            var value = void 0;
                            if (isObj) {
                                if (isArray) {
                                    value = _serializeArray(source[field], field);
                                }
                                else {
                                    value = _serializeObject(source[field], field);
                                }
                            }
                            else {
                                value = source[field];
                            }
                            if (value !== undefined) {
                                output[field] = value;
                            }
                        }
                    });
                    delete source[circularReferenceCheck];
                    return output;
                }
                function _serializeArray(sources, name) {
                    var output;
                    if (!!sources) {
                        if (!isArray(sources)) {
                            _throwInternal(logger, 1 , 54 , "This field was specified as an array in the contract but the item is not an array.\r\n", { name: name }, true);
                        }
                        else {
                            output = [];
                            for (var i = 0; i < sources.length; i++) {
                                var source = sources[i];
                                var item = _serializeObject(source, name + "[" + i + "]");
                                output.push(item);
                            }
                        }
                    }
                    return output;
                }
                function _serializeStringMap(map, expectedType, name) {
                    var output;
                    if (map) {
                        output = {};
                        objForEachKey(map, function (field, value) {
                            if (expectedType === "string") {
                                if (value === undefined) {
                                    output[field] = "undefined";
                                }
                                else if (value === null) {
                                    output[field] = "null";
                                }
                                else if (!value.toString) {
                                    output[field] = "invalid field: toString() is not defined.";
                                }
                                else {
                                    output[field] = value.toString();
                                }
                            }
                            else if (expectedType === "number") {
                                if (value === undefined) {
                                    output[field] = "undefined";
                                }
                                else if (value === null) {
                                    output[field] = "null";
                                }
                                else {
                                    var num = parseFloat(value);
                                    if (isNaN(num)) {
                                        output[field] = "NaN";
                                    }
                                    else {
                                        output[field] = num;
                                    }
                                }
                            }
                            else {
                                output[field] = "invalid field: " + name + " is of unknown type.";
                                _throwInternal(logger, 1 , output[field], null, true);
                            }
                        });
                    }
                    return output;
                }
            });
        }
        return Serializer;
    }());

    function _disableEvents(target, evtNamespace) {
        eventOff(target, null, null, evtNamespace);
    }
    function createOfflineListener(parentEvtNamespace) {
        var _document = getDocument();
        var _navigator = getNavigator();
        var _isListening = false;
        var _onlineStatus = true;
        var _evtNamespace = mergeEvtNamespace(createUniqueNamespace("OfflineListener"), parentEvtNamespace);
        try {
            if (_enableEvents(getWindow())) {
                _isListening = true;
            }
            if (_document) {
                var target = _document.body || _document;
                if (target.ononline) {
                    if (_enableEvents(target)) {
                        _isListening = true;
                    }
                }
            }
            if (_isListening) {
                if (_navigator && !isNullOrUndefined(_navigator.onLine)) {
                    _onlineStatus = _navigator.onLine;
                }
            }
        }
        catch (e) {
            _isListening = false;
        }
        function _enableEvents(target) {
            var enabled = false;
            if (target) {
                enabled = eventOn(target, "online", _setOnline, _evtNamespace);
                if (enabled) {
                    eventOn(target, "offline", _setOffline, _evtNamespace);
                }
            }
            return enabled;
        }
        function _setOnline() {
            _onlineStatus = true;
        }
        function _setOffline() {
            _onlineStatus = false;
        }
        function _isOnline() {
            var result = true;
            if (_isListening) {
                result = _onlineStatus;
            }
            else if (_navigator && !isNullOrUndefined(_navigator.onLine)) {
                result = _navigator.onLine;
            }
            return result;
        }
        function _unload() {
            var win = getWindow();
            if (win && _isListening) {
                _disableEvents(win, _evtNamespace);
                if (_document) {
                    var target = _document.body || _document;
                    if (!isUndefined(target.ononline)) {
                        _disableEvents(target, _evtNamespace);
                    }
                }
                _isListening = false;
            }
        }
        return {
            isOnline: _isOnline,
            isListening: function () { return _isListening; },
            unload: _unload
        };
    }

    var MIN_INPUT_LENGTH = 8;
    var HashCodeScoreGenerator = /** @class */ (function () {
        function HashCodeScoreGenerator() {
        }
        HashCodeScoreGenerator.prototype.getHashCodeScore = function (key) {
            var score = this.getHashCode(key) / HashCodeScoreGenerator.INT_MAX_VALUE;
            return score * 100;
        };
        HashCodeScoreGenerator.prototype.getHashCode = function (input) {
            if (input === "") {
                return 0;
            }
            while (input.length < MIN_INPUT_LENGTH) {
                input = input.concat(input);
            }
            var hash = 5381;
            for (var i = 0; i < input.length; ++i) {
                hash = ((hash << 5) + hash) + input.charCodeAt(i);
                hash = hash & hash;
            }
            return Math.abs(hash);
        };
        HashCodeScoreGenerator.INT_MAX_VALUE = 2147483647;
        return HashCodeScoreGenerator;
    }());

    var SamplingScoreGenerator = /** @class */ (function () {
        function SamplingScoreGenerator() {
            var _self = this;
            var hashCodeGenerator = new HashCodeScoreGenerator();
            var keys = new ContextTagKeys();
            _self.getSamplingScore = function (item) {
                var score = 0;
                if (item.tags && item.tags[keys.userId]) {
                    score = hashCodeGenerator.getHashCodeScore(item.tags[keys.userId]);
                }
                else if (item.ext && item.ext.user && item.ext.user.id) {
                    score = hashCodeGenerator.getHashCodeScore(item.ext.user.id);
                }
                else if (item.tags && item.tags[keys.operationId]) {
                    score = hashCodeGenerator.getHashCodeScore(item.tags[keys.operationId]);
                }
                else if (item.ext && item.ext.telemetryTrace && item.ext.telemetryTrace.traceID) {
                    score = hashCodeGenerator.getHashCodeScore(item.ext.telemetryTrace.traceID);
                }
                else {
                    score = (Math.random() * 100);
                }
                return score;
            };
        }
        return SamplingScoreGenerator;
    }());

    var Sample = /** @class */ (function () {
        function Sample(sampleRate, logger) {
            this.INT_MAX_VALUE = 2147483647;
            var _logger = logger || safeGetLogger(null);
            if (sampleRate > 100 || sampleRate < 0) {
                _logger.throwInternal(2 , 58 , "Sampling rate is out of range (0..100). Sampling will be disabled, you may be sending too much data which may affect your AI service level.", { samplingRate: sampleRate }, true);
                sampleRate = 100;
            }
            this.sampleRate = sampleRate;
            this.samplingScoreGenerator = new SamplingScoreGenerator();
        }
        Sample.prototype.isSampledIn = function (envelope) {
            var samplingPercentage = this.sampleRate;
            var isSampledIn = false;
            if (samplingPercentage === null || samplingPercentage === undefined || samplingPercentage >= 100) {
                return true;
            }
            else if (envelope.baseType === Metric.dataType) {
                return true;
            }
            isSampledIn = this.samplingScoreGenerator.getSamplingScore(envelope) < samplingPercentage;
            return isSampledIn;
        };
        return Sample;
    }());

    var _a;
    var FetchSyncRequestSizeLimitBytes = 65000;
    function _getResponseText(xhr) {
        try {
            return xhr.responseText;
        }
        catch (e) {
        }
        return null;
    }
    function _getDefaultAppInsightsChannelConfig() {
        return {
            endpointUrl: function () { return "https://dc.services.visualstudio.com/v2/track"; },
            emitLineDelimitedJson: function () { return false; },
            maxBatchInterval: function () { return 15000; },
            maxBatchSizeInBytes: function () { return 102400; },
            disableTelemetry: function () { return false; },
            enableSessionStorageBuffer: function () { return true; },
            isRetryDisabled: function () { return false; },
            isBeaconApiDisabled: function () { return true; },
            disableXhr: function () { return false; },
            onunloadDisableFetch: function () { return false; },
            onunloadDisableBeacon: function () { return false; },
            instrumentationKey: function () { return undefined; },
            namePrefix: function () { return undefined; },
            samplingPercentage: function () { return 100; },
            customHeaders: function () { return undefined; },
            convertUndefined: function () { return undefined; },
            eventsLimitInMem: function () { return 10000; }
        };
    }
    var EnvelopeTypeCreator = (_a = {},
        _a[Event.dataType] = EventEnvelopeCreator,
        _a[Trace.dataType] = TraceEnvelopeCreator,
        _a[PageView.dataType] = PageViewEnvelopeCreator,
        _a[PageViewPerformance.dataType] = PageViewPerformanceEnvelopeCreator,
        _a[Exception.dataType] = ExceptionEnvelopeCreator,
        _a[Metric.dataType] = MetricEnvelopeCreator,
        _a[RemoteDependencyData.dataType] = DependencyEnvelopeCreator,
        _a);
    var Sender = /** @class */ (function (_super) {
        __extendsFn(Sender, _super);
        function Sender() {
            var _this = _super.call(this) || this;
            _this.priority = 1001;
            _this.identifier = BreezeChannelIdentifier;
            _this._senderConfig = _getDefaultAppInsightsChannelConfig();
            var _consecutiveErrors;
            var _retryAt;
            var _lastSend;
            var _paused;
            var _timeoutHandle;
            var _serializer;
            var _stamp_specific_redirects;
            var _headers;
            var _syncFetchPayload = 0;
            var _fallbackSender;
            var _syncUnloadSender;
            var _offlineListener;
            var _evtNamespace;
            dynamicProto(Sender, _this, function (_self, _base) {
                _initDefaults();
                _self.pause = function () {
                    _clearScheduledTimer();
                    _paused = true;
                };
                _self.resume = function () {
                    if (_paused) {
                        _paused = false;
                        _retryAt = null;
                        if (_self._buffer.size() > _self._senderConfig.maxBatchSizeInBytes()) {
                            _self.triggerSend(true, null, 10 );
                        }
                        _setupTimer();
                    }
                };
                _self.flush = function (isAsync, callBack, sendReason) {
                    if (isAsync === void 0) { isAsync = true; }
                    if (!_paused) {
                        _clearScheduledTimer();
                        try {
                            _self.triggerSend(isAsync, null, sendReason || 1 );
                        }
                        catch (e) {
                            _throwInternal(_self.diagLog(), 1 , 22 , "flush failed, telemetry will not be collected: " + getExceptionName(e), { exception: dumpObj(e) });
                        }
                    }
                };
                _self.onunloadFlush = function () {
                    if (!_paused) {
                        if ((_self._senderConfig.onunloadDisableBeacon() === false || _self._senderConfig.isBeaconApiDisabled() === false) && isBeaconsSupported()) {
                            try {
                                _self.triggerSend(true, _doUnloadSend, 2 );
                            }
                            catch (e) {
                                _throwInternal(_self.diagLog(), 1 , 20 , "failed to flush with beacon sender on page unload, telemetry will not be collected: " + getExceptionName(e), { exception: dumpObj(e) });
                            }
                        }
                        else {
                            _self.flush();
                        }
                    }
                };
                _self.addHeader = function (name, value) {
                    _headers[name] = value;
                };
                _self.initialize = function (config, core, extensions, pluginChain) {
                    if (_self.isInitialized()) {
                        _throwInternal(_self.diagLog(), 1 , 28 , "Sender is already initialized");
                    }
                    _base.initialize(config, core, extensions, pluginChain);
                    var ctx = _self._getTelCtx();
                    var identifier = _self.identifier;
                    _serializer = new Serializer(core.logger);
                    _consecutiveErrors = 0;
                    _retryAt = null;
                    _lastSend = 0;
                    _self._sender = null;
                    _stamp_specific_redirects = 0;
                    var diagLog = _self.diagLog();
                    _evtNamespace = mergeEvtNamespace(createUniqueNamespace("Sender"), core.evtNamespace && core.evtNamespace());
                    _offlineListener = createOfflineListener(_evtNamespace);
                    var defaultConfig = _getDefaultAppInsightsChannelConfig();
                    objForEachKey(defaultConfig, function (field, value) {
                        _self._senderConfig[field] = function () { return ctx.getConfig(identifier, field, value()); };
                    });
                    _self._buffer = (_self._senderConfig.enableSessionStorageBuffer() && utlCanUseSessionStorage())
                        ? new SessionStorageSendBuffer(diagLog, _self._senderConfig) : new ArraySendBuffer(diagLog, _self._senderConfig);
                    _self._sample = new Sample(_self._senderConfig.samplingPercentage(), diagLog);
                    if (!_validateInstrumentationKey(config)) {
                        _throwInternal(diagLog, 1 , 100 , "Invalid Instrumentation key " + config.instrumentationKey);
                    }
                    if (!isInternalApplicationInsightsEndpoint(_self._senderConfig.endpointUrl()) && _self._senderConfig.customHeaders() && _self._senderConfig.customHeaders().length > 0) {
                        arrForEach(_self._senderConfig.customHeaders(), function (customHeader) {
                            _this.addHeader(customHeader.header, customHeader.value);
                        });
                    }
                    var senderConfig = _self._senderConfig;
                    var sendPostFunc = null;
                    if (!senderConfig.disableXhr() && useXDomainRequest()) {
                        sendPostFunc = _xdrSender;
                    }
                    else if (!senderConfig.disableXhr() && isXhrSupported()) {
                        sendPostFunc = _xhrSender;
                    }
                    if (!sendPostFunc && isFetchSupported()) {
                        sendPostFunc = _fetchSender;
                    }
                    _fallbackSender = sendPostFunc || _xhrSender;
                    if (!senderConfig.isBeaconApiDisabled() && isBeaconsSupported()) {
                        sendPostFunc = _beaconSender;
                    }
                    _self._sender = sendPostFunc || _xhrSender;
                    if (!senderConfig.onunloadDisableFetch() && isFetchSupported(true)) {
                        _syncUnloadSender = _fetchKeepAliveSender;
                    }
                    else if (isBeaconsSupported()) {
                        _syncUnloadSender = _beaconSender;
                    }
                    else if (!senderConfig.disableXhr() && useXDomainRequest()) {
                        _syncUnloadSender = _xdrSender;
                    }
                    else if (!senderConfig.disableXhr() && isXhrSupported()) {
                        _syncUnloadSender = _xhrSender;
                    }
                    else {
                        _syncUnloadSender = _fallbackSender;
                    }
                };
                _self.processTelemetry = function (telemetryItem, itemCtx) {
                    itemCtx = _self._getTelCtx(itemCtx);
                    try {
                        if (_self._senderConfig.disableTelemetry()) {
                            return;
                        }
                        if (!telemetryItem) {
                            _throwInternal(itemCtx.diagLog(), 1 , 7 , "Cannot send empty telemetry");
                            return;
                        }
                        if (telemetryItem.baseData && !telemetryItem.baseType) {
                            _throwInternal(itemCtx.diagLog(), 1 , 70 , "Cannot send telemetry without baseData and baseType");
                            return;
                        }
                        if (!telemetryItem.baseType) {
                            telemetryItem.baseType = "EventData";
                        }
                        if (!_self._sender) {
                            _throwInternal(itemCtx.diagLog(), 1 , 28 , "Sender was not initialized");
                            return;
                        }
                        if (!_isSampledIn(telemetryItem)) {
                            _throwInternal(itemCtx.diagLog(), 2 , 33 , "Telemetry item was sampled out and not sent", { SampleRate: _self._sample.sampleRate });
                            return;
                        }
                        else {
                            telemetryItem[SampleRate] = _self._sample.sampleRate;
                        }
                        var convertUndefined = _self._senderConfig.convertUndefined() || undefined;
                        var defaultEnvelopeIkey = telemetryItem.iKey || _self._senderConfig.instrumentationKey();
                        var aiEnvelope_1 = Sender.constructEnvelope(telemetryItem, defaultEnvelopeIkey, itemCtx.diagLog(), convertUndefined);
                        if (!aiEnvelope_1) {
                            _throwInternal(itemCtx.diagLog(), 1 , 47 , "Unable to create an AppInsights envelope");
                            return;
                        }
                        var doNotSendItem_1 = false;
                        if (telemetryItem.tags && telemetryItem.tags[ProcessLegacy]) {
                            arrForEach(telemetryItem.tags[ProcessLegacy], function (callBack) {
                                try {
                                    if (callBack && callBack(aiEnvelope_1) === false) {
                                        doNotSendItem_1 = true;
                                        _warnToConsole(itemCtx.diagLog(), "Telemetry processor check returns false");
                                    }
                                }
                                catch (e) {
                                    _throwInternal(itemCtx.diagLog(), 1 , 64 , "One of telemetry initializers failed, telemetry item will not be sent: " + getExceptionName(e), { exception: dumpObj(e) }, true);
                                }
                            });
                            delete telemetryItem.tags[ProcessLegacy];
                        }
                        if (doNotSendItem_1) {
                            return;
                        }
                        var payload = _serializer.serialize(aiEnvelope_1);
                        var buffer = _self._buffer;
                        var bufferSize = buffer.size();
                        if ((bufferSize + payload.length) > _self._senderConfig.maxBatchSizeInBytes()) {
                            _self.triggerSend(true, null, 10 );
                        }
                        buffer.enqueue(payload);
                        _setupTimer();
                    }
                    catch (e) {
                        _throwInternal(itemCtx.diagLog(), 2 , 12 , "Failed adding telemetry to the sender's buffer, some telemetry will be lost: " + getExceptionName(e), { exception: dumpObj(e) });
                    }
                    _self.processNext(telemetryItem, itemCtx);
                };
                _self._xhrReadyStateChange = function (xhr, payload, countOfItemsInPayload) {
                    if (xhr.readyState === 4) {
                        _checkResponsStatus(xhr.status, payload, xhr.responseURL, countOfItemsInPayload, _formatErrorMessageXhr(xhr), _getResponseText(xhr) || xhr.response);
                    }
                };
                _self.triggerSend = function (async, forcedSender, sendReason) {
                    if (async === void 0) { async = true; }
                    if (!_paused) {
                        try {
                            var buffer = _self._buffer;
                            if (!_self._senderConfig.disableTelemetry()) {
                                if (buffer.count() > 0) {
                                    var payload = buffer.getItems();
                                    _notifySendRequest(sendReason || 0 , async);
                                    if (forcedSender) {
                                        forcedSender.call(_this, payload, async);
                                    }
                                    else {
                                        _self._sender(payload, async);
                                    }
                                }
                                _lastSend = +new Date;
                            }
                            else {
                                buffer.clear();
                            }
                            _clearScheduledTimer();
                        }
                        catch (e) {
                            var ieVer = getIEVersion();
                            if (!ieVer || ieVer > 9) {
                                _throwInternal(_self.diagLog(), 1 , 40 , "Telemetry transmission failed, some telemetry will be lost: " + getExceptionName(e), { exception: dumpObj(e) });
                            }
                        }
                    }
                };
                _self._doTeardown = function (unloadCtx, unloadState) {
                    _self.onunloadFlush();
                    _offlineListener.unload();
                    _initDefaults();
                };
                _self._onError = function (payload, message, event) {
                    _throwInternal(_self.diagLog(), 2 , 26 , "Failed to send telemetry.", { message: message });
                    _self._buffer.clearSent(payload);
                };
                _self._onPartialSuccess = function (payload, results) {
                    var failed = [];
                    var retry = [];
                    var errors = results.errors.reverse();
                    for (var _i = 0, errors_1 = errors; _i < errors_1.length; _i++) {
                        var error = errors_1[_i];
                        var extracted = payload.splice(error.index, 1)[0];
                        if (_isRetriable(error.statusCode)) {
                            retry.push(extracted);
                        }
                        else {
                            failed.push(extracted);
                        }
                    }
                    if (payload.length > 0) {
                        _self._onSuccess(payload, results.itemsAccepted);
                    }
                    if (failed.length > 0) {
                        _self._onError(failed, _formatErrorMessageXhr(null, ["partial success", results.itemsAccepted, "of", results.itemsReceived].join(" ")));
                    }
                    if (retry.length > 0) {
                        _resendPayload(retry);
                        _throwInternal(_self.diagLog(), 2 , 40 , "Partial success. " +
                            "Delivered: " + payload.length + ", Failed: " + failed.length +
                            ". Will retry to send " + retry.length + " our of " + results.itemsReceived + " items");
                    }
                };
                _self._onSuccess = function (payload, countOfItemsInPayload) {
                    _self._buffer.clearSent(payload);
                };
                _self._xdrOnLoad = function (xdr, payload) {
                    var responseText = _getResponseText(xdr);
                    if (xdr && (responseText + "" === "200" || responseText === "")) {
                        _consecutiveErrors = 0;
                        _self._onSuccess(payload, 0);
                    }
                    else {
                        var results = _parseResponse(responseText);
                        if (results && results.itemsReceived && results.itemsReceived > results.itemsAccepted
                            && !_self._senderConfig.isRetryDisabled()) {
                            _self._onPartialSuccess(payload, results);
                        }
                        else {
                            _self._onError(payload, _formatErrorMessageXdr(xdr));
                        }
                    }
                };
                function _isSampledIn(envelope) {
                    return _self._sample.isSampledIn(envelope);
                }
                function _checkResponsStatus(status, payload, responseUrl, countOfItemsInPayload, errorMessage, res) {
                    var response = null;
                    if (!_self._appId) {
                        response = _parseResponse(res);
                        if (response && response.appId) {
                            _self._appId = response.appId;
                        }
                    }
                    if ((status < 200 || status >= 300) && status !== 0) {
                        if (status === 301 || status === 307 || status === 308) {
                            if (!_checkAndUpdateEndPointUrl(responseUrl)) {
                                _self._onError(payload, errorMessage);
                                return;
                            }
                        }
                        if (!_self._senderConfig.isRetryDisabled() && _isRetriable(status)) {
                            _resendPayload(payload);
                            _throwInternal(_self.diagLog(), 2 , 40 , ". " +
                                "Response code " + status + ". Will retry to send " + payload.length + " items.");
                        }
                        else {
                            _self._onError(payload, errorMessage);
                        }
                    }
                    else if (_offlineListener && !_offlineListener.isOnline()) {
                        if (!_self._senderConfig.isRetryDisabled()) {
                            var offlineBackOffMultiplier = 10;
                            _resendPayload(payload, offlineBackOffMultiplier);
                            _throwInternal(_self.diagLog(), 2 , 40 , ". Offline - Response Code: ".concat(status, ". Offline status: ").concat(!_offlineListener.isOnline(), ". Will retry to send ").concat(payload.length, " items."));
                        }
                    }
                    else {
                        _checkAndUpdateEndPointUrl(responseUrl);
                        if (status === 206) {
                            if (!response) {
                                response = _parseResponse(res);
                            }
                            if (response && !_self._senderConfig.isRetryDisabled()) {
                                _self._onPartialSuccess(payload, response);
                            }
                            else {
                                _self._onError(payload, errorMessage);
                            }
                        }
                        else {
                            _consecutiveErrors = 0;
                            _self._onSuccess(payload, countOfItemsInPayload);
                        }
                    }
                }
                function _checkAndUpdateEndPointUrl(responseUrl) {
                    if (_stamp_specific_redirects >= 10) {
                        return false;
                    }
                    if (!isNullOrUndefined(responseUrl) && responseUrl !== "") {
                        if (responseUrl !== _self._senderConfig.endpointUrl()) {
                            _self._senderConfig.endpointUrl = function () { return responseUrl; };
                            ++_stamp_specific_redirects;
                            return true;
                        }
                    }
                    return false;
                }
                function _doUnloadSend(payload, isAsync) {
                    if (_syncUnloadSender) {
                        _syncUnloadSender(payload, false);
                    }
                    else {
                        _beaconSender(payload, isAsync);
                    }
                }
                function _doBeaconSend(payload) {
                    var nav = getNavigator();
                    var buffer = _self._buffer;
                    var url = _self._senderConfig.endpointUrl();
                    var batch = _self._buffer.batchPayloads(payload);
                    var plainTextBatch = new Blob([batch], { type: "text/plain;charset=UTF-8" });
                    var queued = nav.sendBeacon(url, plainTextBatch);
                    if (queued) {
                        buffer.markAsSent(payload);
                        _self._onSuccess(payload, payload.length);
                    }
                    return queued;
                }
                function _beaconSender(payload, isAsync) {
                    if (isArray(payload) && payload.length > 0) {
                        if (!_doBeaconSend(payload)) {
                            var droppedPayload = [];
                            for (var lp = 0; lp < payload.length; lp++) {
                                var thePayload = payload[lp];
                                if (!_doBeaconSend([thePayload])) {
                                    droppedPayload.push(thePayload);
                                }
                            }
                            if (droppedPayload.length > 0) {
                                _fallbackSender && _fallbackSender(droppedPayload, true);
                                _throwInternal(_self.diagLog(), 2 , 40 , ". " + "Failed to send telemetry with Beacon API, retried with normal sender.");
                            }
                        }
                    }
                }
                function _xhrSender(payload, isAsync) {
                    var xhr = new XMLHttpRequest();
                    var endPointUrl = _self._senderConfig.endpointUrl();
                    try {
                        xhr[DisabledPropertyName] = true;
                    }
                    catch (e) {
                    }
                    xhr.open("POST", endPointUrl, isAsync);
                    xhr.setRequestHeader("Content-type", "application/json");
                    if (isInternalApplicationInsightsEndpoint(endPointUrl)) {
                        xhr.setRequestHeader(RequestHeaders.sdkContextHeader, RequestHeaders.sdkContextHeaderAppIdRequest);
                    }
                    arrForEach(objKeys(_headers), function (headerName) {
                        xhr.setRequestHeader(headerName, _headers[headerName]);
                    });
                    xhr.onreadystatechange = function () { return _self._xhrReadyStateChange(xhr, payload, payload.length); };
                    xhr.onerror = function (event) { return _self._onError(payload, _formatErrorMessageXhr(xhr), event); };
                    var batch = _self._buffer.batchPayloads(payload);
                    xhr.send(batch);
                    _self._buffer.markAsSent(payload);
                }
                function _fetchKeepAliveSender(payload, isAsync) {
                    if (isArray(payload)) {
                        var payloadSize = payload.length;
                        for (var lp = 0; lp < payload.length; lp++) {
                            payloadSize += payload[lp].length;
                        }
                        if ((_syncFetchPayload + payloadSize) <= FetchSyncRequestSizeLimitBytes) {
                            _doFetchSender(payload, false);
                        }
                        else if (isBeaconsSupported()) {
                            _beaconSender(payload, isAsync);
                        }
                        else {
                            _fallbackSender && _fallbackSender(payload, true);
                            _throwInternal(_self.diagLog(), 2 , 40 , ". " + "Failed to send telemetry with Beacon API, retried with xhrSender.");
                        }
                    }
                }
                function _fetchSender(payload, isAsync) {
                    _doFetchSender(payload, true);
                }
                function _doFetchSender(payload, isAsync) {
                    var _a;
                    var endPointUrl = _self._senderConfig.endpointUrl();
                    var batch = _self._buffer.batchPayloads(payload);
                    var plainTextBatch = new Blob([batch], { type: "application/json" });
                    var requestHeaders = new Headers();
                    var batchLength = batch.length;
                    var ignoreResponse = false;
                    var responseHandled = false;
                    if (isInternalApplicationInsightsEndpoint(endPointUrl)) {
                        requestHeaders.append(RequestHeaders.sdkContextHeader, RequestHeaders.sdkContextHeaderAppIdRequest);
                    }
                    arrForEach(objKeys(_headers), function (headerName) {
                        requestHeaders.append(headerName, _headers[headerName]);
                    });
                    var init = (_a = {
                            method: "POST",
                            headers: requestHeaders,
                            body: plainTextBatch
                        },
                        _a[DisabledPropertyName] = true
                    ,
                        _a);
                    if (!isAsync) {
                        init.keepalive = true;
                        ignoreResponse = true;
                        _syncFetchPayload += batchLength;
                    }
                    var request = new Request(endPointUrl, init);
                    try {
                        request[DisabledPropertyName] = true;
                    }
                    catch (e) {
                    }
                    _self._buffer.markAsSent(payload);
                    try {
                        fetch(request).then(function (response) {
                            if (!isAsync) {
                                _syncFetchPayload -= batchLength;
                                batchLength = 0;
                            }
                            if (!responseHandled) {
                                responseHandled = true;
                                if (!response.ok) {
                                    _self._onError(payload, response.statusText);
                                }
                                else {
                                    response.text().then(function (text) {
                                        _checkResponsStatus(response.status, payload, response.url, payload.length, response.statusText, text);
                                    });
                                }
                            }
                        })["catch"](function (error) {
                            if (!isAsync) {
                                _syncFetchPayload -= batchLength;
                                batchLength = 0;
                            }
                            if (!responseHandled) {
                                responseHandled = true;
                                _self._onError(payload, error.message);
                            }
                        });
                    }
                    catch (e) {
                        if (!responseHandled) {
                            _self._onError(payload, dumpObj(e));
                        }
                    }
                    if (ignoreResponse && !responseHandled) {
                        responseHandled = true;
                        _self._onSuccess(payload, payload.length);
                    }
                }
                function _parseResponse(response) {
                    try {
                        if (response && response !== "") {
                            var result = getJSON().parse(response);
                            if (result && result.itemsReceived && result.itemsReceived >= result.itemsAccepted &&
                                result.itemsReceived - result.itemsAccepted === result.errors.length) {
                                return result;
                            }
                        }
                    }
                    catch (e) {
                        _throwInternal(_self.diagLog(), 1 , 43 , "Cannot parse the response. " + getExceptionName(e), {
                            response: response
                        });
                    }
                    return null;
                }
                function _resendPayload(payload, linearFactor) {
                    if (linearFactor === void 0) { linearFactor = 1; }
                    if (!payload || payload.length === 0) {
                        return;
                    }
                    var buffer = _self._buffer;
                    buffer.clearSent(payload);
                    _consecutiveErrors++;
                    for (var _i = 0, payload_1 = payload; _i < payload_1.length; _i++) {
                        var item = payload_1[_i];
                        buffer.enqueue(item);
                    }
                    _setRetryTime(linearFactor);
                    _setupTimer();
                }
                function _setRetryTime(linearFactor) {
                    var SlotDelayInSeconds = 10;
                    var delayInSeconds;
                    if (_consecutiveErrors <= 1) {
                        delayInSeconds = SlotDelayInSeconds;
                    }
                    else {
                        var backOffSlot = (Math.pow(2, _consecutiveErrors) - 1) / 2;
                        var backOffDelay = Math.floor(Math.random() * backOffSlot * SlotDelayInSeconds) + 1;
                        backOffDelay = linearFactor * backOffDelay;
                        delayInSeconds = Math.max(Math.min(backOffDelay, 3600), SlotDelayInSeconds);
                    }
                    var retryAfterTimeSpan = dateNow() + (delayInSeconds * 1000);
                    _retryAt = retryAfterTimeSpan;
                }
                function _setupTimer() {
                    if (!_timeoutHandle && !_paused) {
                        var retryInterval = _retryAt ? Math.max(0, _retryAt - dateNow()) : 0;
                        var timerValue = Math.max(_self._senderConfig.maxBatchInterval(), retryInterval);
                        _timeoutHandle = setTimeout(function () {
                            _timeoutHandle = null;
                            _self.triggerSend(true, null, 1 );
                        }, timerValue);
                    }
                }
                function _clearScheduledTimer() {
                    clearTimeout(_timeoutHandle);
                    _timeoutHandle = null;
                    _retryAt = null;
                }
                function _isRetriable(statusCode) {
                    return statusCode === 408
                        || statusCode === 429
                        || statusCode === 500
                        || statusCode === 503;
                }
                function _formatErrorMessageXhr(xhr, message) {
                    if (xhr) {
                        return "XMLHttpRequest,Status:" + xhr.status + ",Response:" + _getResponseText(xhr) || xhr.response || "";
                    }
                    return message;
                }
                function _xdrSender(payload, isAsync) {
                    var buffer = _self._buffer;
                    var _window = getWindow();
                    var xdr = new XDomainRequest();
                    xdr.onload = function () { return _self._xdrOnLoad(xdr, payload); };
                    xdr.onerror = function (event) { return _self._onError(payload, _formatErrorMessageXdr(xdr), event); };
                    var hostingProtocol = _window && _window.location && _window.location.protocol || "";
                    if (_self._senderConfig.endpointUrl().lastIndexOf(hostingProtocol, 0) !== 0) {
                        _throwInternal(_self.diagLog(), 2 , 40 , ". " +
                            "Cannot send XDomain request. The endpoint URL protocol doesn't match the hosting page protocol.");
                        buffer.clear();
                        return;
                    }
                    var endpointUrl = _self._senderConfig.endpointUrl().replace(/^(https?:)/, "");
                    xdr.open("POST", endpointUrl);
                    var batch = buffer.batchPayloads(payload);
                    xdr.send(batch);
                    buffer.markAsSent(payload);
                }
                function _formatErrorMessageXdr(xdr, message) {
                    if (xdr) {
                        return "XDomainRequest,Response:" + _getResponseText(xdr) || "";
                    }
                    return message;
                }
                function _getNotifyMgr() {
                    var func = "getNotifyMgr";
                    if (_self.core[func]) {
                        return _self.core[func]();
                    }
                    return _self.core["_notificationManager"];
                }
                function _notifySendRequest(sendRequest, isAsync) {
                    var manager = _getNotifyMgr();
                    if (manager && manager.eventsSendRequest) {
                        try {
                            manager.eventsSendRequest(sendRequest, isAsync);
                        }
                        catch (e) {
                            _throwInternal(_self.diagLog(), 1 , 74 , "send request notification failed: " + getExceptionName(e), { exception: dumpObj(e) });
                        }
                    }
                }
                function _validateInstrumentationKey(config) {
                    var disableIKeyValidationFlag = isNullOrUndefined(config.disableInstrumentationKeyValidation) ? false : config.disableInstrumentationKeyValidation;
                    if (disableIKeyValidationFlag) {
                        return true;
                    }
                    var UUID_Regex = "^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$";
                    var regexp = new RegExp(UUID_Regex);
                    return regexp.test(config.instrumentationKey);
                }
                function _initDefaults() {
                    _self._sender = null;
                    _self._buffer = null;
                    _self._appId = null;
                    _self._sample = null;
                    _headers = {};
                    _offlineListener = null;
                    _consecutiveErrors = 0;
                    _retryAt = null;
                    _lastSend = null;
                    _paused = false;
                    _timeoutHandle = null;
                    _serializer = null;
                    _stamp_specific_redirects = 0;
                    _syncFetchPayload = 0;
                    _fallbackSender = null;
                    _syncUnloadSender = null;
                    _evtNamespace = null;
                }
            });
            return _this;
        }
        Sender.constructEnvelope = function (orig, iKey, logger, convertUndefined) {
            var envelope;
            if (iKey !== orig.iKey && !isNullOrUndefined(iKey)) {
                envelope = __assignFn(__assignFn({}, orig), { iKey: iKey });
            }
            else {
                envelope = orig;
            }
            var creator = EnvelopeTypeCreator[envelope.baseType] || EventEnvelopeCreator;
            return creator(logger, envelope, convertUndefined);
        };
        return Sender;
    }(BaseTelemetryPlugin));

    exports.Sender = Sender;

    (function(obj, prop, descriptor) { /* ai_es3_polyfil defineProperty */ var func = Object["defineProperty"]; if (func) { try { return func(obj, prop, descriptor); } catch(e) { /* IE8 defines defineProperty, but will throw */ } } if (descriptor && typeof descriptor.value !== undefined) { obj[prop] = descriptor.value; } return obj; })(exports, '__esModule', { value: true });

}));
//# sourceMappingURL=applicationinsights-channel-js.js.map
