import { IDiagnosticLogger } from "@microsoft/applicationinsights-core-js";
/**
 * Used to track page visit durations
 */
export declare class PageVisitTimeManager {
    private prevPageVisitDataKeyName;
    private pageVisitTimeTrackingHandler;
    private _logger;
    /**
     * Creates a new instance of PageVisitTimeManager
     * @param pageVisitTimeTrackingHandler Delegate that will be called to send telemetry data to AI (when trackPreviousPageVisit is called)
     * @returns {}
     */
    constructor(logger: IDiagnosticLogger, pageVisitTimeTrackingHandler: (pageName: string, pageUrl: string, pageVisitTime: number) => void);
    /**
    * Tracks the previous page visit time telemetry (if exists) and starts timing of new page visit time
    * @param currentPageName Name of page to begin timing for visit duration
    * @param currentPageUrl Url of page to begin timing for visit duration
    */
    trackPreviousPageVisit(currentPageName: string, currentPageUrl: string): void;
    /**
     * Stops timing of current page (if exists) and starts timing for duration of visit to pageName
     * @param pageName Name of page to begin timing visit duration
     * @returns {PageVisitData} Page visit data (including duration) of pageName from last call to start or restart, if exists. Null if not.
     */
    restartPageVisitTimer(pageName: string, pageUrl: string): PageVisitData;
    /**
     * Starts timing visit duration of pageName
     * @param pageName
     * @returns {}
     */
    startPageVisitTimer(pageName: string, pageUrl: string): void;
    /**
     * Stops timing of current page, if exists.
     * @returns {PageVisitData} Page visit data (including duration) of pageName from call to start, if exists. Null if not.
     */
    stopPageVisitTimer(): PageVisitData;
}
export declare class PageVisitData {
    pageName: string;
    pageUrl: string;
    pageVisitStartTime: number;
    pageVisitTime: number;
    constructor(pageName: string, pageUrl: string);
}
