import { IPageViewPerformanceTelemetryInternal } from "@microsoft/applicationinsights-common";
import { IAppInsightsCore } from "@microsoft/applicationinsights-core-js";
/**
 * Class encapsulates sending page view performance telemetry.
 */
export declare class PageViewPerformanceManager {
    private _logger;
    private MAX_DURATION_ALLOWED;
    constructor(core: IAppInsightsCore);
    populatePageViewPerformanceEvent(pageViewPerformance: IPageViewPerformanceTelemetryInternal): void;
    getPerformanceTiming(): PerformanceTiming | null;
    getPerformanceNavigationTiming(): PerformanceNavigationTiming | null;
    /**
    * Returns true is window PerformanceNavigationTiming API is supported, false otherwise.
    */
    isPerformanceNavigationTimingSupported(): boolean;
    /**
    * Returns true is window performance timing API is supported, false otherwise.
    */
    isPerformanceTimingSupported(): PerformanceTiming;
    /**
    * As page loads different parts of performance timing numbers get set. When all of them are set we can report it.
    * Returns true if ready, false otherwise.
    */
    isPerformanceTimingDataReady(): boolean;
    /**
    * This method tells if given durations should be excluded from collection.
    */
    shouldCollectDuration(...durations: number[]): boolean;
}
