---
stage: Secure
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Use of GET request method with sensitive query strings (session ID)

## Description

A session ID was identified in the request URL as well as a cookie value. Session
IDs should not be sent in GET requests as they maybe captured by proxy systems, stored in
browser history, or stored in log files. If an attacker were to get access to the session
ID they would potentially be able to gain access to the target account.

## Remediation

As request headers are rarely logged or captured by third party systems, ensure session ID
values are only sent in cookies (assigned via `Set-Cookie` response headers) and never sent
in the request URL.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 598.1 | true | 598 | Passive | Medium |

## Links

- [OWASP](https://owasp.org/www-community/vulnerabilities/Information_exposure_through_query_strings_in_url)
- [CWE](https://cwe.mitre.org/data/definitions/598.html)
