---
stage: Plan
group: Project Management
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# Plan and track work **(FREE)**

Plan your work by creating requirements, issues, and epics. Schedule work
with milestones and track your team's time. Learn how to save time with
quick actions, see how GitLab renders Markdown text, and learn how to
use Git to interact with GitLab.

<i class="fa fa-youtube-play youtube" aria-hidden="true"></i>
For a thorough demo of Plan features, see
[Multi-team planning with GitLab Ultimate](https://www.youtube.com/watch?v=KmASFwSap7c).
In this video, Gabe describes a use case of a multi-team organization that uses GitLab
with [Scaled Agile Framework (SAFe)](https://about.gitlab.com/solutions/agile-delivery/scaled-agile/).

## Basic workflow features

Planning features everyone needs to use day-to-day.

- [Keyboard shortcuts](../user/shortcuts.md)
- [Markdown](../user/markdown.md)
- [Quick actions](../user/project/quick_actions.md)
- [To-Do lists](../user/todos.md)
- [Using Git](../topics/git/index.md)

## Team planning

Get work done as a team.

- [Comments and threads](../user/discussions/index.md)
- [Customer relations (CRM)](../user/crm/index.md)
  - [Contacts](../user/crm/index.md#contacts)
  - [Organizations](../user/crm/index.md#organizations)
- [Issues](../user/project/issues/index.md)
- [Iterations](../user/group/iterations/index.md)
- [Labels](../user/project/labels.md)
- [Milestones](../user/project/milestones/index.md)
- [Requirements](../user/project/requirements/index.md)
- [Tasks](../user/tasks.md)
- [Time tracking](../user/project/time_tracking.md)
- [Wikis](../user/project/wiki/index.md)

## Portfolio management

Align your work across teams.

- [Epics](../user/group/epics/index.md)
  - [Multi-level epics](../user/group/epics/manage_epics.md#multi-level-child-epics)
  - [Epic boards](../user/group/epics/epic_boards.md)
  - [View health status](../user/project/issues/managing_issues.md#health-status)
- [Roadmaps](../user/group/roadmap/index.md)
- [Planning hierarchies](../user/group/planning_hierarchy/index.md)
