---
stage: Systems
group: Distribution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://about.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

<!-- any changes made to this page should be reflected in https://about.gitlab.com/support/statement-of-support/#alpha-beta-features and https://about.gitlab.com/handbook/product/gitlab-the-product/#alpha-beta-ga -->

# Support for Alpha, Beta, Limited Availability, and Generally Available Features **(PREMIUM)**

Some GitLab features are released as [Alpha or Beta versions](https://about.gitlab.com/support/statement-of-support/#alpha-beta-features) which are not fully supported. All other features are considered to be Generally Available (GA).

## Alpha Features

Characteristics of alpha features:

- Not ready for production use.
- Unstable and can cause performance and stability issues.
- Configuration and dependencies are likely to change.
- Features and functions may be removed.
- Data loss can occur (be that through bugs or updates).

Support is **not** provided for Alpha features and issues with them should be opened in the [GitLab issue tracker](https://gitlab.com/gitlab-org/gitlab/issues).

## Beta Features

Characteristics of beta features:

- Not ready for production use.
- Unstable and can cause performance and stability issues.
- Configuration and dependencies are not likely to change.
- Features and functions are not likely to change.
- Data loss is not likely.

Your Support Contract provides **commercially-reasonable effort** support for Beta features, with the expectation that issues require extra time and assistance from development to troubleshoot.

## Limited Availability (LA)

Characteristics of limited availability features:

- Ready for production use by a small set of customers.
- Can be booked by Deal Desk as part of an order.
- Fully documented and [supported](https://about.gitlab.com/support/statement-of-support/#starter-premium-and-ultimate-users).

## Generally Available (GA)

Generally Available features means that they passed the [Production Readiness Review](https://gitlab.com/gitlab-com/gl-infra/readiness/-/blob/master/.gitlab/issue_templates/production_readiness.md) for GitLab.com, and are:

- Ready for production use at any scale.
- Fully documented and supported.
