# frozen_string_literal: true

class AddUserFkToVulnerabilityStateTransitions < Gitlab::Database::Migration[2.0]
  disable_ddl_transaction!

  INDEX_NAME = 'index_vulnerability_state_transitions_on_author_id'

  def up
    add_concurrent_index :vulnerability_state_transitions, :author_id, name: INDEX_NAME
    add_concurrent_foreign_key :vulnerability_state_transitions, :users, column: :author_id, on_delete: :nullify
  end

  def down
    with_lock_retries do
      remove_foreign_key :vulnerability_state_transitions, column: :author_id
    end

    remove_concurrent_index_by_name :vulnerability_state_transitions, INDEX_NAME
  end
end
