# frozen_string_literal: true

class AddIndexOnVulnerabilityReadsNamespaceId < Gitlab::Database::Migration[2.0]
  INDEX_NAME = 'index_vuln_reads_on_namespace_id_state_severity_and_vuln_id'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_reads,
                         [:namespace_id, :state, :severity, :vulnerability_id],
                         name: INDEX_NAME,
                         order: { vulnerability_id: :desc }
  end

  def down
    remove_concurrent_index_by_name :vulnerability_reads, INDEX_NAME
  end
end
