# frozen_string_literal: true

class ScheduleBackfillVulnerabilityReadsClusterAgent < Gitlab::Database::Migration[2.0]
  restrict_gitlab_migration gitlab_schema: :gitlab_main

  BATCH_SIZE = 10_000
  SUB_BATCH_SIZE = 1_000
  DELAY_INTERVAL = 2.minutes
  MIGRATION_NAME = 'BackfillVulnerabilityReadsClusterAgent'
  BATCH_CLASS_NAME = 'BackfillVulnerabilityReadsClusterAgentBatchingStrategy'

  disable_ddl_transaction!

  def up
    queue_batched_background_migration(
      MIGRATION_NAME,
      :vulnerability_reads,
      :id,
      job_interval: DELAY_INTERVAL,
      batch_size: BATCH_SIZE,
      batch_class_name: BATCH_CLASS_NAME,
      sub_batch_size: SUB_BATCH_SIZE
    )
  end

  def down
    delete_batched_background_migration(MIGRATION_NAME, :vulnerability_reads, :id, [])
  end
end
