# frozen_string_literal: true

class AddUniqueIndexToVulnerabilityFindingLinksWithTruncate < Gitlab::Database::Migration[1.0]
  disable_ddl_transaction!

  NAME_URL_INDEX_NAME = 'finding_link_name_url_idx'
  URL_INDEX_NAME = 'finding_link_url_idx'

  def up
    execute('TRUNCATE TABLE vulnerability_finding_links')

    add_concurrent_index :vulnerability_finding_links, [:vulnerability_occurrence_id, :name, :url], unique: true, name: NAME_URL_INDEX_NAME
    add_concurrent_index :vulnerability_finding_links, [:vulnerability_occurrence_id, :url], unique: true, where: 'name is null', name: URL_INDEX_NAME
  end

  def down
    remove_concurrent_index :vulnerability_finding_links, [:vulnerability_occurrence_id, :name, :url], name: NAME_URL_INDEX_NAME
    remove_concurrent_index :vulnerability_finding_links, [:vulnerability_occurrence_id, :url], name: URL_INDEX_NAME
  end
end
