# frozen_string_literal: true

class AddForeignKeyToVulnerabilityReadsOnVulnerability < Gitlab::Database::Migration[1.0]
  disable_ddl_transaction!

  def up
    add_concurrent_foreign_key :vulnerability_reads, :vulnerabilities, column: :vulnerability_id, on_delete: :cascade
  end

  def down
    with_lock_retries do
      remove_foreign_key :vulnerability_reads, column: :vulnerability_id
    end
  end
end
