# frozen_string_literal: true

class CreateVulnerabilityReads < Gitlab::Database::Migration[1.0]
  def change
    create_table :vulnerability_reads do |t|
      t.bigint :vulnerability_id, null: false
      t.bigint :project_id, null: false
      t.bigint :scanner_id, null: false
      t.integer :report_type, limit: 2, null: false
      t.integer :severity, limit: 2, null: false
      t.integer :state, limit: 2, null: false
      t.boolean :has_issues, default: false, null: false
      t.boolean :resolved_on_default_branch, default: false, null: false
      t.uuid :uuid, null: false
      t.text :location_image, limit: 2048

      t.index :vulnerability_id, unique: true
      t.index :scanner_id
      t.index :uuid, unique: true
      t.index [:project_id, :state, :severity, :vulnerability_id], name: :index_vuln_reads_on_project_id_state_severity_and_vuln_id, order: { vulnerability_id: :desc }
      t.index :location_image, where: "report_type IN (2, 7)", name: :index_vulnerability_reads_on_location_image
    end
  end
end
