# frozen_string_literal: true

class AddUniqueIndexToVulnerabilityFlagsTable < ActiveRecord::Migration[6.1]
  include Gitlab::Database::MigrationHelpers

  INDEX_NAME = 'index_vulnerability_flags_on_unique_columns'

  disable_ddl_transaction!

  def up
    add_concurrent_index :vulnerability_flags, [:vulnerability_occurrence_id, :flag_type, :origin], name: INDEX_NAME, unique: true
  end

  def down
    remove_concurrent_index_by_name :vulnerability_flags, INDEX_NAME
  end
end
