# frozen_string_literal: true

class CreateVulnerabilityFindingEvidenceAssets < ActiveRecord::Migration[6.1]
  include Gitlab::Database::MigrationHelpers

  disable_ddl_transaction!

  def up
    create_table_with_constraints :vulnerability_finding_evidence_assets do |t|
      t.timestamps_with_timezone null: false

      t.references :vulnerability_finding_evidence, index: { name: 'finding_evidence_assets_on_finding_evidence_id' }, null: false, foreign_key: { on_delete: :cascade }
      t.text :type
      t.text :name
      t.text :url

      t.text_limit :type, 2048
      t.text_limit :name, 2048
      t.text_limit :url, 2048
    end
  end

  def down
    with_lock_retries do
      drop_table :vulnerability_finding_evidence_assets
    end
  end
end
