# frozen_string_literal: true

class CreateVulnerabilityFindingEvidenceRequests < ActiveRecord::Migration[6.0]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  disable_ddl_transaction!

  def up
    create_table_with_constraints :vulnerability_finding_evidence_requests do |t|
      t.timestamps_with_timezone null: false

      t.references :vulnerability_finding_evidence, index: { name: 'finding_evidence_requests_on_finding_evidence_id' }, null: false, foreign_key: { on_delete: :cascade }
      t.text :method
      t.text :url

      t.text_limit :method, 32
      t.text_limit :url, 2048
    end
  end

  def down
    with_lock_retries do
      drop_table :vulnerability_finding_evidence_requests
    end
  end
end
