# frozen_string_literal: true

class CreateVulnerabilityFindingEvidences < ActiveRecord::Migration[6.0]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  disable_ddl_transaction!

  def up
    create_table_with_constraints :vulnerability_finding_evidences do |t|
      t.timestamps_with_timezone null: false

      t.references :vulnerability_occurrence, index: { name: 'finding_evidences_on_vulnerability_occurrence_id' }, null: false, foreign_key: { on_delete: :cascade }
      t.text :summary

      t.text_limit :summary, 8_000_000
    end
  end

  def down
    with_lock_retries do
      drop_table :vulnerability_finding_evidences
    end
  end
end
