# frozen_string_literal: true

# See https://docs.gitlab.com/ee/development/migration_style_guide.html
# for more information on how to write migrations for GitLab.

class AddIdxVulnerabilityOccurrencesDedup < ActiveRecord::Migration[6.0]
  include Gitlab::Database::MigrationHelpers

  DOWNTIME = false

  TABLE = :vulnerability_occurrences
  INDEX_NAME = 'index_vulnerability_occurrences_deduplication'
  COLUMNS = %i[project_id report_type project_fingerprint]

  disable_ddl_transaction!

  def up
    add_concurrent_index TABLE, COLUMNS, name: INDEX_NAME
  end

  def down
    remove_concurrent_index TABLE, COLUMNS, name: INDEX_NAME
  end
end
