# frozen_string_literal: true

module VulnerabilityFindingSignatureHelpers
  extend ActiveSupport::Concern
  # If the location object describes a physical location within a file
  # (filename + line numbers), the 'location' algorithm_type should be used
  # If the location object describes arbitrary data, then the 'hash'
  # algorithm_type should be used.

  ALGORITHM_TYPES = { hash: 1, location: 2, scope_offset: 3 }.with_indifferent_access.freeze

  class_methods do
    def priority(algorithm_type)
      raise ArgumentError, "No priority for #{algorithm_type.inspect}" unless ALGORITHM_TYPES.key?(algorithm_type)

      ALGORITHM_TYPES[algorithm_type]
    end

    def algorithm_types
      ALGORITHM_TYPES
    end
  end

  def priority
    self.class.priority(algorithm_type)
  end

  def algorithm_types
    self.class.algorithm_types
  end
end
