/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.system;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import org.sunflow.system.UI;

public class SearchPath {
    private LinkedList<String> searchPath;
    private String type;

    public SearchPath(String string) {
        this.type = string;
        this.searchPath = new LinkedList();
    }

    public void resetSearchPath() {
        this.searchPath.clear();
    }

    public void addSearchPath(String string) {
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            try {
                string = file.getCanonicalPath();
                for (String string2 : this.searchPath) {
                    if (!string2.equals(string)) continue;
                    return;
                }
                UI.printInfo(UI.Module.SYS, "Adding %s search path: \"%s\"", this.type, string);
                this.searchPath.add(string);
            }
            catch (IOException iOException) {
                UI.printError(UI.Module.SYS, "Invalid %s search path specification: \"%s\" - %s", this.type, string, iOException.getMessage());
            }
        } else {
            UI.printError(UI.Module.SYS, "Invalid %s search path specification: \"%s\" - invalid directory", this.type, string);
        }
    }

    public String resolvePath(String string) {
        if (string.startsWith("//")) {
            string = string.substring(2);
        }
        UI.printDetailed(UI.Module.SYS, "Resolving %s path \"%s\" ...", this.type, string);
        File file = new File(string);
        if (!file.isAbsolute()) {
            for (String string2 : this.searchPath) {
                UI.printDetailed(UI.Module.SYS, "  * searching: \"%s\" ...", string2);
                file = string2.endsWith(File.separator) || string.startsWith(File.separator) ? new File(string2 + string) : new File(string2 + File.separator + string);
                if (!file.exists()) continue;
                return file.getAbsolutePath();
            }
        }
        return string;
    }
}

