_probe-rs() {
    local i cur prev opts cmd
    COMPREPLY=()
    if [[ "${BASH_VERSINFO[0]}" -ge 4 ]]; then
        cur="$2"
    else
        cur="${COMP_WORDS[COMP_CWORD]}"
    fi
    prev="$3"
    cmd=""
    opts=""

    for i in "${COMP_WORDS[@]:0:COMP_CWORD}"
    do
        case "${cmd},${i}" in
            ",$1")
                cmd="probe__rs"
                ;;
            probe__rs,attach)
                cmd="probe__rs__attach"
                ;;
            probe__rs,benchmark)
                cmd="probe__rs__benchmark"
                ;;
            probe__rs,chip)
                cmd="probe__rs__chip"
                ;;
            probe__rs,complete)
                cmd="probe__rs__complete"
                ;;
            probe__rs,dap-server)
                cmd="probe__rs__dap__server"
                ;;
            probe__rs,debug)
                cmd="probe__rs__debug"
                ;;
            probe__rs,download)
                cmd="probe__rs__download"
                ;;
            probe__rs,erase)
                cmd="probe__rs__erase"
                ;;
            probe__rs,gdb)
                cmd="probe__rs__gdb"
                ;;
            probe__rs,help)
                cmd="probe__rs__help"
                ;;
            probe__rs,info)
                cmd="probe__rs__info"
                ;;
            probe__rs,itm)
                cmd="probe__rs__itm"
                ;;
            probe__rs,list)
                cmd="probe__rs__list"
                ;;
            probe__rs,mi)
                cmd="probe__rs__mi"
                ;;
            probe__rs,profile)
                cmd="probe__rs__profile"
                ;;
            probe__rs,read)
                cmd="probe__rs__read"
                ;;
            probe__rs,reset)
                cmd="probe__rs__reset"
                ;;
            probe__rs,run)
                cmd="probe__rs__run"
                ;;
            probe__rs,serve)
                cmd="probe__rs__serve"
                ;;
            probe__rs,trace)
                cmd="probe__rs__trace"
                ;;
            probe__rs,verify)
                cmd="probe__rs__verify"
                ;;
            probe__rs,write)
                cmd="probe__rs__write"
                ;;
            probe__rs__chip,help)
                cmd="probe__rs__chip__help"
                ;;
            probe__rs__chip,info)
                cmd="probe__rs__chip__info"
                ;;
            probe__rs__chip,list)
                cmd="probe__rs__chip__list"
                ;;
            probe__rs__chip__help,help)
                cmd="probe__rs__chip__help__help"
                ;;
            probe__rs__chip__help,info)
                cmd="probe__rs__chip__help__info"
                ;;
            probe__rs__chip__help,list)
                cmd="probe__rs__chip__help__list"
                ;;
            probe__rs__complete,chip-list)
                cmd="probe__rs__complete__chip__list"
                ;;
            probe__rs__complete,help)
                cmd="probe__rs__complete__help"
                ;;
            probe__rs__complete,install)
                cmd="probe__rs__complete__install"
                ;;
            probe__rs__complete,probe-list)
                cmd="probe__rs__complete__probe__list"
                ;;
            probe__rs__complete__help,chip-list)
                cmd="probe__rs__complete__help__chip__list"
                ;;
            probe__rs__complete__help,help)
                cmd="probe__rs__complete__help__help"
                ;;
            probe__rs__complete__help,install)
                cmd="probe__rs__complete__help__install"
                ;;
            probe__rs__complete__help,probe-list)
                cmd="probe__rs__complete__help__probe__list"
                ;;
            probe__rs__help,attach)
                cmd="probe__rs__help__attach"
                ;;
            probe__rs__help,benchmark)
                cmd="probe__rs__help__benchmark"
                ;;
            probe__rs__help,chip)
                cmd="probe__rs__help__chip"
                ;;
            probe__rs__help,complete)
                cmd="probe__rs__help__complete"
                ;;
            probe__rs__help,dap-server)
                cmd="probe__rs__help__dap__server"
                ;;
            probe__rs__help,debug)
                cmd="probe__rs__help__debug"
                ;;
            probe__rs__help,download)
                cmd="probe__rs__help__download"
                ;;
            probe__rs__help,erase)
                cmd="probe__rs__help__erase"
                ;;
            probe__rs__help,gdb)
                cmd="probe__rs__help__gdb"
                ;;
            probe__rs__help,help)
                cmd="probe__rs__help__help"
                ;;
            probe__rs__help,info)
                cmd="probe__rs__help__info"
                ;;
            probe__rs__help,itm)
                cmd="probe__rs__help__itm"
                ;;
            probe__rs__help,list)
                cmd="probe__rs__help__list"
                ;;
            probe__rs__help,mi)
                cmd="probe__rs__help__mi"
                ;;
            probe__rs__help,profile)
                cmd="probe__rs__help__profile"
                ;;
            probe__rs__help,read)
                cmd="probe__rs__help__read"
                ;;
            probe__rs__help,reset)
                cmd="probe__rs__help__reset"
                ;;
            probe__rs__help,run)
                cmd="probe__rs__help__run"
                ;;
            probe__rs__help,serve)
                cmd="probe__rs__help__serve"
                ;;
            probe__rs__help,trace)
                cmd="probe__rs__help__trace"
                ;;
            probe__rs__help,verify)
                cmd="probe__rs__help__verify"
                ;;
            probe__rs__help,write)
                cmd="probe__rs__help__write"
                ;;
            probe__rs__help__chip,info)
                cmd="probe__rs__help__chip__info"
                ;;
            probe__rs__help__chip,list)
                cmd="probe__rs__help__chip__list"
                ;;
            probe__rs__help__complete,chip-list)
                cmd="probe__rs__help__complete__chip__list"
                ;;
            probe__rs__help__complete,install)
                cmd="probe__rs__help__complete__install"
                ;;
            probe__rs__help__complete,probe-list)
                cmd="probe__rs__help__complete__probe__list"
                ;;
            probe__rs__help__itm,memory)
                cmd="probe__rs__help__itm__memory"
                ;;
            probe__rs__help__itm,swo)
                cmd="probe__rs__help__itm__swo"
                ;;
            probe__rs__help__mi,meta)
                cmd="probe__rs__help__mi__meta"
                ;;
            probe__rs__help__profile,itm)
                cmd="probe__rs__help__profile__itm"
                ;;
            probe__rs__help__profile,naive)
                cmd="probe__rs__help__profile__naive"
                ;;
            probe__rs__help__profile,pcsr)
                cmd="probe__rs__help__profile__pcsr"
                ;;
            probe__rs__itm,help)
                cmd="probe__rs__itm__help"
                ;;
            probe__rs__itm,memory)
                cmd="probe__rs__itm__memory"
                ;;
            probe__rs__itm,swo)
                cmd="probe__rs__itm__swo"
                ;;
            probe__rs__itm__help,help)
                cmd="probe__rs__itm__help__help"
                ;;
            probe__rs__itm__help,memory)
                cmd="probe__rs__itm__help__memory"
                ;;
            probe__rs__itm__help,swo)
                cmd="probe__rs__itm__help__swo"
                ;;
            probe__rs__mi,help)
                cmd="probe__rs__mi__help"
                ;;
            probe__rs__mi,meta)
                cmd="probe__rs__mi__meta"
                ;;
            probe__rs__mi__help,help)
                cmd="probe__rs__mi__help__help"
                ;;
            probe__rs__mi__help,meta)
                cmd="probe__rs__mi__help__meta"
                ;;
            probe__rs__profile,help)
                cmd="probe__rs__profile__help"
                ;;
            probe__rs__profile,itm)
                cmd="probe__rs__profile__itm"
                ;;
            probe__rs__profile,naive)
                cmd="probe__rs__profile__naive"
                ;;
            probe__rs__profile,pcsr)
                cmd="probe__rs__profile__pcsr"
                ;;
            probe__rs__profile__help,help)
                cmd="probe__rs__profile__help__help"
                ;;
            probe__rs__profile__help,itm)
                cmd="probe__rs__profile__help__itm"
                ;;
            probe__rs__profile__help,naive)
                cmd="probe__rs__profile__help__naive"
                ;;
            probe__rs__profile__help,pcsr)
                cmd="probe__rs__profile__help__pcsr"
                ;;
            *)
                ;;
        esac
    done

    case "${cmd}" in
        probe__rs)
            opts="-r -h -V --log-file --log-to-folder --report --host --token --preset --help --version dap-server list info reset gdb debug download verify erase run attach trace itm chip benchmark profile serve read write complete mi help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 1 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__attach)
            opts="-Z -r -h --catch-reset --catch-hardfault --no-catch-reset --no-catch-hardfault --list --format --exact --ignored --include-ignored --skip-test --nocapture --show-output --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --disable-progressbars --disable-double-buffering --restore-unwritten --flash-layout --preverify --verify --always-print-stacktrace --chip-erase --no-location --binary-format --base-address --skip --idf-bootloader --idf-partition-table --idf-target-app-partition --skip-section --log-format --target-output-file --rtt-scan-memory --log-file --log-to-folder --report --host --token --preset --help [TEST_FILTER]... <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "pretty terse json" -- "${cur}"))
                    return 0
                    ;;
                --skip-test)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -Z)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --flash-layout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --binary-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --base-address)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-bootloader)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-partition-table)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-target-app-partition)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip-section)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --target-output-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__benchmark)
            opts="-r -h --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --address --min-speed --max-speed --word-size --iterations --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --address)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --min-speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --max-speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --word-size)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --iterations)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__chip)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help list info help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__chip__help)
            opts="list info help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__chip__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__chip__help__info)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__chip__help__list)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__chip__info)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help <NAME>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__chip__list)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete)
            opts="-r -h --shell --log-file --log-to-folder --report --host --token --preset --help install probe-list chip-list help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --shell)
                    COMPREPLY=($(compgen -W "bash elvish fish powershell zsh" -- "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__chip__list)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help <INPUT>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__help)
            opts="install probe-list chip-list help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__help__chip__list)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__help__install)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__help__probe__list)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__install)
            opts="-m -r -h --manual --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__complete__probe__list)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help <INPUT>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__dap__server)
            opts="-r -h --port --ip --single-session --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --port)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --ip)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__debug)
            opts="-r -h --core --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --exe --no-catch-reset --no-catch-hardfault --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --core)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --exe)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__download)
            opts="-r -h --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --chip-erase --disable-progressbars --disable-double-buffering --restore-unwritten --flash-layout --preverify --verify --binary-format --base-address --skip --idf-bootloader --idf-partition-table --idf-target-app-partition --skip-section --log-file --log-to-folder --report --host --token --preset --help <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --flash-layout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --binary-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --base-address)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-bootloader)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-partition-table)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-target-app-partition)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip-section)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__erase)
            opts="-r -h --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --disable-progressbars --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__gdb)
            opts="-r -h --gdb-connection-string --reset-halt --gdb --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --log-file --log-to-folder --report --host --token --preset --help [PATH] [GDB ARGS]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --gdb-connection-string)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --gdb)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help)
            opts="dap-server list info reset gdb debug download verify erase run attach trace itm chip benchmark profile serve read write complete mi help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__attach)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__benchmark)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__chip)
            opts="list info"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__chip__info)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__chip__list)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__complete)
            opts="install probe-list chip-list"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__complete__chip__list)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__complete__install)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__complete__probe__list)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__dap__server)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__debug)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__download)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__erase)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__gdb)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__info)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__itm)
            opts="memory swo"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__itm__memory)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__itm__swo)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__list)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__mi)
            opts="meta"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__mi__meta)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__profile)
            opts="naive itm pcsr"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__profile__itm)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__profile__naive)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__profile__pcsr)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__read)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__reset)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__run)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__serve)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__trace)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__verify)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__help__write)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__info)
            opts="-r -h --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --target-sel --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --target-sel)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__itm)
            opts="-r -h --core --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --log-file --log-to-folder --report --host --token --preset --help memory swo help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --core)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__itm__help)
            opts="memory swo help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__itm__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__itm__help__memory)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__itm__help__swo)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__itm__memory)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help <CORECLK>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__itm__swo)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help <DURATION> <CLK> <BAUD>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__list)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__mi)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help meta help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__mi__help)
            opts="meta help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__mi__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__mi__help__meta)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__mi__meta)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile)
            opts="-Z -r -h --catch-reset --catch-hardfault --no-catch-reset --no-catch-hardfault --list --format --exact --ignored --include-ignored --skip-test --nocapture --show-output --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --disable-progressbars --disable-double-buffering --restore-unwritten --flash-layout --preverify --verify --always-print-stacktrace --chip-erase --no-location --binary-format --base-address --skip --idf-bootloader --idf-partition-table --idf-target-app-partition --skip-section --log-format --target-output-file --rtt-scan-memory --flash --line-info --duration --core --limit --log-file --log-to-folder --report --host --token --preset --help [TEST_FILTER]... <PATH> naive itm pcsr help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "pretty terse json" -- "${cur}"))
                    return 0
                    ;;
                --skip-test)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -Z)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --flash-layout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --binary-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --base-address)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-bootloader)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-partition-table)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-target-app-partition)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip-section)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --target-output-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --duration)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --core)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --limit)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__help)
            opts="naive itm pcsr help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__help__help)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__help__itm)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__help__naive)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__help__pcsr)
            opts=""
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 4 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__itm)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help <CLK> <BAUD>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__naive)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__profile__pcsr)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 3 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__read)
            opts="-o -f -r -h --core --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --output --format --log-file --log-to-folder --report --host --token --preset --help b8 b16 b32 b64 <ADDRESS> <WORDS>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --core)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --output)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -o)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --format)
                    COMPREPLY=($(compgen -W "hex binary" -- "${cur}"))
                    return 0
                    ;;
                -f)
                    COMPREPLY=($(compgen -W "hex binary" -- "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__reset)
            opts="-r -h --core --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --core)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__run)
            opts="-Z -r -h --catch-reset --catch-hardfault --no-catch-reset --no-catch-hardfault --list --format --exact --ignored --include-ignored --skip-test --nocapture --show-output --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --disable-progressbars --disable-double-buffering --restore-unwritten --flash-layout --preverify --verify --always-print-stacktrace --chip-erase --no-location --binary-format --base-address --skip --idf-bootloader --idf-partition-table --idf-target-app-partition --skip-section --log-format --target-output-file --rtt-scan-memory --log-file --log-to-folder --report --host --token --preset --help [TEST_FILTER]... <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --format)
                    COMPREPLY=($(compgen -W "pretty terse json" -- "${cur}"))
                    return 0
                    ;;
                --skip-test)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -Z)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --flash-layout)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --binary-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --base-address)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-bootloader)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-partition-table)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-target-app-partition)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip-section)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --target-output-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__serve)
            opts="-r -h --log-file --log-to-folder --report --host --token --preset --help"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__trace)
            opts="-r -h --core --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --log-file --log-to-folder --report --host --token --preset --help <LOC>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --core)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__verify)
            opts="-r -h --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --binary-format --base-address --skip --idf-bootloader --idf-partition-table --idf-target-app-partition --skip-section --disable-progressbars --log-file --log-to-folder --report --host --token --preset --help <PATH>"
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --binary-format)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --base-address)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-bootloader)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-partition-table)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --idf-target-app-partition)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --skip-section)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
        probe__rs__write)
            opts="-r -h --core --chip --chip-description-path --protocol --non-interactive --probe --speed --connect-under-reset --dry-run --allow-erase-all --log-file --log-to-folder --report --host --token --preset --help b8 b16 b32 b64 <ADDRESS> [VALUES]..."
            if [[ ${cur} == -* || ${COMP_CWORD} -eq 2 ]] ; then
                COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
                return 0
            fi
            case "${prev}" in
                --core)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --chip)
                    COMPREPLY=($(probe-rs complete chip-list "${cur}"))
                    return 0
                    ;;
                --chip-description-path)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --protocol)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --probe)
                    COMPREPLY=($(probe-rs complete probe-list "${cur}"))
                    return 0
                    ;;
                --speed)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --log-file)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --report)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                -r)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --host)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --token)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                --preset)
                    COMPREPLY=($(compgen -f "${cur}"))
                    return 0
                    ;;
                *)
                    COMPREPLY=()
                    ;;
            esac
            COMPREPLY=( $(compgen -W "${opts}" -- "${cur}") )
            return 0
            ;;
    esac
}

if [[ "${BASH_VERSINFO[0]}" -eq 4 && "${BASH_VERSINFO[1]}" -ge 4 || "${BASH_VERSINFO[0]}" -gt 4 ]]; then
    complete -F _probe-rs -o nosort -o bashdefault -o default probe-rs
else
    complete -F _probe-rs -o bashdefault -o default probe-rs
fi

