/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.highlight.extractor;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.opensearch.neuralsearch.highlight.extractor.QueryTextExtractor;
import org.opensearch.neuralsearch.highlight.extractor.QueryTextExtractorRegistry;

public class BooleanQueryTextExtractor
implements QueryTextExtractor {
    @Generated
    private static final Logger log = LogManager.getLogger(BooleanQueryTextExtractor.class);
    private final QueryTextExtractorRegistry registry;

    public BooleanQueryTextExtractor(QueryTextExtractorRegistry registry) {
        this.registry = registry;
    }

    @Override
    public String extractQueryText(Query query, String fieldName) {
        BooleanQuery booleanQuery = this.toQueryType(query, BooleanQuery.class);
        StringBuilder sb = new StringBuilder();
        for (BooleanClause clause : booleanQuery.clauses()) {
            if (clause.isProhibited()) continue;
            try {
                String clauseText = this.registry.extractQueryText(clause.query(), fieldName);
                if (clauseText.isEmpty()) continue;
                if (!sb.isEmpty()) {
                    sb.append(" ");
                }
                sb.append(clauseText);
            }
            catch (IllegalArgumentException e) {
                log.warn("Failed to extract text from clause {}: {}", (Object)clause, (Object)e.getMessage(), (Object)e);
            }
        }
        return sb.toString();
    }
}

