/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.stats;

import java.util.concurrent.atomic.AtomicLong;

public enum KNNGraphValue {
    REFRESH_TOTAL_OPERATIONS("total"),
    REFRESH_TOTAL_TIME_IN_MILLIS("total_time_in_millis"),
    MERGE_CURRENT_OPERATIONS("current"),
    MERGE_CURRENT_DOCS("current_docs"),
    MERGE_CURRENT_SIZE_IN_BYTES("current_size_in_bytes"),
    MERGE_TOTAL_OPERATIONS("total"),
    MERGE_TOTAL_TIME_IN_MILLIS("total_time_in_millis"),
    MERGE_TOTAL_DOCS("total_docs"),
    MERGE_TOTAL_SIZE_IN_BYTES("total_size_in_bytes");

    private String name;
    private AtomicLong value;

    private KNNGraphValue(String name) {
        this.name = name;
        this.value = new AtomicLong(0L);
    }

    public String getName() {
        return this.name;
    }

    public Long getValue() {
        return this.value.get();
    }

    public void increment() {
        this.value.getAndIncrement();
    }

    public void decrement() {
        this.value.getAndDecrement();
    }

    public void incrementBy(long delta) {
        this.value.getAndAdd(delta);
    }

    public void decrementBy(long delta) {
        this.value.set(this.value.get() - delta);
    }

    public void set(long value) {
        this.value.set(value);
    }
}

