package directx_d3d11

foreign import "system:d3d11.lib"

import "../dxgi"
import "../d3d_compiler"
import "core:sys/windows"

IUnknown        :: dxgi.IUnknown
IUnknown_VTable :: dxgi.IUnknown_VTable

HANDLE  :: dxgi.HANDLE
HMODULE :: dxgi.HMODULE
HRESULT :: dxgi.HRESULT
GUID    :: dxgi.GUID
IID     :: dxgi.IID
SIZE_T  :: dxgi.SIZE_T
BOOL    :: dxgi.BOOL
UINT    :: dxgi.UINT
INT     :: dxgi.INT

LPCWSTR  :: windows.LPCWSTR

RECT :: dxgi.RECT
SIZE :: dxgi.SIZE

IModuleInstance :: d3d_compiler.ID3D11ModuleInstance
IBlob           :: d3d_compiler.ID3DBlob
IModule         :: d3d_compiler.ID3D11Module

@(default_calling_convention="system", link_prefix="D3D11")
foreign d3d11 {
	CreateDevice :: proc(
		pAdapter:           ^dxgi.IAdapter,
		DriverType:         DRIVER_TYPE,
		Software:           HMODULE,
		Flags:              CREATE_DEVICE_FLAGS,
		pFeatureLevels:     [^]FEATURE_LEVEL,
		FeatureLevels:      u32,
		SDKVersion:         u32,
		ppDevice:           ^^IDevice,
		pFeatureLevel:      ^FEATURE_LEVEL,
		ppImmediateContext: ^^IDeviceContext,
	) -> HRESULT ---
	CreateDeviceAndSwapChain :: proc(
		pAdapter:           ^dxgi.IAdapter,
		DriverType:         DRIVER_TYPE,
		Software:           HMODULE,
		Flags:              CREATE_DEVICE_FLAGS,
		pFeatureLevels:     [^]FEATURE_LEVEL,
		FeatureLevels:      u32,
		SDKVersion:         u32,
		pSwapChainDesc:     ^dxgi.SWAP_CHAIN_DESC,
		ppSwapChain:        ^^dxgi.ISwapChain,
		ppDevice:           ^^IDevice,
		pFeatureLevel:      ^FEATURE_LEVEL,
		ppImmediateContext: ^^IDeviceContext,
	) -> HRESULT ---
}

WKPDID_D3DDebugObjectNameW_UUID_STRING :: "4CCA5FD8-921F-42C8-8566-70CAF2A9B741"
WKPDID_D3DDebugObjectNameW_UUID        := &IID{0x4cca5fd8, 0x921f, 0x42c8, {0x85, 0x66, 0x70, 0xca, 0xf2, 0xa9, 0xb7, 0x41}}

WKPDID_CommentStringW_UUID_STRING :: "d0149dc0-90e8-4ec8-8144-e900ad266bb2"
WKPDID_CommentStringW_UUID        := &IID{0xd0149dc0, 0x90e8, 0x4ec8, {0x81, 0x44, 0xe9, 0x00, 0xad, 0x26, 0x6b, 0xb2}}

TEXTURE_LAYOUT_ROW_MAJOR_UUID_STRING :: "b5dc234f-72bb-4bec-9705-8cf258df6b6c"
TEXTURE_LAYOUT_ROW_MAJOR_UUID        := &IID{0xb5dc234f, 0x72bb, 0x4bec, {0x97, 0x05, 0x8c, 0xf2, 0x58, 0xdf, 0x6b, 0x6c}}

TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE_UUID_STRING :: "4c0f29e3-3f5f-4d35-84c9-bc0983b62c28"
TEXTURE_LAYOUT_64KB_STANDARD_SWIZZLE_UUID        := &IID{0x4c0f29e3, 0x3f5f, 0x4d35, {0x84, 0xc9, 0xbc, 0x09, 0x83, 0xb6, 0x2c, 0x28}}

@(link_prefix="D3D11_")
foreign d3d11 {
	DECODER_PROFILE_MPEG2_MOCOMP:                      GUID
	DECODER_PROFILE_MPEG2_IDCT:                        GUID
	DECODER_PROFILE_MPEG2_VLD:                         GUID
	DECODER_PROFILE_MPEG1_VLD:                         GUID
	DECODER_PROFILE_MPEG2and1_VLD:                     GUID
	DECODER_PROFILE_H264_MOCOMP_NOFGT:                 GUID
	DECODER_PROFILE_H264_MOCOMP_FGT:                   GUID
	DECODER_PROFILE_H264_IDCT_NOFGT:                   GUID
	DECODER_PROFILE_H264_IDCT_FGT:                     GUID
	DECODER_PROFILE_H264_VLD_NOFGT:                    GUID
	DECODER_PROFILE_H264_VLD_FGT:                      GUID
	DECODER_PROFILE_H264_VLD_WITHFMOASO_NOFGT:         GUID
	DECODER_PROFILE_H264_VLD_STEREO_PROGRESSIVE_NOFGT: GUID
	DECODER_PROFILE_H264_VLD_STEREO_NOFGT:             GUID
	DECODER_PROFILE_H264_VLD_MULTIVIEW_NOFGT:          GUID
	DECODER_PROFILE_WMV8_POSTPROC:                     GUID
	DECODER_PROFILE_WMV8_MOCOMP:                       GUID
	DECODER_PROFILE_WMV9_POSTPROC:                     GUID
	DECODER_PROFILE_WMV9_MOCOMP:                       GUID
	DECODER_PROFILE_WMV9_IDCT:                         GUID
	DECODER_PROFILE_VC1_POSTPROC:                      GUID
	DECODER_PROFILE_VC1_MOCOMP:                        GUID
	DECODER_PROFILE_VC1_IDCT:                          GUID
	DECODER_PROFILE_VC1_VLD:                           GUID
	DECODER_PROFILE_VC1_D2010:                         GUID
	DECODER_PROFILE_MPEG4PT2_VLD_SIMPLE:               GUID
	DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_NOGMC:      GUID
	DECODER_PROFILE_MPEG4PT2_VLD_ADVSIMPLE_GMC:        GUID
	DECODER_PROFILE_HEVC_VLD_MAIN:                     GUID
	DECODER_PROFILE_HEVC_VLD_MAIN10:                   GUID
	DECODER_PROFILE_VP9_VLD_PROFILE0:                  GUID
	DECODER_PROFILE_VP9_VLD_10BIT_PROFILE2:            GUID
	DECODER_PROFILE_VP8_VLD:                           GUID

	CRYPTO_TYPE_AES128_CTR:                 GUID
	DECODER_ENCRYPTION_HW_CENC:             GUID
	DECODER_BITSTREAM_ENCRYPTION_TYPE_CENC: GUID
	DECODER_BITSTREAM_ENCRYPTION_TYPE_CBCS: GUID
	KEY_EXCHANGE_HW_PROTECTION:             GUID

	AUTHENTICATED_QUERY_PROTECTION:                                   GUID
	AUTHENTICATED_QUERY_CHANNEL_TYPE:                                 GUID
	AUTHENTICATED_QUERY_DEVICE_HANDLE:                                GUID
	AUTHENTICATED_QUERY_CRYPTO_SESSION:                               GUID
	AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT:     GUID
	AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS:           GUID
	AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT: GUID
	AUTHENTICATED_QUERY_OUTPUT_ID_COUNT:                              GUID
	AUTHENTICATED_QUERY_OUTPUT_ID:                                    GUID
	AUTHENTICATED_QUERY_ACCESSIBILITY_ATTRIBUTES:                     GUID
	AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID_COUNT:        GUID
	AUTHENTICATED_QUERY_ENCRYPTION_WHEN_ACCESSIBLE_GUID:              GUID
	AUTHENTICATED_QUERY_CURRENT_ENCRYPTION_WHEN_ACCESSIBLE:           GUID
	AUTHENTICATED_CONFIGURE_INITIALIZE:                               GUID
	AUTHENTICATED_CONFIGURE_PROTECTION:                               GUID
	AUTHENTICATED_CONFIGURE_CRYPTO_SESSION:                           GUID
	AUTHENTICATED_CONFIGURE_SHARED_RESOURCE:                          GUID
	AUTHENTICATED_CONFIGURE_ENCRYPTION_WHEN_ACCESSIBLE:               GUID

	KEY_EXCHANGE_RSAES_OAEP: GUID
}

FL9_1_REQ_TEXTURE1D_U_DIMENSION        :: 2048
FL9_3_REQ_TEXTURE1D_U_DIMENSION        :: 4096
FL9_1_REQ_TEXTURE2D_U_OR_V_DIMENSION   :: 2048
FL9_3_REQ_TEXTURE2D_U_OR_V_DIMENSION   :: 4096
FL9_1_REQ_TEXTURECUBE_DIMENSION        :: 512
FL9_3_REQ_TEXTURECUBE_DIMENSION        :: 4096
FL9_1_REQ_TEXTURE3D_U_V_OR_W_DIMENSION :: 256
FL9_1_DEFAULT_MAX_ANISOTROPY           :: 2
FL9_1_IA_PRIMITIVE_MAX_COUNT           :: 65535
FL9_2_IA_PRIMITIVE_MAX_COUNT           :: 1048575
FL9_1_SIMULTANEOUS_RENDER_TARGET_COUNT :: 1
FL9_3_SIMULTANEOUS_RENDER_TARGET_COUNT :: 4
FL9_1_MAX_TEXTURE_REPEAT               :: 128
FL9_2_MAX_TEXTURE_REPEAT               :: 2048
FL9_3_MAX_TEXTURE_REPEAT               :: 8192

_8BIT_INDEX_STRIP_CUT_VALUE  :: 0xff
_16BIT_INDEX_STRIP_CUT_VALUE :: 0xffff
_32BIT_INDEX_STRIP_CUT_VALUE :: 0xffffffff

ARRAY_AXIS_ADDRESS_RANGE_BIT_COUNT :: 9

CLIP_OR_CULL_DISTANCE_COUNT         :: 8
CLIP_OR_CULL_DISTANCE_ELEMENT_COUNT :: 2

COMMONSHADER_CONSTANT_BUFFER_API_SLOT_COUNT                        :: 14
COMMONSHADER_CONSTANT_BUFFER_COMPONENTS                            :: 4
COMMONSHADER_CONSTANT_BUFFER_COMPONENT_BIT_COUNT                   :: 32
COMMONSHADER_CONSTANT_BUFFER_HW_SLOT_COUNT                         :: 15
COMMONSHADER_CONSTANT_BUFFER_PARTIAL_UPDATE_EXTENTS_BYTE_ALIGNMENT :: 16
COMMONSHADER_CONSTANT_BUFFER_REGISTER_COMPONENTS                   :: 4
COMMONSHADER_CONSTANT_BUFFER_REGISTER_COUNT                        :: 15
COMMONSHADER_CONSTANT_BUFFER_REGISTER_READS_PER_INST               :: 1
COMMONSHADER_CONSTANT_BUFFER_REGISTER_READ_PORTS                   :: 1
COMMONSHADER_FLOWCONTROL_NESTING_LIMIT                             :: 64
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COMPONENTS         :: 4
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_COUNT              :: 1
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READS_PER_INST     :: 1
COMMONSHADER_IMMEDIATE_CONSTANT_BUFFER_REGISTER_READ_PORTS         :: 1
COMMONSHADER_IMMEDIATE_VALUE_COMPONENT_BIT_COUNT                   :: 32
COMMONSHADER_INPUT_RESOURCE_REGISTER_COMPONENTS                    :: 1
COMMONSHADER_INPUT_RESOURCE_REGISTER_COUNT                         :: 128
COMMONSHADER_INPUT_RESOURCE_REGISTER_READS_PER_INST                :: 1
COMMONSHADER_INPUT_RESOURCE_REGISTER_READ_PORTS                    :: 1
COMMONSHADER_INPUT_RESOURCE_SLOT_COUNT                             :: 128
COMMONSHADER_SAMPLER_REGISTER_COMPONENTS                           :: 1
COMMONSHADER_SAMPLER_REGISTER_COUNT                                :: 16
COMMONSHADER_SAMPLER_REGISTER_READS_PER_INST                       :: 1
COMMONSHADER_SAMPLER_REGISTER_READ_PORTS                           :: 1
COMMONSHADER_SAMPLER_SLOT_COUNT                                    :: 16
COMMONSHADER_SUBROUTINE_NESTING_LIMIT                              :: 32
COMMONSHADER_TEMP_REGISTER_COMPONENTS                              :: 4
COMMONSHADER_TEMP_REGISTER_COMPONENT_BIT_COUNT                     :: 32
COMMONSHADER_TEMP_REGISTER_COUNT                                   :: 4096
COMMONSHADER_TEMP_REGISTER_READS_PER_INST                          :: 3
COMMONSHADER_TEMP_REGISTER_READ_PORTS                              :: 3
COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MAX                          :: 10
COMMONSHADER_TEXCOORD_RANGE_REDUCTION_MIN                          :: -10
COMMONSHADER_TEXEL_OFFSET_MAX_NEGATIVE                             :: -8
COMMONSHADER_TEXEL_OFFSET_MAX_POSITIVE                             :: 7

CS_4_X_BUCKET00_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 256
CS_4_X_BUCKET00_MAX_NUM_THREADS_PER_GROUP          :: 64
CS_4_X_BUCKET01_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 240
CS_4_X_BUCKET01_MAX_NUM_THREADS_PER_GROUP          :: 68
CS_4_X_BUCKET02_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 224
CS_4_X_BUCKET02_MAX_NUM_THREADS_PER_GROUP          :: 72
CS_4_X_BUCKET03_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 208
CS_4_X_BUCKET03_MAX_NUM_THREADS_PER_GROUP          :: 76
CS_4_X_BUCKET04_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 192
CS_4_X_BUCKET04_MAX_NUM_THREADS_PER_GROUP          :: 84
CS_4_X_BUCKET05_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 176
CS_4_X_BUCKET05_MAX_NUM_THREADS_PER_GROUP          :: 92
CS_4_X_BUCKET06_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 160
CS_4_X_BUCKET06_MAX_NUM_THREADS_PER_GROUP          :: 100
CS_4_X_BUCKET07_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 144
CS_4_X_BUCKET07_MAX_NUM_THREADS_PER_GROUP          :: 112
CS_4_X_BUCKET08_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 128
CS_4_X_BUCKET08_MAX_NUM_THREADS_PER_GROUP          :: 128
CS_4_X_BUCKET09_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 112
CS_4_X_BUCKET09_MAX_NUM_THREADS_PER_GROUP          :: 144
CS_4_X_BUCKET10_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 96
CS_4_X_BUCKET10_MAX_NUM_THREADS_PER_GROUP          :: 168
CS_4_X_BUCKET11_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 80
CS_4_X_BUCKET11_MAX_NUM_THREADS_PER_GROUP          :: 204
CS_4_X_BUCKET12_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 64
CS_4_X_BUCKET12_MAX_NUM_THREADS_PER_GROUP          :: 256
CS_4_X_BUCKET13_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 48
CS_4_X_BUCKET13_MAX_NUM_THREADS_PER_GROUP          :: 340
CS_4_X_BUCKET14_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 32
CS_4_X_BUCKET14_MAX_NUM_THREADS_PER_GROUP          :: 512
CS_4_X_BUCKET15_MAX_BYTES_TGSM_WRITABLE_PER_THREAD :: 16
CS_4_X_BUCKET15_MAX_NUM_THREADS_PER_GROUP          :: 768
CS_4_X_DISPATCH_MAX_THREAD_GROUPS_IN_Z_DIMENSION   :: 1
CS_4_X_RAW_UAV_BYTE_ALIGNMENT                      :: 256
CS_4_X_THREAD_GROUP_MAX_THREADS_PER_GROUP          :: 768
CS_4_X_THREAD_GROUP_MAX_X                          :: 768
CS_4_X_THREAD_GROUP_MAX_Y                          :: 768
CS_4_X_UAV_REGISTER_COUNT                          :: 1

CS_DISPATCH_MAX_THREAD_GROUPS_PER_DIMENSION :: 65535
CS_TGSM_REGISTER_COUNT :: 8192
CS_TGSM_REGISTER_READS_PER_INST :: 1
CS_TGSM_RESOURCE_REGISTER_COMPONENTS :: 1
CS_TGSM_RESOURCE_REGISTER_READ_PORTS :: 1
CS_THREADGROUPID_REGISTER_COMPONENTS :: 3
CS_THREADGROUPID_REGISTER_COUNT :: 1
CS_THREADIDINGROUPFLATTENED_REGISTER_COMPONENTS :: 1
CS_THREADIDINGROUPFLATTENED_REGISTER_COUNT :: 1
CS_THREADIDINGROUP_REGISTER_COMPONENTS :: 3
CS_THREADIDINGROUP_REGISTER_COUNT :: 1
CS_THREADID_REGISTER_COMPONENTS :: 3
CS_THREADID_REGISTER_COUNT :: 1
CS_THREAD_GROUP_MAX_THREADS_PER_GROUP :: 1024
CS_THREAD_GROUP_MAX_X :: 1024
CS_THREAD_GROUP_MAX_Y :: 1024
CS_THREAD_GROUP_MAX_Z :: 64
CS_THREAD_GROUP_MIN_X :: 1
CS_THREAD_GROUP_MIN_Y :: 1
CS_THREAD_GROUP_MIN_Z :: 1
CS_THREAD_LOCAL_TEMP_REGISTER_POOL :: 16384

DEFAULT_BLEND_FACTOR_ALPHA :: 1.0
DEFAULT_BLEND_FACTOR_BLUE :: 1.0
DEFAULT_BLEND_FACTOR_GREEN :: 1.0
DEFAULT_BLEND_FACTOR_RED :: 1.0
DEFAULT_BORDER_COLOR_COMPONENT :: 0.0
DEFAULT_DEPTH_BIAS :: 0
DEFAULT_DEPTH_BIAS_CLAMP :: 0.0
DEFAULT_MAX_ANISOTROPY :: 16
DEFAULT_MIP_LOD_BIAS :: 0.0
DEFAULT_RENDER_TARGET_ARRAY_INDEX :: 0
DEFAULT_SAMPLE_MASK :: 0xffffffff
DEFAULT_SCISSOR_ENDX :: 0
DEFAULT_SCISSOR_ENDY :: 0
DEFAULT_SCISSOR_STARTX :: 0
DEFAULT_SCISSOR_STARTY :: 0
DEFAULT_SLOPE_SCALED_DEPTH_BIAS :: 0.0
DEFAULT_STENCIL_READ_MASK :: 0xff
DEFAULT_STENCIL_REFERENCE :: 0
DEFAULT_STENCIL_WRITE_MASK :: 0xff
DEFAULT_VIEWPORT_AND_SCISSORRECT_INDEX :: 0
DEFAULT_VIEWPORT_HEIGHT :: 0
DEFAULT_VIEWPORT_MAX_DEPTH :: 0.0
DEFAULT_VIEWPORT_MIN_DEPTH :: 0.0
DEFAULT_VIEWPORT_TOPLEFTX :: 0
DEFAULT_VIEWPORT_TOPLEFTY :: 0
DEFAULT_VIEWPORT_WIDTH :: 0

DS_INPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS            :: 3968
DS_INPUT_CONTROL_POINT_REGISTER_COMPONENTS           :: 4
DS_INPUT_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT  :: 32
DS_INPUT_CONTROL_POINT_REGISTER_COUNT                :: 32
DS_INPUT_CONTROL_POINT_REGISTER_READS_PER_INST       :: 2
DS_INPUT_CONTROL_POINT_REGISTER_READ_PORTS           :: 1
DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENTS            :: 3
DS_INPUT_DOMAIN_POINT_REGISTER_COMPONENT_BIT_COUNT   :: 32
DS_INPUT_DOMAIN_POINT_REGISTER_COUNT                 :: 1
DS_INPUT_DOMAIN_POINT_REGISTER_READS_PER_INST        :: 2
DS_INPUT_DOMAIN_POINT_REGISTER_READ_PORTS            :: 1
DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENTS          :: 4
DS_INPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT :: 32
DS_INPUT_PATCH_CONSTANT_REGISTER_COUNT               :: 32
DS_INPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST      :: 2
DS_INPUT_PATCH_CONSTANT_REGISTER_READ_PORTS          :: 1
DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS            :: 1
DS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT   :: 32
DS_INPUT_PRIMITIVE_ID_REGISTER_COUNT                 :: 1
DS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST        :: 2
DS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS            :: 1
DS_OUTPUT_REGISTER_COMPONENTS                        :: 4
DS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT               :: 32
DS_OUTPUT_REGISTER_COUNT                             :: 32

FLOAT16_FUSED_TOLERANCE_IN_ULP :: 0.6
FLOAT32_MAX :: 3.402823466e+38
FLOAT32_TO_INTEGER_TOLERANCE_IN_ULP :: 0.6
FLOAT_TO_SRGB_EXPONENT_DENOMINATOR :: 2.4
FLOAT_TO_SRGB_EXPONENT_NUMERATOR :: 1.0
FLOAT_TO_SRGB_OFFSET :: 0.055
FLOAT_TO_SRGB_SCALE_1 :: 12.92
FLOAT_TO_SRGB_SCALE_2 :: 1.055
FLOAT_TO_SRGB_THRESHOLD :: 0.0031308
FTOI_INSTRUCTION_MAX_INPUT :: 2147483647.999
FTOI_INSTRUCTION_MIN_INPUT :: -2147483648.999
FTOU_INSTRUCTION_MAX_INPUT :: 4294967295.999
FTOU_INSTRUCTION_MIN_INPUT :: 0.0
GS_INPUT_INSTANCE_ID_READS_PER_INST :: 2
GS_INPUT_INSTANCE_ID_READ_PORTS :: 1
GS_INPUT_INSTANCE_ID_REGISTER_COMPONENTS :: 1
GS_INPUT_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_INPUT_INSTANCE_ID_REGISTER_COUNT :: 1
GS_INPUT_PRIM_CONST_REGISTER_COMPONENTS :: 1
GS_INPUT_PRIM_CONST_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_INPUT_PRIM_CONST_REGISTER_COUNT :: 1
GS_INPUT_PRIM_CONST_REGISTER_READS_PER_INST :: 2
GS_INPUT_PRIM_CONST_REGISTER_READ_PORTS :: 1
GS_INPUT_REGISTER_COMPONENTS :: 4
GS_INPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_INPUT_REGISTER_COUNT :: 32
GS_INPUT_REGISTER_READS_PER_INST :: 2
GS_INPUT_REGISTER_READ_PORTS :: 1
GS_INPUT_REGISTER_VERTICES :: 32
GS_MAX_INSTANCE_COUNT :: 32
GS_MAX_OUTPUT_VERTEX_COUNT_ACROSS_INSTANCES :: 1024
GS_OUTPUT_ELEMENTS :: 32
GS_OUTPUT_REGISTER_COMPONENTS :: 4
GS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
GS_OUTPUT_REGISTER_COUNT :: 32
HS_CONTROL_POINT_PHASE_INPUT_REGISTER_COUNT :: 32
HS_CONTROL_POINT_PHASE_OUTPUT_REGISTER_COUNT :: 32
HS_CONTROL_POINT_REGISTER_COMPONENTS :: 4
HS_CONTROL_POINT_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_CONTROL_POINT_REGISTER_READS_PER_INST :: 2
HS_CONTROL_POINT_REGISTER_READ_PORTS :: 1
HS_FORK_PHASE_INSTANCE_COUNT_UPPER_BOUND :: 0xffffffff
HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENTS :: 1
HS_INPUT_FORK_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_INPUT_FORK_INSTANCE_ID_REGISTER_COUNT :: 1
HS_INPUT_FORK_INSTANCE_ID_REGISTER_READS_PER_INST :: 2
HS_INPUT_FORK_INSTANCE_ID_REGISTER_READ_PORTS :: 1
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENTS :: 1
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_COUNT :: 1
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READS_PER_INST :: 2
HS_INPUT_JOIN_INSTANCE_ID_REGISTER_READ_PORTS :: 1
HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENTS :: 1
HS_INPUT_PRIMITIVE_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_INPUT_PRIMITIVE_ID_REGISTER_COUNT :: 1
HS_INPUT_PRIMITIVE_ID_REGISTER_READS_PER_INST :: 2
HS_INPUT_PRIMITIVE_ID_REGISTER_READ_PORTS :: 1
HS_JOIN_PHASE_INSTANCE_COUNT_UPPER_BOUND :: 0xffffffff
HS_MAXTESSFACTOR_LOWER_BOUND :: 1.0
HS_MAXTESSFACTOR_UPPER_BOUND :: 64.0
HS_OUTPUT_CONTROL_POINTS_MAX_TOTAL_SCALARS :: 3968
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENTS :: 1
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_COUNT :: 1
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READS_PER_INST :: 2
HS_OUTPUT_CONTROL_POINT_ID_REGISTER_READ_PORTS :: 1
HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENTS :: 4
HS_OUTPUT_PATCH_CONSTANT_REGISTER_COMPONENT_BIT_COUNT :: 32
HS_OUTPUT_PATCH_CONSTANT_REGISTER_COUNT :: 32
HS_OUTPUT_PATCH_CONSTANT_REGISTER_READS_PER_INST :: 2
HS_OUTPUT_PATCH_CONSTANT_REGISTER_READ_PORTS :: 1
HS_OUTPUT_PATCH_CONSTANT_REGISTER_SCALAR_COMPONENTS :: 128
IA_DEFAULT_INDEX_BUFFER_OFFSET_IN_BYTES :: 0
IA_DEFAULT_PRIMITIVE_TOPOLOGY :: 0
IA_DEFAULT_VERTEX_BUFFER_OFFSET_IN_BYTES :: 0
IA_INDEX_INPUT_RESOURCE_SLOT_COUNT :: 1
IA_INSTANCE_ID_BIT_COUNT :: 32
IA_INTEGER_ARITHMETIC_BIT_COUNT :: 32
IA_PATCH_MAX_CONTROL_POINT_COUNT :: 32
IA_PRIMITIVE_ID_BIT_COUNT :: 32
IA_VERTEX_ID_BIT_COUNT :: 32
IA_VERTEX_INPUT_RESOURCE_SLOT_COUNT :: 32
IA_VERTEX_INPUT_STRUCTURE_ELEMENTS_COMPONENTS :: 128
IA_VERTEX_INPUT_STRUCTURE_ELEMENT_COUNT :: 32
INTEGER_DIVIDE_BY_ZERO_QUOTIENT :: 0xffffffff
INTEGER_DIVIDE_BY_ZERO_REMAINDER :: 0xffffffff
KEEP_RENDER_TARGETS_AND_DEPTH_STENCIL :: 0xffffffff
KEEP_UNORDERED_ACCESS_VIEWS :: 0xffffffff
LINEAR_GAMMA :: 1.0
MAJOR_VERSION :: 11
MAX_BORDER_COLOR_COMPONENT :: 1.0
MAX_DEPTH :: 1.0
MAX_MAXANISOTROPY :: 16
MAX_MULTISAMPLE_SAMPLE_COUNT :: 32
MAX_POSITION_VALUE :: 3.402823466e+34
MAX_TEXTURE_DIMENSION_2_TO_EXP :: 17
MINOR_VERSION :: 0
MIN_BORDER_COLOR_COMPONENT :: 0.0
MIN_DEPTH :: 0.0
MIN_MAXANISOTROPY :: 0
MIP_LOD_BIAS_MAX :: 15.99
MIP_LOD_BIAS_MIN :: -16.0
MIP_LOD_FRACTIONAL_BIT_COUNT :: 8
MIP_LOD_RANGE_BIT_COUNT :: 8
MULTISAMPLE_ANTIALIAS_LINE_WIDTH :: 1.4
NONSAMPLE_FETCH_OUT_OF_RANGE_ACCESS_RESULT :: 0
PIXEL_ADDRESS_RANGE_BIT_COUNT :: 15
PRE_SCISSOR_PIXEL_ADDRESS_RANGE_BIT_COUNT :: 16
PS_CS_UAV_REGISTER_COMPONENTS :: 1
PS_CS_UAV_REGISTER_COUNT :: 8
PS_CS_UAV_REGISTER_READS_PER_INST :: 1
PS_CS_UAV_REGISTER_READ_PORTS :: 1
PS_FRONTFACING_DEFAULT_VALUE :: 0xffffffff
PS_FRONTFACING_FALSE_VALUE :: 0
PS_FRONTFACING_TRUE_VALUE :: 0xffffffff
PS_INPUT_REGISTER_COMPONENTS :: 4
PS_INPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_INPUT_REGISTER_COUNT :: 32
PS_INPUT_REGISTER_READS_PER_INST :: 2
PS_INPUT_REGISTER_READ_PORTS :: 1
PS_LEGACY_PIXEL_CENTER_FRACTIONAL_COMPONENT :: 0.0
PS_OUTPUT_DEPTH_REGISTER_COMPONENTS :: 1
PS_OUTPUT_DEPTH_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_OUTPUT_DEPTH_REGISTER_COUNT :: 1
PS_OUTPUT_MASK_REGISTER_COMPONENTS :: 1
PS_OUTPUT_MASK_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_OUTPUT_MASK_REGISTER_COUNT :: 1
PS_OUTPUT_REGISTER_COMPONENTS :: 4
PS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
PS_OUTPUT_REGISTER_COUNT :: 8
PS_PIXEL_CENTER_FRACTIONAL_COMPONENT :: 0.5
RAW_UAV_SRV_BYTE_ALIGNMENT :: 16
REQ_BLEND_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_BUFFER_RESOURCE_TEXEL_COUNT_2_TO_EXP :: 27
REQ_CONSTANT_BUFFER_ELEMENT_COUNT :: 4096
REQ_DEPTH_STENCIL_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_DRAWINDEXED_INDEX_COUNT_2_TO_EXP :: 32
REQ_DRAW_VERTEX_COUNT_2_TO_EXP :: 32
REQ_FILTERING_HW_ADDRESSABLE_RESOURCE_DIMENSION :: 16384
REQ_GS_INVOCATION_32BIT_OUTPUT_COMPONENT_LIMIT :: 1024
REQ_IMMEDIATE_CONSTANT_BUFFER_ELEMENT_COUNT :: 4096
REQ_MAXANISOTROPY :: 16
REQ_MIP_LEVELS :: 15
REQ_MULTI_ELEMENT_STRUCTURE_SIZE_IN_BYTES :: 2048
REQ_RASTERIZER_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_RENDER_TO_BUFFER_WINDOW_WIDTH :: 16384
REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_A_TERM :: 128
REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_B_TERM :: 0.25
REQ_RESOURCE_SIZE_IN_MEGABYTES_EXPRESSION_C_TERM :: 2048
REQ_RESOURCE_VIEW_COUNT_PER_DEVICE_2_TO_EXP :: 20
REQ_SAMPLER_OBJECT_COUNT_PER_DEVICE :: 4096
REQ_TEXTURE1D_ARRAY_AXIS_DIMENSION :: 2048
REQ_TEXTURE1D_U_DIMENSION :: 16384
REQ_TEXTURE2D_ARRAY_AXIS_DIMENSION :: 2048
REQ_TEXTURE2D_U_OR_V_DIMENSION :: 16384
REQ_TEXTURE3D_U_V_OR_W_DIMENSION :: 2048
REQ_TEXTURECUBE_DIMENSION :: 16384
RESINFO_INSTRUCTION_MISSING_COMPONENT_RETVAL :: 0
SHADER_MAJOR_VERSION :: 5
SHADER_MAX_INSTANCES :: 65535
SHADER_MAX_INTERFACES :: 253
SHADER_MAX_INTERFACE_CALL_SITES :: 4096
SHADER_MAX_TYPES :: 65535
SHADER_MINOR_VERSION :: 0
SHIFT_INSTRUCTION_PAD_VALUE :: 0
SHIFT_INSTRUCTION_SHIFT_VALUE_BIT_COUNT :: 5
SIMULTANEOUS_RENDER_TARGET_COUNT :: 8
SO_BUFFER_MAX_STRIDE_IN_BYTES :: 2048
SO_BUFFER_MAX_WRITE_WINDOW_IN_BYTES :: 512
SO_BUFFER_SLOT_COUNT :: 4
SO_DDI_REGISTER_INDEX_DENOTING_GAP :: 0xffffffff
SO_NO_RASTERIZED_STREAM :: 0xffffffff
SO_OUTPUT_COMPONENT_COUNT :: 128
SO_STREAM_COUNT :: 4
SPEC_DATE_DAY :: 16
SPEC_DATE_YEAR :: 2011
SPEC_VERSION :: 1.07
SRGB_GAMMA :: 2.2
SRGB_TO_FLOAT_DENOMINATOR_1 :: 12.92
SRGB_TO_FLOAT_DENOMINATOR_2 :: 1.055
SRGB_TO_FLOAT_EXPONENT :: 2.4
SRGB_TO_FLOAT_OFFSET :: 0.055
SRGB_TO_FLOAT_THRESHOLD :: 0.04045
SRGB_TO_FLOAT_TOLERANCE_IN_ULP :: 0.5
STANDARD_COMPONENT_BIT_COUNT :: 32
STANDARD_COMPONENT_BIT_COUNT_DOUBLED :: 64
STANDARD_MAXIMUM_ELEMENT_ALIGNMENT_BYTE_MULTIPLE :: 4
STANDARD_PIXEL_COMPONENT_COUNT :: 128
STANDARD_PIXEL_ELEMENT_COUNT :: 32
STANDARD_VECTOR_SIZE :: 4
STANDARD_VERTEX_ELEMENT_COUNT :: 32
STANDARD_VERTEX_TOTAL_COMPONENT_COUNT :: 64
SUBPIXEL_FRACTIONAL_BIT_COUNT :: 8
SUBTEXEL_FRACTIONAL_BIT_COUNT :: 8
TESSELLATOR_MAX_EVEN_TESSELLATION_FACTOR :: 64
TESSELLATOR_MAX_ISOLINE_DENSITY_TESSELLATION_FACTOR :: 64
TESSELLATOR_MAX_ODD_TESSELLATION_FACTOR :: 63
TESSELLATOR_MAX_TESSELLATION_FACTOR :: 64
TESSELLATOR_MIN_EVEN_TESSELLATION_FACTOR :: 2
TESSELLATOR_MIN_ISOLINE_DENSITY_TESSELLATION_FACTOR :: 1
TESSELLATOR_MIN_ODD_TESSELLATION_FACTOR :: 1
TEXEL_ADDRESS_RANGE_BIT_COUNT :: 16
UNBOUND_MEMORY_ACCESS_RESULT :: 0
VIEWPORT_AND_SCISSORRECT_MAX_INDEX :: 15
VIEWPORT_AND_SCISSORRECT_OBJECT_COUNT_PER_PIPELINE :: 16
VIEWPORT_BOUNDS_MAX :: 32767
VIEWPORT_BOUNDS_MIN :: -32768
VS_INPUT_REGISTER_COMPONENTS :: 4
VS_INPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
VS_INPUT_REGISTER_COUNT :: 32
VS_INPUT_REGISTER_READS_PER_INST :: 2
VS_INPUT_REGISTER_READ_PORTS :: 1
VS_OUTPUT_REGISTER_COMPONENTS :: 4
VS_OUTPUT_REGISTER_COMPONENT_BIT_COUNT :: 32
VS_OUTPUT_REGISTER_COUNT :: 32
WHQL_CONTEXT_COUNT_FOR_RESOURCE_LIMIT :: 10
WHQL_DRAWINDEXED_INDEX_COUNT_2_TO_EXP :: 25
WHQL_DRAW_VERTEX_COUNT_2_TO_EXP :: 25
_1_UAV_SLOT_COUNT :: 64
_2_TILED_RESOURCE_TILE_SIZE_IN_BYTES :: 65536
_4_VIDEO_DECODER_MAX_HISTOGRAM_COMPONENTS :: 4
_4_VIDEO_DECODER_HISTOGRAM_OFFSET_ALIGNMENT :: 256

_FACD3D11 :: 0x87c

APPEND_ALIGNED_ELEMENT :: 0xffffffff
FILTER_REDUCTION_TYPE_MASK :: 0x3
FILTER_REDUCTION_TYPE_SHIFT :: 7
FILTER_TYPE_MASK :: 0x3
MIN_FILTER_SHIFT :: 4
MAG_FILTER_SHIFT :: 2
MIP_FILTER_SHIFT :: 0
COMPARISON_FILTERING_BIT :: 0x80
ANISOTROPIC_FILTERING_BIT :: 0x40
SDK_VERSION :: 7
RETURN_PARAMETER_INDEX :: -1

COMPONENT_MASK :: distinct bit_set[COMPONENT_MASK_ELEMENT; u32]
COMPONENT_MASK_ELEMENT :: enum u32 {
	X = 1,
	Y = 2,
	Z = 4,
	W = 8,
}

SHADER_REQUIRES_FLAGS :: distinct bit_set[SHADER_REQUIRES_FLAG; u64]
SHADER_REQUIRES_FLAG :: enum u64 {
	DOUBLES                      = 0,
	EARLY_DEPTH_STENCIL          = 1,
	UAVS_AT_EVERY_STAGE          = 2,
	_64_UAVS                     = 3,
	MINIMUM_PRECISION            = 4,
	_11_1_DOUBLE_EXTENSIONS      = 5,
	_11_1_SHADER_EXTENSIONS      = 6,
	LEVEL_9_COMPARISON_FILTERING = 7,
	TILED_RESOURCES              = 8,
}

SHADER_REQUIRES_DOUBLES                      :: SHADER_REQUIRES_FLAGS{.DOUBLES}
SHADER_REQUIRES_EARLY_DEPTH_STENCIL          :: SHADER_REQUIRES_FLAGS{.EARLY_DEPTH_STENCIL}
SHADER_REQUIRES_UAVS_AT_EVERY_STAGE          :: SHADER_REQUIRES_FLAGS{.UAVS_AT_EVERY_STAGE}
SHADER_REQUIRES_64_UAVS                      :: SHADER_REQUIRES_FLAGS{._64_UAVS}
SHADER_REQUIRES_MINIMUM_PRECISION            :: SHADER_REQUIRES_FLAGS{.MINIMUM_PRECISION}
SHADER_REQUIRES_11_1_DOUBLE_EXTENSIONS       :: SHADER_REQUIRES_FLAGS{._11_1_DOUBLE_EXTENSIONS}
SHADER_REQUIRES_11_1_SHADER_EXTENSIONS       :: SHADER_REQUIRES_FLAGS{._11_1_SHADER_EXTENSIONS}
SHADER_REQUIRES_LEVEL_9_COMPARISON_FILTERING :: SHADER_REQUIRES_FLAGS{.LEVEL_9_COMPARISON_FILTERING}
SHADER_REQUIRES_TILED_RESOURCES              :: SHADER_REQUIRES_FLAGS{.TILED_RESOURCES}

DRIVER_TYPE :: enum i32 {
	UNKNOWN   = 0,
	HARDWARE  = 1,
	REFERENCE = 2,
	NULL      = 3,
	SOFTWARE  = 4,
	WARP      = 5,
}

FEATURE_LEVEL :: enum i32 {
	_1_0_CORE = 4096,
	_9_1      = 37120,
	_9_2      = 37376,
	_9_3      = 37632,
	_10_0     = 40960,
	_10_1     = 41216,
	_11_0     = 45056,
	_11_1     = 45312,
	_12_0     = 49152,
	_12_1     = 49408,
}

PRIMITIVE_TOPOLOGY :: enum i32 {
	UNDEFINED                   = 0,
	POINTLIST                   = 1,
	LINELIST                    = 2,
	LINESTRIP                   = 3,
	TRIANGLELIST                = 4,
	TRIANGLESTRIP               = 5,
	LINELIST_ADJ                = 10,
	LINESTRIP_ADJ               = 11,
	TRIANGLELIST_ADJ            = 12,
	TRIANGLESTRIP_ADJ           = 13,
	_1_CONTROL_POINT_PATCHLIST  = 33,
	_2_CONTROL_POINT_PATCHLIST  = 34,
	_3_CONTROL_POINT_PATCHLIST  = 35,
	_4_CONTROL_POINT_PATCHLIST  = 36,
	_5_CONTROL_POINT_PATCHLIST  = 37,
	_6_CONTROL_POINT_PATCHLIST  = 38,
	_7_CONTROL_POINT_PATCHLIST  = 39,
	_8_CONTROL_POINT_PATCHLIST  = 40,
	_9_CONTROL_POINT_PATCHLIST  = 41,
	_10_CONTROL_POINT_PATCHLIST = 42,
	_11_CONTROL_POINT_PATCHLIST = 43,
	_12_CONTROL_POINT_PATCHLIST = 44,
	_13_CONTROL_POINT_PATCHLIST = 45,
	_14_CONTROL_POINT_PATCHLIST = 46,
	_15_CONTROL_POINT_PATCHLIST = 47,
	_16_CONTROL_POINT_PATCHLIST = 48,
	_17_CONTROL_POINT_PATCHLIST = 49,
	_18_CONTROL_POINT_PATCHLIST = 50,
	_19_CONTROL_POINT_PATCHLIST = 51,
	_20_CONTROL_POINT_PATCHLIST = 52,
	_21_CONTROL_POINT_PATCHLIST = 53,
	_22_CONTROL_POINT_PATCHLIST = 54,
	_23_CONTROL_POINT_PATCHLIST = 55,
	_24_CONTROL_POINT_PATCHLIST = 56,
	_25_CONTROL_POINT_PATCHLIST = 57,
	_26_CONTROL_POINT_PATCHLIST = 58,
	_27_CONTROL_POINT_PATCHLIST = 59,
	_28_CONTROL_POINT_PATCHLIST = 60,
	_29_CONTROL_POINT_PATCHLIST = 61,
	_30_CONTROL_POINT_PATCHLIST = 62,
	_31_CONTROL_POINT_PATCHLIST = 63,
	_32_CONTROL_POINT_PATCHLIST = 64,
}

PRIMITIVE :: enum i32 {
	UNDEFINED               = 0,
	POINT                   = 1,
	LINE                    = 2,
	TRIANGLE                = 3,
	LINE_ADJ                = 6,
	TRIANGLE_ADJ            = 7,
	_1_CONTROL_POINT_PATCH  = 8,
	_2_CONTROL_POINT_PATCH  = 9,
	_3_CONTROL_POINT_PATCH  = 10,
	_4_CONTROL_POINT_PATCH  = 11,
	_5_CONTROL_POINT_PATCH  = 12,
	_6_CONTROL_POINT_PATCH  = 13,
	_7_CONTROL_POINT_PATCH  = 14,
	_8_CONTROL_POINT_PATCH  = 15,
	_9_CONTROL_POINT_PATCH  = 16,
	_10_CONTROL_POINT_PATCH = 17,
	_11_CONTROL_POINT_PATCH = 18,
	_12_CONTROL_POINT_PATCH = 19,
	_13_CONTROL_POINT_PATCH = 20,
	_14_CONTROL_POINT_PATCH = 21,
	_15_CONTROL_POINT_PATCH = 22,
	_16_CONTROL_POINT_PATCH = 23,
	_17_CONTROL_POINT_PATCH = 24,
	_18_CONTROL_POINT_PATCH = 25,
	_19_CONTROL_POINT_PATCH = 26,
	_20_CONTROL_POINT_PATCH = 27,
	_21_CONTROL_POINT_PATCH = 28,
	_22_CONTROL_POINT_PATCH = 29,
	_23_CONTROL_POINT_PATCH = 30,
	_24_CONTROL_POINT_PATCH = 31,
	_25_CONTROL_POINT_PATCH = 32,
	_26_CONTROL_POINT_PATCH = 33,
	_27_CONTROL_POINT_PATCH = 34,
	_28_CONTROL_POINT_PATCH = 35,
	_29_CONTROL_POINT_PATCH = 36,
	_30_CONTROL_POINT_PATCH = 37,
	_31_CONTROL_POINT_PATCH = 38,
	_32_CONTROL_POINT_PATCH = 39,
}

SRV_DIMENSION :: enum i32 {
	UNKNOWN          = 0,
	BUFFER           = 1,
	TEXTURE1D        = 2,
	TEXTURE1DARRAY   = 3,
	TEXTURE2D        = 4,
	TEXTURE2DARRAY   = 5,
	TEXTURE2DMS      = 6,
	TEXTURE2DMSARRAY = 7,
	TEXTURE3D        = 8,
	TEXTURECUBE      = 9,
	TEXTURECUBEARRAY = 10,
	BUFFEREX         = 11,
}

PFN_DESTRUCTION_CALLBACK :: #type proc "c" (a0: rawptr)


ID3DDestructionNotifier_UUID_STRING :: "A06EB39A-50DA-425B-8C31-4EECD6C270F3"
ID3DDestructionNotifier_UUID := &IID{0xA06EB39A, 0x50DA, 0x425B, {0x8C, 0x31, 0x4E, 0xEC, 0xD6, 0xC2, 0x70, 0xF3}}
ID3DDestructionNotifier :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3ddestructionnotifier_vtable: ^ID3DDestructionNotifier_VTable,
}
ID3DDestructionNotifier_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	RegisterDestructionCallback: proc "system" (this: ^ID3DDestructionNotifier, callbackFn: PFN_DESTRUCTION_CALLBACK, pData: rawptr, pCallbackID: ^u32) -> HRESULT,
	UnregisterDestructionCallback: proc "system" (this: ^ID3DDestructionNotifier, callbackID: u32) -> HRESULT,
}


SHADER_VARIABLE_CLASS :: enum i32 {
	SCALAR                = 0,
	VECTOR                = 1,
	MATRIX_ROWS           = 2,
	MATRIX_COLUMNS        = 3,
	OBJECT                = 4,
	STRUCT                = 5,
	INTERFACE_CLASS       = 6,
	INTERFACE_POINTER     = 7,
}

SHADER_VARIABLE_FLAGS :: distinct bit_set[SHADER_VARIABLE_FLAG; u32]
SHADER_VARIABLE_FLAG :: enum u32 {
	USERPACKED              = 0,
	USED                    = 1,
	INTERFACE_POINTER       = 2,
	INTERFACE_PARAMETER     = 3,
}

SHADER_VARIABLE_TYPE :: enum i32 {
	VOID                          = 0,
	BOOL                          = 1,
	INT                           = 2,
	FLOAT                         = 3,
	STRING                        = 4,
	TEXTURE                       = 5,
	TEXTURE1D                     = 6,
	TEXTURE2D                     = 7,
	TEXTURE3D                     = 8,
	TEXTURECUBE                   = 9,
	SAMPLER                       = 10,
	SAMPLER1D                     = 11,
	SAMPLER2D                     = 12,
	SAMPLER3D                     = 13,
	SAMPLERCUBE                   = 14,
	PIXELSHADER                   = 15,
	VERTEXSHADER                  = 16,
	PIXELFRAGMENT                 = 17,
	VERTEXFRAGMENT                = 18,
	UINT                          = 19,
	UINT8                         = 20,
	GEOMETRYSHADER                = 21,
	RASTERIZER                    = 22,
	DEPTHSTENCIL                  = 23,
	BLEND                         = 24,
	BUFFER                        = 25,
	CBUFFER                       = 26,
	TBUFFER                       = 27,
	TEXTURE1DARRAY                = 28,
	TEXTURE2DARRAY                = 29,
	RENDERTARGETVIEW              = 30,
	DEPTHSTENCILVIEW              = 31,
	TEXTURE2DMS                   = 32,
	TEXTURE2DMSARRAY              = 33,
	TEXTURECUBEARRAY              = 34,
	HULLSHADER                    = 35,
	DOMAINSHADER                  = 36,
	INTERFACE_POINTER             = 37,
	COMPUTESHADER                 = 38,
	DOUBLE                        = 39,
	RWTEXTURE1D                   = 40,
	RWTEXTURE1DARRAY              = 41,
	RWTEXTURE2D                   = 42,
	RWTEXTURE2DARRAY              = 43,
	RWTEXTURE3D                   = 44,
	RWBUFFER                      = 45,
	BYTEADDRESS_BUFFER            = 46,
	RWBYTEADDRESS_BUFFER          = 47,
	STRUCTURED_BUFFER             = 48,
	RWSTRUCTURED_BUFFER           = 49,
	APPEND_STRUCTURED_BUFFER      = 50,
	CONSUME_STRUCTURED_BUFFER     = 51,
	MIN8FLOAT                     = 52,
	MIN10FLOAT                    = 53,
	MIN16FLOAT                    = 54,
	MIN12INT                      = 55,
	MIN16INT                      = 56,
	MIN16UINT                     = 57,
}

SHADER_INPUT_FLAGS :: distinct bit_set[SHADER_INPUT_FLAG; u32]
SHADER_INPUT_FLAG :: enum u32 {
	USERPACKED          = 0,
	COMPARISON_SAMPLER  = 1,
	TEXTURE_COMPONENT_0 = 2,
	TEXTURE_COMPONENT_1 = 3,
	TEXTURE_COMPONENTS  = 0xc,
	UNUSED              = 4,
}
SHADER_INPUT_FLAG_USERPACKED          :: SHADER_INPUT_FLAGS{.USERPACKED}
SHADER_INPUT_FLAG_COMPARISON_SAMPLER  :: SHADER_INPUT_FLAGS{.COMPARISON_SAMPLER}
SHADER_INPUT_FLAG_TEXTURE_COMPONENT_0 :: SHADER_INPUT_FLAGS{.TEXTURE_COMPONENT_0}
SHADER_INPUT_FLAG_TEXTURE_COMPONENT_1 :: SHADER_INPUT_FLAGS{.TEXTURE_COMPONENT_1}
SHADER_INPUT_FLAG_TEXTURE_COMPONENTS  :: SHADER_INPUT_FLAGS{.TEXTURE_COMPONENT_0, .TEXTURE_COMPONENT_1}
SHADER_INPUT_FLAG_UNUSED              :: SHADER_INPUT_FLAGS{.UNUSED}

SHADER_INPUT_TYPE :: enum i32 {
	CBUFFER                       = 0,
	TBUFFER                       = 1,
	TEXTURE                       = 2,
	SAMPLER                       = 3,
	UAV_RWTYPED                   = 4,
	STRUCTURED                    = 5,
	UAV_RWSTRUCTURED              = 6,
	BYTEADDRESS                   = 7,
	UAV_RWBYTEADDRESS             = 8,
	UAV_APPEND_STRUCTURED         = 9,
	UAV_CONSUME_STRUCTURED        = 10,
	UAV_RWSTRUCTURED_WITH_COUNTER = 11,
	RTACCELERATIONSTRUCTURE       = 12,
	UAV_FEEDBACKTEXTURE           = 13,
}

SHADER_CBUFFER_FLAGS :: distinct bit_set[SHADER_CBUFFER_FLAG; u32]
SHADER_CBUFFER_FLAG :: enum u32 {
	USERPACKED = 0,
}

CBUFFER_TYPE :: enum i32 {
	CBUFFER            = 0,
	TBUFFER            = 1,
	INTERFACE_POINTERS = 2,
	RESOURCE_BIND_INFO = 3,
}

NAME :: enum i32 {
	UNDEFINED                     = 0,
	POSITION                      = 1,
	CLIP_DISTANCE                 = 2,
	CULL_DISTANCE                 = 3,
	RENDER_TARGET_ARRAY_INDEX     = 4,
	VIEWPORT_ARRAY_INDEX          = 5,
	VERTEX_ID                     = 6,
	PRIMITIVE_ID                  = 7,
	INSTANCE_ID                   = 8,
	IS_FRONT_FACE                 = 9,
	SAMPLE_INDEX                  = 10,
	FINAL_QUAD_EDGE_TESSFACTOR    = 11,
	FINAL_QUAD_INSIDE_TESSFACTOR  = 12,
	FINAL_TRI_EDGE_TESSFACTOR     = 13,
	FINAL_TRI_INSIDE_TESSFACTOR   = 14,
	FINAL_LINE_DETAIL_TESSFACTOR  = 15,
	FINAL_LINE_DENSITY_TESSFACTOR = 16,
	BARYCENTRICS                  = 23,
	SHADINGRATE                   = 24,
	CULLPRIMITIVE                 = 25,
	TARGET                        = 64,
	DEPTH                         = 65,
	COVERAGE                      = 66,
	DEPTH_GREATER_EQUAL           = 67,
	DEPTH_LESS_EQUAL              = 68,
	STENCIL_REF                   = 69,
	INNER_COVERAGE                = 70,
}

RESOURCE_RETURN_TYPE :: enum i32 {
	UNORM     = 1,
	SNORM     = 2,
	SINT      = 3,
	UINT      = 4,
	FLOAT     = 5,
	MIXED     = 6,
	DOUBLE    = 7,
	CONTINUED = 8,
}

REGISTER_COMPONENT_TYPE :: enum i32 {
	UNKNOWN = 0,
	UINT32  = 1,
	SINT32  = 2,
	FLOAT32 = 3,
}

TESSELLATOR_DOMAIN :: enum i32 {
	UNDEFINED = 0,
	ISOLINE   = 1,
	TRI       = 2,
	QUAD      = 3,
}

TESSELLATOR_PARTITIONING :: enum i32 {
	UNDEFINED       = 0,
	INTEGER         = 1,
	POW2            = 2,
	FRACTIONAL_ODD  = 3,
	FRACTIONAL_EVEN = 4,
}

TESSELLATOR_OUTPUT_PRIMITIVE :: enum i32 {
	UNDEFINED    = 0,
	POINT        = 1,
	LINE         = 2,
	TRIANGLE_CW  = 3,
	TRIANGLE_CCW = 4,
}

MIN_PRECISION :: enum i32 {
	DEFAULT   = 0,
	FLOAT_16  = 1,
	FLOAT_2_8 = 2,
	RESERVED  = 3,
	SINT_16   = 4,
	UINT_16   = 5,
	ANY_16    = 240,
	ANY_10    = 241,
}

INTERPOLATION_MODE :: enum i32 {
	UNDEFINED                     = 0,
	CONSTANT                      = 1,
	LINEAR                        = 2,
	LINEAR_CENTROID               = 3,
	LINEAR_NOPERSPECTIVE          = 4,
	LINEAR_NOPERSPECTIVE_CENTROID = 5,
	LINEAR_SAMPLE                 = 6,
	LINEAR_NOPERSPECTIVE_SAMPLE   = 7,
}

PARAMETER_FLAGS :: distinct bit_set[PARAMETER_FLAG; u32]
PARAMETER_FLAG :: enum u32 {
	IN   = 0,
	OUT  = 1,
}

CDEFAULT :: struct {
	_: u8,
}

INPUT_CLASSIFICATION :: enum i32 {
	VERTEX_DATA   = 0,
	INSTANCE_DATA = 1,
}

INPUT_ELEMENT_DESC :: struct {
	SemanticName:         cstring,
	SemanticIndex:        u32,
	Format:               dxgi.FORMAT,
	InputSlot:            u32,
	AlignedByteOffset:    u32,
	InputSlotClass:       INPUT_CLASSIFICATION,
	InstanceDataStepRate: u32,
}

FILL_MODE :: enum i32 {
	WIREFRAME = 2,
	SOLID     = 3,
}

CULL_MODE :: enum i32 {
	NONE  = 1,
	FRONT = 2,
	BACK  = 3,
}

SO_DECLARATION_ENTRY :: struct {
	Stream:         u32,
	SemanticName:   cstring,
	SemanticIndex:  u32,
	StartComponent: u8,
	ComponentCount: u8,
	OutputSlot:     u8,
}

VIEWPORT :: struct {
	TopLeftX: f32,
	TopLeftY: f32,
	Width:    f32,
	Height:   f32,
	MinDepth: f32,
	MaxDepth: f32,
}

DRAW_INSTANCED_INDIRECT_ARGS :: struct {
	VertexCountPerInstance: u32,
	InstanceCount:          u32,
	StartVertexLocation:    u32,
	StartInstanceLocation:  u32,
}

DRAW_INDEXED_INSTANCED_INDIRECT_ARGS :: struct {
	IndexCountPerInstance: u32,
	InstanceCount:         u32,
	StartIndexLocation:    u32,
	BaseVertexLocation:    i32,
	StartInstanceLocation: u32,
}

RESOURCE_DIMENSION :: enum i32 {
	UNKNOWN   = 0,
	BUFFER    = 1,
	TEXTURE1D = 2,
	TEXTURE2D = 3,
	TEXTURE3D = 4,
}

DSV_DIMENSION :: enum i32 {
	UNKNOWN          = 0,
	TEXTURE1D        = 1,
	TEXTURE1DARRAY   = 2,
	TEXTURE2D        = 3,
	TEXTURE2DARRAY   = 4,
	TEXTURE2DMS      = 5,
	TEXTURE2DMSARRAY = 6,
}

RTV_DIMENSION :: enum i32 {
	UNKNOWN          = 0,
	BUFFER           = 1,
	TEXTURE1D        = 2,
	TEXTURE1DARRAY   = 3,
	TEXTURE2D        = 4,
	TEXTURE2DARRAY   = 5,
	TEXTURE2DMS      = 6,
	TEXTURE2DMSARRAY = 7,
	TEXTURE3D        = 8,
}

UAV_DIMENSION :: enum i32 {
	UNKNOWN        = 0,
	BUFFER         = 1,
	TEXTURE1D      = 2,
	TEXTURE1DARRAY = 3,
	TEXTURE2D      = 4,
	TEXTURE2DARRAY = 5,
	TEXTURE3D      = 8,
}

USAGE :: enum i32 {
	DEFAULT   = 0,
	IMMUTABLE = 1,
	DYNAMIC   = 2,
	STAGING   = 3,
}

BIND_FLAGS :: distinct bit_set[BIND_FLAG; u32]
BIND_FLAG :: enum u32 {
	VERTEX_BUFFER    = 0,
	INDEX_BUFFER     = 1,
	CONSTANT_BUFFER  = 2,
	SHADER_RESOURCE  = 3,
	STREAM_OUTPUT    = 4,
	RENDER_TARGET    = 5,
	DEPTH_STENCIL    = 6,
	UNORDERED_ACCESS = 7,
	DECODER          = 9,
	VIDEO_ENCODER    = 10,
}

CPU_ACCESS_FLAGS :: distinct bit_set[CPU_ACCESS_FLAG; u32]
CPU_ACCESS_FLAG :: enum u32 {
	WRITE = 16,
	READ  = 17,

}

RESOURCE_MISC_FLAGS :: distinct bit_set[RESOURCE_MISC_FLAG; u32]
RESOURCE_MISC_FLAG :: enum u32 {
	GENERATE_MIPS                   = 0,
	SHARED                          = 1,
	TEXTURECUBE                     = 2,
	DRAWINDIRECT_ARGS               = 4,
	BUFFER_ALLOW_RAW_VIEWS          = 5,
	BUFFER_STRUCTURED               = 6,
	RESOURCE_CLAMP                  = 7,
	SHARED_KEYEDMUTEX               = 8,
	GDI_COMPATIBLE                  = 9,
	SHARED_NTHANDLE                 = 11,
	RESTRICTED_CONTENT              = 12,
	RESTRICT_SHARED_RESOURCE        = 13,
	RESTRICT_SHARED_RESOURCE_DRIVER = 14,
	GUARDED                         = 15,
	TILE_POOL                       = 17,
	TILED                           = 18,
	HW_PROTECTED                    = 19,
}

MAP :: enum i32 {
	READ               = 1,
	WRITE              = 2,
	READ_WRITE         = 3,
	WRITE_DISCARD      = 4,
	WRITE_NO_OVERWRITE = 5,
}

MAP_FLAGS :: distinct bit_set[MAP_FLAG; u32]
MAP_FLAG :: enum u32 {
	DO_NOT_WAIT = 20,
}

RAISE_FLAGS :: distinct bit_set[RAISE_FLAG; u32]
RAISE_FLAG :: enum u32 {
	DRIVER_INTERNAL_ERROR = 0,
}

CLEAR_FLAGS :: distinct bit_set[CLEAR_FLAG; u32]
CLEAR_FLAG :: enum u32 {
	DEPTH   = 0,
	STENCIL = 1,
}


CRECT :: struct {
	using d3d11_rect: RECT,
}

BOX :: struct {
	left:   u32,
	top:    u32,
	front:  u32,
	right:  u32,
	bottom: u32,
	back:   u32,
}

CBOX :: struct {
	using d3d11_box: BOX,
}


IDeviceChild_UUID_STRING :: "1841E5C8-16B0-489B-BCC8-44CFB0D5DEAE"
IDeviceChild_UUID := &IID{0x1841E5C8, 0x16B0, 0x489B, {0xBC, 0xC8, 0x44, 0xCF, 0xB0, 0xD5, 0xDE, 0xAE}}
IDeviceChild :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11devicechild_vtable: ^IDeviceChild_VTable,
}
IDeviceChild_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	GetDevice:               proc "system" (this: ^IDeviceChild, ppDevice: ^^IDevice),
	GetPrivateData:          proc "system" (this: ^IDeviceChild, guid: ^GUID, pDataSize: ^u32, pData: rawptr) -> HRESULT,
	SetPrivateData:          proc "system" (this: ^IDeviceChild, guid: ^GUID, DataSize: u32, pData: rawptr) -> HRESULT,
	SetPrivateDataInterface: proc "system" (this: ^IDeviceChild, guid: ^GUID, pData: ^IUnknown) -> HRESULT,
}


COMPARISON_FUNC :: enum i32 {
	NEVER         = 1,
	LESS          = 2,
	EQUAL         = 3,
	LESS_EQUAL    = 4,
	GREATER       = 5,
	NOT_EQUAL     = 6,
	GREATER_EQUAL = 7,
	ALWAYS        = 8,
}

DEPTH_WRITE_MASK :: enum i32 {
	ZERO = 0,
	ALL  = 1,
}

STENCIL_OP :: enum i32 {
	KEEP     = 1,
	ZERO     = 2,
	REPLACE  = 3,
	INCR_SAT = 4,
	DECR_SAT = 5,
	INVERT   = 6,
	INCR     = 7,
	DECR     = 8,
}

DEPTH_STENCILOP_DESC :: struct {
	StencilFailOp:      STENCIL_OP,
	StencilDepthFailOp: STENCIL_OP,
	StencilPassOp:      STENCIL_OP,
	StencilFunc:        COMPARISON_FUNC,
}

DEPTH_STENCIL_DESC :: struct {
	DepthEnable:      BOOL,
	DepthWriteMask:   DEPTH_WRITE_MASK,
	DepthFunc:        COMPARISON_FUNC,
	StencilEnable:    BOOL,
	StencilReadMask:  u8,
	StencilWriteMask: u8,
	FrontFace:        DEPTH_STENCILOP_DESC,
	BackFace:         DEPTH_STENCILOP_DESC,
}

CDEPTH_STENCIL_DESC :: struct {
	using d3d11_depth_stencil_desc: DEPTH_STENCIL_DESC,
}


IDepthStencilState_UUID_STRING :: "03823EFB-8D8F-4E1C-9AA2-F64BB2CBFDF1"
IDepthStencilState_UUID := &IID{0x03823EFB, 0x8D8F, 0x4E1C, {0x9A, 0xA2, 0xF6, 0x4B, 0xB2, 0xCB, 0xFD, 0xF1}}
IDepthStencilState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11depthstencilstate_vtable: ^IDepthStencilState_VTable,
}
IDepthStencilState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "system" (this: ^IDepthStencilState, pDesc: ^DEPTH_STENCIL_DESC),
}


BLEND :: enum i32 {
	ZERO             = 1,
	ONE              = 2,
	SRC_COLOR        = 3,
	INV_SRC_COLOR    = 4,
	SRC_ALPHA        = 5,
	INV_SRC_ALPHA    = 6,
	DEST_ALPHA       = 7,
	INV_DEST_ALPHA   = 8,
	DEST_COLOR       = 9,
	INV_DEST_COLOR   = 10,
	SRC_ALPHA_SAT    = 11,
	BLEND_FACTOR     = 14,
	INV_BLEND_FACTOR = 15,
	SRC1_COLOR       = 16,
	INV_SRC1_COLOR   = 17,
	SRC1_ALPHA       = 18,
	INV_SRC1_ALPHA   = 19,
}

BLEND_OP :: enum i32 {
	ADD          = 1,
	SUBTRACT     = 2,
	REV_SUBTRACT = 3,
	MIN          = 4,
	MAX          = 5,
}

COLOR_WRITE_ENABLE_MASK   :: distinct bit_set[COLOR_WRITE_ENABLE; u32]

COLOR_WRITE_ENABLE_RED   :: COLOR_WRITE_ENABLE_MASK{.RED}
COLOR_WRITE_ENABLE_GREEN :: COLOR_WRITE_ENABLE_MASK{.GREEN}
COLOR_WRITE_ENABLE_BLUE  :: COLOR_WRITE_ENABLE_MASK{.BLUE}
COLOR_WRITE_ENABLE_ALPHA :: COLOR_WRITE_ENABLE_MASK{.ALPHA}
COLOR_WRITE_ENABLE_ALL   :: COLOR_WRITE_ENABLE_MASK{.RED, .GREEN, .BLUE, .ALPHA}

COLOR_WRITE_ENABLE :: enum i32 {
	RED   = 0,
	GREEN = 1,
	BLUE  = 2,
	ALPHA = 3,
}

RENDER_TARGET_BLEND_DESC :: struct {
	BlendEnable:           BOOL,
	SrcBlend:              BLEND,
	DestBlend:             BLEND,
	BlendOp:               BLEND_OP,
	SrcBlendAlpha:         BLEND,
	DestBlendAlpha:        BLEND,
	BlendOpAlpha:          BLEND_OP,
	RenderTargetWriteMask: u8,
}

BLEND_DESC :: struct {
	AlphaToCoverageEnable:  BOOL,
	IndependentBlendEnable: BOOL,
	RenderTarget:           [8]RENDER_TARGET_BLEND_DESC,
}

CBLEND_DESC :: struct {
	using d3d11_blend_desc: BLEND_DESC,
}


IBlendState_UUID_STRING :: "75B68FAA-347D-4159-8F45-A0640F01CD9A"
IBlendState_UUID := &IID{0x75B68FAA, 0x347D, 0x4159, {0x8F, 0x45, 0xA0, 0x64, 0x0F, 0x01, 0xCD, 0x9A}}
IBlendState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11blendstate_vtable: ^IBlendState_VTable,
}
IBlendState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "system" (this: ^IBlendState, pDesc: ^BLEND_DESC),
}


RASTERIZER_DESC :: struct {
	FillMode:              FILL_MODE,
	CullMode:              CULL_MODE,
	FrontCounterClockwise: BOOL,
	DepthBias:             i32,
	DepthBiasClamp:        f32,
	SlopeScaledDepthBias:  f32,
	DepthClipEnable:       BOOL,
	ScissorEnable:         BOOL,
	MultisampleEnable:     BOOL,
	AntialiasedLineEnable: BOOL,
}

CRASTERIZER_DESC :: struct {
	using d3d11_rasterizer_desc: RASTERIZER_DESC,
}


IRasterizerState_UUID_STRING :: "9BB4AB81-AB1A-4D8F-B506-FC04200B6EE7"
IRasterizerState_UUID := &IID{0x9BB4AB81, 0xAB1A, 0x4D8F, {0xB5, 0x06, 0xFC, 0x04, 0x20, 0x0B, 0x6E, 0xE7}}
IRasterizerState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11rasterizerstate_vtable: ^IRasterizerState_VTable,
}
IRasterizerState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "system" (this: ^IRasterizerState, pDesc: ^RASTERIZER_DESC),
}


SUBRESOURCE_DATA :: struct {
	pSysMem:          rawptr,
	SysMemPitch:      u32,
	SysMemSlicePitch: u32,
}

MAPPED_SUBRESOURCE :: struct {
	pData:      rawptr,
	RowPitch:   u32,
	DepthPitch: u32,
}


IResource_UUID_STRING :: "DC8E63F3-D12B-4952-B47B-5E45026A862D"
IResource_UUID := &IID{0xDC8E63F3, 0xD12B, 0x4952, {0xB4, 0x7B, 0x5E, 0x45, 0x02, 0x6A, 0x86, 0x2D}}
IResource :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11resource_vtable: ^IResource_VTable,
}
IResource_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetType:             proc "system" (this: ^IResource, pResourceDimension: ^RESOURCE_DIMENSION),
	SetEvictionPriority: proc "system" (this: ^IResource, EvictionPriority: u32),
	GetEvictionPriority: proc "system" (this: ^IResource) -> u32,
}


BUFFER_DESC :: struct {
	ByteWidth:           u32,
	Usage:               USAGE,
	BindFlags:           BIND_FLAGS,
	CPUAccessFlags:      CPU_ACCESS_FLAGS,
	MiscFlags:           RESOURCE_MISC_FLAGS,
	StructureByteStride: u32,
}

CBUFFER_DESC :: struct {
	using d3d11_buffer_desc: BUFFER_DESC,
}


IBuffer_UUID_STRING :: "48570B85-D1EE-4FCD-A250-EB350722B037"
IBuffer_UUID := &IID{0x48570B85, 0xD1EE, 0x4FCD, {0xA2, 0x50, 0xEB, 0x35, 0x07, 0x22, 0xB0, 0x37}}
IBuffer :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11buffer_vtable: ^IBuffer_VTable,
}
IBuffer_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "system" (this: ^IBuffer, pDesc: ^BUFFER_DESC),
}


TEXTURE1D_DESC :: struct {
	Width:          u32,
	MipLevels:      u32,
	ArraySize:      u32,
	Format:         dxgi.FORMAT,
	Usage:          USAGE,
	BindFlags:      BIND_FLAGS,
	CPUAccessFlags: CPU_ACCESS_FLAGS,
	MiscFlags:      RESOURCE_MISC_FLAGS,
}

CTEXTURE1D_DESC :: struct {
	using d3d11_texture1d_desc: TEXTURE1D_DESC,
}


ITexture1D_UUID_STRING :: "F8FB5C27-C6B3-4F75-A4C8-439AF2EF564C"
ITexture1D_UUID := &IID{0xF8FB5C27, 0xC6B3, 0x4F75, {0xA4, 0xC8, 0x43, 0x9A, 0xF2, 0xEF, 0x56, 0x4C}}
ITexture1D :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11texture1d_vtable: ^ITexture1D_VTable,
}
ITexture1D_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "system" (this: ^ITexture1D, pDesc: ^TEXTURE1D_DESC),
}


TEXTURE2D_DESC :: struct {
	Width:          u32,
	Height:         u32,
	MipLevels:      u32,
	ArraySize:      u32,
	Format:         dxgi.FORMAT,
	SampleDesc:     dxgi.SAMPLE_DESC,
	Usage:          USAGE,
	BindFlags:      BIND_FLAGS,
	CPUAccessFlags: CPU_ACCESS_FLAGS,
	MiscFlags:      RESOURCE_MISC_FLAGS,
}

CTEXTURE2D_DESC :: struct {
	using d3d11_texture2d_desc: TEXTURE2D_DESC,
}


ITexture2D_UUID_STRING :: "6F15AAF2-D208-4E89-9AB4-489535D34F9C"
ITexture2D_UUID := &IID{0x6F15AAF2, 0xD208, 0x4E89, {0x9A, 0xB4, 0x48, 0x95, 0x35, 0xD3, 0x4F, 0x9C}}
ITexture2D :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11texture2d_vtable: ^ITexture2D_VTable,
}
ITexture2D_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "system" (this: ^ITexture2D, pDesc: ^TEXTURE2D_DESC),
}


TEXTURE3D_DESC :: struct {
	Width:          u32,
	Height:         u32,
	Depth:          u32,
	MipLevels:      u32,
	Format:         dxgi.FORMAT,
	Usage:          USAGE,
	BindFlags:      BIND_FLAGS,
	CPUAccessFlags: CPU_ACCESS_FLAGS,
	MiscFlags:      RESOURCE_MISC_FLAGS,
}

CTEXTURE3D_DESC :: struct {
	using d3d11_texture3d_desc: TEXTURE3D_DESC,
}


ITexture3D_UUID_STRING :: "037E866E-F56D-4357-A8AF-9DABBE6E250E"
ITexture3D_UUID := &IID{0x037E866E, 0xF56D, 0x4357, {0xA8, 0xAF, 0x9D, 0xAB, 0xBE, 0x6E, 0x25, 0x0E}}
ITexture3D :: struct #raw_union {
	#subtype id3d11resource: IResource,
	using id3d11texture3d_vtable: ^ITexture3D_VTable,
}
ITexture3D_VTable :: struct {
	using id3d11resource_vtable: IResource_VTable,
	GetDesc: proc "system" (this: ^ITexture3D, pDesc: ^TEXTURE3D_DESC),
}


TEXTURECUBE_FACE :: enum i32 {
	POSITIVE_X = 0,
	NEGATIVE_X = 1,
	POSITIVE_Y = 2,
	NEGATIVE_Y = 3,
	POSITIVE_Z = 4,
	NEGATIVE_Z = 5,
}


IView_UUID_STRING :: "839D1216-BB2E-412B-B7F4-A9DBEBE08ED1"
IView_UUID := &IID{0x839D1216, 0xBB2E, 0x412B, {0xB7, 0xF4, 0xA9, 0xDB, 0xEB, 0xE0, 0x8E, 0xD1}}
IView :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11view_vtable: ^IView_VTable,
}
IView_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetResource: proc "system" (this: ^IView, ppResource: ^^IResource),
}


BUFFER_SRV :: struct {
	using _: struct #raw_union {
		FirstElement:  u32,
		ElementOffset: u32,
	},
	using _: struct #raw_union {
		NumElements:  u32,
		ElementWidth: u32,
	},
}

BUFFEREX_SRV_FLAGS :: distinct bit_set[BUFFEREX_SRV_FLAG; u32]
BUFFEREX_SRV_FLAG :: enum u32 {
	RAW = 0,
}

BUFFEREX_SRV :: struct {
	FirstElement: u32,
	NumElements:  u32,
	Flags:        BUFFEREX_SRV_FLAGS,
}

TEX1D_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEX1D_ARRAY_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEX2D_ARRAY_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX3D_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEXCUBE_SRV :: struct {
	MostDetailedMip: u32,
	MipLevels:       u32,
}

TEXCUBE_ARRAY_SRV :: struct {
	MostDetailedMip:  u32,
	MipLevels:        u32,
	First2DArrayFace: u32,
	NumCubes:         u32,
}

TEX2DMS_SRV :: struct {
	UnusedField_NothingToDefine: u32,
}

TEX2DMS_ARRAY_SRV :: struct {
	FirstArraySlice: u32,
	ArraySize:       u32,
}

SHADER_RESOURCE_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: SRV_DIMENSION,
	using _: struct #raw_union {
		Buffer:           BUFFER_SRV,
		Texture1D:        TEX1D_SRV,
		Texture1DArray:   TEX1D_ARRAY_SRV,
		Texture2D:        TEX2D_SRV,
		Texture2DArray:   TEX2D_ARRAY_SRV,
		Texture2DMS:      TEX2DMS_SRV,
		Texture2DMSArray: TEX2DMS_ARRAY_SRV,
		Texture3D:        TEX3D_SRV,
		TextureCube:      TEXCUBE_SRV,
		TextureCubeArray: TEXCUBE_ARRAY_SRV,
		BufferEx:         BUFFEREX_SRV,
	},
}

CSHADER_RESOURCE_VIEW_DESC :: struct {
	using d3d11_shader_resource_view_desc: SHADER_RESOURCE_VIEW_DESC,
}


IShaderResourceView_UUID_STRING :: "B0E06FE0-8192-4E1A-B1CA-36D7414710B2"
IShaderResourceView_UUID := &IID{0xB0E06FE0, 0x8192, 0x4E1A, {0xB1, 0xCA, 0x36, 0xD7, 0x41, 0x47, 0x10, 0xB2}}
IShaderResourceView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11shaderresourceview_vtable: ^IShaderResourceView_VTable,
}
IShaderResourceView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "system" (this: ^IShaderResourceView, pDesc: ^SHADER_RESOURCE_VIEW_DESC),
}


BUFFER_RTV :: struct {
	using _: struct #raw_union {
		FirstElement:  u32,
		ElementOffset: u32,
	},
	using _: struct #raw_union {
		NumElements:  u32,
		ElementWidth: u32,
	},
}

TEX1D_RTV :: struct {
	MipSlice: u32,
}

TEX1D_ARRAY_RTV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_RTV :: struct {
	MipSlice: u32,
}

TEX2DMS_RTV :: struct {
	UnusedField_NothingToDefine: u32,
}

TEX2D_ARRAY_RTV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2DMS_ARRAY_RTV :: struct {
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX3D_RTV :: struct {
	MipSlice:    u32,
	FirstWSlice: u32,
	WSize:       u32,
}

RENDER_TARGET_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: RTV_DIMENSION,
	using _: struct #raw_union {
		Buffer:           BUFFER_RTV,
		Texture1D:        TEX1D_RTV,
		Texture1DArray:   TEX1D_ARRAY_RTV,
		Texture2D:        TEX2D_RTV,
		Texture2DArray:   TEX2D_ARRAY_RTV,
		Texture2DMS:      TEX2DMS_RTV,
		Texture2DMSArray: TEX2DMS_ARRAY_RTV,
		Texture3D:        TEX3D_RTV,
	},
}

CRENDER_TARGET_VIEW_DESC :: struct {
	using d3d11_render_target_view_desc: RENDER_TARGET_VIEW_DESC,
}


IRenderTargetView_UUID_STRING :: "DFDBA067-0B8D-4865-875B-D7B4516CC164"
IRenderTargetView_UUID := &IID{0xDFDBA067, 0x0B8D, 0x4865, {0x87, 0x5B, 0xD7, 0xB4, 0x51, 0x6C, 0xC1, 0x64}}
IRenderTargetView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11rendertargetview_vtable: ^IRenderTargetView_VTable,
}
IRenderTargetView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "system" (this: ^IRenderTargetView, pDesc: ^RENDER_TARGET_VIEW_DESC),
}


CVIEWPORT :: struct {
	using d3d11_viewport: VIEWPORT,
}

TEX1D_DSV :: struct {
	MipSlice: u32,
}

TEX1D_ARRAY_DSV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_DSV :: struct {
	MipSlice: u32,
}

TEX2D_ARRAY_DSV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2DMS_DSV :: struct {
	UnusedField_NothingToDefine: u32,
}

TEX2DMS_ARRAY_DSV :: struct {
	FirstArraySlice: u32,
	ArraySize:       u32,
}

DSV_FLAGS :: distinct bit_set[DSV_FLAG; u32]
DSV_FLAG :: enum u32 {
	DEPTH   = 0,
	STENCIL = 1,
}

DEPTH_STENCIL_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: DSV_DIMENSION,
	Flags:         DSV_FLAGS,
	using _: struct #raw_union {
		Texture1D:        TEX1D_DSV,
		Texture1DArray:   TEX1D_ARRAY_DSV,
		Texture2D:        TEX2D_DSV,
		Texture2DArray:   TEX2D_ARRAY_DSV,
		Texture2DMS:      TEX2DMS_DSV,
		Texture2DMSArray: TEX2DMS_ARRAY_DSV,
	},
}

CDEPTH_STENCIL_VIEW_DESC :: struct {
	using d3d11_depth_stencil_view_desc: DEPTH_STENCIL_VIEW_DESC,
}


IDepthStencilView_UUID_STRING :: "9FDAC92A-1876-48C3-AFAD-25B94F84A9B6"
IDepthStencilView_UUID := &IID{0x9FDAC92A, 0x1876, 0x48C3, {0xAF, 0xAD, 0x25, 0xB9, 0x4F, 0x84, 0xA9, 0xB6}}
IDepthStencilView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11depthstencilview_vtable: ^IDepthStencilView_VTable,
}
IDepthStencilView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "system" (this: ^IDepthStencilView, pDesc: ^DEPTH_STENCIL_VIEW_DESC),
}


BUFFER_UAV_FLAGS :: distinct bit_set[BUFFER_UAV_FLAG; u32]
BUFFER_UAV_FLAG :: enum u32 {
	RAW     = 0,
	APPEND  = 1,
	COUNTER = 2,
}

BUFFER_UAV :: struct {
	FirstElement: u32,
	NumElements:  u32,
	Flags:        BUFFER_UAV_FLAGS,
}

TEX1D_UAV :: struct {
	MipSlice: u32,
}

TEX1D_ARRAY_UAV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX2D_UAV :: struct {
	MipSlice: u32,
}

TEX2D_ARRAY_UAV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

TEX3D_UAV :: struct {
	MipSlice:    u32,
	FirstWSlice: u32,
	WSize:       u32,
}

UNORDERED_ACCESS_VIEW_DESC :: struct {
	Format:        dxgi.FORMAT,
	ViewDimension: UAV_DIMENSION,
	using _: struct #raw_union {
		Buffer:         BUFFER_UAV,
		Texture1D:      TEX1D_UAV,
		Texture1DArray: TEX1D_ARRAY_UAV,
		Texture2D:      TEX2D_UAV,
		Texture2DArray: TEX2D_ARRAY_UAV,
		Texture3D:      TEX3D_UAV,
	},
}

CUNORDERED_ACCESS_VIEW_DESC :: struct {
	using d3d11_unordered_access_view_desc: UNORDERED_ACCESS_VIEW_DESC,
}


IUnorderedAccessView_UUID_STRING :: "28ACF509-7F5C-48F6-8611-F316010A6380"
IUnorderedAccessView_UUID := &IID{0x28ACF509, 0x7F5C, 0x48F6, {0x86, 0x11, 0xF3, 0x16, 0x01, 0x0A, 0x63, 0x80}}
IUnorderedAccessView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11unorderedaccessview_vtable: ^IUnorderedAccessView_VTable,
}
IUnorderedAccessView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "system" (this: ^IUnorderedAccessView, pDesc: ^UNORDERED_ACCESS_VIEW_DESC),
}



IVertexShader_UUID_STRING :: "3B301D64-D678-4289-8897-22F8928B72F3"
IVertexShader_UUID := &IID{0x3B301D64, 0xD678, 0x4289, {0x88, 0x97, 0x22, 0xF8, 0x92, 0x8B, 0x72, 0xF3}}
IVertexShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IHullShader_UUID_STRING :: "8E5C6061-628A-4C8E-8264-BBE45CB3D5DD"
IHullShader_UUID := &IID{0x8E5C6061, 0x628A, 0x4C8E, {0x82, 0x64, 0xBB, 0xE4, 0x5C, 0xB3, 0xD5, 0xDD}}
IHullShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IDomainShader_UUID_STRING :: "F582C508-0F36-490C-9977-31EECE268CFA"
IDomainShader_UUID := &IID{0xF582C508, 0x0F36, 0x490C, {0x99, 0x77, 0x31, 0xEE, 0xCE, 0x26, 0x8C, 0xFA}}
IDomainShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IGeometryShader_UUID_STRING :: "38325B96-EFFB-4022-BA02-2E795B70275C"
IGeometryShader_UUID := &IID{0x38325B96, 0xEFFB, 0x4022, {0xBA, 0x02, 0x2E, 0x79, 0x5B, 0x70, 0x27, 0x5C}}
IGeometryShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IPixelShader_UUID_STRING :: "EA82E40D-51DC-4F33-93D4-DB7C9125AE8C"
IPixelShader_UUID := &IID{0xEA82E40D, 0x51DC, 0x4F33, {0x93, 0xD4, 0xDB, 0x7C, 0x91, 0x25, 0xAE, 0x8C}}
IPixelShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IComputeShader_UUID_STRING :: "4F5B196E-C2BD-495E-BD01-1FDED38E4969"
IComputeShader_UUID := &IID{0x4F5B196E, 0xC2BD, 0x495E, {0xBD, 0x01, 0x1F, 0xDE, 0xD3, 0x8E, 0x49, 0x69}}
IComputeShader :: struct {
	using id3d11devicechild: IDeviceChild,
}


IInputLayout_UUID_STRING :: "E4819DDC-4CF0-4025-BD26-5DE82A3E07B7"
IInputLayout_UUID := &IID{0xE4819DDC, 0x4CF0, 0x4025, {0xBD, 0x26, 0x5D, 0xE8, 0x2A, 0x3E, 0x07, 0xB7}}
IInputLayout :: struct {
	using id3d11devicechild: IDeviceChild,
}

FILTER :: enum i32 {
	MIN_MAG_MIP_POINT                          = 0,
	MIN_MAG_POINT_MIP_LINEAR                   = 1,
	MIN_POINT_MAG_LINEAR_MIP_POINT             = 4,
	MIN_POINT_MAG_MIP_LINEAR                   = 5,
	MIN_LINEAR_MAG_MIP_POINT                   = 16,
	MIN_LINEAR_MAG_POINT_MIP_LINEAR            = 17,
	MIN_MAG_LINEAR_MIP_POINT                   = 20,
	MIN_MAG_MIP_LINEAR                         = 21,
	ANISOTROPIC                                = 85,
	COMPARISON_MIN_MAG_MIP_POINT               = 128,
	COMPARISON_MIN_MAG_POINT_MIP_LINEAR        = 129,
	COMPARISON_MIN_POINT_MAG_LINEAR_MIP_POINT  = 132,
	COMPARISON_MIN_POINT_MAG_MIP_LINEAR        = 133,
	COMPARISON_MIN_LINEAR_MAG_MIP_POINT        = 144,
	COMPARISON_MIN_LINEAR_MAG_POINT_MIP_LINEAR = 145,
	COMPARISON_MIN_MAG_LINEAR_MIP_POINT        = 148,
	COMPARISON_MIN_MAG_MIP_LINEAR              = 149,
	COMPARISON_ANISOTROPIC                     = 213,
	MINIMUM_MIN_MAG_MIP_POINT                  = 256,
	MINIMUM_MIN_MAG_POINT_MIP_LINEAR           = 257,
	MINIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT     = 260,
	MINIMUM_MIN_POINT_MAG_MIP_LINEAR           = 261,
	MINIMUM_MIN_LINEAR_MAG_MIP_POINT           = 272,
	MINIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR    = 273,
	MINIMUM_MIN_MAG_LINEAR_MIP_POINT           = 276,
	MINIMUM_MIN_MAG_MIP_LINEAR                 = 277,
	MINIMUM_ANISOTROPIC                        = 341,
	MAXIMUM_MIN_MAG_MIP_POINT                  = 384,
	MAXIMUM_MIN_MAG_POINT_MIP_LINEAR           = 385,
	MAXIMUM_MIN_POINT_MAG_LINEAR_MIP_POINT     = 388,
	MAXIMUM_MIN_POINT_MAG_MIP_LINEAR           = 389,
	MAXIMUM_MIN_LINEAR_MAG_MIP_POINT           = 400,
	MAXIMUM_MIN_LINEAR_MAG_POINT_MIP_LINEAR    = 401,
	MAXIMUM_MIN_MAG_LINEAR_MIP_POINT           = 404,
	MAXIMUM_MIN_MAG_MIP_LINEAR                 = 405,
	MAXIMUM_ANISOTROPIC                        = 469,
}

FILTER_TYPE :: enum i32 {
	POINT  = 0,
	LINEAR = 1,
}

FILTER_REDUCTION_TYPE :: enum i32 {
	STANDARD   = 0,
	COMPARISON = 1,
	MINIMUM    = 2,
	MAXIMUM    = 3,
}

TEXTURE_ADDRESS_MODE :: enum i32 {
	WRAP        = 1,
	MIRROR      = 2,
	CLAMP       = 3,
	BORDER      = 4,
	MIRROR_ONCE = 5,
}

SAMPLER_DESC :: struct {
	Filter:         FILTER,
	AddressU:       TEXTURE_ADDRESS_MODE,
	AddressV:       TEXTURE_ADDRESS_MODE,
	AddressW:       TEXTURE_ADDRESS_MODE,
	MipLODBias:     f32,
	MaxAnisotropy:  u32,
	ComparisonFunc: COMPARISON_FUNC,
	BorderColor:    [4]f32,
	MinLOD:         f32,
	MaxLOD:         f32,
}

CSAMPLER_DESC :: struct {
	using d3d11_sampler_desc: SAMPLER_DESC,
}


ISamplerState_UUID_STRING :: "DA6FEA51-564C-4487-9810-F0D0F9B4E3A5"
ISamplerState_UUID := &IID{0xDA6FEA51, 0x564C, 0x4487, {0x98, 0x10, 0xF0, 0xD0, 0xF9, 0xB4, 0xE3, 0xA5}}
ISamplerState :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11samplerstate_vtable: ^ISamplerState_VTable,
}
ISamplerState_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDesc: proc "system" (this: ^ISamplerState, pDesc: ^SAMPLER_DESC),
}


FORMAT_SUPPORT :: enum i32 { // TODO: make bit_set
	BUFFER                      = 1,
	IA_VERTEX_BUFFER            = 2,
	IA_INDEX_BUFFER             = 4,
	SO_BUFFER                   = 8,
	TEXTURE1D                   = 16,
	TEXTURE2D                   = 32,
	TEXTURE3D                   = 64,
	TEXTURECUBE                 = 128,
	SHADER_LOAD                 = 256,
	SHADER_SAMPLE               = 512,
	SHADER_SAMPLE_COMPARISON    = 1024,
	SHADER_SAMPLE_MONO_TEXT     = 2048,
	MIP                         = 4096,
	MIP_AUTOGEN                 = 8192,
	RENDER_TARGET               = 16384,
	BLENDABLE                   = 32768,
	DEPTH_STENCIL               = 65536,
	CPU_LOCKABLE                = 131072,
	MULTISAMPLE_RESOLVE         = 262144,
	DISPLAY                     = 524288,
	CAST_WITHIN_BIT_LAYOUT      = 1048576,
	MULTISAMPLE_RENDERTARGET    = 2097152,
	MULTISAMPLE_LOAD            = 4194304,
	SHADER_GATHER               = 8388608,
	BACK_BUFFER_CAST            = 16777216,
	TYPED_UNORDERED_ACCESS_VIEW = 33554432,
	SHADER_GATHER_COMPARISON    = 67108864,
	DECODER_OUTPUT              = 134217728,
	VIDEO_PROCESSOR_OUTPUT      = 268435456,
	VIDEO_PROCESSOR_INPUT       = 536870912,
	VIDEO_ENCODER               = 1073741824,
}

FORMAT_SUPPORT2 :: enum i32 { // TODO: make bit_set
	UAV_ATOMIC_ADD                               = 1,
	UAV_ATOMIC_BITWISE_OPS                       = 2,
	UAV_ATOMIC_COMPARE_STORE_OR_COMPARE_EXCHANGE = 4,
	UAV_ATOMIC_EXCHANGE                          = 8,
	UAV_ATOMIC_SIGNED_MIN_OR_MAX                 = 16,
	UAV_ATOMIC_UNSIGNED_MIN_OR_MAX               = 32,
	UAV_TYPED_LOAD                               = 64,
	UAV_TYPED_STORE                              = 128,
	OUTPUT_MERGER_LOGIC_OP                       = 256,
	TILED                                        = 512,
	SHAREABLE                                    = 1024,
	MULTIPLANE_OVERLAY                           = 16384,
}


IAsynchronous_UUID_STRING :: "4B35D0CD-1E15-4258-9C98-1B1333F6DD3B"
IAsynchronous_UUID := &IID{0x4B35D0CD, 0x1E15, 0x4258, {0x9C, 0x98, 0x1B, 0x13, 0x33, 0xF6, 0xDD, 0x3B}}
IAsynchronous :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11asynchronous_vtable: ^IAsynchronous_VTable,
}
IAsynchronous_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDataSize: proc "system" (this: ^IAsynchronous) -> u32,
}


ASYNC_GETDATA_FLAGS :: distinct bit_set[ASYNC_GETDATA_FLAG; u32]
ASYNC_GETDATA_FLAG :: enum u32 {
	DONOTFLUSH = 0,
}

QUERY :: enum i32 {
	EVENT                         = 0,
	OCCLUSION                     = 1,
	TIMESTAMP                     = 2,
	TIMESTAMP_DISJOINT            = 3,
	PIPELINE_STATISTICS           = 4,
	OCCLUSION_PREDICATE           = 5,
	SO_STATISTICS                 = 6,
	SO_OVERFLOW_PREDICATE         = 7,
	SO_STATISTICS_STREAM0         = 8,
	SO_OVERFLOW_PREDICATE_STREAM0 = 9,
	SO_STATISTICS_STREAM1         = 10,
	SO_OVERFLOW_PREDICATE_STREAM1 = 11,
	SO_STATISTICS_STREAM2         = 12,
	SO_OVERFLOW_PREDICATE_STREAM2 = 13,
	SO_STATISTICS_STREAM3         = 14,
	SO_OVERFLOW_PREDICATE_STREAM3 = 15,
}

QUERY_MISC_FLAGS :: distinct bit_set[QUERY_MISC_FLAG; u32]
QUERY_MISC_FLAG :: enum u32 {
	PREDICATEHINT = 0,
}

QUERY_DESC :: struct {
	Query:     QUERY,
	MiscFlags: QUERY_MISC_FLAGS,
}

CQUERY_DESC :: struct {
	using d3d11_query_desc: QUERY_DESC,
}


IQuery_UUID_STRING :: "D6C00747-87B7-425E-B84D-44D108560AFD"
IQuery_UUID := &IID{0xD6C00747, 0x87B7, 0x425E, {0xB8, 0x4D, 0x44, 0xD1, 0x08, 0x56, 0x0A, 0xFD}}
IQuery :: struct #raw_union {
	#subtype id3d11asynchronous: IAsynchronous,
	using id3d11query_vtable: ^IQuery_VTable,
}
IQuery_VTable :: struct {
	using id3d11asynchronous_vtable: IAsynchronous_VTable,
	GetDesc: proc "system" (this: ^IQuery, pDesc: ^QUERY_DESC),
}



IPredicate_UUID_STRING :: "9EB576DD-9F77-4D86-81AA-8BAB5FE490E2"
IPredicate_UUID := &IID{0x9EB576DD, 0x9F77, 0x4D86, {0x81, 0xAA, 0x8B, 0xAB, 0x5F, 0xE4, 0x90, 0xE2}}
IPredicate :: struct {
	using id3d11query: IQuery,
}

QUERY_DATA_TIMESTAMP_DISJOINT :: struct {
	Frequency: u64,
	Disjoint:  BOOL,
}

QUERY_DATA_PIPELINE_STATISTICS :: struct {
	IAVertices:    u64,
	IAPrimitives:  u64,
	VSInvocations: u64,
	GSInvocations: u64,
	GSPrimitives:  u64,
	CInvocations:  u64,
	CPrimitives:   u64,
	PSInvocations: u64,
	HSInvocations: u64,
	DSInvocations: u64,
	CSInvocations: u64,
}

QUERY_DATA_SO_STATISTICS :: struct {
	NumPrimitivesWritten:    u64,
	PrimitivesStorageNeeded: u64,
}

COUNTER :: enum i32 {
	DEVICE_DEPENDENT_0 = 1073741824,
}

COUNTER_TYPE :: enum i32 {
	FLOAT32 = 0,
	UINT16  = 1,
	UINT32  = 2,
	UINT64  = 3,
}

COUNTER_DESC :: struct {
	Counter:   COUNTER,
	MiscFlags: RESOURCE_MISC_FLAGS,
}

CCOUNTER_DESC :: struct {
	using d3d11_counter_desc: COUNTER_DESC,
}

COUNTER_INFO :: struct {
	LastDeviceDependentCounter: COUNTER,
	NumSimultaneousCounters:    u32,
	NumDetectableParallelUnits: u8,
}


ICounter_UUID_STRING :: "6E8C49FB-A371-4770-B440-29086022B741"
ICounter_UUID := &IID{0x6E8C49FB, 0xA371, 0x4770, {0xB4, 0x40, 0x29, 0x08, 0x60, 0x22, 0xB7, 0x41}}
ICounter :: struct #raw_union {
	#subtype id3d11asynchronous: IAsynchronous,
	using id3d11counter_vtable: ^ICounter_VTable,
}
ICounter_VTable :: struct {
	using id3d11asynchronous_vtable: IAsynchronous_VTable,
	GetDesc: proc "system" (this: ^ICounter, pDesc: ^COUNTER_DESC),
}


STANDARD_MULTISAMPLE_QUALITY_LEVELS :: enum i32 {
	STANDARD_MULTISAMPLE_PATTERN = -1,
	CENTER_MULTISAMPLE_PATTERN   = -2,
}

DEVICE_CONTEXT_TYPE :: enum i32 {
	IMMEDIATE = 0,
	DEFERRED  = 1,
}

CLASS_INSTANCE_DESC :: struct {
	InstanceId:               u32,
	InstanceIndex:            u32,
	TypeId:                   u32,
	ConstantBuffer:           u32,
	BaseConstantBufferOffset: u32,
	BaseTexture:              u32,
	BaseSampler:              u32,
	Created:                  BOOL,
}


IClassInstance_UUID_STRING :: "A6CD7FAA-B0B7-4A2F-9436-8662A65797CB"
IClassInstance_UUID := &IID{0xA6CD7FAA, 0xB0B7, 0x4A2F, {0x94, 0x36, 0x86, 0x62, 0xA6, 0x57, 0x97, 0xCB}}
IClassInstance :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11classinstance_vtable: ^IClassInstance_VTable,
}
IClassInstance_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetClassLinkage: proc "system" (this: ^IClassInstance, ppLinkage: ^^IClassLinkage),
	GetDesc:         proc "system" (this: ^IClassInstance, pDesc: ^CLASS_INSTANCE_DESC),
	GetInstanceName: proc "system" (this: ^IClassInstance, pInstanceName: cstring, pBufferLength: ^SIZE_T),
	GetTypeName:     proc "system" (this: ^IClassInstance, pTypeName: cstring, pBufferLength: ^SIZE_T),
}



IClassLinkage_UUID_STRING :: "DDF57CBA-9543-46E4-A12B-F207A0FE7FED"
IClassLinkage_UUID := &IID{0xDDF57CBA, 0x9543, 0x46E4, {0xA1, 0x2B, 0xF2, 0x07, 0xA0, 0xFE, 0x7F, 0xED}}
IClassLinkage :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11classlinkage_vtable: ^IClassLinkage_VTable,
}
IClassLinkage_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetClassInstance:    proc "system" (this: ^IClassLinkage, pClassInstanceName: cstring, InstanceIndex: u32, ppInstance: ^^IClassInstance) -> HRESULT,
	CreateClassInstance: proc "system" (this: ^IClassLinkage, pClassTypeName: cstring, ConstantBufferOffset: u32, ConstantVectorOffset: u32, TextureOffset: u32, SamplerOffset: u32, ppInstance: ^^IClassInstance) -> HRESULT,
}



ICommandList_UUID_STRING :: "A24BC4D1-769E-43F7-8013-98FF566C18E2"
ICommandList_UUID := &IID{0xA24BC4D1, 0x769E, 0x43F7, {0x80, 0x13, 0x98, 0xFF, 0x56, 0x6C, 0x18, 0xE2}}
ICommandList :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11commandlist_vtable: ^ICommandList_VTable,
}
ICommandList_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetContextFlags: proc "system" (this: ^ICommandList) -> u32,
}


FEATURE :: enum i32 {
	THREADING                      = 0,
	DOUBLES                        = 1,
	FORMAT_SUPPORT                 = 2,
	FORMAT_SUPPORT2                = 3,
	D3D10_X_HARDWARE_OPTIONS       = 4,
	OPTIONS                        = 5,
	ARCHITECTURE_INFO              = 6,
	D3D9_OPTIONS                   = 7,
	SHADER_MIN_PRECISION_SUPPORT   = 8,
	D3D9_SHADOW_SUPPORT            = 9,
	OPTIONS1                       = 10,
	D3D9_SIMPLE_INSTANCING_SUPPORT = 11,
	MARKER_SUPPORT                 = 12,
	D3D9_OPTIONS1                  = 13,
	OPTIONS2                       = 14,
	OPTIONS3                       = 15,
	GPU_VIRTUAL_ADDRESS_SUPPORT    = 16,
	OPTIONS4                       = 17,
	SHADER_CACHE                   = 18,
	OPTIONS5                       = 19,
}

FEATURE_DATA_THREADING :: struct {
	DriverConcurrentCreates: BOOL,
	DriverCommandLists:      BOOL,
}

FEATURE_DATA_DOUBLES :: struct {
	DoublePrecisionFloatShaderOps: BOOL,
}

FEATURE_DATA_FORMAT_SUPPORT :: struct {
	InFormat:         dxgi.FORMAT,
	OutFormatSupport: u32,
}

FEATURE_DATA_FORMAT_SUPPORT2 :: struct {
	InFormat:          dxgi.FORMAT,
	OutFormatSupport2: u32,
}

FEATURE_DATA_D3D10_X_HARDWARE_OPTIONS :: struct {
	ComputeShaders_Plus_RawAndStructuredBuffers_Via_Shader_4_x: BOOL,
}

FEATURE_DATA_OPTIONS :: struct {
	OutputMergerLogicOp:                    BOOL,
	UAVOnlyRenderingForcedSampleCount:      BOOL,
	DiscardAPIsSeenByDriver:                BOOL,
	FlagsForUpdateAndCopySeenByDriver:      BOOL,
	ClearView:                              BOOL,
	CopyWithOverlap:                        BOOL,
	ConstantBufferPartialUpdate:            BOOL,
	ConstantBufferOffsetting:               BOOL,
	MapNoOverwriteOnDynamicConstantBuffer:  BOOL,
	MapNoOverwriteOnDynamicBufferSRV:       BOOL,
	MultisampleRTVWithForcedSampleCountOne: BOOL,
	SAD4ShaderInstructions:                 BOOL,
	ExtendedDoublesShaderInstructions:      BOOL,
	ExtendedResourceSharing:                BOOL,
}

FEATURE_DATA_ARCHITECTURE_INFO :: struct {
	TileBasedDeferredRenderer: BOOL,
}

FEATURE_DATA_D3D9_OPTIONS :: struct {
	FullNonPow2TextureSupport: BOOL,
}

FEATURE_DATA_D3D9_SHADOW_SUPPORT :: struct {
	SupportsDepthAsTextureWithLessEqualComparisonFilter: BOOL,
}

SHADER_MIN_PRECISION_SUPPORT :: enum i32 {
	_10_BIT = 1,
	_16_BIT = 2,
}

FEATURE_DATA_SHADER_MIN_PRECISION_SUPPORT :: struct {
	PixelShaderMinPrecision:          u32,
	AllOtherShaderStagesMinPrecision: u32,
}

TILED_RESOURCES_TIER :: enum i32 {
	TILED_RESOURCES_NOT_SUPPORTED = 0,
	_1                                  = 1,
	_2                                  = 2,
	_3                                  = 3,
}

FEATURE_DATA_OPTIONS1 :: struct {
	TiledResourcesTier:                    TILED_RESOURCES_TIER,
	MinMaxFiltering:                       BOOL,
	ClearViewAlsoSupportsDepthOnlyFormats: BOOL,
	MapOnDefaultBuffers:                   BOOL,
}

FEATURE_DATA_D3D9_SIMPLE_INSTANCING_SUPPORT :: struct {
	SimpleInstancingSupported: BOOL,
}

FEATURE_DATA_MARKER_SUPPORT :: struct {
	Profile: BOOL,
}

FEATURE_DATA_D3D9_OPTIONS1 :: struct {
	FullNonPow2TextureSupported:                                 BOOL,
	DepthAsTextureWithLessEqualComparisonFilterSupported:        BOOL,
	SimpleInstancingSupported:                                   BOOL,
	TextureCubeFaceRenderTargetWithNonCubeDepthStencilSupported: BOOL,
}

CONSERVATIVE_RASTERIZATION_TIER :: enum i32 {
	CONSERVATIVE_RASTERIZATION_NOT_SUPPORTED = 0,
	_1                                             = 1,
	_2                                             = 2,
	_3                                             = 3,
}

FEATURE_DATA_OPTIONS2 :: struct {
	PSSpecifiedStencilRefSupported: BOOL,
	TypedUAVLoadAdditionalFormats:  BOOL,
	ROVsSupported:                  BOOL,
	ConservativeRasterizationTier:  CONSERVATIVE_RASTERIZATION_TIER,
	TiledResourcesTier:             TILED_RESOURCES_TIER,
	MapOnDefaultTextures:           BOOL,
	StandardSwizzle:                BOOL,
	UnifiedMemoryArchitecture:      BOOL,
}

FEATURE_DATA_OPTIONS3 :: struct {
	VPAndRTArrayIndexFromAnyShaderFeedingRasterizer: BOOL,
}

FEATURE_DATA_GPU_VIRTUAL_ADDRESS_SUPPORT :: struct {
	MaxGPUVirtualAddressBitsPerResource: u32,
	MaxGPUVirtualAddressBitsPerProcess:  u32,
}

SHADER_CACHE_SUPPORT_FLAGS :: distinct bit_set[SHADER_CACHE_SUPPORT_FLAG; u32]
SHADER_CACHE_SUPPORT_FLAG :: enum u32 {
	AUTOMATIC_INPROC_CACHE = 0,
	AUTOMATIC_DISK_CACHE   = 1,
}

FEATURE_DATA_SHADER_CACHE :: struct {
	SupportFlags: SHADER_CACHE_SUPPORT_FLAGS,
}

SHARED_RESOURCE_TIER :: enum i32 {
	_0 = 0,
	_1 = 1,
	_2 = 2,
	_3 = 3,
}

FEATURE_DATA_OPTIONS5 :: struct {
	SharedResourceTier: SHARED_RESOURCE_TIER,
}


IDeviceContext_UUID_STRING :: "C0BFA96C-E089-44FB-8EAF-26F8796190DA"
IDeviceContext_UUID := &IID{0xC0BFA96C, 0xE089, 0x44FB, {0x8E, 0xAF, 0x26, 0xF8, 0x79, 0x61, 0x90, 0xDA}}
IDeviceContext :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11devicecontext_vtable: ^IDeviceContext_VTable,
}
IDeviceContext_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	VSSetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	PSSetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	PSSetShader:                               proc "system" (this: ^IDeviceContext, pPixelShader: ^IPixelShader, ppClassInstances: [^]^IClassInstance, NumClassInstances: u32),
	PSSetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	VSSetShader:                               proc "system" (this: ^IDeviceContext, pVertexShader: ^IVertexShader, ppClassInstances: [^]^IClassInstance, NumClassInstances: u32),
	DrawIndexed:                               proc "system" (this: ^IDeviceContext, IndexCount: u32, StartIndexLocation: u32, BaseVertexLocation: i32),
	Draw:                                      proc "system" (this: ^IDeviceContext, VertexCount: u32, StartVertexLocation: u32),
	Map:                                       proc "system" (this: ^IDeviceContext, pResource: ^IResource, Subresource: u32, MapType: MAP, MapFlags: MAP_FLAGS, pMappedResource: ^MAPPED_SUBRESOURCE) -> HRESULT,
	Unmap:                                     proc "system" (this: ^IDeviceContext, pResource: ^IResource, Subresource: u32),
	PSSetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	IASetInputLayout:                          proc "system" (this: ^IDeviceContext, pInputLayout: ^IInputLayout),
	IASetVertexBuffers:                        proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppVertexBuffers: [^]^IBuffer, pStrides: [^]u32, pOffsets: [^]u32),
	IASetIndexBuffer:                          proc "system" (this: ^IDeviceContext, pIndexBuffer: ^IBuffer, Format: dxgi.FORMAT, Offset: u32),
	DrawIndexedInstanced:                      proc "system" (this: ^IDeviceContext, IndexCountPerInstance: u32, InstanceCount: u32, StartIndexLocation: u32, BaseVertexLocation: i32, StartInstanceLocation: u32),
	DrawInstanced:                             proc "system" (this: ^IDeviceContext, VertexCountPerInstance: u32, InstanceCount: u32, StartVertexLocation: u32, StartInstanceLocation: u32),
	GSSetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	GSSetShader:                               proc "system" (this: ^IDeviceContext, pShader: ^IGeometryShader, ppClassInstances: [^]^IClassInstance, NumClassInstances: u32),
	IASetPrimitiveTopology:                    proc "system" (this: ^IDeviceContext, Topology: PRIMITIVE_TOPOLOGY),
	VSSetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	VSSetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	Begin:                                     proc "system" (this: ^IDeviceContext, pAsync: ^IAsynchronous),
	End:                                       proc "system" (this: ^IDeviceContext, pAsync: ^IAsynchronous),
	GetData:                                   proc "system" (this: ^IDeviceContext, pAsync: ^IAsynchronous, pData: rawptr, DataSize: u32, GetDataFlags: u32) -> HRESULT,
	SetPredication:                            proc "system" (this: ^IDeviceContext, pPredicate: ^IPredicate, PredicateValue: BOOL),
	GSSetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	GSSetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	OMSetRenderTargets:                        proc "system" (this: ^IDeviceContext, NumViews: u32, ppRenderTargetViews: [^]^IRenderTargetView, pDepthStencilView: ^IDepthStencilView),
	OMSetRenderTargetsAndUnorderedAccessViews: proc "system" (this: ^IDeviceContext, NumRTVs: u32, ppRenderTargetViews: [^]^IRenderTargetView, pDepthStencilView: ^IDepthStencilView, UAVStartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: [^]^IUnorderedAccessView, pUAVInitialCounts: [^]u32),
	OMSetBlendState:                           proc "system" (this: ^IDeviceContext, pBlendState: ^IBlendState, BlendFactor: ^[4]f32, SampleMask: u32),
	OMSetDepthStencilState:                    proc "system" (this: ^IDeviceContext, pDepthStencilState: ^IDepthStencilState, StencilRef: u32),
	SOSetTargets:                              proc "system" (this: ^IDeviceContext, NumBuffers: u32, ppSOTargets: [^]^IBuffer, pOffsets: [^]u32),
	DrawAuto:                                  proc "system" (this: ^IDeviceContext),
	DrawIndexedInstancedIndirect:              proc "system" (this: ^IDeviceContext, pBufferForArgs: ^IBuffer, AlignedByteOffsetForArgs: u32),
	DrawInstancedIndirect:                     proc "system" (this: ^IDeviceContext, pBufferForArgs: ^IBuffer, AlignedByteOffsetForArgs: u32),
	Dispatch:                                  proc "system" (this: ^IDeviceContext, ThreadGroupCountX: u32, ThreadGroupCountY: u32, ThreadGroupCountZ: u32),
	DispatchIndirect:                          proc "system" (this: ^IDeviceContext, pBufferForArgs: ^IBuffer, AlignedByteOffsetForArgs: u32),
	RSSetState:                                proc "system" (this: ^IDeviceContext, pRasterizerState: ^IRasterizerState),
	RSSetViewports:                            proc "system" (this: ^IDeviceContext, NumViewports: u32, pViewports: [^]VIEWPORT),
	RSSetScissorRects:                         proc "system" (this: ^IDeviceContext, NumRects: u32, pRects: [^]RECT),
	CopySubresourceRegion:                     proc "system" (this: ^IDeviceContext, pDstResource: ^IResource, DstSubresource: u32, DstX: u32, DstY: u32, DstZ: u32, pSrcResource: ^IResource, SrcSubresource: u32, pSrcBox: ^BOX),
	CopyResource:                              proc "system" (this: ^IDeviceContext, pDstResource: ^IResource, pSrcResource: ^IResource),
	UpdateSubresource:                         proc "system" (this: ^IDeviceContext, pDstResource: ^IResource, DstSubresource: u32, pDstBox: ^BOX, pSrcData: rawptr, SrcRowPitch: u32, SrcDepthPitch: u32),
	CopyStructureCount:                        proc "system" (this: ^IDeviceContext, pDstBuffer: ^IBuffer, DstAlignedByteOffset: u32, pSrcView: ^IUnorderedAccessView),
	ClearRenderTargetView:                     proc "system" (this: ^IDeviceContext, pRenderTargetView: ^IRenderTargetView, ColorRGBA: ^[4]f32),
	ClearUnorderedAccessViewUint:              proc "system" (this: ^IDeviceContext, pUnorderedAccessView: ^IUnorderedAccessView, Values: ^[4]u32),
	ClearUnorderedAccessViewFloat:             proc "system" (this: ^IDeviceContext, pUnorderedAccessView: ^IUnorderedAccessView, Values: ^[4]f32),
	ClearDepthStencilView:                     proc "system" (this: ^IDeviceContext, pDepthStencilView: ^IDepthStencilView, ClearFlags: CLEAR_FLAGS, Depth: f32, Stencil: u8),
	GenerateMips:                              proc "system" (this: ^IDeviceContext, pShaderResourceView: ^IShaderResourceView),
	SetResourceMinLOD:                         proc "system" (this: ^IDeviceContext, pResource: ^IResource, MinLOD: f32),
	GetResourceMinLOD:                         proc "system" (this: ^IDeviceContext, pResource: ^IResource) -> f32,
	ResolveSubresource:                        proc "system" (this: ^IDeviceContext, pDstResource: ^IResource, DstSubresource: u32, pSrcResource: ^IResource, SrcSubresource: u32, Format: dxgi.FORMAT),
	ExecuteCommandList:                        proc "system" (this: ^IDeviceContext, pCommandList: ^ICommandList, RestoreContextState: BOOL),
	HSSetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	HSSetShader:                               proc "system" (this: ^IDeviceContext, pHullShader: ^IHullShader, ppClassInstances: [^]^IClassInstance, NumClassInstances: u32),
	HSSetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	HSSetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	DSSetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	DSSetShader:                               proc "system" (this: ^IDeviceContext, pDomainShader: ^IDomainShader, ppClassInstances: [^]^IClassInstance, NumClassInstances: u32),
	DSSetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	DSSetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	CSSetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	CSSetUnorderedAccessViews:                 proc "system" (this: ^IDeviceContext, StartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: [^]^IUnorderedAccessView, pUAVInitialCounts: [^]u32),
	CSSetShader:                               proc "system" (this: ^IDeviceContext, pComputeShader: ^IComputeShader, ppClassInstances: [^]^IClassInstance, NumClassInstances: u32),
	CSSetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	CSSetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	VSGetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	PSGetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	PSGetShader:                               proc "system" (this: ^IDeviceContext, ppPixelShader: ^^IPixelShader, ppClassInstances: [^]^IClassInstance, pNumClassInstances: ^u32),
	PSGetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	VSGetShader:                               proc "system" (this: ^IDeviceContext, ppVertexShader: ^^IVertexShader, ppClassInstances: [^]^IClassInstance, pNumClassInstances: ^u32),
	PSGetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	IAGetInputLayout:                          proc "system" (this: ^IDeviceContext, ppInputLayout: ^^IInputLayout),
	IAGetVertexBuffers:                        proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppVertexBuffers: [^]^IBuffer, pStrides: [^]u32, pOffsets: [^]u32),
	IAGetIndexBuffer:                          proc "system" (this: ^IDeviceContext, pIndexBuffer: ^^IBuffer, Format: ^dxgi.FORMAT, Offset: ^u32),
	GSGetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	GSGetShader:                               proc "system" (this: ^IDeviceContext, ppGeometryShader: ^^IGeometryShader, ppClassInstances: [^]^IClassInstance, pNumClassInstances: ^u32),
	IAGetPrimitiveTopology:                    proc "system" (this: ^IDeviceContext, pTopology: ^PRIMITIVE_TOPOLOGY),
	VSGetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	VSGetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	GetPredication:                            proc "system" (this: ^IDeviceContext, ppPredicate: ^^IPredicate, pPredicateValue: ^BOOL),
	GSGetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	GSGetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	OMGetRenderTargets:                        proc "system" (this: ^IDeviceContext, NumViews: u32, ppRenderTargetViews: [^]^IRenderTargetView, ppDepthStencilView: ^^IDepthStencilView),
	OMGetRenderTargetsAndUnorderedAccessViews: proc "system" (this: ^IDeviceContext, NumRTVs: u32, ppRenderTargetViews: [^]^IRenderTargetView, ppDepthStencilView: ^^IDepthStencilView, UAVStartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: [^]^IUnorderedAccessView),
	OMGetBlendState:                           proc "system" (this: ^IDeviceContext, ppBlendState: ^^IBlendState, BlendFactor: ^[4]f32, pSampleMask: ^COLOR_WRITE_ENABLE_MASK),
	OMGetDepthStencilState:                    proc "system" (this: ^IDeviceContext, ppDepthStencilState: ^^IDepthStencilState, pStencilRef: ^u32),
	SOGetTargets:                              proc "system" (this: ^IDeviceContext, NumBuffers: u32, ppSOTargets: [^]^IBuffer),
	RSGetState:                                proc "system" (this: ^IDeviceContext, ppRasterizerState: ^^IRasterizerState),
	RSGetViewports:                            proc "system" (this: ^IDeviceContext, pNumViewports: ^u32, pViewports: [^]VIEWPORT),
	RSGetScissorRects:                         proc "system" (this: ^IDeviceContext, pNumRects: ^u32, pRects: [^]RECT),
	HSGetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	HSGetShader:                               proc "system" (this: ^IDeviceContext, ppHullShader: ^^IHullShader, ppClassInstances: [^]^IClassInstance, pNumClassInstances: ^u32),
	HSGetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	HSGetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	DSGetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	DSGetShader:                               proc "system" (this: ^IDeviceContext, ppDomainShader: ^^IDomainShader, ppClassInstances: [^]^IClassInstance, pNumClassInstances: ^u32),
	DSGetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	DSGetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	CSGetShaderResources:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumViews: u32, ppShaderResourceViews: [^]^IShaderResourceView),
	CSGetUnorderedAccessViews:                 proc "system" (this: ^IDeviceContext, StartSlot: u32, NumUAVs: u32, ppUnorderedAccessViews: [^]^IUnorderedAccessView),
	CSGetShader:                               proc "system" (this: ^IDeviceContext, ppComputeShader: ^^IComputeShader, ppClassInstances: [^]^IClassInstance, pNumClassInstances: ^u32),
	CSGetSamplers:                             proc "system" (this: ^IDeviceContext, StartSlot: u32, NumSamplers: u32, ppSamplers: [^]^ISamplerState),
	CSGetConstantBuffers:                      proc "system" (this: ^IDeviceContext, StartSlot: u32, NumBuffers: u32, ppConstantBuffers: [^]^IBuffer),
	ClearState:                                proc "system" (this: ^IDeviceContext),
	Flush:                                     proc "system" (this: ^IDeviceContext),
	GetType:                                   proc "system" (this: ^IDeviceContext) -> DEVICE_CONTEXT_TYPE,
	GetContextFlags:                           proc "system" (this: ^IDeviceContext) -> u32,
	FinishCommandList:                         proc "system" (this: ^IDeviceContext, RestoreDeferredContextState: BOOL, ppCommandList: ^^ICommandList) -> HRESULT,
}


CVIDEO_DEFAULT :: struct {
	_: u8,
}

APP_DEPRECATED_HRESULT :: HRESULT


VIDEO_DECODER_DESC :: struct {
	Guid:         GUID,
	SampleWidth:  u32,
	SampleHeight: u32,
	OutputFormat: dxgi.FORMAT,
}

VIDEO_DECODER_CONFIG :: struct {
	guidConfigBitstreamEncryption:  GUID,
	guidConfigMBcontrolEncryption:  GUID,
	guidConfigResidDiffEncryption:  GUID,
	ConfigBitstreamRaw:             u32,
	ConfigMBcontrolRasterOrder:     u32,
	ConfigResidDiffHost:            u32,
	ConfigSpatialResid8:            u32,
	ConfigResid8Subtraction:        u32,
	ConfigSpatialHost8or9Clipping:  u32,
	ConfigSpatialResidInterleaved:  u32,
	ConfigIntraResidUnsigned:       u32,
	ConfigResidDiffAccelerator:     u32,
	ConfigHostInverseScan:          u32,
	ConfigSpecificIDCT:             u32,
	Config4GroupedCoefs:            u32,
	ConfigMinRenderTargetBuffCount: u16,
	ConfigDecoderSpecific:          u16,
}

VIDEO_DECODER_BUFFER_TYPE :: enum i32 {
	PICTURE_PARAMETERS          = 0,
	MACROBLOCK_CONTROL          = 1,
	RESIDUAL_DIFFERENCE         = 2,
	DEBLOCKING_CONTROL          = 3,
	INVERSE_QUANTIZATION_MATRIX = 4,
	SLICE_CONTROL               = 5,
	BITSTREAM                   = 6,
	MOTION_VECTOR               = 7,
	FILM_GRAIN                  = 8,
}

AES_CTR_IV :: struct {
	IV:    u64,
	Count: u64,
}

ENCRYPTED_BLOCK_INFO :: struct {
	NumEncryptedBytesAtBeginning: u32,
	NumBytesInSkipPattern:        u32,
	NumBytesInEncryptPattern:     u32,
}

VIDEO_DECODER_BUFFER_DESC :: struct {
	BufferType:         VIDEO_DECODER_BUFFER_TYPE,
	BufferIndex:        u32,
	DataOffset:         u32,
	DataSize:           u32,
	FirstMBaddress:     u32,
	NumMBsInBuffer:     u32,
	Width:              u32,
	Height:             u32,
	Stride:             u32,
	ReservedBits:       u32,

	pIV:                rawptr,
	IVSize:             u32,
	PartialEncryption:  BOOL,
	EncryptedBlockInfo: ENCRYPTED_BLOCK_INFO,
}

VIDEO_DECODER_EXTENSION :: struct {
	Function:              u32,

	pPrivateInputData:     rawptr,
	PrivateInputDataSize:  u32,

	pPrivateOutputData:    rawptr,
	PrivateOutputDataSize: u32,
	ResourceCount:         u32,

	ppResourceList:        ^^IResource,
}


IVideoDecoder_UUID_STRING :: "3C9C5B51-995D-48D1-9B8D-FA5CAEDED65C"
IVideoDecoder_UUID := &IID{0x3C9C5B51, 0x995D, 0x48D1, {0x9B, 0x8D, 0xFA, 0x5C, 0xAE, 0xDE, 0xD6, 0x5C}}
IVideoDecoder :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videodecoder_vtable: ^IVideoDecoder_VTable,
}
IVideoDecoder_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetCreationParameters: proc "system" (this: ^IVideoDecoder, pVideoDesc: ^VIDEO_DECODER_DESC, pConfig: ^VIDEO_DECODER_CONFIG) -> HRESULT,
	GetDriverHandle: proc "system" (this: ^IVideoDecoder, pDriverHandle: ^HANDLE) -> HRESULT,
}


VIDEO_PROCESSOR_FORMAT_SUPPORT :: enum i32 {
	INPUT  = 1,
	OUTPUT = 2,
}

VIDEO_PROCESSOR_DEVICE_CAPS :: enum i32 { // TODO: make bit_set
	LINEAR_SPACE            = 1,
	xvYCC                   = 2,
	RGB_RANGE_CONVERSION    = 4,
	YCbCr_MATRIX_CONVERSION = 8,
	NOMINAL_RANGE           = 16,
}

VIDEO_PROCESSOR_FEATURE_CAPS :: enum i32 { // TODO: make bit_set
	ALPHA_FILL         = 1,
	CONSTRICTION       = 2,
	LUMA_KEY           = 4,
	ALPHA_PALETTE      = 8,
	LEGACY             = 16,
	STEREO             = 32,
	ROTATION           = 64,
	ALPHA_STREAM       = 128,
	PIXEL_ASPECT_RATIO = 256,
	MIRROR             = 512,
	SHADER_USAGE       = 1024,
	METADATA_HDR10     = 2048,
}

VIDEO_PROCESSOR_FILTER_CAPS :: enum i32 { // TODO: make bit_set
	BRIGHTNESS         = 1,
	CONTRAST           = 2,
	HUE                = 4,
	SATURATION         = 8,
	NOISE_REDUCTION    = 16,
	EDGE_ENHANCEMENT   = 32,
	ANAMORPHIC_SCALING = 64,
	STEREO_ADJUSTMENT  = 128,
}

VIDEO_PROCESSOR_FORMAT_CAPS :: enum i32 { // TODO: make bit_set
	RGB_INTERLACED     = 1,
	RGB_PROCAMP        = 2,
	RGB_LUMA_KEY       = 4,
	PALETTE_INTERLACED = 8,
}

VIDEO_PROCESSOR_AUTO_STREAM_CAPS :: enum i32 { // TODO: make bit_set
	DENOISE             = 1,
	DERINGING           = 2,
	EDGE_ENHANCEMENT    = 4,
	COLOR_CORRECTION    = 8,
	FLESH_TONE_MAPPING  = 16,
	IMAGE_STABILIZATION = 32,
	SUPER_RESOLUTION    = 64,
	ANAMORPHIC_SCALING  = 128,
}

VIDEO_PROCESSOR_STEREO_CAPS :: enum i32 { // TODO: make bit_set
	MONO_OFFSET        = 1,
	ROW_INTERLEAVED    = 2,
	COLUMN_INTERLEAVED = 4,
	CHECKERBOARD       = 8,
	FLIP_MODE          = 16,
}

VIDEO_PROCESSOR_CAPS :: struct {
	DeviceCaps:              u32,
	FeatureCaps:             u32,
	FilterCaps:              u32,
	InputFormatCaps:         u32,
	AutoStreamCaps:          u32,
	StereoCaps:              u32,
	RateConversionCapsCount: u32,
	MaxInputStreams:         u32,
	MaxStreamStates:         u32,
}

VIDEO_PROCESSOR_PROCESSOR_CAPS :: enum i32 { // TODO: make bit_set
	DEINTERLACE_BLEND               = 1,
	DEINTERLACE_BOB                 = 2,
	DEINTERLACE_ADAPTIVE            = 4,
	DEINTERLACE_MOTION_COMPENSATION = 8,
	INVERSE_TELECINE                = 16,
	FRAME_RATE_CONVERSION           = 32,
}

VIDEO_PROCESSOR_ITELECINE_CAPS :: enum i32 {
	_32           = 1,
	_22           = 2,
	_2224         = 4,
	_2332         = 8,
	_32322        = 16,
	_55           = 32,
	_64           = 64,
	_87           = 128,
	_222222222223 = 256,
	OTHER         = -2147483648,
}

VIDEO_PROCESSOR_RATE_CONVERSION_CAPS :: struct {
	PastFrames:      u32,
	FutureFrames:    u32,
	ProcessorCaps:   u32,
	ITelecineCaps:   u32,
	CustomRateCount: u32,
}

CONTENT_PROTECTION_CAPS :: enum i32 {
	SOFTWARE                                  = 1,
	HARDWARE                                  = 2,
	PROTECTION_ALWAYS_ON                      = 4,
	PARTIAL_DECRYPTION                        = 8,
	CONTENT_KEY                               = 16,
	FRESHEN_SESSION_KEY                       = 32,
	ENCRYPTED_READ_BACK                       = 64,
	ENCRYPTED_READ_BACK_KEY                   = 128,
	SEQUENTIAL_CTR_IV                         = 256,
	ENCRYPT_SLICEDATA_ONLY                    = 512,
	DECRYPTION_BLT                            = 1024,
	HARDWARE_PROTECT_UNCOMPRESSED             = 2048,
	HARDWARE_PROTECTED_MEMORY_PAGEABLE        = 4096,
	HARDWARE_TEARDOWN                         = 8192,
	HARDWARE_DRM_COMMUNICATION                = 16384,
	HARDWARE_DRM_COMMUNICATION_MULTI_THREADED = 32768,
}


VIDEO_CONTENT_PROTECTION_CAPS :: struct {
	Caps:                 u32,
	KeyExchangeTypeCount: u32,
	BlockAlignmentSize:   u32,
	ProtectedMemorySize:  u64,
}

VIDEO_PROCESSOR_CUSTOM_RATE :: struct {
	CustomRate:          dxgi.RATIONAL,
	OutputFrames:        u32,
	InputInterlaced:     BOOL,
	InputFramesOrFields: u32,
}

VIDEO_PROCESSOR_FILTER :: enum i32 {
	BRIGHTNESS         = 0,
	CONTRAST           = 1,
	HUE                = 2,
	SATURATION         = 3,
	NOISE_REDUCTION    = 4,
	EDGE_ENHANCEMENT   = 5,
	ANAMORPHIC_SCALING = 6,
	STEREO_ADJUSTMENT  = 7,
}

VIDEO_PROCESSOR_FILTER_RANGE :: struct {
	Minimum:    i32,
	Maximum:    i32,
	Default:    i32,
	Multiplier: f32,
}

VIDEO_FRAME_FORMAT :: enum i32 {
	PROGRESSIVE                   = 0,
	INTERLACED_TOP_FIELD_FIRST    = 1,
	INTERLACED_BOTTOM_FIELD_FIRST = 2,
}

VIDEO_USAGE :: enum i32 {
	PLAYBACK_NORMAL = 0,
	OPTIMAL_SPEED   = 1,
	OPTIMAL_QUALITY = 2,
}

VIDEO_PROCESSOR_CONTENT_DESC :: struct {
	InputFrameFormat: VIDEO_FRAME_FORMAT,
	InputFrameRate:   dxgi.RATIONAL,
	InputWidth:       u32,
	InputHeight:      u32,
	OutputFrameRate:  dxgi.RATIONAL,
	OutputWidth:      u32,
	OutputHeight:     u32,
	Usage:            VIDEO_USAGE,
}


IVideoProcessorEnumerator_UUID_STRING :: "31627037-53AB-4200-9061-05FAA9AB45F9"
IVideoProcessorEnumerator_UUID := &IID{0x31627037, 0x53AB, 0x4200, {0x90, 0x61, 0x05, 0xFA, 0xA9, 0xAB, 0x45, 0xF9}}
IVideoProcessorEnumerator :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videoprocessorenumerator_vtable: ^IVideoProcessorEnumerator_VTable,
}
IVideoProcessorEnumerator_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetVideoProcessorContentDesc:        proc "system" (this: ^IVideoProcessorEnumerator, pContentDesc: ^VIDEO_PROCESSOR_CONTENT_DESC) -> HRESULT,
	CheckVideoProcessorFormat:           proc "system" (this: ^IVideoProcessorEnumerator, Format: dxgi.FORMAT, pFlags: ^u32) -> HRESULT,
	GetVideoProcessorCaps:               proc "system" (this: ^IVideoProcessorEnumerator, pCaps: ^VIDEO_PROCESSOR_CAPS) -> HRESULT,
	GetVideoProcessorRateConversionCaps: proc "system" (this: ^IVideoProcessorEnumerator, TypeIndex: u32, pCaps: ^VIDEO_PROCESSOR_RATE_CONVERSION_CAPS) -> HRESULT,
	GetVideoProcessorCustomRate:         proc "system" (this: ^IVideoProcessorEnumerator, TypeIndex: u32, CustomRateIndex: u32, pRate: ^VIDEO_PROCESSOR_CUSTOM_RATE) -> HRESULT,
	GetVideoProcessorFilterRange:        proc "system" (this: ^IVideoProcessorEnumerator, Filter: VIDEO_PROCESSOR_FILTER, pRange: ^VIDEO_PROCESSOR_FILTER_RANGE) -> HRESULT,
}


VIDEO_COLOR_RGBA :: struct {
	R: f32,
	G: f32,
	B: f32,
	A: f32,
}

VIDEO_COLOR_YCbCrA :: struct {
	Y:  f32,
	Cb: f32,
	Cr: f32,
	A:  f32,
}

VIDEO_COLOR :: struct {
	using _: struct #raw_union {
		YCbCr: VIDEO_COLOR_YCbCrA,
		RGBA:  VIDEO_COLOR_RGBA,
	},
}

VIDEO_PROCESSOR_NOMINAL_RANGE :: enum i32 {
	UNDEFINED = 0,
	_16_235   = 1,
	_0_255    = 2,
}

VIDEO_PROCESSOR_COLOR_SPACE_FLAG :: enum u32 {
	Usage          = 0,
	RGB_Range      = 1,
	YCbCr_Matrix   = 2,
	YCbCr_xvYCC    = 3,
	Nominal_Range  = 4,
	Reserved       = 6,
}

VIDEO_PROCESSOR_COLOR_SPACE :: distinct bit_set[VIDEO_PROCESSOR_COLOR_SPACE_FLAG; u32]

VIDEO_PROCESSOR_ALPHA_FILL_MODE :: enum i32 {
	OPAQUE        = 0,
	BACKGROUND    = 1,
	DESTINATION   = 2,
	SOURCE_STREAM = 3,
}

VIDEO_PROCESSOR_OUTPUT_RATE :: enum i32 {
	NORMAL = 0,
	HALF   = 1,
	CUSTOM = 2,
}

VIDEO_PROCESSOR_STEREO_FORMAT :: enum i32 {
	MONO               = 0,
	HORIZONTAL         = 1,
	VERTICAL           = 2,
	SEPARATE           = 3,
	MONO_OFFSET        = 4,
	ROW_INTERLEAVED    = 5,
	COLUMN_INTERLEAVED = 6,
	CHECKERBOARD       = 7,
}

VIDEO_PROCESSOR_STEREO_FLIP_MODE :: enum i32 {
	NONE   = 0,
	FRAME0 = 1,
	FRAME1 = 2,
}

VIDEO_PROCESSOR_ROTATION :: enum i32 {
	IDENTITY = 0,
	_90      = 1,
	_180     = 2,
	_270     = 3,
}

VIDEO_PROCESSOR_STREAM :: struct {
	Enable:                BOOL,
	OutputIndex:           u32,
	InputFrameOrField:     u32,
	PastFrames:            u32,
	FutureFrames:          u32,

	ppPastSurfaces:        ^^IVideoProcessorInputView,
	pInputSurface:         ^IVideoProcessorInputView,

	ppFutureSurfaces:      ^^IVideoProcessorInputView,

	ppPastSurfacesRight:   ^^IVideoProcessorInputView,
	pInputSurfaceRight:    ^IVideoProcessorInputView,

	ppFutureSurfacesRight: ^^IVideoProcessorInputView,
}


IVideoProcessor_UUID_STRING :: "1D7B0652-185F-41C6-85CE-0C5BE3D4AE6C"
IVideoProcessor_UUID := &IID{0x1D7B0652, 0x185F, 0x41C6, {0x85, 0xCE, 0x0C, 0x5B, 0xE3, 0xD4, 0xAE, 0x6C}}
IVideoProcessor :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videoprocessor_vtable: ^IVideoProcessor_VTable,
}
IVideoProcessor_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetContentDesc:        proc "system" (this: ^IVideoProcessor, pDesc: ^VIDEO_PROCESSOR_CONTENT_DESC),
	GetRateConversionCaps: proc "system" (this: ^IVideoProcessor, pCaps: ^VIDEO_PROCESSOR_RATE_CONVERSION_CAPS),
}


OMAC :: struct {
	Omac: [16]u8,
}

AUTHENTICATED_CHANNEL_TYPE :: enum i32 {
	D3D11           = 1,
	DRIVER_SOFTWARE = 2,
	DRIVER_HARDWARE = 3,
}


IAuthenticatedChannel_UUID_STRING :: "3015A308-DCBD-47AA-A747-192486D14D4A"
IAuthenticatedChannel_UUID := &IID{0x3015A308, 0xDCBD, 0x47AA, {0xA7, 0x47, 0x19, 0x24, 0x86, 0xD1, 0x4D, 0x4A}}
IAuthenticatedChannel :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11authenticatedchannel_vtable: ^IAuthenticatedChannel_VTable,
}
IAuthenticatedChannel_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetCertificateSize: proc "system" (this: ^IAuthenticatedChannel, pCertificateSize: ^u32) -> HRESULT,
	GetCertificate:     proc "system" (this: ^IAuthenticatedChannel, CertificateSize: u32, pCertificate: cstring) -> HRESULT,
	GetChannelHandle:   proc "system" (this: ^IAuthenticatedChannel, pChannelHandle: ^HANDLE),
}


AUTHENTICATED_QUERY_INPUT :: struct {
	QueryType:      GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
}

AUTHENTICATED_QUERY_OUTPUT :: struct {
	omac:           OMAC,
	QueryType:      GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
	ReturnCode:     HRESULT,
}

AUTHENTICATED_PROTECTION_FLAG :: enum u32 {
	ProtectionEnabled           = 0,
	OverlayOrFullscreenRequired = 1,
	Reserved                    = 2,
}
AUTHENTICATED_PROTECTION_FLAGS :: distinct bit_set[AUTHENTICATED_PROTECTION_FLAG; u32]

AUTHENTICATED_QUERY_PROTECTION_OUTPUT :: struct {
	Output:          AUTHENTICATED_QUERY_OUTPUT,
	ProtectionFlags: AUTHENTICATED_PROTECTION_FLAGS,
}

AUTHENTICATED_QUERY_CHANNEL_TYPE_OUTPUT :: struct {
	Output:      AUTHENTICATED_QUERY_OUTPUT,
	ChannelType: AUTHENTICATED_CHANNEL_TYPE,
}

AUTHENTICATED_QUERY_DEVICE_HANDLE_OUTPUT :: struct {
	Output:       AUTHENTICATED_QUERY_OUTPUT,
	DeviceHandle: HANDLE,
}

AUTHENTICATED_QUERY_CRYPTO_SESSION_INPUT :: struct {
	Input:         AUTHENTICATED_QUERY_INPUT,
	DecoderHandle: HANDLE,
}

AUTHENTICATED_QUERY_CRYPTO_SESSION_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	DecoderHandle:       HANDLE,
	CryptoSessionHandle: HANDLE,
	DeviceHandle:        HANDLE,
}

AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_COUNT_OUTPUT :: struct {
	Output:                               AUTHENTICATED_QUERY_OUTPUT,
	RestrictedSharedResourceProcessCount: u32,
}

AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_INPUT :: struct {
	Input:        AUTHENTICATED_QUERY_INPUT,
	ProcessIndex: u32,
}

AUTHENTICATED_PROCESS_IDENTIFIER_TYPE :: enum i32 {
	UNKNOWN = 0,
	DWM     = 1,
	HANDLE  = 2,
}

AUTHENTICATED_QUERY_RESTRICTED_SHARED_RESOURCE_PROCESS_OUTPUT :: struct {
	Output:            AUTHENTICATED_QUERY_OUTPUT,
	ProcessIndex:      u32,
	ProcessIdentifier: AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
	ProcessHandle:     HANDLE,
}

AUTHENTICATED_QUERY_UNRESTRICTED_PROTECTED_SHARED_RESOURCE_COUNT_OUTPUT :: struct {
	Output:                                   AUTHENTICATED_QUERY_OUTPUT,
	UnrestrictedProtectedSharedResourceCount: u32,
}

AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_INPUT :: struct {
	Input:               AUTHENTICATED_QUERY_INPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
}

AUTHENTICATED_QUERY_OUTPUT_ID_COUNT_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
	OutputIDCount:       u32,
}

AUTHENTICATED_QUERY_OUTPUT_ID_INPUT :: struct {
	Input:               AUTHENTICATED_QUERY_INPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
	OutputIDIndex:       u32,
}

AUTHENTICATED_QUERY_OUTPUT_ID_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	DeviceHandle:        HANDLE,
	CryptoSessionHandle: HANDLE,
	OutputIDIndex:       u32,
	OutputID:            u64,
}

BUS_TYPE :: enum i32 {
	OTHER                                  = 0,
	PCI                                    = 1,
	PCIX                                   = 2,
	PCIEXPRESS                             = 3,
	AGP                                    = 4,
	NSIDE_OF_CHIPSET                       = 65536,
	RACKS_ON_MOTHER_BOARD_TO_CHIP          = 131072,
	RACKS_ON_MOTHER_BOARD_TO_SOCKET        = 196608,
	AUGHTER_BOARD_CONNECTOR                = 262144,
	AUGHTER_BOARD_CONNECTOR_INSIDE_OF_NUAE = 327680,
	ON_STANDARD                            = -2147483648,
}

AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT :: struct {
	Output:                          AUTHENTICATED_QUERY_OUTPUT,
	BusType:                         BUS_TYPE,
	AccessibleInContiguousBlocks:    BOOL,
	AccessibleInNonContiguousBlocks: BOOL,
}

AUTHENTICATED_QUERY_ACCESSIBILITY_OUTPUT :: AUTHENTICATED_QUERY_ACESSIBILITY_OUTPUT

AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_COUNT_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	EncryptionGuidCount: u32,
}

AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_INPUT :: struct {
	Input:               AUTHENTICATED_QUERY_INPUT,
	EncryptionGuidIndex: u32,
}

AUTHENTICATED_QUERY_ACCESSIBILITY_ENCRYPTION_GUID_OUTPUT :: struct {
	Output:              AUTHENTICATED_QUERY_OUTPUT,
	EncryptionGuidIndex: u32,
	EncryptionGuid:      GUID,
}

AUTHENTICATED_QUERY_CURRENT_ACCESSIBILITY_ENCRYPTION_OUTPUT :: struct {
	Output:         AUTHENTICATED_QUERY_OUTPUT,
	EncryptionGuid: GUID,
}

AUTHENTICATED_CONFIGURE_INPUT :: struct {
	omac:           OMAC,
	ConfigureType:  GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
}

AUTHENTICATED_CONFIGURE_OUTPUT :: struct {
	omac:           OMAC,
	ConfigureType:  GUID,
	hChannel:       HANDLE,
	SequenceNumber: u32,
	ReturnCode:     HRESULT,
}

AUTHENTICATED_CONFIGURE_INITIALIZE_INPUT :: struct {
	Parameters:             AUTHENTICATED_CONFIGURE_INPUT,
	StartSequenceQuery:     u32,
	StartSequenceConfigure: u32,
}

AUTHENTICATED_CONFIGURE_PROTECTION_INPUT :: struct {
	Parameters:  AUTHENTICATED_CONFIGURE_INPUT,
	Protections: AUTHENTICATED_PROTECTION_FLAGS,
}

AUTHENTICATED_CONFIGURE_CRYPTO_SESSION_INPUT :: struct {
	Parameters:          AUTHENTICATED_CONFIGURE_INPUT,
	DecoderHandle:       HANDLE,
	CryptoSessionHandle: HANDLE,
	DeviceHandle:        HANDLE,
}

AUTHENTICATED_CONFIGURE_SHARED_RESOURCE_INPUT :: struct {
	Parameters:    AUTHENTICATED_CONFIGURE_INPUT,
	ProcessType:   AUTHENTICATED_PROCESS_IDENTIFIER_TYPE,
	ProcessHandle: HANDLE,
	AllowAccess:   BOOL,
}

AUTHENTICATED_CONFIGURE_ACCESSIBLE_ENCRYPTION_INPUT :: struct {
	Parameters:     AUTHENTICATED_CONFIGURE_INPUT,
	EncryptionGuid: GUID,
}



ICryptoSession_UUID_STRING :: "9B32F9AD-BDCC-40A6-A39D-D5C865845720"
ICryptoSession_UUID := &IID{0x9B32F9AD, 0xBDCC, 0x40A6, {0xA3, 0x9D, 0xD5, 0xC8, 0x65, 0x84, 0x57, 0x20}}
ICryptoSession :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11cryptosession_vtable: ^ICryptoSession_VTable,
}
ICryptoSession_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetCryptoType:          proc "system" (this: ^ICryptoSession, pCryptoType: ^GUID),
	GetDecoderProfile:      proc "system" (this: ^ICryptoSession, pDecoderProfile: ^GUID),
	GetCertificateSize:     proc "system" (this: ^ICryptoSession, pCertificateSize: ^u32) -> HRESULT,
	GetCertificate:         proc "system" (this: ^ICryptoSession, CertificateSize: u32, pCertificate: cstring) -> HRESULT,
	GetCryptoSessionHandle: proc "system" (this: ^ICryptoSession, pCryptoSessionHandle: ^HANDLE),
}


VDOV_DIMENSION :: enum i32 {
	UNKNOWN   = 0,
	TEXTURE2D = 1,
}

TEX2D_VDOV :: struct {
	ArraySlice: u32,
}

VIDEO_DECODER_OUTPUT_VIEW_DESC :: struct {
	DecodeProfile: GUID,
	ViewDimension: VDOV_DIMENSION,
	using _: struct #raw_union {
		Texture2D: TEX2D_VDOV,
	},
}


IVideoDecoderOutputView_UUID_STRING :: "C2931AEA-2A85-4F20-860F-FBA1FD256E18"
IVideoDecoderOutputView_UUID := &IID{0xC2931AEA, 0x2A85, 0x4F20, {0x86, 0x0F, 0xFB, 0xA1, 0xFD, 0x25, 0x6E, 0x18}}
IVideoDecoderOutputView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11videodecoderoutputview_vtable: ^IVideoDecoderOutputView_VTable,
}
IVideoDecoderOutputView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "system" (this: ^IVideoDecoderOutputView, pDesc: ^VIDEO_DECODER_OUTPUT_VIEW_DESC),
}


VPIV_DIMENSION :: enum i32 {
	UNKNOWN   = 0,
	TEXTURE2D = 1,
}

TEX2D_VPIV :: struct {
	MipSlice:   u32,
	ArraySlice: u32,
}

VIDEO_PROCESSOR_INPUT_VIEW_DESC :: struct {
	FourCC:        u32,
	ViewDimension: VPIV_DIMENSION,
	using _: struct #raw_union {
		Texture2D: TEX2D_VPIV,
	},
}


IVideoProcessorInputView_UUID_STRING :: "11EC5A5F-51DC-4945-AB34-6E8C21300EA5"
IVideoProcessorInputView_UUID := &IID{0x11EC5A5F, 0x51DC, 0x4945, {0xAB, 0x34, 0x6E, 0x8C, 0x21, 0x30, 0x0E, 0xA5}}
IVideoProcessorInputView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11videoprocessorinputview_vtable: ^IVideoProcessorInputView_VTable,
}
IVideoProcessorInputView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "system" (this: ^IVideoProcessorInputView, pDesc: ^VIDEO_PROCESSOR_INPUT_VIEW_DESC),
}


VPOV_DIMENSION :: enum i32 {
	UNKNOWN        = 0,
	TEXTURE2D      = 1,
	TEXTURE2DARRAY = 2,
}

TEX2D_VPOV :: struct {
	MipSlice: u32,
}

TEX2D_ARRAY_VPOV :: struct {
	MipSlice:        u32,
	FirstArraySlice: u32,
	ArraySize:       u32,
}

VIDEO_PROCESSOR_OUTPUT_VIEW_DESC :: struct {
	ViewDimension: VPOV_DIMENSION,
	using _: struct #raw_union {
		Texture2D:      TEX2D_VPOV,
		Texture2DArray: TEX2D_ARRAY_VPOV,
	},
}


IVideoProcessorOutputView_UUID_STRING :: "A048285E-25A9-4527-BD93-D68B68C44254"
IVideoProcessorOutputView_UUID := &IID{0xA048285E, 0x25A9, 0x4527, {0xBD, 0x93, 0xD6, 0x8B, 0x68, 0xC4, 0x42, 0x54}}
IVideoProcessorOutputView :: struct #raw_union {
	#subtype id3d11view: IView,
	using id3d11videoprocessoroutputview_vtable: ^IVideoProcessorOutputView_VTable,
}
IVideoProcessorOutputView_VTable :: struct {
	using id3d11view_vtable: IView_VTable,
	GetDesc: proc "system" (this: ^IVideoProcessorOutputView, pDesc: ^VIDEO_PROCESSOR_OUTPUT_VIEW_DESC),
}



IVideoContext_UUID_STRING :: "61F21C45-3C0E-4A74-9CEA-67100D9AD5E4"
IVideoContext_UUID := &IID{0x61F21C45, 0x3C0E, 0x4A74, {0x9C, 0xEA, 0x67, 0x10, 0x0D, 0x9A, 0xD5, 0xE4}}
IVideoContext :: struct #raw_union {
	#subtype id3d11devicechild: IDeviceChild,
	using id3d11videocontext_vtable: ^IVideoContext_VTable,
}
IVideoContext_VTable :: struct {
	using id3d11devicechild_vtable: IDeviceChild_VTable,
	GetDecoderBuffer:                          proc "system" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, Type: VIDEO_DECODER_BUFFER_TYPE, pBufferSize: ^u32, ppBuffer: ^rawptr) -> HRESULT,
	ReleaseDecoderBuffer:                      proc "system" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, Type: VIDEO_DECODER_BUFFER_TYPE) -> HRESULT,
	DecoderBeginFrame:                         proc "system" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, pView: ^IVideoDecoderOutputView, ContentKeySize: u32, pContentKey: rawptr) -> HRESULT,
	DecoderEndFrame:                           proc "system" (this: ^IVideoContext, pDecoder: ^IVideoDecoder) -> HRESULT,
	SubmitDecoderBuffers:                      proc "system" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, NumBuffers: u32, pBufferDesc: ^VIDEO_DECODER_BUFFER_DESC) -> HRESULT,
	DecoderExtension:                          proc "system" (this: ^IVideoContext, pDecoder: ^IVideoDecoder, pExtensionData: ^VIDEO_DECODER_EXTENSION) -> APP_DEPRECATED_HRESULT,
	VideoProcessorSetOutputTargetRect:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enable: BOOL, pRect: ^RECT),
	VideoProcessorSetOutputBackgroundColor:    proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, YCbCr: BOOL, pColor: ^VIDEO_COLOR),
	VideoProcessorSetOutputColorSpace:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorSetOutputAlphaFillMode:      proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, AlphaFillMode: VIDEO_PROCESSOR_ALPHA_FILL_MODE, StreamIndex: u32),
	VideoProcessorSetOutputConstriction:       proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enable: BOOL, Size: SIZE),
	VideoProcessorSetOutputStereoMode:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enable: BOOL),
	VideoProcessorSetOutputExtension:          proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorGetOutputTargetRect:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, Enabled: ^BOOL, pRect: ^RECT),
	VideoProcessorGetOutputBackgroundColor:    proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pYCbCr: ^BOOL, pColor: ^VIDEO_COLOR),
	VideoProcessorGetOutputColorSpace:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorGetOutputAlphaFillMode:      proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pAlphaFillMode: ^VIDEO_PROCESSOR_ALPHA_FILL_MODE, pStreamIndex: ^u32),
	VideoProcessorGetOutputConstriction:       proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pEnabled: ^BOOL, pSize: ^SIZE),
	VideoProcessorGetOutputStereoMode:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pEnabled: ^BOOL),
	VideoProcessorGetOutputExtension:          proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorSetStreamFrameFormat:        proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, FrameFormat: VIDEO_FRAME_FORMAT),
	VideoProcessorSetStreamColorSpace:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorSetStreamOutputRate:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, OutputRate: VIDEO_PROCESSOR_OUTPUT_RATE, RepeatFrame: BOOL, pCustomRate: ^dxgi.RATIONAL),
	VideoProcessorSetStreamSourceRect:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, pRect: ^RECT),
	VideoProcessorSetStreamDestRect:           proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, pRect: ^RECT),
	VideoProcessorSetStreamAlpha:              proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Alpha: f32),
	VideoProcessorSetStreamPalette:            proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Count: u32, pEntries: [^]u32),
	VideoProcessorSetStreamPixelAspectRatio:   proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, pSourceAspectRatio: ^dxgi.RATIONAL, pDestinationAspectRatio: ^dxgi.RATIONAL),
	VideoProcessorSetStreamLumaKey:            proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Lower: f32, Upper: f32),
	VideoProcessorSetStreamStereoFormat:       proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Format: VIDEO_PROCESSOR_STEREO_FORMAT, LeftViewFrame0: BOOL, BaseViewFrame0: BOOL, FlipMode: VIDEO_PROCESSOR_STEREO_FLIP_MODE, MonoOffset: i32),
	VideoProcessorSetStreamAutoProcessingMode: proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL),
	VideoProcessorSetStreamFilter:             proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Filter: VIDEO_PROCESSOR_FILTER, Enable: BOOL, Level: i32),
	VideoProcessorSetStreamExtension:          proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorGetStreamFrameFormat:        proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pFrameFormat: ^VIDEO_FRAME_FORMAT),
	VideoProcessorGetStreamColorSpace:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pColorSpace: ^VIDEO_PROCESSOR_COLOR_SPACE),
	VideoProcessorGetStreamOutputRate:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pOutputRate: ^VIDEO_PROCESSOR_OUTPUT_RATE, pRepeatFrame: ^BOOL, pCustomRate: ^dxgi.RATIONAL),
	VideoProcessorGetStreamSourceRect:         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pRect: ^RECT),
	VideoProcessorGetStreamDestRect:           proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pRect: ^RECT),
	VideoProcessorGetStreamAlpha:              proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pAlpha: ^f32),
	VideoProcessorGetStreamPalette:            proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Count: u32, pEntries: [^]u32),
	VideoProcessorGetStreamPixelAspectRatio:   proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pSourceAspectRatio: ^dxgi.RATIONAL, pDestinationAspectRatio: ^dxgi.RATIONAL),
	VideoProcessorGetStreamLumaKey:            proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL, pLower: ^f32, pUpper: ^f32),
	VideoProcessorGetStreamStereoFormat:       proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnable: ^BOOL, pFormat: ^VIDEO_PROCESSOR_STEREO_FORMAT, pLeftViewFrame0: ^BOOL, pBaseViewFrame0: ^BOOL, pFlipMode: ^VIDEO_PROCESSOR_STEREO_FLIP_MODE, MonoOffset: ^i32),
	VideoProcessorGetStreamAutoProcessingMode: proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnabled: ^BOOL),
	VideoProcessorGetStreamFilter:             proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Filter: VIDEO_PROCESSOR_FILTER, pEnabled: ^BOOL, pLevel: ^i32),
	VideoProcessorGetStreamExtension:          proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pExtensionGuid: ^GUID, DataSize: u32, pData: rawptr) -> APP_DEPRECATED_HRESULT,
	VideoProcessorBlt:                         proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, pView: ^IVideoProcessorOutputView, OutputFrame: u32, StreamCount: u32, pStreams: [^]VIDEO_PROCESSOR_STREAM) -> HRESULT,
	NegotiateCryptoSessionKeyExchange:         proc "system" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, DataSize: u32, pData: rawptr) -> HRESULT,
	EncryptionBlt:                             proc "system" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, pSrcSurface: ^ITexture2D, pDstSurface: ^ITexture2D, IVSize: u32, pIV: rawptr),
	DecryptionBlt:                             proc "system" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, pSrcSurface: ^ITexture2D, pDstSurface: ^ITexture2D, pEncryptedBlockInfo: ^ENCRYPTED_BLOCK_INFO, ContentKeySize: u32, pContentKey: rawptr, IVSize: u32, pIV: rawptr),
	StartSessionKeyRefresh:                    proc "system" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, RandomNumberSize: u32, pRandomNumber: rawptr),
	FinishSessionKeyRefresh:                   proc "system" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession),
	GetEncryptionBltKey:                       proc "system" (this: ^IVideoContext, pCryptoSession: ^ICryptoSession, KeySize: u32, pReadbackKey: rawptr) -> HRESULT,
	NegotiateAuthenticatedChannelKeyExchange:  proc "system" (this: ^IVideoContext, pChannel: ^IAuthenticatedChannel, DataSize: u32, pData: rawptr) -> HRESULT,
	QueryAuthenticatedChannel:                 proc "system" (this: ^IVideoContext, pChannel: ^IAuthenticatedChannel, InputSize: u32, pInput: rawptr, OutputSize: u32, pOutput: rawptr) -> HRESULT,
	ConfigureAuthenticatedChannel:             proc "system" (this: ^IVideoContext, pChannel: ^IAuthenticatedChannel, InputSize: u32, pInput: rawptr, pOutput: ^AUTHENTICATED_CONFIGURE_OUTPUT) -> HRESULT,
	VideoProcessorSetStreamRotation:           proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, Enable: BOOL, Rotation: VIDEO_PROCESSOR_ROTATION),
	VideoProcessorGetStreamRotation:           proc "system" (this: ^IVideoContext, pVideoProcessor: ^IVideoProcessor, StreamIndex: u32, pEnable: ^BOOL, pRotation: ^VIDEO_PROCESSOR_ROTATION),
}

IUserDefinedAnnotation_UUID_STRING :: "B2DAAD8B-03D4-4DBF-95EB-32AB4B63D0AB"
IUserDefinedAnnotation_UUID := &IID{0xB2DAAD8B, 0x03D4, 0x4DBF, {0x95, 0xEB, 0x32, 0xAB, 0x4B, 0x63, 0xD0, 0xAB}}
IUserDefinedAnnotation :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11userdefinedannotation_vtable: ^IUserDefinedAnnotation_VTable,
}
IUserDefinedAnnotation_VTable :: struct {
	using iunknown_vtable : IUnknown_VTable,
	BeginEvent: proc "system" (this: ^IUserDefinedAnnotation, Name: LPCWSTR) -> i32,
	EndEvent:   proc "system" (this: ^IUserDefinedAnnotation) -> i32,
	GetStatus:  proc "system" (this: ^IUserDefinedAnnotation) -> i32,
	SetMarker:  proc "system" (this: ^IUserDefinedAnnotation, Name: LPCWSTR),
}

IVideoDevice_UUID_STRING :: "10EC4D5B-975A-4689-B9E4-D0AAC30FE333"
IVideoDevice_UUID := &IID{0x10EC4D5B, 0x975A, 0x4689, {0xB9, 0xE4, 0xD0, 0xAA, 0xC3, 0x0F, 0xE3, 0x33}}
IVideoDevice :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11videodevice_vtable: ^IVideoDevice_VTable,
}
IVideoDevice_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	CreateVideoDecoder:             proc "system" (this: ^IVideoDevice, pVideoDesc: ^VIDEO_DECODER_DESC, pConfig: ^VIDEO_DECODER_CONFIG, ppDecoder: ^^IVideoDecoder) -> HRESULT,
	CreateVideoProcessor:           proc "system" (this: ^IVideoDevice, pEnum: ^IVideoProcessorEnumerator, RateConversionIndex: u32, ppVideoProcessor: ^^IVideoProcessor) -> HRESULT,
	CreateAuthenticatedChannel:     proc "system" (this: ^IVideoDevice, ChannelType: AUTHENTICATED_CHANNEL_TYPE, ppAuthenticatedChannel: ^^IAuthenticatedChannel) -> HRESULT,
	CreateCryptoSession:            proc "system" (this: ^IVideoDevice, pCryptoType: ^GUID, pDecoderProfile: ^GUID, pKeyExchangeType: ^GUID, ppCryptoSession: ^^ICryptoSession) -> HRESULT,
	CreateVideoDecoderOutputView:   proc "system" (this: ^IVideoDevice, pResource: ^IResource, pDesc: ^VIDEO_DECODER_OUTPUT_VIEW_DESC, ppVDOVView: ^^IVideoDecoderOutputView) -> HRESULT,
	CreateVideoProcessorInputView:  proc "system" (this: ^IVideoDevice, pResource: ^IResource, pEnum: ^IVideoProcessorEnumerator, pDesc: ^VIDEO_PROCESSOR_INPUT_VIEW_DESC, ppVPIView: ^^IVideoProcessorInputView) -> HRESULT,
	CreateVideoProcessorOutputView: proc "system" (this: ^IVideoDevice, pResource: ^IResource, pEnum: ^IVideoProcessorEnumerator, pDesc: ^VIDEO_PROCESSOR_OUTPUT_VIEW_DESC, ppVPOView: ^^IVideoProcessorOutputView) -> HRESULT,
	CreateVideoProcessorEnumerator: proc "system" (this: ^IVideoDevice, pDesc: ^VIDEO_PROCESSOR_CONTENT_DESC, ppEnum: ^^IVideoProcessorEnumerator) -> HRESULT,
	GetVideoDecoderProfileCount:    proc "system" (this: ^IVideoDevice) -> u32,
	GetVideoDecoderProfile:         proc "system" (this: ^IVideoDevice, Index: u32, pDecoderProfile: ^GUID) -> HRESULT,
	CheckVideoDecoderFormat:        proc "system" (this: ^IVideoDevice, pDecoderProfile: ^GUID, Format: dxgi.FORMAT, pSupported: ^BOOL) -> HRESULT,
	GetVideoDecoderConfigCount:     proc "system" (this: ^IVideoDevice, pDesc: ^VIDEO_DECODER_DESC, pCount: ^u32) -> HRESULT,
	GetVideoDecoderConfig:          proc "system" (this: ^IVideoDevice, pDesc: ^VIDEO_DECODER_DESC, Index: u32, pConfig: ^VIDEO_DECODER_CONFIG) -> HRESULT,
	GetContentProtectionCaps:       proc "system" (this: ^IVideoDevice, pCryptoType: ^GUID, pDecoderProfile: ^GUID, pCaps: ^VIDEO_CONTENT_PROTECTION_CAPS) -> HRESULT,
	CheckCryptoKeyExchange:         proc "system" (this: ^IVideoDevice, pCryptoType: ^GUID, pDecoderProfile: ^GUID, Index: u32, pKeyExchangeType: ^GUID) -> HRESULT,
	SetPrivateData:                 proc "system" (this: ^IVideoDevice, guid: ^GUID, DataSize: u32, pData: rawptr) -> HRESULT,
	SetPrivateDataInterface:        proc "system" (this: ^IVideoDevice, guid: ^GUID, pData: ^IUnknown) -> HRESULT,
}



IDevice_UUID_STRING :: "DB6F6DDB-AC77-4E88-8253-819DF9BBF140"
IDevice_UUID := &IID{0xDB6F6DDB, 0xAC77, 0x4E88, {0x82, 0x53, 0x81, 0x9D, 0xF9, 0xBB, 0xF1, 0x40}}
IDevice :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11device_vtable: ^IDevice_VTable,
}
IDevice_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	CreateBuffer:                         proc "system" (this: ^IDevice, pDesc: ^BUFFER_DESC, pInitialData: ^SUBRESOURCE_DATA, ppBuffer: ^^IBuffer) -> HRESULT,
	CreateTexture1D:                      proc "system" (this: ^IDevice, pDesc: ^TEXTURE1D_DESC, pInitialData: ^SUBRESOURCE_DATA, ppTexture1D: ^^ITexture1D) -> HRESULT,
	CreateTexture2D:                      proc "system" (this: ^IDevice, pDesc: ^TEXTURE2D_DESC, pInitialData: ^SUBRESOURCE_DATA, ppTexture2D: ^^ITexture2D) -> HRESULT,
	CreateTexture3D:                      proc "system" (this: ^IDevice, pDesc: ^TEXTURE3D_DESC, pInitialData: ^SUBRESOURCE_DATA, ppTexture3D: ^^ITexture3D) -> HRESULT,
	CreateShaderResourceView:             proc "system" (this: ^IDevice, pResource: ^IResource, pDesc: ^SHADER_RESOURCE_VIEW_DESC, ppSRView: ^^IShaderResourceView) -> HRESULT,
	CreateUnorderedAccessView:            proc "system" (this: ^IDevice, pResource: ^IResource, pDesc: ^UNORDERED_ACCESS_VIEW_DESC, ppUAView: ^^IUnorderedAccessView) -> HRESULT,
	CreateRenderTargetView:               proc "system" (this: ^IDevice, pResource: ^IResource, pDesc: ^RENDER_TARGET_VIEW_DESC, ppRTView: ^^IRenderTargetView) -> HRESULT,
	CreateDepthStencilView:               proc "system" (this: ^IDevice, pResource: ^IResource, pDesc: ^DEPTH_STENCIL_VIEW_DESC, ppDepthStencilView: ^^IDepthStencilView) -> HRESULT,
	CreateInputLayout:                    proc "system" (this: ^IDevice, pInputElementDescs: [^]INPUT_ELEMENT_DESC, NumElements: u32, pShaderBytecodeWithInputSignature: rawptr, BytecodeLength: SIZE_T, ppInputLayout: ^^IInputLayout) -> HRESULT,
	CreateVertexShader:                   proc "system" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppVertexShader: ^^IVertexShader) -> HRESULT,
	CreateGeometryShader:                 proc "system" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppGeometryShader: ^^IGeometryShader) -> HRESULT,
	CreateGeometryShaderWithStreamOutput: proc "system" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pSODeclaration: ^SO_DECLARATION_ENTRY, NumEntries: u32, pBufferStrides: [^]u32, NumStrides: u32, RasterizedStream: u32, pClassLinkage: ^IClassLinkage, ppGeometryShader: ^^IGeometryShader) -> HRESULT,
	CreatePixelShader:                    proc "system" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppPixelShader: ^^IPixelShader) -> HRESULT,
	CreateHullShader:                     proc "system" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppHullShader: ^^IHullShader) -> HRESULT,
	CreateDomainShader:                   proc "system" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppDomainShader: ^^IDomainShader) -> HRESULT,
	CreateComputeShader:                  proc "system" (this: ^IDevice, pShaderBytecode: rawptr, BytecodeLength: SIZE_T, pClassLinkage: ^IClassLinkage, ppComputeShader: ^^IComputeShader) -> HRESULT,
	CreateClassLinkage:                   proc "system" (this: ^IDevice, ppLinkage: ^^IClassLinkage) -> HRESULT,
	CreateBlendState:                     proc "system" (this: ^IDevice, pBlendStateDesc: ^BLEND_DESC, ppBlendState: ^^IBlendState) -> HRESULT,
	CreateDepthStencilState:              proc "system" (this: ^IDevice, pDepthStencilDesc: ^DEPTH_STENCIL_DESC, ppDepthStencilState: ^^IDepthStencilState) -> HRESULT,
	CreateRasterizerState:                proc "system" (this: ^IDevice, pRasterizerDesc: ^RASTERIZER_DESC, ppRasterizerState: ^^IRasterizerState) -> HRESULT,
	CreateSamplerState:                   proc "system" (this: ^IDevice, pSamplerDesc: ^SAMPLER_DESC, ppSamplerState: ^^ISamplerState) -> HRESULT,
	CreateQuery:                          proc "system" (this: ^IDevice, pQueryDesc: ^QUERY_DESC, ppQuery: ^^IQuery) -> HRESULT,
	CreatePredicate:                      proc "system" (this: ^IDevice, pPredicateDesc: ^QUERY_DESC, ppPredicate: ^^IPredicate) -> HRESULT,
	CreateCounter:                        proc "system" (this: ^IDevice, pCounterDesc: ^COUNTER_DESC, ppCounter: ^^ICounter) -> HRESULT,
	CreateDeferredContext:                proc "system" (this: ^IDevice, ContextFlags: u32, ppDeferredContext: ^^IDeviceContext) -> HRESULT,
	OpenSharedResource:                   proc "system" (this: ^IDevice, hResource: HANDLE, ReturnedInterface: ^IID, ppResource: ^rawptr) -> HRESULT,
	CheckFormatSupport:                   proc "system" (this: ^IDevice, Format: dxgi.FORMAT, pFormatSupport: ^u32) -> HRESULT,
	CheckMultisampleQualityLevels:        proc "system" (this: ^IDevice, Format: dxgi.FORMAT, SampleCount: u32, pNumQualityLevels: [^]u32) -> HRESULT,
	CheckCounterInfo:                     proc "system" (this: ^IDevice, pCounterInfo: ^COUNTER_INFO),
	CheckCounter:                         proc "system" (this: ^IDevice, pDesc: ^COUNTER_DESC, pType: ^COUNTER_TYPE, pActiveCounters: ^u32, szName: cstring, pNameLength: ^u32, szUnits: cstring, pUnitsLength: ^u32, szDescription: cstring, pDescriptionLength: ^u32) -> HRESULT,
	CheckFeatureSupport:                  proc "system" (this: ^IDevice, Feature: FEATURE, pFeatureSupportData: rawptr, FeatureSupportDataSize: u32) -> HRESULT,
	GetPrivateData:                       proc "system" (this: ^IDevice, guid: ^GUID, pDataSize: ^u32, pData: rawptr) -> HRESULT,
	SetPrivateData:                       proc "system" (this: ^IDevice, guid: ^GUID, DataSize: u32, pData: rawptr) -> HRESULT,
	SetPrivateDataInterface:              proc "system" (this: ^IDevice, guid: ^GUID, pData: ^IUnknown) -> HRESULT,
	GetFeatureLevel:                      proc "system" (this: ^IDevice) -> FEATURE_LEVEL,
	GetCreationFlags:                     proc "system" (this: ^IDevice) -> u32,
	GetDeviceRemovedReason:               proc "system" (this: ^IDevice) -> HRESULT,
	GetImmediateContext:                  proc "system" (this: ^IDevice, ppImmediateContext: ^^IDeviceContext),
	SetExceptionMode:                     proc "system" (this: ^IDevice, RaiseFlags: RAISE_FLAGS) -> HRESULT,
	GetExceptionMode:                     proc "system" (this: ^IDevice) -> u32,
}


CREATE_DEVICE_FLAGS :: distinct bit_set[CREATE_DEVICE_FLAG; u32]
CREATE_DEVICE_FLAG :: enum u32 {
	SINGLETHREADED                                = 0,
	DEBUG                                         = 1,
	SWITCH_TO_REF                                 = 2,
	PREVENT_INTERNAL_THREADING_OPTIMIZATIONS      = 3,
	BGRA_SUPPORT                                  = 5,
	DEBUGGABLE                                    = 6,
	PREVENT_ALTERING_LAYER_SETTINGS_FROM_REGISTRY = 7,
	DISABLE_GPU_TIMEOUT                           = 8,
	VIDEO_SUPPORT                                 = 11,
}

PFN_CREATE_DEVICE :: #type proc "c" (a0: ^dxgi.IAdapter, a1: DRIVER_TYPE, a2: HMODULE, a3: u32, a4: ^FEATURE_LEVEL, a5: u32, a6: u32, a7: ^^IDevice, a8: ^FEATURE_LEVEL, a9: ^^IDeviceContext) -> HRESULT
PFN_CREATE_DEVICE_AND_SWAP_CHAIN :: #type proc "c" (a0: ^dxgi.IAdapter, a1: DRIVER_TYPE, a2: HMODULE, a3: u32, a4: ^FEATURE_LEVEL, a5: u32, a6: u32, a7: ^dxgi.SWAP_CHAIN_DESC, a8: ^^dxgi.ISwapChain, a9: ^^IDevice, a10: ^FEATURE_LEVEL, a11: ^^IDeviceContext) -> HRESULT

SHADER_VERSION_TYPE :: enum i32 {
	PIXEL_SHADER    = 0,
	VERTEX_SHADER   = 1,
	GEOMETRY_SHADER = 2,

	HULL_SHADER     = 3,
	DOMAIN_SHADER   = 4,
	COMPUTE_SHADER  = 5,

	RESERVED0       = 65520,
}

SIGNATURE_PARAMETER_DESC :: struct {
	SemanticName:    cstring,
	SemanticIndex:   u32,
	Register:        u32,
	SystemValueType: NAME,
	ComponentType:   REGISTER_COMPONENT_TYPE,
	Mask:            u8,

	ReadWriteMask:   u8,

	Stream:          u32,
	MinPrecision:    MIN_PRECISION,
}

SHADER_BUFFER_DESC :: struct {
	Name:      cstring,
	Type:      CBUFFER_TYPE,
	Variables: u32,
	Size:      u32,
	uFlags:    SHADER_CBUFFER_FLAGS,
}

SHADER_VARIABLE_DESC :: struct {
	Name:         cstring,
	StartOffset:  u32,
	Size:         u32,
	uFlags:       SHADER_VARIABLE_FLAGS,
	DefaultValue: rawptr,
	StartTexture: u32,
	TextureSize:  u32,
	StartSampler: u32,
	SamplerSize:  u32,
}

SHADER_TYPE_DESC :: struct {
	Class:    SHADER_VARIABLE_CLASS,
	Type:     SHADER_VARIABLE_TYPE,
	Rows:     u32,
	Columns:  u32,
	Elements: u32,
	Members:  u32,
	Offset:   u32,
	Name:     cstring,
}

SHADER_DESC :: struct {
	Version:                     u32,
	Creator:                     cstring,
	Flags:                       u32,

	ConstantBuffers:             u32,
	BoundResources:              u32,
	InputParameters:             u32,
	OutputParameters:            u32,

	InstructionCount:            u32,
	TempRegisterCount:           u32,
	TempArrayCount:              u32,
	DefCount:                    u32,
	DclCount:                    u32,
	TextureNormalInstructions:   u32,
	TextureLoadInstructions:     u32,
	TextureCompInstructions:     u32,
	TextureBiasInstructions:     u32,
	TextureGradientInstructions: u32,
	FloatInstructionCount:       u32,
	IntInstructionCount:         u32,
	UintInstructionCount:        u32,
	StaticFlowControlCount:      u32,
	DynamicFlowControlCount:     u32,
	MacroInstructionCount:       u32,
	ArrayInstructionCount:       u32,
	CutInstructionCount:         u32,
	EmitInstructionCount:        u32,
	GSOutputTopology:            PRIMITIVE_TOPOLOGY,
	GSMaxOutputVertexCount:      u32,
	InputPrimitive:              PRIMITIVE,
	PatchConstantParameters:     u32,
	cGSInstanceCount:            u32,
	cControlPoints:              u32,
	HSOutputPrimitive:           TESSELLATOR_OUTPUT_PRIMITIVE,
	HSPartitioning:              TESSELLATOR_PARTITIONING,
	TessellatorDomain:           TESSELLATOR_DOMAIN,

	cBarrierInstructions:        u32,
	cInterlockedInstructions:    u32,
	cTextureStoreInstructions:   u32,
}

SHADER_INPUT_BIND_DESC :: struct {
	Name:       cstring,
	Type:       SHADER_INPUT_TYPE,
	BindPoint:  u32,
	BindCount:  u32,

	uFlags:     SHADER_INPUT_FLAGS,
	ReturnType: RESOURCE_RETURN_TYPE,
	Dimension:  SRV_DIMENSION,
	NumSamples: u32,
}

LIBRARY_DESC :: struct {
	Creator:       cstring,
	Flags:         u32,
	FunctionCount: u32,
}

FUNCTION_DESC :: struct {
	Version:                     u32,
	Creator:                     cstring,
	Flags:                       u32,

	ConstantBuffers:             u32,
	BoundResources:              u32,

	InstructionCount:            u32,
	TempRegisterCount:           u32,
	TempArrayCount:              u32,
	DefCount:                    u32,
	DclCount:                    u32,
	TextureNormalInstructions:   u32,
	TextureLoadInstructions:     u32,
	TextureCompInstructions:     u32,
	TextureBiasInstructions:     u32,
	TextureGradientInstructions: u32,
	FloatInstructionCount:       u32,
	IntInstructionCount:         u32,
	UintInstructionCount:        u32,
	StaticFlowControlCount:      u32,
	DynamicFlowControlCount:     u32,
	MacroInstructionCount:       u32,
	ArrayInstructionCount:       u32,
	MovInstructionCount:         u32,
	MovcInstructionCount:        u32,
	ConversionInstructionCount:  u32,
	BitwiseInstructionCount:     u32,
	MinFeatureLevel:             FEATURE_LEVEL,
	RequiredFeatureFlags:        SHADER_REQUIRES_FLAGS,

	Name:                        cstring,
	FunctionParameterCount:      i32,
	HasReturn:                   BOOL,
	Has10Level9VertexShader:     BOOL,
	Has10Level9PixelShader:      BOOL,
}

PARAMETER_DESC :: struct {
	Name:              cstring,
	SemanticName:      cstring,
	Type:              SHADER_VARIABLE_TYPE,
	Class:             SHADER_VARIABLE_CLASS,
	Rows:              u32,
	Columns:           u32,
	InterpolationMode: INTERPOLATION_MODE,
	Flags:             PARAMETER_FLAGS,

	FirstInRegister:   u32,
	FirstInComponent:  u32,
	FirstOutRegister:  u32,
	FirstOutComponent: u32,
}

ID3D11ShaderReflectionType_UUID_STRING :: "6E6FFA6A-9BAE-4613-A51E-91652D508C21"
ID3D11ShaderReflectionType_UUID := &IID{0x6E6FFA6A, 0x9BAE, 0x4613, {0xA5, 0x1E, 0x91, 0x65, 0x2D, 0x50, 0x8C, 0x21}}
IShaderReflectionType :: struct {
	using vtable: ^IShaderReflectionType_VTable,
}
IShaderReflectionType_VTable :: struct {
	GetDesc:              proc "system" (this: ^IShaderReflectionType, pDesc: ^SHADER_TYPE_DESC) -> HRESULT,
	GetMemberTypeByIndex: proc "system" (this: ^IShaderReflectionType, Index: u32) -> ^IShaderReflectionType,
	GetMemberTypeByName:  proc "system" (this: ^IShaderReflectionType, Name: cstring) -> ^IShaderReflectionType,
	GetMemberTypeName:    proc "system" (this: ^IShaderReflectionType, Index: u32) -> cstring,
	IsEqual:              proc "system" (this: ^IShaderReflectionType, pType: ^IShaderReflectionType) -> HRESULT,
	GetSubType:           proc "system" (this: ^IShaderReflectionType) -> ^IShaderReflectionType,
	GetBaseClass:         proc "system" (this: ^IShaderReflectionType) -> ^IShaderReflectionType,
	GetNumInterfaces:     proc "system" (this: ^IShaderReflectionType) -> u32,
	GetInterfaceByIndex:  proc "system" (this: ^IShaderReflectionType, uIndex: u32) -> ^IShaderReflectionType,
	IsOfType:             proc "system" (this: ^IShaderReflectionType, pType: ^IShaderReflectionType) -> HRESULT,
	ImplementsInterface:  proc "system" (this: ^IShaderReflectionType, pBase: ^IShaderReflectionType) -> HRESULT,
}

ID3D11ShaderReflectionVariable_UUID_STRING :: "51F23923-F3E5-4BD1-91CB-606177D8DB4C"
ID3D11ShaderReflectionVariable_UUID := &IID{0x51F23923, 0xF3E5, 0x4BD1, {0x91, 0xCB, 0x60, 0x61, 0x77, 0xD8, 0xDB, 0x4C}}
IShaderReflectionVariable :: struct {
	using vtable: ^IShaderReflectionVariable_VTable,
}
IShaderReflectionVariable_VTable :: struct {
	GetDesc:          proc "system" (this: ^IShaderReflectionVariable, pDesc: ^SHADER_VARIABLE_DESC) -> HRESULT,
	GetType:          proc "system" (this: ^IShaderReflectionVariable) -> ^IShaderReflectionType,
	GetBuffer:        proc "system" (this: ^IShaderReflectionVariable) -> ^IShaderReflectionConstantBuffer,
	GetInterfaceSlot: proc "system" (this: ^IShaderReflectionVariable, uArrayIndex: u32) -> u32,
}

ID3D11ShaderReflectionConstantBuffer_UUID_STRING :: "EB62D63D-93DD-4318-8AE8-C6F83AD371B8"
ID3D11ShaderReflectionConstantBuffer_UUID := &IID{0xEB62D63D, 0x93DD, 0x4318, {0x8A, 0xE8, 0xC6, 0xF8, 0x3A, 0xD3, 0x71, 0xB8}}
IShaderReflectionConstantBuffer :: struct {
	using vtable: ^IShaderReflectionConstantBuffer_VTable,
}
IShaderReflectionConstantBuffer_VTable :: struct {
	GetDesc: proc "system" (this: ^IShaderReflectionConstantBuffer, pDesc: ^SHADER_BUFFER_DESC) -> HRESULT,
	GetVariableByIndex: proc "system" (this: ^IShaderReflectionConstantBuffer, Index: u32) -> ^IShaderReflectionVariable,
	GetVariableByName: proc "system" (this: ^IShaderReflectionConstantBuffer, Name: cstring) -> ^IShaderReflectionVariable,
}


ID3D11ShaderReflection_UUID_STRING :: "8D536CA1-0CCA-4956-A837-786963755584"
ID3D11ShaderReflection_UUID := &IID{0x8D536CA1, 0x0CCA, 0x4956, {0xA8, 0x37, 0x78, 0x69, 0x63, 0x75, 0x55, 0x84}}
IShaderReflection :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11shaderreflection_vtable: ^IShaderReflection_VTable,
}
IShaderReflection_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	GetDesc:                       proc "system" (this: ^IShaderReflection, pDesc: ^SHADER_DESC) -> HRESULT,
	GetConstantBufferByIndex:      proc "system" (this: ^IShaderReflection, Index: u32) -> ^IShaderReflectionConstantBuffer,
	GetConstantBufferByName:       proc "system" (this: ^IShaderReflection, Name: cstring) -> ^IShaderReflectionConstantBuffer,
	GetResourceBindingDesc:        proc "system" (this: ^IShaderReflection, ResourceIndex: u32, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetInputParameterDesc:         proc "system" (this: ^IShaderReflection, ParameterIndex: u32, pDesc: ^SIGNATURE_PARAMETER_DESC) -> HRESULT,
	GetOutputParameterDesc:        proc "system" (this: ^IShaderReflection, ParameterIndex: u32, pDesc: ^SIGNATURE_PARAMETER_DESC) -> HRESULT,
	GetPatchConstantParameterDesc: proc "system" (this: ^IShaderReflection, ParameterIndex: u32, pDesc: ^SIGNATURE_PARAMETER_DESC) -> HRESULT,
	GetVariableByName:             proc "system" (this: ^IShaderReflection, Name: cstring) -> ^IShaderReflectionVariable,
	GetResourceBindingDescByName:  proc "system" (this: ^IShaderReflection, Name: cstring, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetMovInstructionCount:        proc "system" (this: ^IShaderReflection) -> u32,
	GetMovcInstructionCount:       proc "system" (this: ^IShaderReflection) -> u32,
	GetConversionInstructionCount: proc "system" (this: ^IShaderReflection) -> u32,
	GetBitwiseInstructionCount:    proc "system" (this: ^IShaderReflection) -> u32,
	GetGSInputPrimitive:           proc "system" (this: ^IShaderReflection) -> PRIMITIVE,
	IsSampleFrequencyShader:       proc "system" (this: ^IShaderReflection) -> BOOL,
	GetNumInterfaceSlots:          proc "system" (this: ^IShaderReflection) -> u32,
	GetMinFeatureLevel:            proc "system" (this: ^IShaderReflection, pLevel: ^FEATURE_LEVEL) -> HRESULT,
	GetThreadGroupSize:            proc "system" (this: ^IShaderReflection, pSizeX: ^u32, pSizeY: ^u32, pSizeZ: ^u32) -> u32,
	GetRequiresFlags:              proc "system" (this: ^IShaderReflection) -> SHADER_REQUIRES_FLAGS,
}


ID3D11LibraryReflection_UUID_STRING :: "54384F1B-5B3E-4BB7-AE01-60BA3097CBB6"
ID3D11LibraryReflection_UUID := &IID{0x54384F1B, 0x5B3E, 0x4BB7, {0xAE, 0x1, 0x60, 0xBA, 0x30, 0x97, 0xCD, 0xB6}}
ILibraryReflection :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11libraryreflection_vtable: ^ILibraryReflection_VTable,
}
ILibraryReflection_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	GetDesc:            proc "system" (this: ^ILibraryReflection, pDesc: ^LIBRARY_DESC) -> HRESULT,
	GetFunctionByIndex: proc "system" (this: ^ILibraryReflection, FunctionIndex: i32) -> ^IFunctionReflection,
}

ID3D11FunctionReflection_UUID_STRING :: "207BCECB-D683-4A06-A8A3-9B149B9F73A4"
ID3D11FunctionReflection_UUID := &IID{0x207BCECB, 0xD683, 0x4A06, {0xA8, 0xA3, 0x9B, 0x14, 0x9B, 0x9F, 0x73, 0xA4}}
IFunctionReflection :: struct {
	using vtable: ^IFunctionReflection_VTable,
}
IFunctionReflection_VTable :: struct {
	GetDesc:                      proc "system" (this: ^IFunctionReflection, pDesc: ^FUNCTION_DESC) -> HRESULT,
	GetConstantBufferByIndex:     proc "system" (this: ^IFunctionReflection, BufferIndex: u32) -> ^IShaderReflectionConstantBuffer,
	GetConstantBufferByName:      proc "system" (this: ^IFunctionReflection, Name: cstring) -> ^IShaderReflectionConstantBuffer,
	GetResourceBindingDesc:       proc "system" (this: ^IFunctionReflection, ResourceIndex: u32, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetVariableByName:            proc "system" (this: ^IFunctionReflection, Name: cstring) -> ^IShaderReflectionVariable,
	GetResourceBindingDescByName: proc "system" (this: ^IFunctionReflection, Name: cstring, pDesc: ^SHADER_INPUT_BIND_DESC) -> HRESULT,
	GetFunctionParameter:         proc "system" (this: ^IFunctionReflection, ParameterIndex: i32) -> ^IFunctionParameterReflection,
}

ID3D11FunctionParameterReflection_UUID_STRING :: "42757488-334F-47FE-982E-1A65D08CC462"
ID3D11FunctionParameterReflection_UUID := &IID{0x42757488, 0x334f, 0x47FE, {0x98, 0x2E, 0x1A, 0x65, 0xD0, 0x8C, 0xC4, 0x62}}
IFunctionParameterReflection :: struct {
	using vtable: ^IFunctionParameterReflection_VTable,
}
IFunctionParameterReflection_VTable :: struct {
	GetDesc: proc "system" (this: ^IFunctionParameterReflection, pDesc: ^PARAMETER_DESC) -> HRESULT,
}


ILinkingNode :: struct {
	using iunknown: IUnknown,
}

IFunctionLinkingGraph :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11functionlinkinggraph_vtable: ^IFunctionLinkingGraph_VTable,
}
IFunctionLinkingGraph_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	CreateModuleInstance: proc "system" (this: ^IFunctionLinkingGraph, ppModuleInstance: ^^IModuleInstance, ppErrorBuffer: ^^IBlob) -> HRESULT,
	SetInputSignature:    proc "system" (this: ^IFunctionLinkingGraph, pInputParameters: [^]PARAMETER_DESC, cInputParameters: u32, ppInputNode: ^^ILinkingNode) -> HRESULT,
	SetOutputSignature:   proc "system" (this: ^IFunctionLinkingGraph, pOutputParameters: [^]PARAMETER_DESC, cOutputParameters: u32, ppOutputNode: ^^ILinkingNode) -> HRESULT,
	CallFunction:         proc "system" (this: ^IFunctionLinkingGraph, pModuleInstanceNamespace: cstring, pModuleWithFunctionPrototype: ^IModule, pFunctionName: cstring, ppCallNode: ^^ILinkingNode) -> HRESULT,
	PassValue:            proc "system" (this: ^IFunctionLinkingGraph, pSrcNode: ^ILinkingNode, SrcParameterIndex: i32, pDstNode: ^ILinkingNode, DstParameterIndex: i32) -> HRESULT,
	PassValueWithSwizzle: proc "system" (this: ^IFunctionLinkingGraph, pSrcNode: ^ILinkingNode, SrcParameterIndex: i32, pSrcSwizzle: ^u8, pDstNode: ^ILinkingNode, DstParameterIndex: i32, pDstSwizzle: ^u8) -> HRESULT,
	GetLastError:         proc "system" (this: ^IFunctionLinkingGraph, ppErrorBuffer: ^^IBlob) -> HRESULT,
	GenerateHlsl:         proc "system" (this: ^IFunctionLinkingGraph, uFlags: u32, ppBuffer: ^^IBlob) -> HRESULT,
}

IDebug_UUID_STRING :: "79CF2233-7536-4948-9D36-1E4692DC5760"
IDebug_UUID := &IID{0x79CF2233, 0x7536, 0x4948, {0x9D, 0x36, 0x1E, 0x46, 0x92, 0xDC, 0x57, 0x60}}

IDebug :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11debug_vtable: ^IDebug_VTable,
}

RLDO_FLAGS :: distinct bit_set[RLDO_FLAG; u32]
RLDO_FLAG :: enum u32 {
	SUMMARY = 0,
	DETAIL = 1,
	IGNORE_INTERNAL = 2,
}

DEBUG_FEATURES :: distinct bit_set[DEBUG_FEATURE; u32]
DEBUG_FEATURE :: enum u32 {
	FLUSH_PER_RENDER_OP = 0,
	FINISH_PER_RENDER_OP = 1,
	FEATURE_PRESENT_PER_RENDER_OP = 2,
}

IDebug_VTable :: struct {
	using iunkown_vtable: IUnknown_VTable,
	SetFeatureMask:             proc "system" (this: ^IDebug, mask: DEBUG_FEATURES) -> HRESULT,
	GetFeatureMask:             proc "system" (this: ^IDebug) -> DEBUG_FEATURES,
	SetPresentPerRenderOpDelay: proc "system" (this: ^IDebug, Milliseconds: u32) -> HRESULT,
	GetPresentPerRenderOpDelay: proc "system" (this: ^IDebug) -> u32,
	SetSwapChain:               proc "system" (this: ^IDebug, pSwapChain: ^dxgi.ISwapChain) -> HRESULT,
	GetSwapChain:               proc "system" (this: ^IDebug, ppSwapChain: ^^dxgi.ISwapChain) -> HRESULT,
	ValidateContext:            proc "system" (this: ^IDebug, pContext: ^IDeviceContext) -> HRESULT,
	ReportLiveDeviceObjects:    proc "system" (this: ^IDebug, Flags: RLDO_FLAGS) -> HRESULT,
	ValidateContextForDispatch: proc "system" (this: ^IDebug, pContext: ^IDeviceContext) -> HRESULT,
}

IInfoQueue_UUID_STRING :: "6543DBB6-1B48-42F5-AB82-E97EC74326F6"
IInfoQueue_UUID := &IID{0x6543DBB6, 0x1B48, 0x42F5, {0xAB, 0x82, 0xE9, 0x7E, 0xC7, 0x43, 0x26, 0xF6}}

IInfoQueue :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using id3d11infoqueue_vtable: ^IInfoQueue_VTable,
}

MESSAGE_SEVERITY :: enum u32 {
	CORRUPTION = 0,
	ERROR,
	WARNING,
	INFO,
	MESSAGE, // Not supported until D3D 11.1
}

MESSAGE_CATEGORY :: enum u32 {
	APPLICATION_DEFINED = 0,
	MISCELLANEOUS,
	INITIALIZATION,
	CLEANUP,
	COMPILATION,
	STATE_CREATION,
	STATE_SETTING,
	STATE_GETTING,
	RESOURCE_MANIPULATION,
	EXECUTION,
	SHADER, // Not supported until D3D 11.1
}

INFO_QUEUE_FILTER_DESC :: struct {
	NumCategories:    u32,
	pCategoryList:    ^MESSAGE_CATEGORY,

	NumSeverities:    u32,
	pSeverityList:    ^MESSAGE_SEVERITY,

	NumIDs:           u32,
	pIDList:          ^MESSAGE_ID,
}

INFO_QUEUE_FILTER :: struct {
	AllowList:  INFO_QUEUE_FILTER_DESC,
	DenyList:   INFO_QUEUE_FILTER_DESC,
}

MESSAGE :: struct {
	Category:              MESSAGE_CATEGORY,
	Severity:              MESSAGE_SEVERITY,
	ID:                    MESSAGE_ID,
	pDescription:          cstring,
	DescriptionByteLength: SIZE_T,
}

IInfoQueue_VTable :: struct {
	using iunkown_vtable: IUnknown_VTable,
	SetMessageCountLimit:                         proc "system" (this: ^IInfoQueue, MessageCountLimit: u64) -> HRESULT,
	ClearStoredMessages:                          proc "system" (this: ^IInfoQueue),
	GetMessage:                                   proc "system" (this: ^IInfoQueue, MessageIndex: u64, pMessage: ^MESSAGE, pMessageByteLength: ^SIZE_T) -> HRESULT,
	GetNumMessagesAllowedByStorageFilter:         proc "system" (this: ^IInfoQueue) -> u64,
	GetNumMessagesDeniedByStorageFilter:          proc "system" (this: ^IInfoQueue) -> u64,
	GetNumStoredMessages:                         proc "system" (this: ^IInfoQueue) -> u64,
	GetNumStoredMessagesAllowedByRetrievalFilter: proc "system" (this: ^IInfoQueue) -> u64,
	GetNumMessagesDiscardedByMessageCountLimit:   proc "system" (this: ^IInfoQueue) -> u64,
	GetMessageCountLimit:                         proc "system" (this: ^IInfoQueue) -> u64,
	AddStorageFilterEntries:                      proc "system" (this: ^IInfoQueue, pFilter: ^INFO_QUEUE_FILTER) -> HRESULT,
	GetStorageFilter:                             proc "system" (this: ^IInfoQueue, pFilter: ^INFO_QUEUE_FILTER, pFilterByteLength: ^SIZE_T) -> HRESULT,
	ClearStorageFilter:                           proc "system" (this: ^IInfoQueue),
	PushEmptyStorageFilter:                       proc "system" (this: ^IInfoQueue) -> HRESULT,
	PushCopyOfStorageFilter:                      proc "system" (this: ^IInfoQueue) -> HRESULT,
	PushStorageFilter:                            proc "system" (this: ^IInfoQueue, pFilter: ^INFO_QUEUE_FILTER) -> HRESULT,
	PopStorageFilter:                             proc "system" (this: ^IInfoQueue),
	GetStorageFilterStackSize:                    proc "system" (this: ^IInfoQueue) -> u64,
	AddRetrievalFilterEntries:                    proc "system" (this: ^IInfoQueue, pFilter: ^INFO_QUEUE_FILTER) -> HRESULT,
	GetRetrievalFilter:                           proc "system" (this: ^IInfoQueue, pFilter: ^INFO_QUEUE_FILTER, pFilterByteLength: ^SIZE_T) -> HRESULT,
	ClearRetrievalFilter:                         proc "system" (this: ^IInfoQueue),
	PushEmptyRetrievalFilter:                     proc "system" (this: ^IInfoQueue) -> HRESULT,
	PushCopyOfRetrievalFilter:                    proc "system" (this: ^IInfoQueue) -> HRESULT,
	PushRetrievalFilter:                          proc "system" (this: ^IInfoQueue, pFilter: ^INFO_QUEUE_FILTER) -> HRESULT,
	PopRetrievalFilter:                           proc "system" (this: ^IInfoQueue),
	GetRetrievalFilterStackSize:                  proc "system" (this: ^IInfoQueue) -> u64,
	AddMessage:                                   proc "system" (this: ^IInfoQueue, Category: MESSAGE_CATEGORY, Severity: MESSAGE_SEVERITY, ID: MESSAGE_ID, pDescription: cstring) -> HRESULT,
	AddApplicationMessage:                        proc "system" (this: ^IInfoQueue, Severity: MESSAGE_SEVERITY, pDescription: cstring) -> HRESULT,
	SetBreakOnCategory:                           proc "system" (this: ^IInfoQueue, Category: MESSAGE_CATEGORY, bEnable: BOOL) -> HRESULT,
	SetBreakOnSeverity:                           proc "system" (this: ^IInfoQueue, Severity: MESSAGE_SEVERITY, bEnable: BOOL) -> HRESULT,
	SetBreakOnID:                                 proc "system" (this: ^IInfoQueue, ID: MESSAGE_ID, bEnable: BOOL) -> HRESULT,
	GetBreakOnCategory:                           proc "system" (this: ^IInfoQueue, Category: MESSAGE_CATEGORY) -> BOOL,
	GetBreakOnSeverity:                           proc "system" (this: ^IInfoQueue, Severity: MESSAGE_SEVERITY) -> BOOL,
	GetBreakOnID:                                 proc "system" (this: ^IInfoQueue, ID: MESSAGE_ID) -> BOOL,
	SetMuteDebugOutput:                           proc "system" (this: ^IInfoQueue, bMute: BOOL),
	GetMuteDebugOutput:                           proc "system" (this: ^IInfoQueue) -> BOOL,
}

MESSAGE_ID :: enum u32 {
	UNKNOWN = 0,
	DEVICE_IASETVERTEXBUFFERS_HAZARD,
	DEVICE_IASETINDEXBUFFER_HAZARD,
	DEVICE_VSSETSHADERRESOURCES_HAZARD,
	DEVICE_VSSETCONSTANTBUFFERS_HAZARD,
	DEVICE_GSSETSHADERRESOURCES_HAZARD,
	DEVICE_GSSETCONSTANTBUFFERS_HAZARD,
	DEVICE_PSSETSHADERRESOURCES_HAZARD,
	DEVICE_PSSETCONSTANTBUFFERS_HAZARD,
	DEVICE_OMSETRENDERTARGETS_HAZARD,
	DEVICE_SOSETTARGETS_HAZARD,
	STRING_FROM_APPLICATION,
	CORRUPTED_THIS,
	CORRUPTED_PARAMETER1,
	CORRUPTED_PARAMETER2,
	CORRUPTED_PARAMETER3,
	CORRUPTED_PARAMETER4,
	CORRUPTED_PARAMETER5,
	CORRUPTED_PARAMETER6,
	CORRUPTED_PARAMETER7,
	CORRUPTED_PARAMETER8,
	CORRUPTED_PARAMETER9,
	CORRUPTED_PARAMETER10,
	CORRUPTED_PARAMETER11,
	CORRUPTED_PARAMETER12,
	CORRUPTED_PARAMETER13,
	CORRUPTED_PARAMETER14,
	CORRUPTED_PARAMETER15,
	CORRUPTED_MULTITHREADING,
	MESSAGE_REPORTING_OUTOFMEMORY,
	IASETINPUTLAYOUT_UNBINDDELETINGOBJECT,
	IASETVERTEXBUFFERS_UNBINDDELETINGOBJECT,
	IASETINDEXBUFFER_UNBINDDELETINGOBJECT,
	VSSETSHADER_UNBINDDELETINGOBJECT,
	VSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	VSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	VSSETSAMPLERS_UNBINDDELETINGOBJECT,
	GSSETSHADER_UNBINDDELETINGOBJECT,
	GSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	GSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	GSSETSAMPLERS_UNBINDDELETINGOBJECT,
	SOSETTARGETS_UNBINDDELETINGOBJECT,
	PSSETSHADER_UNBINDDELETINGOBJECT,
	PSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	PSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	PSSETSAMPLERS_UNBINDDELETINGOBJECT,
	RSSETSTATE_UNBINDDELETINGOBJECT,
	OMSETBLENDSTATE_UNBINDDELETINGOBJECT,
	OMSETDEPTHSTENCILSTATE_UNBINDDELETINGOBJECT,
	OMSETRENDERTARGETS_UNBINDDELETINGOBJECT,
	SETPREDICATION_UNBINDDELETINGOBJECT,
	GETPRIVATEDATA_MOREDATA,
	SETPRIVATEDATA_INVALIDFREEDATA,
	SETPRIVATEDATA_INVALIDIUNKNOWN,
	SETPRIVATEDATA_INVALIDFLAGS,
	SETPRIVATEDATA_CHANGINGPARAMS,
	SETPRIVATEDATA_OUTOFMEMORY,
	CREATEBUFFER_UNRECOGNIZEDFORMAT,
	CREATEBUFFER_INVALIDSAMPLES,
	CREATEBUFFER_UNRECOGNIZEDUSAGE,
	CREATEBUFFER_UNRECOGNIZEDBINDFLAGS,
	CREATEBUFFER_UNRECOGNIZEDCPUACCESSFLAGS,
	CREATEBUFFER_UNRECOGNIZEDMISCFLAGS,
	CREATEBUFFER_INVALIDCPUACCESSFLAGS,
	CREATEBUFFER_INVALIDBINDFLAGS,
	CREATEBUFFER_INVALIDINITIALDATA,
	CREATEBUFFER_INVALIDDIMENSIONS,
	CREATEBUFFER_INVALIDMIPLEVELS,
	CREATEBUFFER_INVALIDMISCFLAGS,
	CREATEBUFFER_INVALIDARG_RETURN,
	CREATEBUFFER_OUTOFMEMORY_RETURN,
	CREATEBUFFER_NULLDESC,
	CREATEBUFFER_INVALIDCONSTANTBUFFERBINDINGS,
	CREATEBUFFER_LARGEALLOCATION,
	CREATETEXTURE1D_UNRECOGNIZEDFORMAT,
	CREATETEXTURE1D_UNSUPPORTEDFORMAT,
	CREATETEXTURE1D_INVALIDSAMPLES,
	CREATETEXTURE1D_UNRECOGNIZEDUSAGE,
	CREATETEXTURE1D_UNRECOGNIZEDBINDFLAGS,
	CREATETEXTURE1D_UNRECOGNIZEDCPUACCESSFLAGS,
	CREATETEXTURE1D_UNRECOGNIZEDMISCFLAGS,
	CREATETEXTURE1D_INVALIDCPUACCESSFLAGS,
	CREATETEXTURE1D_INVALIDBINDFLAGS,
	CREATETEXTURE1D_INVALIDINITIALDATA,
	CREATETEXTURE1D_INVALIDDIMENSIONS,
	CREATETEXTURE1D_INVALIDMIPLEVELS,
	CREATETEXTURE1D_INVALIDMISCFLAGS,
	CREATETEXTURE1D_INVALIDARG_RETURN,
	CREATETEXTURE1D_OUTOFMEMORY_RETURN,
	CREATETEXTURE1D_NULLDESC,
	CREATETEXTURE1D_LARGEALLOCATION,
	CREATETEXTURE2D_UNRECOGNIZEDFORMAT,
	CREATETEXTURE2D_UNSUPPORTEDFORMAT,
	CREATETEXTURE2D_INVALIDSAMPLES,
	CREATETEXTURE2D_UNRECOGNIZEDUSAGE,
	CREATETEXTURE2D_UNRECOGNIZEDBINDFLAGS,
	CREATETEXTURE2D_UNRECOGNIZEDCPUACCESSFLAGS,
	CREATETEXTURE2D_UNRECOGNIZEDMISCFLAGS,
	CREATETEXTURE2D_INVALIDCPUACCESSFLAGS,
	CREATETEXTURE2D_INVALIDBINDFLAGS,
	CREATETEXTURE2D_INVALIDINITIALDATA,
	CREATETEXTURE2D_INVALIDDIMENSIONS,
	CREATETEXTURE2D_INVALIDMIPLEVELS,
	CREATETEXTURE2D_INVALIDMISCFLAGS,
	CREATETEXTURE2D_INVALIDARG_RETURN,
	CREATETEXTURE2D_OUTOFMEMORY_RETURN,
	CREATETEXTURE2D_NULLDESC,
	CREATETEXTURE2D_LARGEALLOCATION,
	CREATETEXTURE3D_UNRECOGNIZEDFORMAT,
	CREATETEXTURE3D_UNSUPPORTEDFORMAT,
	CREATETEXTURE3D_INVALIDSAMPLES,
	CREATETEXTURE3D_UNRECOGNIZEDUSAGE,
	CREATETEXTURE3D_UNRECOGNIZEDBINDFLAGS,
	CREATETEXTURE3D_UNRECOGNIZEDCPUACCESSFLAGS,
	CREATETEXTURE3D_UNRECOGNIZEDMISCFLAGS,
	CREATETEXTURE3D_INVALIDCPUACCESSFLAGS,
	CREATETEXTURE3D_INVALIDBINDFLAGS,
	CREATETEXTURE3D_INVALIDINITIALDATA,
	CREATETEXTURE3D_INVALIDDIMENSIONS,
	CREATETEXTURE3D_INVALIDMIPLEVELS,
	CREATETEXTURE3D_INVALIDMISCFLAGS,
	CREATETEXTURE3D_INVALIDARG_RETURN,
	CREATETEXTURE3D_OUTOFMEMORY_RETURN,
	CREATETEXTURE3D_NULLDESC,
	CREATETEXTURE3D_LARGEALLOCATION,
	CREATESHADERRESOURCEVIEW_UNRECOGNIZEDFORMAT,
	CREATESHADERRESOURCEVIEW_INVALIDDESC,
	CREATESHADERRESOURCEVIEW_INVALIDFORMAT,
	CREATESHADERRESOURCEVIEW_INVALIDDIMENSIONS,
	CREATESHADERRESOURCEVIEW_INVALIDRESOURCE,
	CREATESHADERRESOURCEVIEW_TOOMANYOBJECTS,
	CREATESHADERRESOURCEVIEW_INVALIDARG_RETURN,
	CREATESHADERRESOURCEVIEW_OUTOFMEMORY_RETURN,
	CREATERENDERTARGETVIEW_UNRECOGNIZEDFORMAT,
	CREATERENDERTARGETVIEW_UNSUPPORTEDFORMAT,
	CREATERENDERTARGETVIEW_INVALIDDESC,
	CREATERENDERTARGETVIEW_INVALIDFORMAT,
	CREATERENDERTARGETVIEW_INVALIDDIMENSIONS,
	CREATERENDERTARGETVIEW_INVALIDRESOURCE,
	CREATERENDERTARGETVIEW_TOOMANYOBJECTS,
	CREATERENDERTARGETVIEW_INVALIDARG_RETURN,
	CREATERENDERTARGETVIEW_OUTOFMEMORY_RETURN,
	CREATEDEPTHSTENCILVIEW_UNRECOGNIZEDFORMAT,
	CREATEDEPTHSTENCILVIEW_INVALIDDESC,
	CREATEDEPTHSTENCILVIEW_INVALIDFORMAT,
	CREATEDEPTHSTENCILVIEW_INVALIDDIMENSIONS,
	CREATEDEPTHSTENCILVIEW_INVALIDRESOURCE,
	CREATEDEPTHSTENCILVIEW_TOOMANYOBJECTS,
	CREATEDEPTHSTENCILVIEW_INVALIDARG_RETURN,
	CREATEDEPTHSTENCILVIEW_OUTOFMEMORY_RETURN,
	CREATEINPUTLAYOUT_OUTOFMEMORY,
	CREATEINPUTLAYOUT_TOOMANYELEMENTS,
	CREATEINPUTLAYOUT_INVALIDFORMAT,
	CREATEINPUTLAYOUT_INCOMPATIBLEFORMAT,
	CREATEINPUTLAYOUT_INVALIDSLOT,
	CREATEINPUTLAYOUT_INVALIDINPUTSLOTCLASS,
	CREATEINPUTLAYOUT_STEPRATESLOTCLASSMISMATCH,
	CREATEINPUTLAYOUT_INVALIDSLOTCLASSCHANGE,
	CREATEINPUTLAYOUT_INVALIDSTEPRATECHANGE,
	CREATEINPUTLAYOUT_INVALIDALIGNMENT,
	CREATEINPUTLAYOUT_DUPLICATESEMANTIC,
	CREATEINPUTLAYOUT_UNPARSEABLEINPUTSIGNATURE,
	CREATEINPUTLAYOUT_NULLSEMANTIC,
	CREATEINPUTLAYOUT_MISSINGELEMENT,
	CREATEINPUTLAYOUT_NULLDESC,
	CREATEVERTEXSHADER_OUTOFMEMORY,
	CREATEVERTEXSHADER_INVALIDSHADERBYTECODE,
	CREATEVERTEXSHADER_INVALIDSHADERTYPE,
	CREATEGEOMETRYSHADER_OUTOFMEMORY,
	CREATEGEOMETRYSHADER_INVALIDSHADERBYTECODE,
	CREATEGEOMETRYSHADER_INVALIDSHADERTYPE,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTOFMEMORY,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERBYTECODE,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSHADERTYPE,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMENTRIES,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSTREAMSTRIDEUNUSED,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDDECL,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_EXPECTEDDECL,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_OUTPUTSLOT0EXPECTED,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSLOT,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_ONLYONEELEMENTPERSLOT,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCOMPONENTCOUNT,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTARTCOMPONENTANDCOMPONENTCOUNT,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDGAPDEFINITION,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_REPEATEDOUTPUT,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDOUTPUTSTREAMSTRIDE,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGSEMANTIC,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MASKMISMATCH,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_CANTHAVEONLYGAPS,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DECLTOOCOMPLEX,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_MISSINGOUTPUTSIGNATURE,
	CREATEPIXELSHADER_OUTOFMEMORY,
	CREATEPIXELSHADER_INVALIDSHADERBYTECODE,
	CREATEPIXELSHADER_INVALIDSHADERTYPE,
	CREATERASTERIZERSTATE_INVALIDFILLMODE,
	CREATERASTERIZERSTATE_INVALIDCULLMODE,
	CREATERASTERIZERSTATE_INVALIDDEPTHBIASCLAMP,
	CREATERASTERIZERSTATE_INVALIDSLOPESCALEDDEPTHBIAS,
	CREATERASTERIZERSTATE_TOOMANYOBJECTS,
	CREATERASTERIZERSTATE_NULLDESC,
	CREATEDEPTHSTENCILSTATE_INVALIDDEPTHWRITEMASK,
	CREATEDEPTHSTENCILSTATE_INVALIDDEPTHFUNC,
	CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFAILOP,
	CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILZFAILOP,
	CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILPASSOP,
	CREATEDEPTHSTENCILSTATE_INVALIDFRONTFACESTENCILFUNC,
	CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFAILOP,
	CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILZFAILOP,
	CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILPASSOP,
	CREATEDEPTHSTENCILSTATE_INVALIDBACKFACESTENCILFUNC,
	CREATEDEPTHSTENCILSTATE_TOOMANYOBJECTS,
	CREATEDEPTHSTENCILSTATE_NULLDESC,
	CREATEBLENDSTATE_INVALIDSRCBLEND,
	CREATEBLENDSTATE_INVALIDDESTBLEND,
	CREATEBLENDSTATE_INVALIDBLENDOP,
	CREATEBLENDSTATE_INVALIDSRCBLENDALPHA,
	CREATEBLENDSTATE_INVALIDDESTBLENDALPHA,
	CREATEBLENDSTATE_INVALIDBLENDOPALPHA,
	CREATEBLENDSTATE_INVALIDRENDERTARGETWRITEMASK,
	CREATEBLENDSTATE_TOOMANYOBJECTS,
	CREATEBLENDSTATE_NULLDESC,
	CREATESAMPLERSTATE_INVALIDFILTER,
	CREATESAMPLERSTATE_INVALIDADDRESSU,
	CREATESAMPLERSTATE_INVALIDADDRESSV,
	CREATESAMPLERSTATE_INVALIDADDRESSW,
	CREATESAMPLERSTATE_INVALIDMIPLODBIAS,
	CREATESAMPLERSTATE_INVALIDMAXANISOTROPY,
	CREATESAMPLERSTATE_INVALIDCOMPARISONFUNC,
	CREATESAMPLERSTATE_INVALIDMINLOD,
	CREATESAMPLERSTATE_INVALIDMAXLOD,
	CREATESAMPLERSTATE_TOOMANYOBJECTS,
	CREATESAMPLERSTATE_NULLDESC,
	CREATEQUERYORPREDICATE_INVALIDQUERY,
	CREATEQUERYORPREDICATE_INVALIDMISCFLAGS,
	CREATEQUERYORPREDICATE_UNEXPECTEDMISCFLAG,
	CREATEQUERYORPREDICATE_NULLDESC,
	DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNRECOGNIZED,
	DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNDEFINED,
	IASETVERTEXBUFFERS_INVALIDBUFFER,
	DEVICE_IASETVERTEXBUFFERS_OFFSET_TOO_LARGE,
	DEVICE_IASETVERTEXBUFFERS_BUFFERS_EMPTY,
	IASETINDEXBUFFER_INVALIDBUFFER,
	DEVICE_IASETINDEXBUFFER_FORMAT_INVALID,
	DEVICE_IASETINDEXBUFFER_OFFSET_TOO_LARGE,
	DEVICE_IASETINDEXBUFFER_OFFSET_UNALIGNED,
	DEVICE_VSSETSHADERRESOURCES_VIEWS_EMPTY,
	VSSETCONSTANTBUFFERS_INVALIDBUFFER,
	DEVICE_VSSETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_VSSETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_GSSETSHADERRESOURCES_VIEWS_EMPTY,
	GSSETCONSTANTBUFFERS_INVALIDBUFFER,
	DEVICE_GSSETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_GSSETSAMPLERS_SAMPLERS_EMPTY,
	SOSETTARGETS_INVALIDBUFFER,
	DEVICE_SOSETTARGETS_OFFSET_UNALIGNED,
	DEVICE_PSSETSHADERRESOURCES_VIEWS_EMPTY,
	PSSETCONSTANTBUFFERS_INVALIDBUFFER,
	DEVICE_PSSETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_PSSETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_RSSETVIEWPORTS_INVALIDVIEWPORT,
	DEVICE_RSSETSCISSORRECTS_INVALIDSCISSOR,
	CLEARRENDERTARGETVIEW_DENORMFLUSH,
	CLEARDEPTHSTENCILVIEW_DENORMFLUSH,
	CLEARDEPTHSTENCILVIEW_INVALID,
	DEVICE_IAGETVERTEXBUFFERS_BUFFERS_EMPTY,
	DEVICE_VSGETSHADERRESOURCES_VIEWS_EMPTY,
	DEVICE_VSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_VSGETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_GSGETSHADERRESOURCES_VIEWS_EMPTY,
	DEVICE_GSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_GSGETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_SOGETTARGETS_BUFFERS_EMPTY,
	DEVICE_PSGETSHADERRESOURCES_VIEWS_EMPTY,
	DEVICE_PSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_PSGETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_RSGETVIEWPORTS_VIEWPORTS_EMPTY,
	DEVICE_RSGETSCISSORRECTS_RECTS_EMPTY,
	DEVICE_GENERATEMIPS_RESOURCE_INVALID,
	COPYSUBRESOURCEREGION_INVALIDDESTINATIONSUBRESOURCE,
	COPYSUBRESOURCEREGION_INVALIDSOURCESUBRESOURCE,
	COPYSUBRESOURCEREGION_INVALIDSOURCEBOX,
	COPYSUBRESOURCEREGION_INVALIDSOURCE,
	COPYSUBRESOURCEREGION_INVALIDDESTINATIONSTATE,
	COPYSUBRESOURCEREGION_INVALIDSOURCESTATE,
	COPYRESOURCE_INVALIDSOURCE,
	COPYRESOURCE_INVALIDDESTINATIONSTATE,
	COPYRESOURCE_INVALIDSOURCESTATE,
	UPDATESUBRESOURCE_INVALIDDESTINATIONSUBRESOURCE,
	UPDATESUBRESOURCE_INVALIDDESTINATIONBOX,
	UPDATESUBRESOURCE_INVALIDDESTINATIONSTATE,
	DEVICE_RESOLVESUBRESOURCE_DESTINATION_INVALID,
	DEVICE_RESOLVESUBRESOURCE_DESTINATION_SUBRESOURCE_INVALID,
	DEVICE_RESOLVESUBRESOURCE_SOURCE_INVALID,
	DEVICE_RESOLVESUBRESOURCE_SOURCE_SUBRESOURCE_INVALID,
	DEVICE_RESOLVESUBRESOURCE_FORMAT_INVALID,
	BUFFER_MAP_INVALIDMAPTYPE,
	BUFFER_MAP_INVALIDFLAGS,
	BUFFER_MAP_ALREADYMAPPED,
	BUFFER_MAP_DEVICEREMOVED_RETURN,
	BUFFER_UNMAP_NOTMAPPED,
	TEXTURE1D_MAP_INVALIDMAPTYPE,
	TEXTURE1D_MAP_INVALIDSUBRESOURCE,
	TEXTURE1D_MAP_INVALIDFLAGS,
	TEXTURE1D_MAP_ALREADYMAPPED,
	TEXTURE1D_MAP_DEVICEREMOVED_RETURN,
	TEXTURE1D_UNMAP_INVALIDSUBRESOURCE,
	TEXTURE1D_UNMAP_NOTMAPPED,
	TEXTURE2D_MAP_INVALIDMAPTYPE,
	TEXTURE2D_MAP_INVALIDSUBRESOURCE,
	TEXTURE2D_MAP_INVALIDFLAGS,
	TEXTURE2D_MAP_ALREADYMAPPED,
	TEXTURE2D_MAP_DEVICEREMOVED_RETURN,
	TEXTURE2D_UNMAP_INVALIDSUBRESOURCE,
	TEXTURE2D_UNMAP_NOTMAPPED,
	TEXTURE3D_MAP_INVALIDMAPTYPE,
	TEXTURE3D_MAP_INVALIDSUBRESOURCE,
	TEXTURE3D_MAP_INVALIDFLAGS,
	TEXTURE3D_MAP_ALREADYMAPPED,
	TEXTURE3D_MAP_DEVICEREMOVED_RETURN,
	TEXTURE3D_UNMAP_INVALIDSUBRESOURCE,
	TEXTURE3D_UNMAP_NOTMAPPED,
	CHECKFORMATSUPPORT_FORMAT_DEPRECATED,
	CHECKMULTISAMPLEQUALITYLEVELS_FORMAT_DEPRECATED,
	SETEXCEPTIONMODE_UNRECOGNIZEDFLAGS,
	SETEXCEPTIONMODE_INVALIDARG_RETURN,
	SETEXCEPTIONMODE_DEVICEREMOVED_RETURN,
	REF_SIMULATING_INFINITELY_FAST_HARDWARE,
	REF_THREADING_MODE,
	REF_UMDRIVER_EXCEPTION,
	REF_KMDRIVER_EXCEPTION,
	REF_HARDWARE_EXCEPTION,
	REF_ACCESSING_INDEXABLE_TEMP_OUT_OF_RANGE,
	REF_PROBLEM_PARSING_SHADER,
	REF_OUT_OF_MEMORY,
	REF_INFO,
	DEVICE_DRAW_VERTEXPOS_OVERFLOW,
	DEVICE_DRAWINDEXED_INDEXPOS_OVERFLOW,
	DEVICE_DRAWINSTANCED_VERTEXPOS_OVERFLOW,
	DEVICE_DRAWINSTANCED_INSTANCEPOS_OVERFLOW,
	DEVICE_DRAWINDEXEDINSTANCED_INSTANCEPOS_OVERFLOW,
	DEVICE_DRAWINDEXEDINSTANCED_INDEXPOS_OVERFLOW,
	DEVICE_DRAW_VERTEX_SHADER_NOT_SET,
	DEVICE_SHADER_LINKAGE_SEMANTICNAME_NOT_FOUND,
	DEVICE_SHADER_LINKAGE_REGISTERINDEX,
	DEVICE_SHADER_LINKAGE_COMPONENTTYPE,
	DEVICE_SHADER_LINKAGE_REGISTERMASK,
	DEVICE_SHADER_LINKAGE_SYSTEMVALUE,
	DEVICE_SHADER_LINKAGE_NEVERWRITTEN_ALWAYSREADS,
	DEVICE_DRAW_VERTEX_BUFFER_NOT_SET,
	DEVICE_DRAW_INPUTLAYOUT_NOT_SET,
	DEVICE_DRAW_CONSTANT_BUFFER_NOT_SET,
	DEVICE_DRAW_CONSTANT_BUFFER_TOO_SMALL,
	DEVICE_DRAW_SAMPLER_NOT_SET,
	DEVICE_DRAW_SHADERRESOURCEVIEW_NOT_SET,
	DEVICE_DRAW_VIEW_DIMENSION_MISMATCH,
	DEVICE_DRAW_VERTEX_BUFFER_STRIDE_TOO_SMALL,
	DEVICE_DRAW_VERTEX_BUFFER_TOO_SMALL,
	DEVICE_DRAW_INDEX_BUFFER_NOT_SET,
	DEVICE_DRAW_INDEX_BUFFER_FORMAT_INVALID,
	DEVICE_DRAW_INDEX_BUFFER_TOO_SMALL,
	DEVICE_DRAW_GS_INPUT_PRIMITIVE_MISMATCH,
	DEVICE_DRAW_RESOURCE_RETURN_TYPE_MISMATCH,
	DEVICE_DRAW_POSITION_NOT_PRESENT,
	DEVICE_DRAW_OUTPUT_STREAM_NOT_SET,
	DEVICE_DRAW_BOUND_RESOURCE_MAPPED,
	DEVICE_DRAW_INVALID_PRIMITIVETOPOLOGY,
	DEVICE_DRAW_VERTEX_OFFSET_UNALIGNED,
	DEVICE_DRAW_VERTEX_STRIDE_UNALIGNED,
	DEVICE_DRAW_INDEX_OFFSET_UNALIGNED,
	DEVICE_DRAW_OUTPUT_STREAM_OFFSET_UNALIGNED,
	DEVICE_DRAW_RESOURCE_FORMAT_LD_UNSUPPORTED,
	DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_UNSUPPORTED,
	DEVICE_DRAW_RESOURCE_FORMAT_SAMPLE_C_UNSUPPORTED,
	DEVICE_DRAW_RESOURCE_MULTISAMPLE_UNSUPPORTED,
	DEVICE_DRAW_SO_TARGETS_BOUND_WITHOUT_SOURCE,
	DEVICE_DRAW_SO_STRIDE_LARGER_THAN_BUFFER,
	DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_BLENDING,
	DEVICE_DRAW_OM_DUAL_SOURCE_BLENDING_CAN_ONLY_HAVE_RENDER_TARGET_0,
	DEVICE_REMOVAL_PROCESS_AT_FAULT,
	DEVICE_REMOVAL_PROCESS_POSSIBLY_AT_FAULT,
	DEVICE_REMOVAL_PROCESS_NOT_AT_FAULT,
	DEVICE_OPEN_SHARED_RESOURCE_INVALIDARG_RETURN,
	DEVICE_OPEN_SHARED_RESOURCE_OUTOFMEMORY_RETURN,
	DEVICE_OPEN_SHARED_RESOURCE_BADINTERFACE_RETURN,
	DEVICE_DRAW_VIEWPORT_NOT_SET,
	CREATEINPUTLAYOUT_TRAILING_DIGIT_IN_SEMANTIC,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_TRAILING_DIGIT_IN_SEMANTIC,
	DEVICE_RSSETVIEWPORTS_DENORMFLUSH,
	OMSETRENDERTARGETS_INVALIDVIEW,
	DEVICE_SETTEXTFILTERSIZE_INVALIDDIMENSIONS,
	DEVICE_DRAW_SAMPLER_MISMATCH,
	CREATEINPUTLAYOUT_TYPE_MISMATCH,
	BLENDSTATE_GETDESC_LEGACY,
	SHADERRESOURCEVIEW_GETDESC_LEGACY,
	CREATEQUERY_OUTOFMEMORY_RETURN,
	CREATEPREDICATE_OUTOFMEMORY_RETURN,
	CREATECOUNTER_OUTOFRANGE_COUNTER,
	CREATECOUNTER_SIMULTANEOUS_ACTIVE_COUNTERS_EXHAUSTED,
	CREATECOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER,
	CREATECOUNTER_OUTOFMEMORY_RETURN,
	CREATECOUNTER_NONEXCLUSIVE_RETURN,
	CREATECOUNTER_NULLDESC,
	CHECKCOUNTER_OUTOFRANGE_COUNTER,
	CHECKCOUNTER_UNSUPPORTED_WELLKNOWN_COUNTER,
	SETPREDICATION_INVALID_PREDICATE_STATE,
	QUERY_BEGIN_UNSUPPORTED,
	PREDICATE_BEGIN_DURING_PREDICATION,
	QUERY_BEGIN_DUPLICATE,
	QUERY_BEGIN_ABANDONING_PREVIOUS_RESULTS,
	PREDICATE_END_DURING_PREDICATION,
	QUERY_END_ABANDONING_PREVIOUS_RESULTS,
	QUERY_END_WITHOUT_BEGIN,
	QUERY_GETDATA_INVALID_DATASIZE,
	QUERY_GETDATA_INVALID_FLAGS,
	QUERY_GETDATA_INVALID_CALL,
	DEVICE_DRAW_PS_OUTPUT_TYPE_MISMATCH,
	DEVICE_DRAW_RESOURCE_FORMAT_GATHER_UNSUPPORTED,
	DEVICE_DRAW_INVALID_USE_OF_CENTER_MULTISAMPLE_PATTERN,
	DEVICE_IASETVERTEXBUFFERS_STRIDE_TOO_LARGE,
	DEVICE_IASETVERTEXBUFFERS_INVALIDRANGE,
	CREATEINPUTLAYOUT_EMPTY_LAYOUT,
	DEVICE_DRAW_RESOURCE_SAMPLE_COUNT_MISMATCH,
	LIVE_OBJECT_SUMMARY,
	LIVE_BUFFER,
	LIVE_TEXTURE1D,
	LIVE_TEXTURE2D,
	LIVE_TEXTURE3D,
	LIVE_SHADERRESOURCEVIEW,
	LIVE_RENDERTARGETVIEW,
	LIVE_DEPTHSTENCILVIEW,
	LIVE_VERTEXSHADER,
	LIVE_GEOMETRYSHADER,
	LIVE_PIXELSHADER,
	LIVE_INPUTLAYOUT,
	LIVE_SAMPLER,
	LIVE_BLENDSTATE,
	LIVE_DEPTHSTENCILSTATE,
	LIVE_RASTERIZERSTATE,
	LIVE_QUERY,
	LIVE_PREDICATE,
	LIVE_COUNTER,
	LIVE_DEVICE,
	LIVE_SWAPCHAIN,
	D3D10_MESSAGES_END,
	D3D10L9_MESSAGES_START = 0x100000,
	CREATEDEPTHSTENCILSTATE_STENCIL_NO_TWO_SIDED,
	CREATERASTERIZERSTATE_DepthBiasClamp_NOT_SUPPORTED,
	CREATESAMPLERSTATE_NO_COMPARISON_SUPPORT,
	CREATESAMPLERSTATE_EXCESSIVE_ANISOTROPY,
	CREATESAMPLERSTATE_BORDER_OUT_OF_RANGE,
	VSSETSAMPLERS_NOT_SUPPORTED,
	VSSETSAMPLERS_TOO_MANY_SAMPLERS,
	PSSETSAMPLERS_TOO_MANY_SAMPLERS,
	CREATERESOURCE_NO_ARRAYS,
	CREATERESOURCE_NO_VB_AND_IB_BIND,
	CREATERESOURCE_NO_TEXTURE_1D,
	CREATERESOURCE_DIMENSION_OUT_OF_RANGE,
	CREATERESOURCE_NOT_BINDABLE_AS_SHADER_RESOURCE,
	OMSETRENDERTARGETS_TOO_MANY_RENDER_TARGETS,
	OMSETRENDERTARGETS_NO_DIFFERING_BIT_DEPTHS,
	IASETVERTEXBUFFERS_BAD_BUFFER_INDEX,
	DEVICE_RSSETVIEWPORTS_TOO_MANY_VIEWPORTS,
	DEVICE_IASETPRIMITIVETOPOLOGY_ADJACENCY_UNSUPPORTED,
	DEVICE_RSSETSCISSORRECTS_TOO_MANY_SCISSORS,
	COPYRESOURCE_ONLY_TEXTURE_2D_WITHIN_GPU_MEMORY,
	COPYRESOURCE_NO_TEXTURE_3D_READBACK,
	COPYRESOURCE_NO_TEXTURE_ONLY_READBACK,
	CREATEINPUTLAYOUT_UNSUPPORTED_FORMAT,
	CREATEBLENDSTATE_NO_ALPHA_TO_COVERAGE,
	CREATERASTERIZERSTATE_DepthClipEnable_MUST_BE_TRUE,
	DRAWINDEXED_STARTINDEXLOCATION_MUST_BE_POSITIVE,
	CREATESHADERRESOURCEVIEW_MUST_USE_LOWEST_LOD,
	CREATESAMPLERSTATE_MINLOD_MUST_NOT_BE_FRACTIONAL,
	CREATESAMPLERSTATE_MAXLOD_MUST_BE_FLT_MAX,
	CREATESHADERRESOURCEVIEW_FIRSTARRAYSLICE_MUST_BE_ZERO,
	CREATESHADERRESOURCEVIEW_CUBES_MUST_HAVE_6_SIDES,
	CREATERESOURCE_NOT_BINDABLE_AS_RENDER_TARGET,
	CREATERESOURCE_NO_DWORD_INDEX_BUFFER,
	CREATERESOURCE_MSAA_PRECLUDES_SHADER_RESOURCE,
	CREATERESOURCE_PRESENTATION_PRECLUDES_SHADER_RESOURCE,
	CREATEBLENDSTATE_NO_INDEPENDENT_BLEND_ENABLE,
	CREATEBLENDSTATE_NO_INDEPENDENT_WRITE_MASKS,
	CREATERESOURCE_NO_STREAM_OUT,
	CREATERESOURCE_ONLY_VB_IB_FOR_BUFFERS,
	CREATERESOURCE_NO_AUTOGEN_FOR_VOLUMES,
	CREATERESOURCE_DXGI_FORMAT_R8G8B8A8_CANNOT_BE_SHARED,
	VSSHADERRESOURCES_NOT_SUPPORTED,
	GEOMETRY_SHADER_NOT_SUPPORTED,
	STREAM_OUT_NOT_SUPPORTED,
	TEXT_FILTER_NOT_SUPPORTED,
	CREATEBLENDSTATE_NO_SEPARATE_ALPHA_BLEND,
	CREATEBLENDSTATE_NO_MRT_BLEND,
	CREATEBLENDSTATE_OPERATION_NOT_SUPPORTED,
	CREATESAMPLERSTATE_NO_MIRRORONCE,
	DRAWINSTANCED_NOT_SUPPORTED,
	DRAWINDEXEDINSTANCED_NOT_SUPPORTED_BELOW_9_3,
	DRAWINDEXED_POINTLIST_UNSUPPORTED,
	SETBLENDSTATE_SAMPLE_MASK_CANNOT_BE_ZERO,
	CREATERESOURCE_DIMENSION_EXCEEDS_FEATURE_LEVEL_DEFINITION,
	CREATERESOURCE_ONLY_SINGLE_MIP_LEVEL_DEPTH_STENCIL_SUPPORTED,
	DEVICE_RSSETSCISSORRECTS_NEGATIVESCISSOR,
	SLOT_ZERO_MUST_BE_D3D10_INPUT_PER_VERTEX_DATA,
	CREATERESOURCE_NON_POW_2_MIPMAP,
	CREATESAMPLERSTATE_BORDER_NOT_SUPPORTED,
	OMSETRENDERTARGETS_NO_SRGB_MRT,
	COPYRESOURCE_NO_3D_MISMATCHED_UPDATES,
	D3D10L9_MESSAGES_END,
	D3D11_MESSAGES_START = 0x200000,
	CREATEDEPTHSTENCILVIEW_INVALIDFLAGS,
	CREATEVERTEXSHADER_INVALIDCLASSLINKAGE,
	CREATEGEOMETRYSHADER_INVALIDCLASSLINKAGE,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTREAMS,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAMTORASTERIZER,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTREAMS,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDCLASSLINKAGE,
	CREATEPIXELSHADER_INVALIDCLASSLINKAGE,
	CREATEDEFERREDCONTEXT_INVALID_COMMANDLISTFLAGS,
	CREATEDEFERREDCONTEXT_SINGLETHREADED,
	CREATEDEFERREDCONTEXT_INVALIDARG_RETURN,
	CREATEDEFERREDCONTEXT_INVALID_CALL_RETURN,
	CREATEDEFERREDCONTEXT_OUTOFMEMORY_RETURN,
	FINISHDISPLAYLIST_ONIMMEDIATECONTEXT,
	FINISHDISPLAYLIST_OUTOFMEMORY_RETURN,
	FINISHDISPLAYLIST_INVALID_CALL_RETURN,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDSTREAM,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDENTRIES,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UNEXPECTEDSTRIDES,
	CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_INVALIDNUMSTRIDES,
	DEVICE_HSSETSHADERRESOURCES_HAZARD,
	DEVICE_HSSETCONSTANTBUFFERS_HAZARD,
	HSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	HSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	CREATEHULLSHADER_INVALIDCALL,
	CREATEHULLSHADER_OUTOFMEMORY,
	CREATEHULLSHADER_INVALIDSHADERBYTECODE,
	CREATEHULLSHADER_INVALIDSHADERTYPE,
	CREATEHULLSHADER_INVALIDCLASSLINKAGE,
	DEVICE_HSSETSHADERRESOURCES_VIEWS_EMPTY,
	HSSETCONSTANTBUFFERS_INVALIDBUFFER,
	DEVICE_HSSETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_HSSETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_HSGETSHADERRESOURCES_VIEWS_EMPTY,
	DEVICE_HSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_HSGETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_DSSETSHADERRESOURCES_HAZARD,
	DEVICE_DSSETCONSTANTBUFFERS_HAZARD,
	DSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	DSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	CREATEDOMAINSHADER_INVALIDCALL,
	CREATEDOMAINSHADER_OUTOFMEMORY,
	CREATEDOMAINSHADER_INVALIDSHADERBYTECODE,
	CREATEDOMAINSHADER_INVALIDSHADERTYPE,
	CREATEDOMAINSHADER_INVALIDCLASSLINKAGE,
	DEVICE_DSSETSHADERRESOURCES_VIEWS_EMPTY,
	DSSETCONSTANTBUFFERS_INVALIDBUFFER,
	DEVICE_DSSETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_DSSETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_DSGETSHADERRESOURCES_VIEWS_EMPTY,
	DEVICE_DSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_DSGETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_DRAW_HS_XOR_DS_MISMATCH,
	DEFERRED_CONTEXT_REMOVAL_PROCESS_AT_FAULT,
	DEVICE_DRAWINDIRECT_INVALID_ARG_BUFFER,
	DEVICE_DRAWINDIRECT_OFFSET_UNALIGNED,
	DEVICE_DRAWINDIRECT_OFFSET_OVERFLOW,
	RESOURCE_MAP_INVALIDMAPTYPE,
	RESOURCE_MAP_INVALIDSUBRESOURCE,
	RESOURCE_MAP_INVALIDFLAGS,
	RESOURCE_MAP_ALREADYMAPPED,
	RESOURCE_MAP_DEVICEREMOVED_RETURN,
	RESOURCE_MAP_OUTOFMEMORY_RETURN,
	RESOURCE_MAP_WITHOUT_INITIAL_DISCARD,
	RESOURCE_UNMAP_INVALIDSUBRESOURCE,
	RESOURCE_UNMAP_NOTMAPPED,
	DEVICE_DRAW_RASTERIZING_CONTROL_POINTS,
	DEVICE_IASETPRIMITIVETOPOLOGY_TOPOLOGY_UNSUPPORTED,
	DEVICE_DRAW_HS_DS_SIGNATURE_MISMATCH,
	DEVICE_DRAW_HULL_SHADER_INPUT_TOPOLOGY_MISMATCH,
	DEVICE_DRAW_HS_DS_CONTROL_POINT_COUNT_MISMATCH,
	DEVICE_DRAW_HS_DS_TESSELLATOR_DOMAIN_MISMATCH,
	CREATE_CONTEXT,
	LIVE_CONTEXT,
	DESTROY_CONTEXT,
	CREATE_BUFFER,
	LIVE_BUFFER_WIN7,
	DESTROY_BUFFER,
	CREATE_TEXTURE1D,
	LIVE_TEXTURE1D_WIN7,
	DESTROY_TEXTURE1D,
	CREATE_TEXTURE2D,
	LIVE_TEXTURE2D_WIN7,
	DESTROY_TEXTURE2D,
	CREATE_TEXTURE3D,
	LIVE_TEXTURE3D_WIN7,
	DESTROY_TEXTURE3D,
	CREATE_SHADERRESOURCEVIEW,
	LIVE_SHADERRESOURCEVIEW_WIN7,
	DESTROY_SHADERRESOURCEVIEW,
	CREATE_RENDERTARGETVIEW,
	LIVE_RENDERTARGETVIEW_WIN7,
	DESTROY_RENDERTARGETVIEW,
	CREATE_DEPTHSTENCILVIEW,
	LIVE_DEPTHSTENCILVIEW_WIN7,
	DESTROY_DEPTHSTENCILVIEW,
	CREATE_VERTEXSHADER,
	LIVE_VERTEXSHADER_WIN7,
	DESTROY_VERTEXSHADER,
	CREATE_HULLSHADER,
	LIVE_HULLSHADER,
	DESTROY_HULLSHADER,
	CREATE_DOMAINSHADER,
	LIVE_DOMAINSHADER,
	DESTROY_DOMAINSHADER,
	CREATE_GEOMETRYSHADER,
	LIVE_GEOMETRYSHADER_WIN7,
	DESTROY_GEOMETRYSHADER,
	CREATE_PIXELSHADER,
	LIVE_PIXELSHADER_WIN7,
	DESTROY_PIXELSHADER,
	CREATE_INPUTLAYOUT,
	LIVE_INPUTLAYOUT_WIN7,
	DESTROY_INPUTLAYOUT,
	CREATE_SAMPLER,
	LIVE_SAMPLER_WIN7,
	DESTROY_SAMPLER,
	CREATE_BLENDSTATE,
	LIVE_BLENDSTATE_WIN7,
	DESTROY_BLENDSTATE,
	CREATE_DEPTHSTENCILSTATE,
	LIVE_DEPTHSTENCILSTATE_WIN7,
	DESTROY_DEPTHSTENCILSTATE,
	CREATE_RASTERIZERSTATE,
	LIVE_RASTERIZERSTATE_WIN7,
	DESTROY_RASTERIZERSTATE,
	CREATE_QUERY,
	LIVE_QUERY_WIN7,
	DESTROY_QUERY,
	CREATE_PREDICATE,
	LIVE_PREDICATE_WIN7,
	DESTROY_PREDICATE,
	CREATE_COUNTER,
	DESTROY_COUNTER,
	CREATE_COMMANDLIST,
	LIVE_COMMANDLIST,
	DESTROY_COMMANDLIST,
	CREATE_CLASSINSTANCE,
	LIVE_CLASSINSTANCE,
	DESTROY_CLASSINSTANCE,
	CREATE_CLASSLINKAGE,
	LIVE_CLASSLINKAGE,
	DESTROY_CLASSLINKAGE,
	LIVE_DEVICE_WIN7,
	LIVE_OBJECT_SUMMARY_WIN7,
	CREATE_COMPUTESHADER,
	LIVE_COMPUTESHADER,
	DESTROY_COMPUTESHADER,
	CREATE_UNORDEREDACCESSVIEW,
	LIVE_UNORDEREDACCESSVIEW,
	DESTROY_UNORDEREDACCESSVIEW,
	DEVICE_SETSHADER_INTERFACES_FEATURELEVEL,
	DEVICE_SETSHADER_INTERFACE_COUNT_MISMATCH,
	DEVICE_SETSHADER_INVALID_INSTANCE,
	DEVICE_SETSHADER_INVALID_INSTANCE_INDEX,
	DEVICE_SETSHADER_INVALID_INSTANCE_TYPE,
	DEVICE_SETSHADER_INVALID_INSTANCE_DATA,
	DEVICE_SETSHADER_UNBOUND_INSTANCE_DATA,
	DEVICE_SETSHADER_INSTANCE_DATA_BINDINGS,
	DEVICE_CREATESHADER_CLASSLINKAGE_FULL,
	DEVICE_CHECKFEATURESUPPORT_UNRECOGNIZED_FEATURE,
	DEVICE_CHECKFEATURESUPPORT_MISMATCHED_DATA_SIZE,
	DEVICE_CHECKFEATURESUPPORT_INVALIDARG_RETURN,
	DEVICE_CSSETSHADERRESOURCES_HAZARD,
	DEVICE_CSSETCONSTANTBUFFERS_HAZARD,
	CSSETSHADERRESOURCES_UNBINDDELETINGOBJECT,
	CSSETCONSTANTBUFFERS_UNBINDDELETINGOBJECT,
	CREATECOMPUTESHADER_INVALIDCALL,
	CREATECOMPUTESHADER_OUTOFMEMORY,
	CREATECOMPUTESHADER_INVALIDSHADERBYTECODE,
	CREATECOMPUTESHADER_INVALIDSHADERTYPE,
	CREATECOMPUTESHADER_INVALIDCLASSLINKAGE,
	DEVICE_CSSETSHADERRESOURCES_VIEWS_EMPTY,
	CSSETCONSTANTBUFFERS_INVALIDBUFFER,
	DEVICE_CSSETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_CSSETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_CSGETSHADERRESOURCES_VIEWS_EMPTY,
	DEVICE_CSGETCONSTANTBUFFERS_BUFFERS_EMPTY,
	DEVICE_CSGETSAMPLERS_SAMPLERS_EMPTY,
	DEVICE_CREATEVERTEXSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	DEVICE_CREATEHULLSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	DEVICE_CREATEDOMAINSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEFLOATOPSNOTSUPPORTED,
	DEVICE_CREATEPIXELSHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	DEVICE_CREATECOMPUTESHADER_DOUBLEFLOATOPSNOTSUPPORTED,
	CREATEBUFFER_INVALIDSTRUCTURESTRIDE,
	CREATESHADERRESOURCEVIEW_INVALIDFLAGS,
	CREATEUNORDEREDACCESSVIEW_INVALIDRESOURCE,
	CREATEUNORDEREDACCESSVIEW_INVALIDDESC,
	CREATEUNORDEREDACCESSVIEW_INVALIDFORMAT,
	CREATEUNORDEREDACCESSVIEW_INVALIDDIMENSIONS,
	CREATEUNORDEREDACCESSVIEW_UNRECOGNIZEDFORMAT,
	DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_HAZARD,
	DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_OVERLAPPING_OLD_SLOTS,
	DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NO_OP,
	CSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT,
	PSSETUNORDEREDACCESSVIEWS_UNBINDDELETINGOBJECT,
	CREATEUNORDEREDACCESSVIEW_INVALIDARG_RETURN,
	CREATEUNORDEREDACCESSVIEW_OUTOFMEMORY_RETURN,
	CREATEUNORDEREDACCESSVIEW_TOOMANYOBJECTS,
	DEVICE_CSSETUNORDEREDACCESSVIEWS_HAZARD,
	CLEARUNORDEREDACCESSVIEW_DENORMFLUSH,
	DEVICE_CSSETUNORDEREDACCESSS_VIEWS_EMPTY,
	DEVICE_CSGETUNORDEREDACCESSS_VIEWS_EMPTY,
	CREATEUNORDEREDACCESSVIEW_INVALIDFLAGS,
	CREATESHADERRESESOURCEVIEW_TOOMANYOBJECTS,
	DEVICE_DISPATCHINDIRECT_INVALID_ARG_BUFFER,
	DEVICE_DISPATCHINDIRECT_OFFSET_UNALIGNED,
	DEVICE_DISPATCHINDIRECT_OFFSET_OVERFLOW,
	DEVICE_SETRESOURCEMINLOD_INVALIDCONTEXT,
	DEVICE_SETRESOURCEMINLOD_INVALIDRESOURCE,
	DEVICE_SETRESOURCEMINLOD_INVALIDMINLOD,
	DEVICE_GETRESOURCEMINLOD_INVALIDCONTEXT,
	DEVICE_GETRESOURCEMINLOD_INVALIDRESOURCE,
	OMSETDEPTHSTENCIL_UNBINDDELETINGOBJECT,
	CLEARDEPTHSTENCILVIEW_DEPTH_READONLY,
	CLEARDEPTHSTENCILVIEW_STENCIL_READONLY,
	CHECKFEATURESUPPORT_FORMAT_DEPRECATED,
	DEVICE_UNORDEREDACCESSVIEW_RETURN_TYPE_MISMATCH,
	DEVICE_UNORDEREDACCESSVIEW_NOT_SET,
	DEVICE_DRAW_UNORDEREDACCESSVIEW_RENDERTARGETVIEW_OVERLAP,
	DEVICE_UNORDEREDACCESSVIEW_DIMENSION_MISMATCH,
	DEVICE_UNORDEREDACCESSVIEW_APPEND_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_ATOMICS_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_STRUCTURE_STRIDE_MISMATCH,
	DEVICE_UNORDEREDACCESSVIEW_BUFFER_TYPE_MISMATCH,
	DEVICE_UNORDEREDACCESSVIEW_RAW_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_FORMAT_LD_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_FORMAT_STORE_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_ATOMIC_ADD_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_ATOMIC_BITWISE_OPS_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_ATOMIC_CMPSTORE_CMPEXCHANGE_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_ATOMIC_EXCHANGE_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_ATOMIC_SIGNED_MINMAX_UNSUPPORTED,
	DEVICE_UNORDEREDACCESSVIEW_ATOMIC_UNSIGNED_MINMAX_UNSUPPORTED,
	DEVICE_DISPATCH_BOUND_RESOURCE_MAPPED,
	DEVICE_DISPATCH_THREADGROUPCOUNT_OVERFLOW,
	DEVICE_DISPATCH_THREADGROUPCOUNT_ZERO,
	DEVICE_SHADERRESOURCEVIEW_STRUCTURE_STRIDE_MISMATCH,
	DEVICE_SHADERRESOURCEVIEW_BUFFER_TYPE_MISMATCH,
	DEVICE_SHADERRESOURCEVIEW_RAW_UNSUPPORTED,
	DEVICE_DISPATCH_UNSUPPORTED,
	DEVICE_DISPATCHINDIRECT_UNSUPPORTED,
	COPYSTRUCTURECOUNT_INVALIDOFFSET,
	COPYSTRUCTURECOUNT_LARGEOFFSET,
	COPYSTRUCTURECOUNT_INVALIDDESTINATIONSTATE,
	COPYSTRUCTURECOUNT_INVALIDSOURCESTATE,
	CHECKFORMATSUPPORT_FORMAT_NOT_SUPPORTED,
	DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDVIEW,
	DEVICE_CSSETUNORDEREDACCESSVIEWS_INVALIDOFFSET,
	DEVICE_CSSETUNORDEREDACCESSVIEWS_TOOMANYVIEWS,
	CLEARUNORDEREDACCESSVIEWFLOAT_INVALIDFORMAT,
	DEVICE_UNORDEREDACCESSVIEW_COUNTER_UNSUPPORTED,
	REF_WARNING,
	DEVICE_DRAW_PIXEL_SHADER_WITHOUT_RTV_OR_DSV,
	SHADER_ABORT,
	SHADER_MESSAGE,
	SHADER_ERROR,
	OFFERRESOURCES_INVALIDRESOURCE,
	HSSETSAMPLERS_UNBINDDELETINGOBJECT,
	DSSETSAMPLERS_UNBINDDELETINGOBJECT,
	CSSETSAMPLERS_UNBINDDELETINGOBJECT,
	HSSETSHADER_UNBINDDELETINGOBJECT,
	DSSETSHADER_UNBINDDELETINGOBJECT,
	CSSETSHADER_UNBINDDELETINGOBJECT,
	ENQUEUESETEVENT_INVALIDARG_RETURN,
	ENQUEUESETEVENT_OUTOFMEMORY_RETURN,
	ENQUEUESETEVENT_ACCESSDENIED_RETURN,
	DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_NUMUAVS_INVALIDRANGE,
	USE_OF_ZERO_REFCOUNT_OBJECT,
	D3D11_MESSAGES_END,
	D3D11_1_MESSAGES_START = 0x300000,
	CREATE_VIDEODECODER,
	CREATE_VIDEOPROCESSORENUM,
	CREATE_VIDEOPROCESSOR,
	CREATE_DECODEROUTPUTVIEW,
	CREATE_PROCESSORINPUTVIEW,
	CREATE_PROCESSOROUTPUTVIEW,
	CREATE_DEVICECONTEXTSTATE,
	LIVE_VIDEODECODER,
	LIVE_VIDEOPROCESSORENUM,
	LIVE_VIDEOPROCESSOR,
	LIVE_DECODEROUTPUTVIEW,
	LIVE_PROCESSORINPUTVIEW,
	LIVE_PROCESSOROUTPUTVIEW,
	LIVE_DEVICECONTEXTSTATE,
	DESTROY_VIDEODECODER,
	DESTROY_VIDEOPROCESSORENUM,
	DESTROY_VIDEOPROCESSOR,
	DESTROY_DECODEROUTPUTVIEW,
	DESTROY_PROCESSORINPUTVIEW,
	DESTROY_PROCESSOROUTPUTVIEW,
	DESTROY_DEVICECONTEXTSTATE,
	CREATEDEVICECONTEXTSTATE_INVALIDFLAGS,
	CREATEDEVICECONTEXTSTATE_INVALIDFEATURELEVEL,
	CREATEDEVICECONTEXTSTATE_FEATURELEVELS_NOT_SUPPORTED,
	CREATEDEVICECONTEXTSTATE_INVALIDREFIID,
	DEVICE_DISCARDVIEW_INVALIDVIEW,
	COPYSUBRESOURCEREGION1_INVALIDCOPYFLAGS,
	UPDATESUBRESOURCE1_INVALIDCOPYFLAGS,
	CREATERASTERIZERSTATE_INVALIDFORCEDSAMPLECOUNT,
	CREATEVIDEODECODER_OUTOFMEMORY_RETURN,
	CREATEVIDEODECODER_NULLPARAM,
	CREATEVIDEODECODER_INVALIDFORMAT,
	CREATEVIDEODECODER_ZEROWIDTHHEIGHT,
	CREATEVIDEODECODER_DRIVER_INVALIDBUFFERSIZE,
	CREATEVIDEODECODER_DRIVER_INVALIDBUFFERUSAGE,
	GETVIDEODECODERPROFILECOUNT_OUTOFMEMORY,
	GETVIDEODECODERPROFILE_NULLPARAM,
	GETVIDEODECODERPROFILE_INVALIDINDEX,
	GETVIDEODECODERPROFILE_OUTOFMEMORY_RETURN,
	CHECKVIDEODECODERFORMAT_NULLPARAM,
	CHECKVIDEODECODERFORMAT_OUTOFMEMORY_RETURN,
	GETVIDEODECODERCONFIGCOUNT_NULLPARAM,
	GETVIDEODECODERCONFIGCOUNT_OUTOFMEMORY_RETURN,
	GETVIDEODECODERCONFIG_NULLPARAM,
	GETVIDEODECODERCONFIG_INVALIDINDEX,
	GETVIDEODECODERCONFIG_OUTOFMEMORY_RETURN,
	GETDECODERCREATIONPARAMS_NULLPARAM,
	GETDECODERDRIVERHANDLE_NULLPARAM,
	GETDECODERBUFFER_NULLPARAM,
	GETDECODERBUFFER_INVALIDBUFFER,
	GETDECODERBUFFER_INVALIDTYPE,
	GETDECODERBUFFER_LOCKED,
	RELEASEDECODERBUFFER_NULLPARAM,
	RELEASEDECODERBUFFER_INVALIDTYPE,
	RELEASEDECODERBUFFER_NOTLOCKED,
	DECODERBEGINFRAME_NULLPARAM,
	DECODERBEGINFRAME_HAZARD,
	DECODERENDFRAME_NULLPARAM,
	SUBMITDECODERBUFFERS_NULLPARAM,
	SUBMITDECODERBUFFERS_INVALIDTYPE,
	DECODEREXTENSION_NULLPARAM,
	DECODEREXTENSION_INVALIDRESOURCE,
	CREATEVIDEOPROCESSORENUMERATOR_OUTOFMEMORY_RETURN,
	CREATEVIDEOPROCESSORENUMERATOR_NULLPARAM,
	CREATEVIDEOPROCESSORENUMERATOR_INVALIDFRAMEFORMAT,
	CREATEVIDEOPROCESSORENUMERATOR_INVALIDUSAGE,
	CREATEVIDEOPROCESSORENUMERATOR_INVALIDINPUTFRAMERATE,
	CREATEVIDEOPROCESSORENUMERATOR_INVALIDOUTPUTFRAMERATE,
	CREATEVIDEOPROCESSORENUMERATOR_INVALIDWIDTHHEIGHT,
	GETVIDEOPROCESSORCONTENTDESC_NULLPARAM,
	CHECKVIDEOPROCESSORFORMAT_NULLPARAM,
	GETVIDEOPROCESSORCAPS_NULLPARAM,
	GETVIDEOPROCESSORRATECONVERSIONCAPS_NULLPARAM,
	GETVIDEOPROCESSORRATECONVERSIONCAPS_INVALIDINDEX,
	GETVIDEOPROCESSORCUSTOMRATE_NULLPARAM,
	GETVIDEOPROCESSORCUSTOMRATE_INVALIDINDEX,
	GETVIDEOPROCESSORFILTERRANGE_NULLPARAM,
	GETVIDEOPROCESSORFILTERRANGE_UNSUPPORTED,
	CREATEVIDEOPROCESSOR_OUTOFMEMORY_RETURN,
	CREATEVIDEOPROCESSOR_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTTARGETRECT_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTBACKGROUNDCOLOR_INVALIDALPHA,
	VIDEOPROCESSORSETOUTPUTCOLORSPACE_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_UNSUPPORTED,
	VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDSTREAM,
	VIDEOPROCESSORSETOUTPUTALPHAFILLMODE_INVALIDFILLMODE,
	VIDEOPROCESSORSETOUTPUTCONSTRICTION_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTSTEREOMODE_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTSTEREOMODE_UNSUPPORTED,
	VIDEOPROCESSORSETOUTPUTEXTENSION_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTTARGETRECT_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTBACKGROUNDCOLOR_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTCOLORSPACE_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTALPHAFILLMODE_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTCONSTRICTION_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTCONSTRICTION_UNSUPPORTED,
	VIDEOPROCESSORSETOUTPUTCONSTRICTION_INVALIDSIZE,
	VIDEOPROCESSORGETOUTPUTSTEREOMODE_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTEXTENSION_NULLPARAM,
	VIDEOPROCESSORSETSTREAMFRAMEFORMAT_NULLPARAM,
	VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDFORMAT,
	VIDEOPROCESSORSETSTREAMFRAMEFORMAT_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMCOLORSPACE_NULLPARAM,
	VIDEOPROCESSORSETSTREAMCOLORSPACE_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMOUTPUTRATE_NULLPARAM,
	VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDRATE,
	VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDFLAG,
	VIDEOPROCESSORSETSTREAMOUTPUTRATE_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMSOURCERECT_NULLPARAM,
	VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMSOURCERECT_INVALIDRECT,
	VIDEOPROCESSORSETSTREAMDESTRECT_NULLPARAM,
	VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMDESTRECT_INVALIDRECT,
	VIDEOPROCESSORSETSTREAMALPHA_NULLPARAM,
	VIDEOPROCESSORSETSTREAMALPHA_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMALPHA_INVALIDALPHA,
	VIDEOPROCESSORSETSTREAMPALETTE_NULLPARAM,
	VIDEOPROCESSORSETSTREAMPALETTE_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMPALETTE_INVALIDCOUNT,
	VIDEOPROCESSORSETSTREAMPALETTE_INVALIDALPHA,
	VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_NULLPARAM,
	VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_INVALIDRATIO,
	VIDEOPROCESSORSETSTREAMLUMAKEY_NULLPARAM,
	VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMLUMAKEY_INVALIDRANGE,
	VIDEOPROCESSORSETSTREAMLUMAKEY_UNSUPPORTED,
	VIDEOPROCESSORSETSTREAMSTEREOFORMAT_NULLPARAM,
	VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMSTEREOFORMAT_UNSUPPORTED,
	VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FLIPUNSUPPORTED,
	VIDEOPROCESSORSETSTREAMSTEREOFORMAT_MONOOFFSETUNSUPPORTED,
	VIDEOPROCESSORSETSTREAMSTEREOFORMAT_FORMATUNSUPPORTED,
	VIDEOPROCESSORSETSTREAMSTEREOFORMAT_INVALIDFORMAT,
	VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_NULLPARAM,
	VIDEOPROCESSORSETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMFILTER_NULLPARAM,
	VIDEOPROCESSORSETSTREAMFILTER_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMFILTER_INVALIDFILTER,
	VIDEOPROCESSORSETSTREAMFILTER_UNSUPPORTED,
	VIDEOPROCESSORSETSTREAMFILTER_INVALIDLEVEL,
	VIDEOPROCESSORSETSTREAMEXTENSION_NULLPARAM,
	VIDEOPROCESSORSETSTREAMEXTENSION_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMFRAMEFORMAT_NULLPARAM,
	VIDEOPROCESSORGETSTREAMCOLORSPACE_NULLPARAM,
	VIDEOPROCESSORGETSTREAMOUTPUTRATE_NULLPARAM,
	VIDEOPROCESSORGETSTREAMSOURCERECT_NULLPARAM,
	VIDEOPROCESSORGETSTREAMDESTRECT_NULLPARAM,
	VIDEOPROCESSORGETSTREAMALPHA_NULLPARAM,
	VIDEOPROCESSORGETSTREAMPALETTE_NULLPARAM,
	VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_NULLPARAM,
	VIDEOPROCESSORGETSTREAMLUMAKEY_NULLPARAM,
	VIDEOPROCESSORGETSTREAMSTEREOFORMAT_NULLPARAM,
	VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_NULLPARAM,
	VIDEOPROCESSORGETSTREAMFILTER_NULLPARAM,
	VIDEOPROCESSORGETSTREAMEXTENSION_NULLPARAM,
	VIDEOPROCESSORGETSTREAMEXTENSION_INVALIDSTREAM,
	VIDEOPROCESSORBLT_NULLPARAM,
	VIDEOPROCESSORBLT_INVALIDSTREAMCOUNT,
	VIDEOPROCESSORBLT_TARGETRECT,
	VIDEOPROCESSORBLT_INVALIDOUTPUT,
	VIDEOPROCESSORBLT_INVALIDPASTFRAMES,
	VIDEOPROCESSORBLT_INVALIDFUTUREFRAMES,
	VIDEOPROCESSORBLT_INVALIDSOURCERECT,
	VIDEOPROCESSORBLT_INVALIDDESTRECT,
	VIDEOPROCESSORBLT_INVALIDINPUTRESOURCE,
	VIDEOPROCESSORBLT_INVALIDARRAYSIZE,
	VIDEOPROCESSORBLT_INVALIDARRAY,
	VIDEOPROCESSORBLT_RIGHTEXPECTED,
	VIDEOPROCESSORBLT_RIGHTNOTEXPECTED,
	VIDEOPROCESSORBLT_STEREONOTENABLED,
	VIDEOPROCESSORBLT_INVALIDRIGHTRESOURCE,
	VIDEOPROCESSORBLT_NOSTEREOSTREAMS,
	VIDEOPROCESSORBLT_INPUTHAZARD,
	VIDEOPROCESSORBLT_OUTPUTHAZARD,
	CREATEVIDEODECODEROUTPUTVIEW_OUTOFMEMORY_RETURN,
	CREATEVIDEODECODEROUTPUTVIEW_NULLPARAM,
	CREATEVIDEODECODEROUTPUTVIEW_INVALIDTYPE,
	CREATEVIDEODECODEROUTPUTVIEW_INVALIDBIND,
	CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEDFORMAT,
	CREATEVIDEODECODEROUTPUTVIEW_INVALIDMIP,
	CREATEVIDEODECODEROUTPUTVIEW_UNSUPPORTEMIP,
	CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAYSIZE,
	CREATEVIDEODECODEROUTPUTVIEW_INVALIDARRAY,
	CREATEVIDEODECODEROUTPUTVIEW_INVALIDDIMENSION,
	CREATEVIDEOPROCESSORINPUTVIEW_OUTOFMEMORY_RETURN,
	CREATEVIDEOPROCESSORINPUTVIEW_NULLPARAM,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDTYPE,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDBIND,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMISC,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDUSAGE,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFORMAT,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDFOURCC,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMIP,
	CREATEVIDEOPROCESSORINPUTVIEW_UNSUPPORTEDMIP,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAYSIZE,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDARRAY,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDDIMENSION,
	CREATEVIDEOPROCESSOROUTPUTVIEW_OUTOFMEMORY_RETURN,
	CREATEVIDEOPROCESSOROUTPUTVIEW_NULLPARAM,
	CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDTYPE,
	CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDBIND,
	CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDFORMAT,
	CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMIP,
	CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDMIP,
	CREATEVIDEOPROCESSOROUTPUTVIEW_UNSUPPORTEDARRAY,
	CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDARRAY,
	CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDDIMENSION,
	DEVICE_DRAW_INVALID_USE_OF_FORCED_SAMPLE_COUNT,
	CREATEBLENDSTATE_INVALIDLOGICOPS,
	CREATESHADERRESOURCEVIEW_INVALIDDARRAYWITHDECODER,
	CREATEUNORDEREDACCESSVIEW_INVALIDDARRAYWITHDECODER,
	CREATERENDERTARGETVIEW_INVALIDDARRAYWITHDECODER,
	DEVICE_LOCKEDOUT_INTERFACE,
	REF_WARNING_ATOMIC_INCONSISTENT,
	REF_WARNING_READING_UNINITIALIZED_RESOURCE,
	REF_WARNING_RAW_HAZARD,
	REF_WARNING_WAR_HAZARD,
	REF_WARNING_WAW_HAZARD,
	CREATECRYPTOSESSION_NULLPARAM,
	CREATECRYPTOSESSION_OUTOFMEMORY_RETURN,
	GETCRYPTOTYPE_NULLPARAM,
	GETDECODERPROFILE_NULLPARAM,
	GETCRYPTOSESSIONCERTIFICATESIZE_NULLPARAM,
	GETCRYPTOSESSIONCERTIFICATE_NULLPARAM,
	GETCRYPTOSESSIONCERTIFICATE_WRONGSIZE,
	GETCRYPTOSESSIONHANDLE_WRONGSIZE,
	NEGOTIATECRPYTOSESSIONKEYEXCHANGE_NULLPARAM,
	ENCRYPTIONBLT_UNSUPPORTED,
	ENCRYPTIONBLT_NULLPARAM,
	ENCRYPTIONBLT_SRC_WRONGDEVICE,
	ENCRYPTIONBLT_DST_WRONGDEVICE,
	ENCRYPTIONBLT_FORMAT_MISMATCH,
	ENCRYPTIONBLT_SIZE_MISMATCH,
	ENCRYPTIONBLT_SRC_MULTISAMPLED,
	ENCRYPTIONBLT_DST_NOT_STAGING,
	ENCRYPTIONBLT_SRC_MAPPED,
	ENCRYPTIONBLT_DST_MAPPED,
	ENCRYPTIONBLT_SRC_OFFERED,
	ENCRYPTIONBLT_DST_OFFERED,
	ENCRYPTIONBLT_SRC_CONTENT_UNDEFINED,
	DECRYPTIONBLT_UNSUPPORTED,
	DECRYPTIONBLT_NULLPARAM,
	DECRYPTIONBLT_SRC_WRONGDEVICE,
	DECRYPTIONBLT_DST_WRONGDEVICE,
	DECRYPTIONBLT_FORMAT_MISMATCH,
	DECRYPTIONBLT_SIZE_MISMATCH,
	DECRYPTIONBLT_DST_MULTISAMPLED,
	DECRYPTIONBLT_SRC_NOT_STAGING,
	DECRYPTIONBLT_DST_NOT_RENDER_TARGET,
	DECRYPTIONBLT_SRC_MAPPED,
	DECRYPTIONBLT_DST_MAPPED,
	DECRYPTIONBLT_SRC_OFFERED,
	DECRYPTIONBLT_DST_OFFERED,
	DECRYPTIONBLT_SRC_CONTENT_UNDEFINED,
	STARTSESSIONKEYREFRESH_NULLPARAM,
	STARTSESSIONKEYREFRESH_INVALIDSIZE,
	FINISHSESSIONKEYREFRESH_NULLPARAM,
	GETENCRYPTIONBLTKEY_NULLPARAM,
	GETENCRYPTIONBLTKEY_INVALIDSIZE,
	GETCONTENTPROTECTIONCAPS_NULLPARAM,
	CHECKCRYPTOKEYEXCHANGE_NULLPARAM,
	CHECKCRYPTOKEYEXCHANGE_INVALIDINDEX,
	CREATEAUTHENTICATEDCHANNEL_NULLPARAM,
	CREATEAUTHENTICATEDCHANNEL_UNSUPPORTED,
	CREATEAUTHENTICATEDCHANNEL_INVALIDTYPE,
	CREATEAUTHENTICATEDCHANNEL_OUTOFMEMORY_RETURN,
	GETAUTHENTICATEDCHANNELCERTIFICATESIZE_INVALIDCHANNEL,
	GETAUTHENTICATEDCHANNELCERTIFICATESIZE_NULLPARAM,
	GETAUTHENTICATEDCHANNELCERTIFICATE_INVALIDCHANNEL,
	GETAUTHENTICATEDCHANNELCERTIFICATE_NULLPARAM,
	GETAUTHENTICATEDCHANNELCERTIFICATE_WRONGSIZE,
	NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDCHANNEL,
	NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_NULLPARAM,
	QUERYAUTHENTICATEDCHANNEL_NULLPARAM,
	QUERYAUTHENTICATEDCHANNEL_WRONGCHANNEL,
	QUERYAUTHENTICATEDCHANNEL_UNSUPPORTEDQUERY,
	QUERYAUTHENTICATEDCHANNEL_WRONGSIZE,
	QUERYAUTHENTICATEDCHANNEL_INVALIDPROCESSINDEX,
	CONFIGUREAUTHENTICATEDCHANNEL_NULLPARAM,
	CONFIGUREAUTHENTICATEDCHANNEL_WRONGCHANNEL,
	CONFIGUREAUTHENTICATEDCHANNEL_UNSUPPORTEDCONFIGURE,
	CONFIGUREAUTHENTICATEDCHANNEL_WRONGSIZE,
	CONFIGUREAUTHENTICATEDCHANNEL_INVALIDPROCESSIDTYPE,
	VSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	DSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	HSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	GSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	PSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	CSSETCONSTANTBUFFERS_INVALIDBUFFEROFFSETORCOUNT,
	NEGOTIATECRPYTOSESSIONKEYEXCHANGE_INVALIDSIZE,
	NEGOTIATEAUTHENTICATEDCHANNELKEYEXCHANGE_INVALIDSIZE,
	OFFERRESOURCES_INVALIDPRIORITY,
	GETCRYPTOSESSIONHANDLE_OUTOFMEMORY,
	ACQUIREHANDLEFORCAPTURE_NULLPARAM,
	ACQUIREHANDLEFORCAPTURE_INVALIDTYPE,
	ACQUIREHANDLEFORCAPTURE_INVALIDBIND,
	ACQUIREHANDLEFORCAPTURE_INVALIDARRAY,
	VIDEOPROCESSORSETSTREAMROTATION_NULLPARAM,
	VIDEOPROCESSORSETSTREAMROTATION_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMROTATION_INVALID,
	VIDEOPROCESSORSETSTREAMROTATION_UNSUPPORTED,
	VIDEOPROCESSORGETSTREAMROTATION_NULLPARAM,
	DEVICE_CLEARVIEW_INVALIDVIEW,
	DEVICE_CREATEVERTEXSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEVERTEXSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEHULLSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEHULLSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEDOMAINSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEDOMAINSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_DOUBLEEXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_SHADEREXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEPIXELSHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	DEVICE_CREATEPIXELSHADER_SHADEREXTENSIONSNOTSUPPORTED,
	DEVICE_CREATECOMPUTESHADER_DOUBLEEXTENSIONSNOTSUPPORTED,
	DEVICE_CREATECOMPUTESHADER_SHADEREXTENSIONSNOTSUPPORTED,
	DEVICE_SHADER_LINKAGE_MINPRECISION,
	VIDEOPROCESSORSETSTREAMALPHA_UNSUPPORTED,
	VIDEOPROCESSORSETSTREAMPIXELASPECTRATIO_UNSUPPORTED,
	DEVICE_CREATEVERTEXSHADER_UAVSNOTSUPPORTED,
	DEVICE_CREATEHULLSHADER_UAVSNOTSUPPORTED,
	DEVICE_CREATEDOMAINSHADER_UAVSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADER_UAVSNOTSUPPORTED,
	DEVICE_CREATEGEOMETRYSHADERWITHSTREAMOUTPUT_UAVSNOTSUPPORTED,
	DEVICE_CREATEPIXELSHADER_UAVSNOTSUPPORTED,
	DEVICE_CREATECOMPUTESHADER_UAVSNOTSUPPORTED,
	DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_INVALIDOFFSET,
	DEVICE_OMSETRENDERTARGETSANDUNORDEREDACCESSVIEWS_TOOMANYVIEWS,
	DEVICE_CLEARVIEW_NOTSUPPORTED,
	SWAPDEVICECONTEXTSTATE_NOTSUPPORTED,
	UPDATESUBRESOURCE_PREFERUPDATESUBRESOURCE1,
	GETDC_INACCESSIBLE,
	DEVICE_CLEARVIEW_INVALIDRECT,
	DEVICE_DRAW_SAMPLE_MASK_IGNORED_ON_FL9,
	DEVICE_OPEN_SHARED_RESOURCE1_NOT_SUPPORTED,
	DEVICE_OPEN_SHARED_RESOURCE_BY_NAME_NOT_SUPPORTED,
	ENQUEUESETEVENT_NOT_SUPPORTED,
	OFFERRELEASE_NOT_SUPPORTED,
	OFFERRESOURCES_INACCESSIBLE,
	CREATEVIDEOPROCESSORINPUTVIEW_INVALIDMSAA,
	CREATEVIDEOPROCESSOROUTPUTVIEW_INVALIDMSAA,
	DEVICE_CLEARVIEW_INVALIDSOURCERECT,
	DEVICE_CLEARVIEW_EMPTYRECT,
	UPDATESUBRESOURCE_EMPTYDESTBOX,
	COPYSUBRESOURCEREGION_EMPTYSOURCEBOX,
	DEVICE_DRAW_OM_RENDER_TARGET_DOES_NOT_SUPPORT_LOGIC_OPS,
	DEVICE_DRAW_DEPTHSTENCILVIEW_NOT_SET,
	DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET,
	DEVICE_DRAW_RENDERTARGETVIEW_NOT_SET_DUE_TO_FLIP_PRESENT,
	DEVICE_UNORDEREDACCESSVIEW_NOT_SET_DUE_TO_FLIP_PRESENT,
	GETDATAFORNEWHARDWAREKEY_NULLPARAM,
	CHECKCRYPTOSESSIONSTATUS_NULLPARAM,
	GETCRYPTOSESSIONPRIVATEDATASIZE_NULLPARAM,
	GETVIDEODECODERCAPS_NULLPARAM,
	GETVIDEODECODERCAPS_ZEROWIDTHHEIGHT,
	CHECKVIDEODECODERDOWNSAMPLING_NULLPARAM,
	CHECKVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE,
	CHECKVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT,
	VIDEODECODERENABLEDOWNSAMPLING_NULLPARAM,
	VIDEODECODERENABLEDOWNSAMPLING_UNSUPPORTED,
	VIDEODECODERUPDATEDOWNSAMPLING_NULLPARAM,
	VIDEODECODERUPDATEDOWNSAMPLING_UNSUPPORTED,
	CHECKVIDEOPROCESSORFORMATCONVERSION_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTCOLORSPACE1_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTCOLORSPACE1_NULLPARAM,
	VIDEOPROCESSORSETSTREAMCOLORSPACE1_NULLPARAM,
	VIDEOPROCESSORSETSTREAMCOLORSPACE1_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMMIRROR_NULLPARAM,
	VIDEOPROCESSORSETSTREAMMIRROR_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMMIRROR_UNSUPPORTED,
	VIDEOPROCESSORGETSTREAMCOLORSPACE1_NULLPARAM,
	VIDEOPROCESSORGETSTREAMMIRROR_NULLPARAM,
	RECOMMENDVIDEODECODERDOWNSAMPLING_NULLPARAM,
	RECOMMENDVIDEODECODERDOWNSAMPLING_INVALIDCOLORSPACE,
	RECOMMENDVIDEODECODERDOWNSAMPLING_ZEROWIDTHHEIGHT,
	VIDEOPROCESSORSETOUTPUTSHADERUSAGE_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTSHADERUSAGE_NULLPARAM,
	VIDEOPROCESSORGETBEHAVIORHINTS_NULLPARAM,
	VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSTREAMCOUNT,
	VIDEOPROCESSORGETBEHAVIORHINTS_TARGETRECT,
	VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDSOURCERECT,
	VIDEOPROCESSORGETBEHAVIORHINTS_INVALIDDESTRECT,
	GETCRYPTOSESSIONPRIVATEDATASIZE_INVALID_KEY_EXCHANGE_TYPE,
	DEVICE_OPEN_SHARED_RESOURCE1_ACCESS_DENIED,
	D3D11_1_MESSAGES_END,
	D3D11_2_MESSAGES_START,
	CREATEBUFFER_INVALIDUSAGE,
	CREATETEXTURE1D_INVALIDUSAGE,
	CREATETEXTURE2D_INVALIDUSAGE,
	CREATEINPUTLAYOUT_LEVEL9_STEPRATE_NOT_1,
	CREATEINPUTLAYOUT_LEVEL9_INSTANCING_NOT_SUPPORTED,
	UPDATETILEMAPPINGS_INVALID_PARAMETER,
	COPYTILEMAPPINGS_INVALID_PARAMETER,
	COPYTILES_INVALID_PARAMETER,
	UPDATETILES_INVALID_PARAMETER,
	RESIZETILEPOOL_INVALID_PARAMETER,
	TILEDRESOURCEBARRIER_INVALID_PARAMETER,
	NULL_TILE_MAPPING_ACCESS_WARNING,
	NULL_TILE_MAPPING_ACCESS_ERROR,
	DIRTY_TILE_MAPPING_ACCESS,
	DUPLICATE_TILE_MAPPINGS_IN_COVERED_AREA,
	TILE_MAPPINGS_IN_COVERED_AREA_DUPLICATED_OUTSIDE,
	TILE_MAPPINGS_SHARED_BETWEEN_INCOMPATIBLE_RESOURCES,
	TILE_MAPPINGS_SHARED_BETWEEN_INPUT_AND_OUTPUT,
	CHECKMULTISAMPLEQUALITYLEVELS_INVALIDFLAGS,
	GETRESOURCETILING_NONTILED_RESOURCE,
	RESIZETILEPOOL_SHRINK_WITH_MAPPINGS_STILL_DEFINED_PAST_END,
	NEED_TO_CALL_TILEDRESOURCEBARRIER,
	CREATEDEVICE_INVALIDARGS,
	CREATEDEVICE_WARNING,
	CLEARUNORDEREDACCESSVIEWUINT_HAZARD,
	CLEARUNORDEREDACCESSVIEWFLOAT_HAZARD,
	TILED_RESOURCE_TIER_1_BUFFER_TEXTURE_MISMATCH,
	CREATE_CRYPTOSESSION,
	CREATE_AUTHENTICATEDCHANNEL,
	LIVE_CRYPTOSESSION,
	LIVE_AUTHENTICATEDCHANNEL,
	DESTROY_CRYPTOSESSION,
	DESTROY_AUTHENTICATEDCHANNEL,
	D3D11_2_MESSAGES_END,
	D3D11_3_MESSAGES_START,
	CREATERASTERIZERSTATE_INVALID_CONSERVATIVERASTERMODE,
	DEVICE_DRAW_INVALID_SYSTEMVALUE,
	CREATEQUERYORPREDICATE_INVALIDCONTEXTTYPE,
	CREATEQUERYORPREDICATE_DECODENOTSUPPORTED,
	CREATEQUERYORPREDICATE_ENCODENOTSUPPORTED,
	CREATESHADERRESOURCEVIEW_INVALIDPLANEINDEX,
	CREATESHADERRESOURCEVIEW_INVALIDVIDEOPLANEINDEX,
	CREATESHADERRESOURCEVIEW_AMBIGUOUSVIDEOPLANEINDEX,
	CREATERENDERTARGETVIEW_INVALIDPLANEINDEX,
	CREATERENDERTARGETVIEW_INVALIDVIDEOPLANEINDEX,
	CREATERENDERTARGETVIEW_AMBIGUOUSVIDEOPLANEINDEX,
	CREATEUNORDEREDACCESSVIEW_INVALIDPLANEINDEX,
	CREATEUNORDEREDACCESSVIEW_INVALIDVIDEOPLANEINDEX,
	CREATEUNORDEREDACCESSVIEW_AMBIGUOUSVIDEOPLANEINDEX,
	JPEGDECODE_INVALIDSCANDATAOFFSET,
	JPEGDECODE_NOTSUPPORTED,
	JPEGDECODE_DIMENSIONSTOOLARGE,
	JPEGDECODE_INVALIDCOMPONENTS,
	JPEGDECODE_DESTINATIONNOT2D,
	JPEGDECODE_TILEDRESOURCESUNSUPPORTED,
	JPEGDECODE_GUARDRECTSUNSUPPORTED,
	JPEGDECODE_FORMATUNSUPPORTED,
	JPEGDECODE_INVALIDSUBRESOURCE,
	JPEGDECODE_INVALIDMIPLEVEL,
	JPEGDECODE_EMPTYDESTBOX,
	JPEGDECODE_DESTBOXNOT2D,
	JPEGDECODE_DESTBOXNOTSUB,
	JPEGDECODE_DESTBOXESINTERSECT,
	JPEGDECODE_XSUBSAMPLEMISMATCH,
	JPEGDECODE_YSUBSAMPLEMISMATCH,
	JPEGDECODE_XSUBSAMPLEODD,
	JPEGDECODE_YSUBSAMPLEODD,
	JPEGDECODE_OUTPUTDIMENSIONSTOOLARGE,
	JPEGDECODE_NONPOW2SCALEUNSUPPORTED,
	JPEGDECODE_FRACTIONALDOWNSCALETOLARGE,
	JPEGDECODE_CHROMASIZEMISMATCH,
	JPEGDECODE_LUMACHROMASIZEMISMATCH,
	JPEGDECODE_INVALIDNUMDESTINATIONS,
	JPEGDECODE_SUBBOXUNSUPPORTED,
	JPEGDECODE_1DESTUNSUPPORTEDFORMAT,
	JPEGDECODE_3DESTUNSUPPORTEDFORMAT,
	JPEGDECODE_SCALEUNSUPPORTED,
	JPEGDECODE_INVALIDSOURCESIZE,
	JPEGDECODE_INVALIDCOPYFLAGS,
	JPEGDECODE_HAZARD,
	JPEGDECODE_UNSUPPORTEDSRCBUFFERUSAGE,
	JPEGDECODE_UNSUPPORTEDSRCBUFFERMISCFLAGS,
	JPEGDECODE_UNSUPPORTEDDSTTEXTUREUSAGE,
	JPEGDECODE_BACKBUFFERNOTSUPPORTED,
	JPEGDECODE_UNSUPPRTEDCOPYFLAGS,
	JPEGENCODE_NOTSUPPORTED,
	JPEGENCODE_INVALIDSCANDATAOFFSET,
	JPEGENCODE_INVALIDCOMPONENTS,
	JPEGENCODE_SOURCENOT2D,
	JPEGENCODE_TILEDRESOURCESUNSUPPORTED,
	JPEGENCODE_GUARDRECTSUNSUPPORTED,
	JPEGENCODE_XSUBSAMPLEMISMATCH,
	JPEGENCODE_YSUBSAMPLEMISMATCH,
	JPEGENCODE_FORMATUNSUPPORTED,
	JPEGENCODE_INVALIDSUBRESOURCE,
	JPEGENCODE_INVALIDMIPLEVEL,
	JPEGENCODE_DIMENSIONSTOOLARGE,
	JPEGENCODE_HAZARD,
	JPEGENCODE_UNSUPPORTEDDSTBUFFERUSAGE,
	JPEGENCODE_UNSUPPORTEDDSTBUFFERMISCFLAGS,
	JPEGENCODE_UNSUPPORTEDSRCTEXTUREUSAGE,
	JPEGENCODE_BACKBUFFERNOTSUPPORTED,
	CREATEQUERYORPREDICATE_UNSUPPORTEDCONTEXTTTYPEFORQUERY,
	FLUSH1_INVALIDCONTEXTTYPE,
	DEVICE_SETHARDWAREPROTECTION_INVALIDCONTEXT,
	VIDEOPROCESSORSETOUTPUTHDRMETADATA_NULLPARAM,
	VIDEOPROCESSORSETOUTPUTHDRMETADATA_INVALIDSIZE,
	VIDEOPROCESSORGETOUTPUTHDRMETADATA_NULLPARAM,
	VIDEOPROCESSORGETOUTPUTHDRMETADATA_INVALIDSIZE,
	VIDEOPROCESSORSETSTREAMHDRMETADATA_NULLPARAM,
	VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSTREAM,
	VIDEOPROCESSORSETSTREAMHDRMETADATA_INVALIDSIZE,
	VIDEOPROCESSORGETSTREAMHDRMETADATA_NULLPARAM,
	VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMHDRMETADATA_INVALIDSIZE,
	VIDEOPROCESSORGETSTREAMFRAMEFORMAT_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMCOLORSPACE_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMOUTPUTRATE_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMSOURCERECT_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMDESTRECT_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMALPHA_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMPALETTE_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMPIXELASPECTRATIO_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMLUMAKEY_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMSTEREOFORMAT_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMAUTOPROCESSINGMODE_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMFILTER_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMROTATION_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMCOLORSPACE1_INVALIDSTREAM,
	VIDEOPROCESSORGETSTREAMMIRROR_INVALIDSTREAM,
	CREATE_FENCE,
	LIVE_FENCE,
	DESTROY_FENCE,
	CREATE_SYNCHRONIZEDCHANNEL,
	LIVE_SYNCHRONIZEDCHANNEL,
	DESTROY_SYNCHRONIZEDCHANNEL,
	CREATEFENCE_INVALIDFLAGS,
	D3D11_3_MESSAGES_END,
	D3D11_5_MESSAGES_START,
	NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_INVALIDKEYEXCHANGETYPE,
	NEGOTIATECRYPTOSESSIONKEYEXCHANGEMT_NOT_SUPPORTED,
	DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT_COUNT,
	DECODERBEGINFRAME_INVALID_HISTOGRAM_COMPONENT,
	DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_SIZE,
	DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_USAGE,
	DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_MISC_FLAGS,
	DECODERBEGINFRAME_INVALID_HISTOGRAM_BUFFER_OFFSET,
	CREATE_TRACKEDWORKLOAD,
	LIVE_TRACKEDWORKLOAD,
	DESTROY_TRACKEDWORKLOAD,
	CREATE_TRACKED_WORKLOAD_NULLPARAM,
	CREATE_TRACKED_WORKLOAD_INVALID_MAX_INSTANCES,
	CREATE_TRACKED_WORKLOAD_INVALID_DEADLINE_TYPE,
	CREATE_TRACKED_WORKLOAD_INVALID_ENGINE_TYPE,
	MULTIPLE_TRACKED_WORKLOADS,
	MULTIPLE_TRACKED_WORKLOAD_PAIRS,
	INCOMPLETE_TRACKED_WORKLOAD_PAIR,
	OUT_OF_ORDER_TRACKED_WORKLOAD_PAIR,
	CANNOT_ADD_TRACKED_WORKLOAD,
	TRACKED_WORKLOAD_NOT_SUPPORTED,
	TRACKED_WORKLOAD_ENGINE_TYPE_NOT_FOUND,
	NO_TRACKED_WORKLOAD_SLOT_AVAILABLE,
	END_TRACKED_WORKLOAD_INVALID_ARG,
	TRACKED_WORKLOAD_DISJOINT_FAILURE,
	D3D11_5_MESSAGES_END,
}

CalcSubresource :: #force_inline proc "contextless" (MipSlice: UINT, ArraySlice: UINT, MipLevels: UINT) -> UINT {
	return MipSlice + ArraySlice * MipLevels
}

ID3DUserDefinedAnnotation_UUID_STRING :: "B2DAAD8B-03D4-4DBF-95EB-32AB4B63D0AB"
ID3DUserDefinedAnnotation_UUID := &IID{0xB2DAAD8B, 0x03D4, 0x4DBF, {0x95, 0xEB, 0x32, 0xAB, 0x4B, 0x63, 0xD0, 0xAB}}
ID3DUserDefinedAnnotation :: struct #raw_union {
	#subtype iunknown: IUnknown,
	using vtable: ^ID3DUserDefinedAnnotation_VTable,
}
ID3DUserDefinedAnnotation_VTable :: struct {
	using iunknown_vtable: IUnknown_VTable,
	BeginEvent: proc "system" (this: ^ID3DUserDefinedAnnotation, Name: windows.LPCWSTR) -> INT,
	EndEvent:   proc "system" (this: ^ID3DUserDefinedAnnotation) -> INT,
	SetMarker:  proc "system" (this: ^ID3DUserDefinedAnnotation, Name: windows.LPCWSTR),
	GetStatus:  proc "system" (this: ^ID3DUserDefinedAnnotation) -> BOOL,
}
