/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.util.timeout;

import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.mariadb.jdbc.Connection;
import org.mariadb.jdbc.client.util.ClosableLock;
import org.mariadb.jdbc.client.util.SchedulerProvider;
import org.mariadb.jdbc.util.timeout.QueryTimeoutHandler;

public class QueryTimeoutHandlerImpl
implements QueryTimeoutHandler {
    private Future<?> timerTaskFuture;
    private ScheduledExecutorService timeoutScheduler;
    private Connection conn;
    private ClosableLock lock;

    @Override
    public QueryTimeoutHandler create(int queryTimeout) {
        assert (this.timerTaskFuture == null);
        if (queryTimeout > 0) {
            if (this.timeoutScheduler == null) {
                this.timeoutScheduler = SchedulerProvider.getTimeoutScheduler(this.lock);
            }
            this.timerTaskFuture = this.timeoutScheduler.schedule(() -> {
                try {
                    this.conn.cancelCurrentQuery();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, (long)queryTimeout, TimeUnit.SECONDS);
        }
        return this;
    }

    public QueryTimeoutHandlerImpl(Connection conn, ClosableLock lock) {
        this.conn = conn;
        this.lock = lock;
    }

    @Override
    public void close() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException | CancellationException | ExecutionException exception) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }
}

