/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler;

import java.util.Vector;
import javax.swing.SwingUtilities;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.EffectSendsEvent;
import org.jsampler.event.EffectSendsListener;
import org.jsampler.event.SamplerChannelEvent;
import org.jsampler.event.SamplerChannelListener;
import org.jsampler.task.Channel;
import org.jsampler.task.DuplicateChannels;
import org.linuxsampler.lscp.FxSend;
import org.linuxsampler.lscp.SamplerChannel;
import org.linuxsampler.lscp.event.MidiDataEvent;
import org.linuxsampler.lscp.event.MidiDataListener;

public class DefaultSamplerChannelModel
implements SamplerChannelModel {
    private SamplerChannel channel;
    private int streamCount = 0;
    private int voiceCount = 0;
    private final Vector<SamplerChannelListener> listeners = new Vector();
    private final Vector<EffectSendsListener> fxListeners = new Vector();
    private final Vector<FxSend> fxSends = new Vector();
    private final Vector<MidiDataListener> midiListeners = new Vector();

    public DefaultSamplerChannelModel(SamplerChannel samplerChannel) {
        if (samplerChannel == null) {
            throw new IllegalArgumentException("channel must be non null");
        }
        this.channel = samplerChannel;
    }

    @Override
    public void addSamplerChannelListener(SamplerChannelListener samplerChannelListener) {
        this.listeners.add(samplerChannelListener);
    }

    @Override
    public void removeSamplerChannelListener(SamplerChannelListener samplerChannelListener) {
        this.listeners.remove(samplerChannelListener);
    }

    @Override
    public void addEffectSendsListener(EffectSendsListener effectSendsListener) {
        this.fxListeners.add(effectSendsListener);
    }

    @Override
    public void removeEffectSendsListener(EffectSendsListener effectSendsListener) {
        this.fxListeners.remove(effectSendsListener);
    }

    @Override
    public void addMidiDataListener(MidiDataListener midiDataListener) {
        this.midiListeners.add(midiDataListener);
    }

    @Override
    public void removeMidiDataListener(MidiDataListener midiDataListener) {
        this.midiListeners.remove(midiDataListener);
    }

    @Override
    public int getChannelId() {
        return this.channel == null ? -1 : this.channel.getChannelId();
    }

    @Override
    public SamplerChannel getChannelInfo() {
        return this.channel;
    }

    @Override
    public void setChannelInfo(SamplerChannel samplerChannel) {
        if (samplerChannel == null) {
            throw new IllegalArgumentException("channel must be non null");
        }
        if (this.channel == samplerChannel) {
            return;
        }
        this.channel = samplerChannel;
        this.fireSamplerChannelChanged();
    }

    @Override
    public int getStreamCount() {
        return this.streamCount;
    }

    @Override
    public void setStreamCount(int n) {
        if (this.streamCount == n) {
            return;
        }
        this.streamCount = n;
        this.fireStreamCountChanged();
    }

    @Override
    public int getVoiceCount() {
        return this.voiceCount;
    }

    @Override
    public void setVoiceCount(int n) {
        if (this.voiceCount == n) {
            return;
        }
        this.voiceCount = n;
        this.fireVoiceCountChanged();
    }

    @Override
    public void setBackendEngineType(String string) {
        final Channel.LoadEngine loadEngine = new Channel.LoadEngine(string, this.getChannelId());
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        loadEngine.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (loadEngine.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(loadEngine);
    }

    @Override
    public void setBackendMute(boolean bl) {
        final Channel.SetMute setMute = new Channel.SetMute(this.getChannelId(), bl);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setMute.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setMute.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setMute);
    }

    @Override
    public void setBackendSolo(boolean bl) {
        final Channel.SetSolo setSolo = new Channel.SetSolo(this.getChannelId(), bl);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setSolo.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setSolo.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setSolo);
    }

    @Override
    public void setBackendVolume(float f) {
        final Channel.SetVolume setVolume = new Channel.SetVolume(this.getChannelId(), f);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setVolume.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setVolume.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setVolume);
    }

    @Override
    public void setBackendMidiInputDevice(int n) {
        final Channel.SetMidiInputDevice setMidiInputDevice = new Channel.SetMidiInputDevice(this.getChannelId(), n);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setMidiInputDevice.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setMidiInputDevice.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setMidiInputDevice);
    }

    @Override
    public void setBackendMidiInputPort(int n) {
        final Channel.SetMidiInputPort setMidiInputPort = new Channel.SetMidiInputPort(this.getChannelId(), n);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setMidiInputPort.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setMidiInputPort.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setMidiInputPort);
    }

    @Override
    public void setBackendMidiInputChannel(int n) {
        final Channel.SetMidiInputChannel setMidiInputChannel = new Channel.SetMidiInputChannel(this.getChannelId(), n);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setMidiInputChannel.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setMidiInputChannel.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setMidiInputChannel);
    }

    @Override
    public void setBackendAudioOutputDevice(int n) {
        final Channel.SetAudioOutputDevice setAudioOutputDevice = new Channel.SetAudioOutputDevice(this.getChannelId(), n);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setAudioOutputDevice.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setAudioOutputDevice.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setAudioOutputDevice);
    }

    @Override
    public void setBackendAudioOutputChannel(int n, int n2) {
        final Channel.SetAudioOutputChannel setAudioOutputChannel = new Channel.SetAudioOutputChannel(this.getChannelId(), n, n2);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setAudioOutputChannel.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setAudioOutputChannel.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setAudioOutputChannel);
    }

    @Override
    public void setBackendMidiInstrumentMap(int n) {
        final Channel.SetMidiInstrumentMap setMidiInstrumentMap = new Channel.SetMidiInstrumentMap(this.getChannelId(), n);
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        setMidiInstrumentMap.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setMidiInstrumentMap.doneWithErrors()) {
                    DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
                }
            }
        });
        CC.getTaskQueue().add(setMidiInstrumentMap);
    }

    @Override
    public void loadBackendInstrument(String string, int n) {
        Channel.LoadInstrument loadInstrument = new Channel.LoadInstrument(string, n, this.getChannelId());
        CC.getTaskQueue().add(loadInstrument);
    }

    @Override
    public void resetBackendChannel() {
        CC.getTaskQueue().add(new Channel.Reset(this.getChannelId()));
    }

    @Override
    public void duplicateBackendChannel() {
        CC.getTaskQueue().add(new DuplicateChannels(this.getChannelInfo()));
    }

    @Override
    public void addBackendFxSend(int n) {
        CC.getTaskQueue().add(new Channel.AddFxSend(this.getChannelId(), n));
    }

    @Override
    public void addBackendFxSend(int n, String string) {
        CC.getTaskQueue().add(new Channel.AddFxSend(this.getChannelId(), n, string));
    }

    @Override
    public void addFxSend(FxSend fxSend) {
        this.fxSends.add(fxSend);
        this.fireFxSendAdded(fxSend);
    }

    @Override
    public void removeBackendFxSend(int n) {
        CC.getTaskQueue().add(new Channel.RemoveFxSend(this.getChannelId(), n));
    }

    @Override
    public FxSend getFxSend(int n) {
        return this.fxSends.get(n);
    }

    @Override
    public FxSend getFxSendById(int n) {
        for (FxSend fxSend : this.fxSends) {
            if (fxSend.getFxSendId() != n) continue;
            return fxSend;
        }
        return null;
    }

    @Override
    public FxSend removeFxSend(int n) {
        FxSend fxSend = this.fxSends.remove(n);
        this.fireFxSendRemoved(fxSend);
        return fxSend;
    }

    @Override
    public boolean removeFxSendById(int n) {
        for (int i = 0; i < this.fxSends.size(); ++i) {
            FxSend fxSend = this.fxSends.get(i);
            if (fxSend.getFxSendId() != n) continue;
            this.fxSends.remove(i);
            this.fireFxSendRemoved(fxSend);
            return true;
        }
        return false;
    }

    @Override
    public void removeAllFxSends() {
        for (int i = this.fxSends.size() - 1; i >= 0; --i) {
            FxSend fxSend = this.fxSends.get(i);
            this.fxSends.removeElementAt(i);
            this.fireFxSendRemoved(fxSend);
        }
    }

    @Override
    public void updateFxSend(FxSend fxSend) {
        for (int i = 0; i < this.fxSends.size(); ++i) {
            FxSend fxSend2 = this.fxSends.get(i);
            if (fxSend2.getFxSendId() != fxSend.getFxSendId()) continue;
            this.fxSends.setElementAt(fxSend, i);
            this.fireFxSendUpdated(fxSend);
            return;
        }
    }

    @Override
    public int getFxSendCount() {
        return this.fxSends.size();
    }

    @Override
    public FxSend[] getFxSends() {
        return this.fxSends.toArray(new FxSend[this.fxSends.size()]);
    }

    @Override
    public void setBackendFxSendName(final int n, String string) {
        final Channel.SetFxSendName setFxSendName = new Channel.SetFxSendName(this.getChannelId(), n, string);
        setFxSendName.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (setFxSendName.doneWithErrors()) {
                    int n2 = DefaultSamplerChannelModel.this.getChannelId();
                    CC.getTaskQueue().add(new Channel.UpdateFxSendInfo(n2, n));
                }
            }
        });
        CC.getTaskQueue().add(setFxSendName);
    }

    @Override
    public void setBackendFxSendAudioOutputChannel(int n, int n2, int n3) {
        Channel.SetFxSendAudioOutputChannel setFxSendAudioOutputChannel = new Channel.SetFxSendAudioOutputChannel(this.getChannelId(), n, n2, n3);
        CC.getTaskQueue().add(setFxSendAudioOutputChannel);
    }

    @Override
    public void setBackendFxSendMidiController(int n, int n2) {
        Channel.SetFxSendMidiController setFxSendMidiController = new Channel.SetFxSendMidiController(this.getChannelId(), n, n2);
        CC.getTaskQueue().add(setFxSendMidiController);
    }

    @Override
    public void setBackendFxSendLevel(int n, float f) {
        CC.getTaskQueue().add(new Channel.SetFxSendLevel(this.getChannelId(), n, f));
    }

    @Override
    public void sendBackendMidiData(MidiDataEvent midiDataEvent) {
        this.sendBackendMidiData(midiDataEvent.getType(), midiDataEvent.getNote(), midiDataEvent.getVelocity());
    }

    @Override
    public void sendBackendMidiData(MidiDataEvent.Type type, int n, int n2) {
        CC.getTaskQueue().add(new Channel.SendMidiMsg(this.getChannelId(), type, n, n2));
    }

    protected void fireSamplerChannelChanged() {
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerChannelModel.this.fireSamplerChannelChanged(samplerChannelEvent);
            }
        });
    }

    protected void fireSamplerChannelChanged(SamplerChannelEvent samplerChannelEvent) {
        CC.getSamplerModel().setModified(true);
        for (SamplerChannelListener samplerChannelListener : this.listeners) {
            samplerChannelListener.channelChanged(samplerChannelEvent);
        }
    }

    protected void fireStreamCountChanged() {
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerChannelModel.this.fireStreamCountChanged(samplerChannelEvent);
            }
        });
    }

    protected void fireStreamCountChanged(SamplerChannelEvent samplerChannelEvent) {
        for (SamplerChannelListener samplerChannelListener : this.listeners) {
            samplerChannelListener.streamCountChanged(samplerChannelEvent);
        }
    }

    protected void fireVoiceCountChanged() {
        final SamplerChannelEvent samplerChannelEvent = new SamplerChannelEvent(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerChannelModel.this.fireVoiceCountChanged(samplerChannelEvent);
            }
        });
    }

    protected void fireVoiceCountChanged(SamplerChannelEvent samplerChannelEvent) {
        for (SamplerChannelListener samplerChannelListener : this.listeners) {
            samplerChannelListener.voiceCountChanged(samplerChannelEvent);
        }
    }

    protected void fireFxSendAdded(FxSend fxSend) {
        final EffectSendsEvent effectSendsEvent = new EffectSendsEvent(this, fxSend);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerChannelModel.this.fireFxSendAdded(effectSendsEvent);
            }
        });
    }

    protected void fireFxSendAdded(EffectSendsEvent effectSendsEvent) {
        CC.getSamplerModel().setModified(true);
        for (EffectSendsListener effectSendsListener : this.fxListeners) {
            effectSendsListener.effectSendAdded(effectSendsEvent);
        }
    }

    protected void fireFxSendRemoved(FxSend fxSend) {
        final EffectSendsEvent effectSendsEvent = new EffectSendsEvent(this, fxSend);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerChannelModel.this.fireFxSendRemoved(effectSendsEvent);
            }
        });
    }

    protected void fireFxSendRemoved(EffectSendsEvent effectSendsEvent) {
        CC.getSamplerModel().setModified(true);
        for (EffectSendsListener effectSendsListener : this.fxListeners) {
            effectSendsListener.effectSendRemoved(effectSendsEvent);
        }
    }

    protected void fireFxSendUpdated(FxSend fxSend) {
        final EffectSendsEvent effectSendsEvent = new EffectSendsEvent(this, fxSend);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultSamplerChannelModel.this.fireFxSendUpdated(effectSendsEvent);
            }
        });
    }

    protected void fireFxSendUpdated(EffectSendsEvent effectSendsEvent) {
        CC.getSamplerModel().setModified(true);
        for (EffectSendsListener effectSendsListener : this.fxListeners) {
            effectSendsListener.effectSendChanged(effectSendsEvent);
        }
    }

    protected void fireMidiDataEvent(MidiDataEvent midiDataEvent) {
        for (MidiDataListener midiDataListener : this.midiListeners) {
            midiDataListener.midiDataArrived(midiDataEvent);
        }
    }
}

