/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Shift and scale the pixels in an image.


ShiftScaleImageFilter shifts the input pixel by Shift (default 0.0) and then scales the
pixel by Scale (default 1.0). All computations are performed in the
precision of the input pixel's RealType. Before assigning the computed
value to the output pixel, the value is clamped at the NonpositiveMin
and max of the pixel type.
See:
 itk::simple::ShiftScale for the procedural interface

 itk::ShiftScaleImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkShiftScaleImageFilter.h
*/
public class ShiftScaleImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected ShiftScaleImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.ShiftScaleImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(ShiftScaleImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(ShiftScaleImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::ShiftScaleImageFilter::~ShiftScaleImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_ShiftScaleImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::ShiftScaleImageFilter::ShiftScaleImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  ShiftScaleImageFilter() {
    this(SimpleITKJNI.new_ShiftScaleImageFilter(), true);
  }

  /**
Self&amp; itk::simple::ShiftScaleImageFilter::SetShift(double Shift)

Set/Get the amount to Shift each Pixel. The shift is followed by a
Scale.

*/
public  void setShift(double Shift) {
    SimpleITKJNI.ShiftScaleImageFilter_setShift(swigCPtr, this, Shift);
  }

  /**
double itk::simple::ShiftScaleImageFilter::GetShift() const

Set/Get the amount to Shift each Pixel. The shift is followed by a
Scale.

*/
public  double getShift() {
    return SimpleITKJNI.ShiftScaleImageFilter_getShift(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShiftScaleImageFilter::SetScale(double Scale)

Set/Get the amount to Scale each Pixel. The Scale is applied after the
Shift.

*/
public  void setScale(double Scale) {
    SimpleITKJNI.ShiftScaleImageFilter_setScale(swigCPtr, this, Scale);
  }

  /**
double itk::simple::ShiftScaleImageFilter::GetScale() const

Set/Get the amount to Scale each Pixel. The Scale is applied after the
Shift.

*/
public  double getScale() {
    return SimpleITKJNI.ShiftScaleImageFilter_getScale(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::ShiftScaleImageFilter::SetOutputPixelType(PixelIDValueEnum OutputPixelType)

Set the output pixel type, if sitkUnknown then the input type is used.

*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.ShiftScaleImageFilter_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::ShiftScaleImageFilter::GetOutputPixelType() const

Get the output pixel type.

*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.ShiftScaleImageFilter_getOutputPixelType(swigCPtr, this));
  }

  /**
int64_t itk::simple::ShiftScaleImageFilter::GetUnderflowCount() const

Get the number of pixels that underflowed and overflowed.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getUnderflowCount() {
    return SimpleITKJNI.ShiftScaleImageFilter_getUnderflowCount(swigCPtr, this);
  }

  /**
int64_t itk::simple::ShiftScaleImageFilter::GetOverflowCount() const

Get the number of pixels that underflowed and overflowed.

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  long getOverflowCount() {
    return SimpleITKJNI.ShiftScaleImageFilter_getOverflowCount(swigCPtr, this);
  }

  /**
std::string itk::simple::ShiftScaleImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.ShiftScaleImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::ShiftScaleImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.ShiftScaleImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::ShiftScaleImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.ShiftScaleImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
