/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Convolve a given image with an arbitrary image kernel using
multiplication in the Fourier domain.


This filter produces output equivalent to the output of the ConvolutionImageFilter . However, it takes advantage of the convolution theorem to
accelerate the convolution computation when the kernel is large.


WARNING:
This filter ignores the spacing, origin, and orientation of the kernel
image and treats them as identical to those in the input image.
 This code was adapted from the Insight Journal contribution:

"FFT Based Convolution" by Gaetan Lehmann https://doi.org/10.54294/0iky0u


See:
 ConvolutionImageFilter

 InverseDeconvolutionImageFilter

 IterativeDeconvolutionImageFilter

 itk::simple::FFTConvolution for the procedural interface

 itk::FFTConvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkFFTConvolutionImageFilter.h
*/
public class FFTConvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected FFTConvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.FFTConvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(FFTConvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(FFTConvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::FFTConvolutionImageFilter::~FFTConvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_FFTConvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::FFTConvolutionImageFilter::FFTConvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  FFTConvolutionImageFilter() {
    this(SimpleITKJNI.new_FFTConvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::FFTConvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.FFTConvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::FFTConvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.FFTConvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FFTConvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.FFTConvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::FFTConvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.FFTConvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::FFTConvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(FFTConvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.FFTConvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::FFTConvolutionImageFilter::GetBoundaryCondition() const
*/
public  FFTConvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return FFTConvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.FFTConvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::FFTConvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(FFTConvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.FFTConvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::FFTConvolutionImageFilter::GetOutputRegionMode() const
*/
public  FFTConvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return FFTConvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.FFTConvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::FFTConvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.FFTConvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::FFTConvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.FFTConvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::FFTConvolutionImageFilter::Execute(const Image &amp;image, const Image &amp;kernelImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image kernelImage) {
    return new Image(SimpleITKJNI.FFTConvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(kernelImage), kernelImage), true);
  }

  public final static class BoundaryConditionType {
    public final static FFTConvolutionImageFilter.BoundaryConditionType ZERO_PAD = new FFTConvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static FFTConvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new FFTConvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static FFTConvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new FFTConvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static FFTConvolutionImageFilter.OutputRegionModeType SAME = new FFTConvolutionImageFilter.OutputRegionModeType("SAME");
    public final static FFTConvolutionImageFilter.OutputRegionModeType VALID = new FFTConvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
