#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-puresat-z-internal
version:              0.1
package-name:         puresat
lib-name:             internal
id:                   puresat-0.1-IEkcz1suN6pLdoR4P7YGit-internal
key:                  puresat-0.1-IEkcz1suN6pLdoR4P7YGit-internal
license:              BSD-3-Clause
copyright:            (c) 2024 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/puresat
synopsis:             Pure Haskell SAT-solver
description:
    SAT Solver implemented in Haskell.

    PureSAT uses DPLL with non-chronological backtracking and learning of binaary clauses.
    Solver is in no-comparison to the state of the art solvers, but it'\''s fast enough to solve sudoku.

category:             Data
abi:                  c8e4203b525961a30d0ec6f3293cc6c9
exposed-modules:
    PureSAT.Assert PureSAT.Base PureSAT.Boost PureSAT.Clause2
    PureSAT.LBool PureSAT.LCG PureSAT.Level PureSAT.LitSet
    PureSAT.LitTable PureSAT.LitVar PureSAT.Main
    PureSAT.PartialAssignment PureSAT.Prim PureSAT.Satisfied
    PureSAT.SparseMaxHeap PureSAT.SparseSet PureSAT.Stats PureSAT.Trail
    PureSAT.Utils PureSAT.VarSet PureSAT.Vec

import-dirs:          /usr/lib/ghc-9.6.6/site-local/puresat-0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/puresat-0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/puresat-0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-puresat
hs-libraries:         HSpuresat-0.1-IEkcz1suN6pLdoR4P7YGit-internal
depends:
    base-4.18.2.1 containers-0.6.7
    primitive-0.9.1.0-AmjYrOULh0Y82MuHW1HjrT

haddock-interfaces:   /usr/share/doc/haskell-puresat/html/puresat.haddock
haddock-html:         /usr/share/doc/haskell-puresat/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-puresat-z-dimacs
version:              0.1
package-name:         puresat
lib-name:             dimacs
id:                   puresat-0.1-GNzl19G5fiM7WHbH4uYBt9-dimacs
key:                  puresat-0.1-GNzl19G5fiM7WHbH4uYBt9-dimacs
license:              BSD-3-Clause
copyright:            (c) 2024 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/puresat
synopsis:             Pure Haskell SAT-solver
description:
    SAT Solver implemented in Haskell.

    PureSAT uses DPLL with non-chronological backtracking and learning of binaary clauses.
    Solver is in no-comparison to the state of the art solvers, but it'\''s fast enough to solve sudoku.

category:             Data
abi:                  8d356fd3f91538574fc30892b9ad55e7
exposed-modules:      PureSAT.DIMACS
import-dirs:          /usr/lib/ghc-9.6.6/site-local/puresat-0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/puresat-0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/puresat-0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-puresat
hs-libraries:         HSpuresat-0.1-GNzl19G5fiM7WHbH4uYBt9-dimacs
depends:
    base-4.18.2.1 bytestring-0.11.5.3 parsec-3.1.16.1
    puresat-0.1-IEkcz1suN6pLdoR4P7YGit-internal

haddock-interfaces:   /usr/share/doc/haskell-puresat/html/puresat.haddock
haddock-html:         /usr/share/doc/haskell-puresat/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 puresat
version:              0.1
visibility:           public
id:                   puresat-0.1-6TVyTC19VOO77LwyynGZPH
key:                  puresat-0.1-6TVyTC19VOO77LwyynGZPH
license:              BSD-3-Clause
copyright:            (c) 2024 Oleg Grenrus
maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/puresat
synopsis:             Pure Haskell SAT-solver
description:
    SAT Solver implemented in Haskell.

    PureSAT uses DPLL with non-chronological backtracking and learning of binaary clauses.
    Solver is in no-comparison to the state of the art solvers, but it'\''s fast enough to solve sudoku.

category:             Data
abi:                  f11f2ccfd359a5789b38df690af99f81
exposed:              True
exposed-modules:      Control.Monad.SAT PureSAT
hidden-modules:       EST
import-dirs:          /usr/lib/ghc-9.6.6/site-local/puresat-0.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/puresat-0.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/puresat-0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-puresat
hs-libraries:         HSpuresat-0.1-6TVyTC19VOO77LwyynGZPH
depends:
    base-4.18.2.1 containers-0.6.7
    puresat-0.1-IEkcz1suN6pLdoR4P7YGit-internal

haddock-interfaces:   /usr/share/doc/haskell-puresat/html/puresat.haddock
haddock-html:         /usr/share/doc/haskell-puresat/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

