#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 HTF
version:              0.15.0.2
visibility:           public
id:                   HTF-0.15.0.2-61BNZIjPNCKJN9RrgXm77h
key:                  HTF-0.15.0.2-61BNZIjPNCKJN9RrgXm77h
license:              LGPL-2.1-only
copyright:            (c) 2005-2024 Stefan Wehr
maintainer:           Stefan Wehr
author:               Stefan Wehr
stability:            Beta
homepage:             https://github.com/skogsbaer/HTF/
synopsis:             The Haskell Test Framework
description:
    The Haskell Test Framework (/HTF/ for short) lets you define and organize unit tests,
    QuickCheck properties,
    and black box tests in an
    easy and convenient way. HTF uses a custom preprocessor that collects
    test definitions automatically.

    HTF produces highly readable output
    for failing test cases: it provides exact file name and line number
    information,
    it colors and pretty prints expected and
    actual results, and it displays a diff highlighting the mismatching parts.

    The documentation of the "Test.Framework.Tutorial" module
    provides a tutorial for HTF. The /sample/ directory in
    the HTF repo provides a good starting point for
    a project using HTF.

category:             Testing
abi:                  0c68771a52ade5ac54a8b623021be158
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.AssertM Test.Framework.BlackBoxTest
    Test.Framework.HUnitWrapper Test.Framework.History
    Test.Framework.JsonOutput Test.Framework.Location
    Test.Framework.Preprocessor Test.Framework.Pretty
    Test.Framework.PrettyHaskell Test.Framework.QuickCheckWrapper
    Test.Framework.TestInterface Test.Framework.TestManager
    Test.Framework.TestTypes Test.Framework.ThreadPool
    Test.Framework.Tutorial Test.Framework.XmlOutput

hidden-modules:
    Paths_HTF Test.Framework.CmdlineOptions Test.Framework.Colors
    Test.Framework.Diff Test.Framework.Process
    Test.Framework.TestReporter Test.Framework.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-htf
hs-libraries:         HSHTF-0.15.0.2-61BNZIjPNCKJN9RrgXm77h
depends:
    Diff-0.5-IogcF5fQ5dZG0PEbxrqbdI
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    QuickCheck-2.15.0.1-8WOZKPDaVcqBn81v5fpGVL
    aeson-2.1.2.1-KHwyqlRT8uq4KliO3neHti array-0.5.4.0 base-4.17.2.1
    base64-bytestring-1.2.1.0-F6smDE5HGDf8fxaFSXDtqF
    bytestring-0.11.5.3 containers-0.6.7
    cpphs-1.20.9.1-2DOXkAxjH8X2uNUFEwCYhv directory-1.3.7.1
    haskell-src-1.0.4.2-KtVS50g076cHW32UtRdq9d
    lifted-base-0.2.3.12-KJvM774tIJVFiPFul3K1Yv
    monad-control-1.0.3.1-BOt9UiTcmLyI9gMDVX2E5U mtl-2.2.2
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9 pretty-1.1.3.6
    process-1.6.18.0 random-1.2.1.3-KqHaq6YE0664JHSWbd4LQ1
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8 text-2.0.2 time-1.12.2
    unix-2.7.3 vector-0.13.2.0-EKABDCAVgb42yYEtp4rYAX
    xmlgen-0.6.2.2-IZ1KH7NGefz6PwNfZfF3q8

haddock-interfaces:   /usr/share/doc/haskell-htf/html/HTF.haddock
haddock-html:         /usr/share/doc/haskell-htf/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

