#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 clash-lib
version:              1.8.2
visibility:           public
id:                   clash-lib-1.8.2-LFgoGRX61VJ4JMOPteOxYx
key:                  clash-lib-1.8.2-LFgoGRX61VJ4JMOPteOxYx
license:              BSD-2-Clause
copyright:
    Copyright © 2012-2016, University of Twente,
    2016-2019, Myrtle Software Ltd,
    2017-2023, QBayLogic B.V., Google Inc.

maintainer:           QBayLogic B.V. <devops@qbaylogic.com>
author:               The Clash Authors
homepage:             https://clash-lang.org/
synopsis:
    Clash: a functional hardware description language - As a library

description:
    Clash is a functional hardware description language that borrows both its
    syntax and semantics from the functional programming language Haskell. The
    Clash compiler transforms these high-level descriptions to low-level
    synthesizable VHDL, Verilog, or SystemVerilog.

    Features of Clash:

    * Strongly typed, but with a very high degree of type inference, enabling both
    safe and fast prototyping using concise descriptions.

    * Interactive REPL: load your designs in an interpreter and easily test all
    your component without needing to setup a test bench.

    * Higher-order functions, with type inference, result in designs that are
    fully parametric by default.

    * Synchronous sequential circuit design based on streams of values, called
    @Signal@s, lead to natural descriptions of feedback loops.

    * Support for multiple clock domains, with type safe clock domain crossing.


    This package provides:

    * The CoreHW internal language: SystemF + Letrec + Case-decomposition

    * The normalisation process that brings CoreHW in a normal form that can be
    converted to a netlist

    * Blackbox/Primitive Handling


    Front-ends (for: parsing, typecheck, etc.) are provided by separate packages:

    * <https://hackage.haskell.org/package/clash-ghc GHC/Haskell Frontend>

    * <https://github.com/christiaanb/Idris-dev Idris Frontend>


    Prelude library: <https://hackage.haskell.org/package/clash-prelude>

category:             Hardware
abi:                  365859bdb936c218e89e16da009fcaf4
exposed:              True
exposed-modules:
    Clash.Annotations.BitRepresentation.ClashLib Clash.Backend
    Clash.Backend.SystemVerilog Clash.Backend.VHDL
    Clash.Backend.Verilog Clash.Backend.Verilog.Time Clash.Core.DataCon
    Clash.Core.EqSolver Clash.Core.Evaluator.Types Clash.Core.FreeVars
    Clash.Core.HasFreeVars Clash.Core.HasType Clash.Core.Literal
    Clash.Core.Name Clash.Core.PartialEval
    Clash.Core.PartialEval.AsTerm Clash.Core.PartialEval.Monad
    Clash.Core.PartialEval.NormalForm Clash.Core.Pretty
    Clash.Core.Subst Clash.Core.Term Clash.Core.TermInfo
    Clash.Core.TermLiteral Clash.Core.TermLiteral.TH Clash.Core.TyCon
    Clash.Core.Type Clash.Core.TysPrim Clash.Core.Util Clash.Core.Var
    Clash.Core.VarEnv Clash.Data.UniqMap Clash.DataFiles Clash.Debug
    Clash.Driver Clash.Driver.Bool Clash.Driver.Manifest
    Clash.Driver.Types Clash.Edalize.Edam Clash.Netlist
    Clash.Netlist.BlackBox Clash.Netlist.BlackBox.Parser
    Clash.Netlist.BlackBox.Types Clash.Netlist.BlackBox.Util
    Clash.Netlist.Expr Clash.Netlist.Id Clash.Netlist.Id.Common
    Clash.Netlist.Id.Internal Clash.Netlist.Id.SystemVerilog
    Clash.Netlist.Id.VHDL Clash.Netlist.Id.Verilog Clash.Netlist.Types
    Clash.Netlist.Util Clash.Normalize
    Clash.Normalize.PrimitiveReductions Clash.Normalize.Primitives
    Clash.Normalize.Strategy Clash.Normalize.Transformations
    Clash.Normalize.Transformations.ANF
    Clash.Normalize.Transformations.Case
    Clash.Normalize.Transformations.Cast
    Clash.Normalize.Transformations.DEC
    Clash.Normalize.Transformations.EtaExpand
    Clash.Normalize.Transformations.Inline
    Clash.Normalize.Transformations.Letrec
    Clash.Normalize.Transformations.MultiPrim
    Clash.Normalize.Transformations.Reduce
    Clash.Normalize.Transformations.SeparateArgs
    Clash.Normalize.Transformations.Specialize
    Clash.Normalize.Transformations.XOptimize Clash.Normalize.Types
    Clash.Normalize.Util Clash.Pretty
    Clash.Primitives.Annotations.SynthesisAttributes
    Clash.Primitives.DSL Clash.Primitives.GHC.Int
    Clash.Primitives.GHC.Literal Clash.Primitives.GHC.Word
    Clash.Primitives.Intel.ClockGen Clash.Primitives.Magic
    Clash.Primitives.Sized.Signed Clash.Primitives.Sized.ToInteger
    Clash.Primitives.Sized.Vector Clash.Primitives.Types
    Clash.Primitives.Util Clash.Primitives.Verification
    Clash.Primitives.Xilinx.ClockGen Clash.Rewrite.Combinators
    Clash.Rewrite.Types Clash.Rewrite.Util Clash.Rewrite.WorkFree
    Clash.Unique Clash.Util Clash.Util.Eq Clash.Util.Graph
    Clash.Util.Interpolate Clash.Util.Supply Clash.Verification.Pretty
    Data.Aeson.Extra Data.Text.Prettyprint.Doc.Extra
    GHC.BasicTypes.Extra

hidden-modules:
    Clash.Annotations.TopEntity.Extra Data.IntMap.Extra Data.List.Extra
    Data.Map.Ordered.Extra Data.Monoid.Extra
    Data.Primitive.ByteArray.Extra Data.Set.Ordered.Extra
    Data.Text.Extra GHC.SrcLoc.Extra Paths_clash_lib

import-dirs:          /usr/lib/ghc-9.6.6/site-local/clash-lib-1.8.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/clash-lib-1.8.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/clash-lib-1.8.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-clash-lib
hs-libraries:         HSclash-lib-1.8.2-LFgoGRX61VJ4JMOPteOxYx
depends:
    aeson-2.1.2.1-KAplhvfLEdp6k37mi9zTZA
    aeson-pretty-0.8.10-4x4ypBnGO9IVSNKcDWoP9
    ansi-terminal-1.0.2-5RUb9SpCZmqDNBPT2BV2fb array-0.5.6.0
    async-2.2.5-7QLouev6UZnCRkgh8pzL0M
    attoparsec-0.14.4-ARFIPKVHAQdH6rZ1P31wQY
    attoparsec-aeson-2.1.0.0-3BmzrRmuboN9yKjU3uAJWM base-4.18.2.1
    base16-bytestring-1.0.2.0-6dMnLpvCfjZITVAVfsWwso binary-0.8.9.1
    bytestring-0.11.5.3 clash-prelude-1.8.2-HweLGVbW9KJ716demNWbjJ
    containers-0.6.7
    cryptohash-sha256-0.11.102.1-ApSk5LfMHTl1SNuSBD4pe1
    data-binary-ieee754-0.4.4-4UW07Uhzyok6gyNDRTrrKK
    data-default-0.7.1.3-EtVHsfbH5oIpJ9umzYHUz deepseq-1.4.8.1
    directory-1.3.8.5 dlist-1.0-B7D1vsARFiIHVaGk5CGbYO
    exceptions-0.10.7 extra-1.7.16-8xfhX7g6qo3J4L1mTio5RX
    filepath-1.4.300.1 ghc-9.6.6 ghc-bignum-1.3 ghc-boot-th-9.6.6
    ghc-prim-0.10.0 hashable-1.4.7.0-9Up8LPJnqTG92zCMBiHaIh
    haskell-src-meta-0.8.15-LBcHkcwhTm5LXkELzKR9cO
    hint-0.9.0.8-In9fGtvZfWr9gRtNma112f
    infinite-list-0.1.2-7wQ9e7q6Hw95c1M2R2lW15
    lens-5.3.3-ATynRreA1Nv2YBaKYxJYCc mtl-2.3.1
    ordered-containers-0.2.4-rxVOB73VokJ9Uy5el6Uvt
    pretty-show-1.10-EXsS4VwIV5tJ56gbmVdfrR
    prettyprinter-1.7.1-3RIfAGP8Xsr2KtHw8aT8ed
    prettyprinter-interp-0.2.0.0-1S6RR3e2FgSAv37fNstnY7
    primitive-0.9.1.0-AmjYrOULh0Y82MuHW1HjrT
    string-interpolate-0.3.4.0-9WKqrxH0rdQAsw4nMh64wp
    template-haskell-2.20.0.0 temporary-1.3-CdOGj1QmJdlAICjb9ViQf9
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2 time-1.12.2
    transformers-0.6.1.0 trifecta-2.1.4-6I0fPSjSoaPIpmnHfp9bCg
    unordered-containers-0.2.20.1-CjV5euINhym8dGoasHPURS
    vector-0.13.2.0-3Co1wNPhccp6XnsJEn8cXR
    vector-binary-instances-0.2.5.2-Icf3cJJhCgW4lKdS51reKr
    yaml-0.11.11.2-2uKQ3imTBzRK4XVeM4BHFd

haddock-interfaces:   /usr/share/doc/haskell-clash-lib/html/clash-lib.haddock
haddock-html:         /usr/share/doc/haskell-clash-lib/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

