/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.anim.dom;

import io.sf.carte.echosvg.anim.dom.SVG12DOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGDOMImplementation;
import io.sf.carte.echosvg.anim.dom.SVGOMDocument;
import io.sf.carte.echosvg.dom.svg.SVGDocumentFactory;
import io.sf.carte.echosvg.dom.util.SAXDocumentFactory;
import io.sf.carte.echosvg.util.MimeTypeConstants;
import io.sf.carte.echosvg.util.ParsedURL;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.svg.SVGDocument;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXSVGDocumentFactory
extends SAXDocumentFactory
implements SVGDocumentFactory {
    private static final String HTTP_CHARSET = "charset";

    public SAXSVGDocumentFactory() {
        this(null);
    }

    public SAXSVGDocumentFactory(XMLReader xMLReader) {
        this(xMLReader, false);
    }

    public SAXSVGDocumentFactory(XMLReader xMLReader, boolean bl) {
        super(SVGDOMImplementation.getDOMImplementation(), xMLReader, bl);
    }

    public SVGDocument createSVGDocument(String string) throws IOException {
        return this.createDocument(string);
    }

    public SVGDocument createSVGDocument(String string, InputStream inputStream) throws IOException {
        return this.createDocument(string, inputStream, null);
    }

    public SVGDocument createSVGDocument(String string, Reader reader) throws IOException {
        return this.createDocument(string, reader);
    }

    public SVGDocument createDocument(String string) throws IOException {
        return this.createDocumentWithDefaultEncoding(string, null);
    }

    public SVGDocument createDocument(String string, String string2) throws IOException {
        return this.createDocumentWithDefaultEncoding(string, string2);
    }

    private SVGDocument createDocumentWithDefaultEncoding(String string, String string2) throws IOException {
        int n;
        int n2;
        ParsedURL parsedURL = new ParsedURL(string);
        InputStream inputStream = parsedURL.openStream(MimeTypeConstants.MIME_TYPES_SVG_LIST.iterator());
        string = parsedURL.getPostConnectionURL();
        InputSource inputSource = new InputSource(inputStream);
        String string3 = parsedURL.getContentType();
        int n3 = -1;
        if (string3 != null) {
            string3 = string3.toLowerCase();
            n3 = string3.indexOf(HTTP_CHARSET);
        }
        String string4 = string2;
        if (n3 != -1 && (n2 = string3.indexOf(61, n = n3 + HTTP_CHARSET.length())) != -1) {
            int n4 = string3.indexOf(44, ++n2);
            int n5 = string3.indexOf(59, n2);
            if (n5 != -1 && (n5 < n4 || n4 == -1)) {
                n4 = n5;
            }
            string4 = n4 != -1 ? string3.substring(n2, n4) : string3.substring(n2);
            string4 = string4.trim();
        }
        inputSource.setEncoding(string4);
        inputSource.setSystemId(string);
        SVGOMDocument sVGOMDocument = (SVGOMDocument)((Object)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource));
        sVGOMDocument.setParsedURL(new ParsedURL(string));
        sVGOMDocument.setDocumentInputEncoding(string4);
        sVGOMDocument.setXmlStandalone(this.isStandalone());
        sVGOMDocument.setXmlVersion(this.getXmlVersion());
        inputStream.close();
        return sVGOMDocument;
    }

    public SVGDocument createDocument(String string, InputStream inputStream) throws IOException {
        return this.createDocument(string, inputStream, null);
    }

    public SVGDocument createDocument(String string, InputStream inputStream, String string2) throws IOException {
        SVGOMDocument sVGOMDocument;
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setSystemId(string);
        inputSource.setEncoding(string2);
        try {
            sVGOMDocument = (SVGOMDocument)((Object)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource));
            if (string != null) {
                sVGOMDocument.setParsedURL(new ParsedURL(string));
            }
            SVGOMDocument sVGOMDocument2 = sVGOMDocument;
            sVGOMDocument2.setDocumentURI(string);
            sVGOMDocument2.setXmlStandalone(this.isStandalone());
            sVGOMDocument2.setXmlVersion(this.getXmlVersion());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return sVGOMDocument;
    }

    public SVGDocument createDocument(String string, Reader reader) throws IOException {
        SVGOMDocument sVGOMDocument;
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string);
        try {
            sVGOMDocument = (SVGOMDocument)((Object)super.createDocument("http://www.w3.org/2000/svg", "svg", string, inputSource));
            if (string != null) {
                sVGOMDocument.setParsedURL(new ParsedURL(string));
            }
            SVGOMDocument sVGOMDocument2 = sVGOMDocument;
            sVGOMDocument2.setDocumentURI(string);
            sVGOMDocument2.setXmlStandalone(this.isStandalone());
            sVGOMDocument2.setXmlVersion(this.getXmlVersion());
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException(malformedURLException.getMessage());
        }
        return sVGOMDocument;
    }

    public SVGDocument createDocument(String string, String string2, String string3) throws IOException {
        return this.createDocument(string3);
    }

    public SVGDocument createDocument(String string, String string2, String string3, String string4) throws IOException {
        return this.createDocument(string3, string4);
    }

    protected void checkRootElement(String string, String string2) {
        if (!"http://www.w3.org/2000/svg".equals(string) || !"svg".equals(string2)) {
            throw new IllegalArgumentException("Bad root element");
        }
    }

    public SVGDocument createDocument(String string, String string2, String string3, InputStream inputStream) throws IOException {
        return this.createDocument(string3, inputStream, null);
    }

    public SVGDocument createDocument(String string, String string2, String string3, InputStream inputStream, String string4) throws IOException {
        return this.createDocument(string3, inputStream, string4);
    }

    public SVGDocument createDocument(String string, String string2, String string3, Reader reader) throws IOException {
        return this.createDocument(string3, reader);
    }

    public DOMImplementation getDOMImplementation(String string) {
        if (!"1.2".equals(string)) {
            return SVGDOMImplementation.getDOMImplementation();
        }
        return SVG12DOMImplementation.getDOMImplementation();
    }

    public void startDocument() throws SAXException {
        super.startDocument();
    }
}

