/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.ComponentValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericValue;
import io.sf.carte.echosvg.css.engine.value.TypedValue;
import org.w3c.api.DOMSyntaxException;
import org.w3c.css.om.typed.CSSColorValue;
import org.w3c.css.om.typed.CSSNumericValue;

public abstract class ColorValue
extends ComponentValue
implements TypedValue,
CSSColorValue {
    private static final long serialVersionUID = 1L;
    public static final String RGB_FUNCTION = "rgb";
    public static final String CS_SRGB = "srgb";
    public static final String LAB = "lab";
    public static final String LCH = "lch";
    public static final String CS_DISPLAY_P3 = "display-p3";
    public static final String CS_SRGB_LINEAR = "srgb-linear";
    public static final String CS_A98_RGB = "a98-rgb";
    public static final String CS_PROPHOTO_RGB = "prophoto-rgb";
    public static final String CS_REC2020 = "rec2020";
    public static final String CS_XYZ_D50 = "xyz-d50";
    public static final String CS_XYZ_D65 = "xyz-d65";
    public static final String CS_XYZ = "xyz";
    protected NumericValue alpha;

    protected ColorValue() {
    }

    protected ColorValue(NumericValue numericValue) throws DOMSyntaxException {
        this.setAlphaChannel(numericValue);
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.COLOR;
    }

    public abstract String getCSSColorSpace();

    public NumericValue getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = new FloatValue(2, (float)d * 100.0f);
        this.componentize(this.alpha);
        this.componentChanged(this.alpha);
    }

    public void setAlpha(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        this.setAlphaChannel(cSSNumericValue);
    }

    private void setAlphaChannel(CSSNumericValue cSSNumericValue) throws DOMSyntaxException {
        NumericValue numericValue = (NumericValue)cSSNumericValue;
        if (numericValue.getUnitType() != 2 && numericValue.getUnitType() != 0) {
            throw new DOMSyntaxException("Alpha channel must be a number or percentage.");
        }
        this.componentize(numericValue);
        this.alpha = numericValue;
        this.componentChanged(numericValue);
    }

    boolean isOpaque() {
        switch (this.alpha.getUnitType()) {
            case 0: {
                return this.alpha.getFloatValue() == 1.0f;
            }
            case 2: {
                return this.alpha.getFloatValue() == 100.0f;
            }
        }
        return false;
    }

    @Override
    public ColorValue getColorValue() {
        return this;
    }

    @Override
    public ColorValue clone() {
        ColorValue colorValue = (ColorValue)super.clone();
        colorValue.alpha = this.alpha.clone();
        return colorValue;
    }
}

