/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.core.importer.ClassFileLocation;
import com.tngtech.archunit.core.importer.ImportOptions;
import com.tngtech.archunit.core.importer.Location;
import com.tngtech.archunit.core.importer.NormalizedResourceName;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarEntry;
import java.util.stream.Collectors;

@Internal
interface ClassFileSource
extends Iterable<ClassFileLocation> {

    @Internal
    public static class FileToImport {
        static boolean isRelevant(String simpleFileName) {
            return simpleFileName.endsWith(".class") && !simpleFileName.equals("module-info.class");
        }
    }

    @Internal
    public static abstract class InputStreamSupplier
    implements Supplier<InputStream> {
        @Override
        public InputStream get() {
            try {
                return this.getInputStream();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        abstract InputStream getInputStream() throws IOException;
    }

    @Internal
    public static class InputStreamSupplierClassFileLocation
    implements ClassFileLocation {
        private final URI uri;
        private final Supplier<InputStream> streamSupplier;

        InputStreamSupplierClassFileLocation(URI uri, Supplier<InputStream> streamSupplier) {
            this.uri = uri;
            this.streamSupplier = streamSupplier;
        }

        @Override
        public InputStream openStream() {
            return this.streamSupplier.get();
        }

        @Override
        public URI getUri() {
            return this.uri;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{uri=" + this.uri + '}';
        }
    }

    @Internal
    public static class FromJar
    implements ClassFileSource {
        private final Iterable<ClassFileLocation> classFileLocations;

        FromJar(URL jarUrl, String path, ImportOptions importOptions) {
            this(jarUrl, NormalizedResourceName.from(path), importOptions);
        }

        FromJar(URL jarUrl, NormalizedResourceName path, ImportOptions importOptions) {
            try {
                JarURLConnection connection = (JarURLConnection)jarUrl.openConnection();
                this.classFileLocations = Collections.list(connection.getJarFile().entries()).stream().filter(this.classFilesBeneath(path)).map(this.toClassFilesInJarOf(connection)).filter(this.by(importOptions)).map(this.toInputStreamSupplier()).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private Predicate<JarEntry> classFilesBeneath(NormalizedResourceName prefix) {
            return input -> input.getName().startsWith(prefix.toEntryName()) && FileToImport.isRelevant(input.getName());
        }

        private Function<JarEntry, ClassFileInJar> toClassFilesInJarOf(JarURLConnection connection) {
            return input -> new ClassFileInJar(connection, (JarEntry)input);
        }

        private Predicate<ClassFileInJar> by(ImportOptions importOptions) {
            return input -> input.isIncludedIn(importOptions);
        }

        private Function<ClassFileInJar, ClassFileLocation> toInputStreamSupplier() {
            return input -> new InputStreamSupplierClassFileLocation(input.getUri(), new InputStreamSupplier((ClassFileInJar)input){
                final /* synthetic */ ClassFileInJar val$input;
                {
                    this.val$input = classFileInJar;
                }

                @Override
                InputStream getInputStream() throws IOException {
                    return this.val$input.openStream();
                }
            });
        }

        @Override
        public Iterator<ClassFileLocation> iterator() {
            return this.classFileLocations.iterator();
        }

        private static class ClassFileInJar {
            private final JarURLConnection connection;
            private final JarEntry jarEntry;
            private final URI uri;

            private ClassFileInJar(JarURLConnection connection, JarEntry jarEntry) {
                this.connection = connection;
                this.jarEntry = jarEntry;
                this.uri = this.makeJarUri(jarEntry);
            }

            private URI makeJarUri(JarEntry input) {
                return Location.of(this.connection.getURL()).append(input.getName()).asURI();
            }

            URI getUri() {
                return this.uri;
            }

            InputStream openStream() throws IOException {
                return this.connection.getJarFile().getInputStream(this.jarEntry);
            }

            boolean isIncludedIn(ImportOptions importOptions) {
                return importOptions.include(Location.of(this.uri));
            }
        }
    }

    @Internal
    public static class FromFilePath
    extends SimpleFileVisitor<Path>
    implements ClassFileSource {
        private final Set<ClassFileLocation> classFileLocations = new HashSet<ClassFileLocation>();
        private final ImportOptions importOptions;

        FromFilePath(Path path, ImportOptions importOptions) {
            this.importOptions = importOptions;
            if (path.toFile().exists()) {
                try {
                    Files.walkFileTree(path, this);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        @Override
        public Iterator<ClassFileLocation> iterator() {
            return this.classFileLocations.iterator();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (this.shouldBeConsidered(file)) {
                this.classFileLocations.add(new InputStreamSupplierClassFileLocation(file.toUri(), this.newInputStreamSupplierFor(file)));
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean shouldBeConsidered(Path file) {
            Path fileName = file.getFileName();
            return fileName != null && FileToImport.isRelevant(fileName.toString()) && this.importOptions.include(Location.of(file));
        }

        private Supplier<InputStream> newInputStreamSupplierFor(final Path file) {
            return new InputStreamSupplier(){

                @Override
                InputStream getInputStream() throws IOException {
                    return Files.newInputStream(file, new OpenOption[0]);
                }
            };
        }
    }
}

