/*
 * Decompiled with CFR 0.152.
 */
package firrtl.backends.experimental.smt;

import firrtl.backends.experimental.smt.ArrayFunctionCall;
import firrtl.backends.experimental.smt.ArraySymbol;
import firrtl.backends.experimental.smt.BVAnd$;
import firrtl.backends.experimental.smt.BVExpr;
import firrtl.backends.experimental.smt.BVForall;
import firrtl.backends.experimental.smt.BVFunctionCall;
import firrtl.backends.experimental.smt.BVLiteral;
import firrtl.backends.experimental.smt.BVNot$;
import firrtl.backends.experimental.smt.BVSymbol;
import firrtl.backends.experimental.smt.Comment;
import firrtl.backends.experimental.smt.Comment$;
import firrtl.backends.experimental.smt.DeclareFunction;
import firrtl.backends.experimental.smt.DeclareUninterpretedSort;
import firrtl.backends.experimental.smt.DefineFunction;
import firrtl.backends.experimental.smt.IsBad$;
import firrtl.backends.experimental.smt.IsConstraint$;
import firrtl.backends.experimental.smt.IsFair$;
import firrtl.backends.experimental.smt.IsInit$;
import firrtl.backends.experimental.smt.IsNext$;
import firrtl.backends.experimental.smt.IsNode$;
import firrtl.backends.experimental.smt.IsOutput$;
import firrtl.backends.experimental.smt.SMTCommand;
import firrtl.backends.experimental.smt.SMTEqual$;
import firrtl.backends.experimental.smt.SMTExpr;
import firrtl.backends.experimental.smt.SMTExprMap$;
import firrtl.backends.experimental.smt.SMTFunctionArg;
import firrtl.backends.experimental.smt.SMTLibSerializer$;
import firrtl.backends.experimental.smt.SMTSymbol;
import firrtl.backends.experimental.smt.SMTSymbol$;
import firrtl.backends.experimental.smt.Signal;
import firrtl.backends.experimental.smt.SignalLabel;
import firrtl.backends.experimental.smt.State;
import firrtl.backends.experimental.smt.TransitionSystem;
import firrtl.backends.experimental.smt.TransitionSystem$;
import firrtl.backends.experimental.smt.True$;
import firrtl.backends.experimental.smt.UTSymbol;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SMTTransitionSystemEncoder$ {
    public static final SMTTransitionSystemEncoder$ MODULE$ = new SMTTransitionSystemEncoder$();
    private static final String SignalSuffix = "_f";
    private static final String NextSuffix = "_next";
    private static final String InitSuffix = "_init";
    private static final String AssertionSuffix = "_a";
    private static final String AssumptionSuffix = "_u";

    /*
     * WARNING - void declaration
     */
    public Iterable<SMTCommand> encode(TransitionSystem sys) {
        void var2_2;
        ArrayBuffer cmds = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String name = sys.name();
        cmds.$plus$plus$eq(TransitionSystem$.MODULE$.findUninterpretedFunctions(sys));
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sys.header())) ? cmds.$plus$plus$eq(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps(StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(sys.header()), '\n')), Comment$.MODULE$, ClassTag$.MODULE$.apply(Comment.class)))) : BoxedUnit.UNIT;
        String stateType = this.id(new StringBuilder(2).append(name).append("_s").toString());
        cmds.$plus$eq(new DeclareUninterpretedSort(stateType));
        UTSymbol State2 = new UTSymbol("state", stateType);
        UTSymbol StateNext = new UTSymbol("state_n", stateType);
        sys.inputs().foreach((Function1<BVSymbol, Object> & Serializable)i -> {
            this.declare$1(i, "input", cmds, sys, State2);
            return BoxedUnit.UNIT;
        });
        sys.states().foreach((Function1<State, Object> & Serializable)s -> {
            this.declare$1(s.sym(), "register", cmds, sys, State2);
            return BoxedUnit.UNIT;
        });
        sys.signals().foreach((Function1<Signal, Object> & Serializable)signal -> {
            SMTTransitionSystemEncoder$.$anonfun$encode$4(this, cmds, sys, State2, signal);
            return BoxedUnit.UNIT;
        });
        sys.states().foreach((Function1<State, Object> & Serializable)state -> {
            SMTTransitionSystemEncoder$.$anonfun$encode$6(this, State2, cmds, state);
            return BoxedUnit.UNIT;
        });
        Object transitionRelations = sys.states().map((Function1<State, BVExpr> & Serializable)state -> {
            SMTExpr newState = MODULE$.replaceSymbols(MODULE$.SignalSuffix(), StateNext, MODULE$.replaceSymbols$default$3(), state.sym());
            SMTExpr nextOldState = MODULE$.replaceSymbols(MODULE$.NextSuffix(), State2, MODULE$.replaceSymbols$default$3(), state.sym());
            return SMTEqual$.MODULE$.apply(newState, nextOldState);
        });
        BVLiteral transitionExpr = ((List)transitionRelations).isEmpty() ? True$.MODULE$.apply() : this.replaceSymbols(this.SignalSuffix(), State2, this.replaceSymbols$default$3(), BVAnd$.MODULE$.apply((List<BVExpr>)transitionRelations));
        cmds.$plus$eq(new DefineFunction(new StringBuilder(2).append(name).append("_t").toString(), (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UTSymbol[]{State2, StateNext})), transitionExpr));
        Object initRelations = ((List)sys.states().filter((Function1<State, Object> & Serializable)x$1 -> BoxesRunTime.boxToBoolean(SMTTransitionSystemEncoder$.$anonfun$encode$10(x$1)))).map((Function1<State, BVExpr> & Serializable)state -> {
            SMTExpr stateSignal = MODULE$.replaceSymbols(MODULE$.SignalSuffix(), State2, MODULE$.replaceSymbols$default$3(), state.sym());
            SMTExpr initSignal = MODULE$.replaceSymbols(MODULE$.InitSuffix(), State2, MODULE$.replaceSymbols$default$3(), state.sym());
            return SMTEqual$.MODULE$.apply(stateSignal, initSignal);
        });
        this.defineConjunction$1((List)initRelations, "_i", name, State2, cmds);
        Object assertions = ((List)sys.signals().filter((Function1<Signal, Object> & Serializable)x$2 -> BoxesRunTime.boxToBoolean(SMTTransitionSystemEncoder$.$anonfun$encode$12(x$2)))).map((Function1<Signal, SMTExpr> & Serializable)a -> MODULE$.replaceSymbols(MODULE$.SignalSuffix(), State2, MODULE$.replaceSymbols$default$3(), a.sym()));
        this.defineConjunction$1((List)((List)assertions).map((Function1<SMTExpr, BVExpr> & Serializable)x$3 -> (BVExpr)x$3), this.AssertionSuffix(), name, State2, cmds);
        Object assumptions = ((List)sys.signals().filter((Function1<Signal, Object> & Serializable)x$4 -> BoxesRunTime.boxToBoolean(SMTTransitionSystemEncoder$.$anonfun$encode$15(x$4)))).map((Function1<Signal, SMTExpr> & Serializable)a -> MODULE$.replaceSymbols(MODULE$.SignalSuffix(), State2, MODULE$.replaceSymbols$default$3(), a.sym()));
        this.defineConjunction$1((List)((List)assumptions).map((Function1<SMTExpr, BVExpr> & Serializable)x$5 -> (BVExpr)x$5), this.AssumptionSuffix(), name, State2, cmds);
        return var2_2;
    }

    private String id(String s) {
        return SMTLibSerializer$.MODULE$.escapeIdentifier(s);
    }

    private String SignalSuffix() {
        return SignalSuffix;
    }

    private String NextSuffix() {
        return NextSuffix;
    }

    private String InitSuffix() {
        return InitSuffix;
    }

    public String AssertionSuffix() {
        return AssertionSuffix;
    }

    public String AssumptionSuffix() {
        return AssumptionSuffix;
    }

    private String lblToKind(SignalLabel lbl) {
        String string;
        SignalLabel signalLabel = lbl;
        boolean bl = IsNode$.MODULE$.equals(signalLabel) ? true : (IsInit$.MODULE$.equals(signalLabel) ? true : IsNext$.MODULE$.equals(signalLabel));
        if (bl) {
            string = "wire";
        } else if (IsOutput$.MODULE$.equals(signalLabel)) {
            string = "output";
        } else if (IsBad$.MODULE$.equals(signalLabel)) {
            string = "assert";
        } else if (IsConstraint$.MODULE$.equals(signalLabel)) {
            string = "assume";
        } else if (IsFair$.MODULE$.equals(signalLabel)) {
            string = "fair";
        } else {
            throw new MatchError(signalLabel);
        }
        return string;
    }

    private List<Comment> toDescription(SMTSymbol sym, String kind, Function1<String, Option<String>> comments) {
        Comment comment;
        List$ list$2 = package$.MODULE$.List();
        Comment[] commentArray = new Comment[1];
        SMTSymbol sMTSymbol = sym;
        if (sMTSymbol instanceof BVSymbol) {
            BVSymbol bVSymbol = (BVSymbol)sMTSymbol;
            String name = bVSymbol.name();
            int width = bVSymbol.width();
            comment = new Comment(new StringBuilder(14).append("firrtl-smt2-").append(kind).append(" ").append(name).append(" ").append(width).toString());
        } else if (sMTSymbol instanceof ArraySymbol) {
            ArraySymbol arraySymbol = (ArraySymbol)sMTSymbol;
            String name = arraySymbol.name();
            int indexWidth = arraySymbol.indexWidth();
            int dataWidth = arraySymbol.dataWidth();
            comment = new Comment(new StringBuilder(15).append("firrtl-smt2-").append(kind).append(" ").append(name).append(" ").append(indexWidth).append(" ").append(dataWidth).toString());
        } else {
            throw new MatchError(sMTSymbol);
        }
        commentArray[0] = comment;
        return (List)((IterableOps)list$2.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])commentArray))).$plus$plus(comments.apply(sym.name()).map(Comment$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SMTExpr replaceSymbols(String suffix, SMTFunctionArg arg, Set<String> vars, SMTExpr e2) {
        SMTExpr sMTExpr = e2;
        if (sMTExpr instanceof BVSymbol) {
            BVSymbol bVSymbol = (BVSymbol)sMTExpr;
            String name = bVSymbol.name();
            int width = bVSymbol.width();
            if (!vars.apply(name)) {
                return new BVFunctionCall(this.id(new StringBuilder(0).append(name).append(suffix).toString()), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SMTFunctionArg[]{arg})), width);
            }
        }
        if (sMTExpr instanceof ArraySymbol) {
            ArraySymbol arraySymbol = (ArraySymbol)sMTExpr;
            String name = arraySymbol.name();
            int indexWidth = arraySymbol.indexWidth();
            int dataWidth = arraySymbol.dataWidth();
            if (!vars.apply(name)) {
                return new ArrayFunctionCall(this.id(new StringBuilder(0).append(name).append(suffix).toString()), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SMTFunctionArg[]{arg})), indexWidth, dataWidth);
            }
        }
        if (!(sMTExpr instanceof BVForall)) return SMTExprMap$.MODULE$.mapExpr(sMTExpr, (Function1<SMTExpr, SMTExpr> & Serializable)e -> MODULE$.replaceSymbols(suffix, arg, vars, (SMTExpr)e));
        BVForall bVForall = (BVForall)sMTExpr;
        BVSymbol variable = bVForall.variable();
        Set set = (Set)vars.$plus(variable.name());
        return SMTExprMap$.MODULE$.mapExpr(bVForall, (Function1<SMTExpr, SMTExpr> & Serializable)e -> MODULE$.replaceSymbols(suffix, arg, set, (SMTExpr)e));
    }

    private Set<String> replaceSymbols$default$3() {
        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
    }

    private final void declare$1(SMTSymbol sym, String kind, ArrayBuffer cmds$1, TransitionSystem sys$1, UTSymbol State$1) {
        cmds$1.$plus$plus$eq(this.toDescription(sym, kind, (Function1<String, Option<String>>)(Function1<String, Option> & Serializable)key -> sys$1.comments().get((String)key)));
        SMTSymbol s = SMTSymbol$.MODULE$.fromExpr(new StringBuilder(0).append(sym.name()).append(this.SignalSuffix()).toString(), sym);
        cmds$1.$plus$eq(new DeclareFunction(s, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UTSymbol[]{State$1}))));
    }

    private final void define$1(SMTSymbol sym, SMTExpr e, String suffix, UTSymbol State$1, ArrayBuffer cmds$1) {
        SMTExpr withReplacedSymbols = this.replaceSymbols(this.SignalSuffix(), State$1, this.replaceSymbols$default$3(), e);
        cmds$1.$plus$eq(new DefineFunction(new StringBuilder(0).append(sym.name()).append(suffix).toString(), (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new UTSymbol[]{State$1})), withReplacedSymbols));
    }

    private final String define$default$3$1() {
        return this.SignalSuffix();
    }

    public static final /* synthetic */ void $anonfun$encode$4(SMTTransitionSystemEncoder$ $this, ArrayBuffer cmds$1, TransitionSystem sys$1, UTSymbol State$1, Signal signal) {
        SMTSymbol sym = signal.sym();
        cmds$1.$plus$plus$eq(MODULE$.toDescription(sym, MODULE$.lblToKind(signal.lbl()), (Function1<String, Option<String>>)(Function1<String, Option> & Serializable)key -> sys$1.comments().get((String)key)));
        SignalLabel signalLabel = signal.lbl();
        IsBad$ isBad$ = IsBad$.MODULE$;
        SMTExpr e = !(signalLabel != null ? !signalLabel.equals(isBad$) : isBad$ != null) ? BVNot$.MODULE$.apply((BVExpr)signal.e()) : signal.e();
        $this.define$1(sym, e, $this.define$default$3$1(), State$1, cmds$1);
    }

    public static final /* synthetic */ void $anonfun$encode$6(SMTTransitionSystemEncoder$ $this, UTSymbol State$1, ArrayBuffer cmds$1, State state) {
        Predef$.MODULE$.assert(state.next().nonEmpty(), (Function0<Object>)(Function0<String> & Serializable)() -> "Next function required");
        $this.define$1(state.sym(), state.next().get(), MODULE$.NextSuffix(), State$1, cmds$1);
        state.init().foreach((Function1<SMTExpr, Object> & Serializable)init -> {
            $this.define$1(state.sym(), init, SMTTransitionSystemEncoder$.MODULE$.InitSuffix(), State$1, cmds$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void defineConjunction$1(List e, String suffix, String name$1, UTSymbol State$1, ArrayBuffer cmds$1) {
        this.define$1(new BVSymbol(name$1, 1), e.isEmpty() ? True$.MODULE$.apply() : BVAnd$.MODULE$.apply(e), suffix, State$1, cmds$1);
    }

    public static final /* synthetic */ boolean $anonfun$encode$10(State x$1) {
        return x$1.init().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$encode$12(Signal x$2) {
        SignalLabel signalLabel = x$2.lbl();
        IsBad$ isBad$ = IsBad$.MODULE$;
        return !(signalLabel != null ? !signalLabel.equals(isBad$) : isBad$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$encode$15(Signal x$4) {
        SignalLabel signalLabel = x$4.lbl();
        IsConstraint$ isConstraint$ = IsConstraint$.MODULE$;
        return !(signalLabel != null ? !signalLabel.equals(isConstraint$) : isConstraint$ != null);
    }

    private SMTTransitionSystemEncoder$() {
    }
}

