import Bluebird from "bluebird";
export interface Defer<T> {
    resolve: (value?: T) => void;
    reject: (err?: unknown) => void;
    promise: Bluebird<T>;
}
export declare function defer<T>(): Defer<T>;
/**
 * A Promise that delays the execution by a number of milliseconds.
 * This is a suitable replacement for Bluebird.delay().
 * @param ms The duration in milliseconds
 */
export declare function delay(ms: number): Promise<void>;
