/*
 * AT-SPI - Assistive Technology Service Provider Interface
 * (Gnome Accessibility Project; http://developer.gnome.org/projects/gap)
 *
 * Copyright 2023 SUSE LLC.
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _ATSPI_VERSION_H_
#define _ATSPI_VERSION_H_

G_BEGIN_DECLS

/**
 * ATSPI_MAJOR_VERSION:
 *
 * The major version of AT-SPI used at compile time.
 *
 * Since: 2.50.0
 */
#define ATSPI_MAJOR_VERSION (2)

/**
 * ATSPI_MINOR_VERSION:
 *
 * The minor version of AT-SPI used at compile time.
 *
 * Since: 2.50.0
 */
#define ATSPI_MINOR_VERSION (51)

/**
 * ATSPI_MICRO_VERSION:
 *
 * The micro version / patch level of AT-SPI used at compile time.
 *
 * Since: 2.50.0
 */
#define ATSPI_MICRO_VERSION (90)

G_END_DECLS

#endif /* _ATSPI_VERSION_H_ */
