# Copyright (c) 2017-2021 Advanced Micro Devices, Inc. All rights reserved.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.

# rocrand-config.cmake
# ---------
#
# Finds rocRAND include directory and library.
#
# Use this module by invoking find_package with the form:
#
#   find_package(rocrand
#     [version] [EXACT]           # Minimum or EXACT version e.g. 0.5.0
#     [REQUIRED]                  # Fail with error if rocRAND is not found
#     CONFIG                      # Enable Config mode (might be required)
#     [PATHS path1 [path2 ... ]]  # Path to install dir (e.g. /opt/rocm/rocrand)
#   )
#
# The following variables are defined when rocRAND is found:
#
#   rocrand_FOUND            - True if rocRAND headers and library were found.
#   rocrand_INCLUDE_DIRS     - rocRAND include directory.
#   rocrand_LIBRARY_DIRS     - Link directory for rocRAND library.
#   rocrand_LIBRARIES        - rocRAND library to be linked.
#   rocrand_VERSION          - ROCRAND_VERSION value from rocrand.h.
#
#   rocrand_FORTRAN_FOUND    - True if rocRAND was built with Fortran wrapper; otherwise - false.
#   rocrand_FORTRAN_SRC_DIRS - Directory with rocRAND Fortran wrapper sources rocrand_m.f90
#                              and hip_m.f90. Include those source files, and add "use rocrand_m"
#                              statement into your Fortran code.
#
# Example (requires HIP):
#
#    // First find and include HIP
#    // See https://github.com/ROCm-Developer-Tools/HIP
#    find_package(rocrand REQUIRED CONFIG PATHS "/opt/rocm/rocrand")
#    add_executable(foo foo.cpp)
#    // Set HIP flags, add HIP includes
#    // Link foo against HIP or CUDA lib (see hipconfig)
#    target_link_libraries(foo roc::rocrand)
#
#    # Using Fortran wrapper
#    set(bar_SRCS
#      bar.f90
#      /hip_m.f90
#      /rocrand_m.f90
#    )
#
#    add_executable(bar )
#    // Link bar against HIP or CUDA library (see hipconfig)
#    target_link_libraries(bar roc::rocrand)
#

# Fortran wrapper
if(OFF)
    set_and_check(rocrand_FORTRAN_SRC_DIR "/opt/rocm/rocrand/src/fortran")
    set_and_check(rocrand_FORTRAN_SRC_DIRS "/opt/rocm/rocrand/src/fortran")
    set(rocrand_FORTRAN_FOUND YES)
else()
    set(rocrand_FORTRAN_FOUND NOTFOUND)
endif()
