// Copyright (c) 2022 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

#ifndef ROCRAND_HIP_CPU_H_
#define ROCRAND_HIP_CPU_H_

/* Check if hip-cpu is used */
/* #undef USE_HIP_CPU */
#ifdef USE_HIP_CPU

    /* Define if there is hipRuntimeGetVersion() function in HIP */
/* #undef HAVE_HIP_RUNTIME_GET_VERSION */

    #ifndef HAVE_HIP_RUNTIME_GET_VERSION
        #define HAVE_HIP_RUNTIME_GET_VERSION
        #include "hip/hip_runtime.h"

inline hipError_t hipRuntimeGetVersion(int* runtimeVersion)
{
    *runtimeVersion = 99999;
    return hipSuccess;
}

    #endif //HAVE_HIP_RUNTIME_GET_VERSION

    /* Define if there is min() function in HIP */
/* #undef HAVE_HIP_MATH */

    #ifndef HAVE_HIP_MATH
        #define HAVE_HIP_MATH
        #include <algorithm>

template<typename T>
inline const T& min(const T& a, const T& b)
{
    return std::min<T>(a, b);
}

    #endif //HAVE_HIP_MATH
#endif //USE_HIP_CPU
#endif //ROCRAND_HIP_CPU_H_
