/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplate> {
    private static final SdkField<String> LAUNCH_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateId").getter(LaunchTemplate.getter(LaunchTemplate::launchTemplateId)).setter(LaunchTemplate.setter(Builder::launchTemplateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateId").unmarshallLocationName("launchTemplateId").build()}).build();
    private static final SdkField<String> LAUNCH_TEMPLATE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LaunchTemplateName").getter(LaunchTemplate.getter(LaunchTemplate::launchTemplateName)).setter(LaunchTemplate.setter(Builder::launchTemplateName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateName").unmarshallLocationName("launchTemplateName").build()}).build();
    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateTime").getter(LaunchTemplate.getter(LaunchTemplate::createTime)).setter(LaunchTemplate.setter(Builder::createTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime").unmarshallLocationName("createTime").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(LaunchTemplate.getter(LaunchTemplate::createdBy)).setter(LaunchTemplate.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").unmarshallLocationName("createdBy").build()}).build();
    private static final SdkField<Long> DEFAULT_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("DefaultVersionNumber").getter(LaunchTemplate.getter(LaunchTemplate::defaultVersionNumber)).setter(LaunchTemplate.setter(Builder::defaultVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultVersionNumber").unmarshallLocationName("defaultVersionNumber").build()}).build();
    private static final SdkField<Long> LATEST_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LatestVersionNumber").getter(LaunchTemplate.getter(LaunchTemplate::latestVersionNumber)).setter(LaunchTemplate.setter(Builder::latestVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionNumber").unmarshallLocationName("latestVersionNumber").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(LaunchTemplate.getter(LaunchTemplate::tags)).setter(LaunchTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_ID_FIELD, LAUNCH_TEMPLATE_NAME_FIELD, CREATE_TIME_FIELD, CREATED_BY_FIELD, DEFAULT_VERSION_NUMBER_FIELD, LATEST_VERSION_NUMBER_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String launchTemplateId;
    private final String launchTemplateName;
    private final Instant createTime;
    private final String createdBy;
    private final Long defaultVersionNumber;
    private final Long latestVersionNumber;
    private final List<Tag> tags;

    private LaunchTemplate(BuilderImpl builder) {
        this.launchTemplateId = builder.launchTemplateId;
        this.launchTemplateName = builder.launchTemplateName;
        this.createTime = builder.createTime;
        this.createdBy = builder.createdBy;
        this.defaultVersionNumber = builder.defaultVersionNumber;
        this.latestVersionNumber = builder.latestVersionNumber;
        this.tags = builder.tags;
    }

    public final String launchTemplateId() {
        return this.launchTemplateId;
    }

    public final String launchTemplateName() {
        return this.launchTemplateName;
    }

    public final Instant createTime() {
        return this.createTime;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Long defaultVersionNumber() {
        return this.defaultVersionNumber;
    }

    public final Long latestVersionNumber() {
        return this.latestVersionNumber;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.latestVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplate)) {
            return false;
        }
        LaunchTemplate other = (LaunchTemplate)obj;
        return Objects.equals(this.launchTemplateId(), other.launchTemplateId()) && Objects.equals(this.launchTemplateName(), other.launchTemplateName()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.defaultVersionNumber(), other.defaultVersionNumber()) && Objects.equals(this.latestVersionNumber(), other.latestVersionNumber()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplate").add("LaunchTemplateId", (Object)this.launchTemplateId()).add("LaunchTemplateName", (Object)this.launchTemplateName()).add("CreateTime", (Object)this.createTime()).add("CreatedBy", (Object)this.createdBy()).add("DefaultVersionNumber", (Object)this.defaultVersionNumber()).add("LatestVersionNumber", (Object)this.latestVersionNumber()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateId": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateId()));
            }
            case "LaunchTemplateName": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateName()));
            }
            case "CreateTime": {
                return Optional.ofNullable(clazz.cast(this.createTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "DefaultVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.defaultVersionNumber()));
            }
            case "LatestVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.latestVersionNumber()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplate, T> g) {
        return obj -> g.apply((LaunchTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchTemplateId;
        private String launchTemplateName;
        private Instant createTime;
        private String createdBy;
        private Long defaultVersionNumber;
        private Long latestVersionNumber;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplate model) {
            this.launchTemplateId(model.launchTemplateId);
            this.launchTemplateName(model.launchTemplateName);
            this.createTime(model.createTime);
            this.createdBy(model.createdBy);
            this.defaultVersionNumber(model.defaultVersionNumber);
            this.latestVersionNumber(model.latestVersionNumber);
            this.tags(model.tags);
        }

        public final String getLaunchTemplateId() {
            return this.launchTemplateId;
        }

        public final void setLaunchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
        }

        @Override
        public final Builder launchTemplateId(String launchTemplateId) {
            this.launchTemplateId = launchTemplateId;
            return this;
        }

        public final String getLaunchTemplateName() {
            return this.launchTemplateName;
        }

        public final void setLaunchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
        }

        @Override
        public final Builder launchTemplateName(String launchTemplateName) {
            this.launchTemplateName = launchTemplateName;
            return this;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Long getDefaultVersionNumber() {
            return this.defaultVersionNumber;
        }

        public final void setDefaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
        }

        @Override
        public final Builder defaultVersionNumber(Long defaultVersionNumber) {
            this.defaultVersionNumber = defaultVersionNumber;
            return this;
        }

        public final Long getLatestVersionNumber() {
            return this.latestVersionNumber;
        }

        public final void setLatestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        public final Builder latestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LaunchTemplate build() {
            return new LaunchTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplate> {
        public Builder launchTemplateId(String var1);

        public Builder launchTemplateName(String var1);

        public Builder createTime(Instant var1);

        public Builder createdBy(String var1);

        public Builder defaultVersionNumber(Long var1);

        public Builder latestVersionNumber(Long var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

