/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch.subphase;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.opensearch.search.fetch.FetchContext;
import org.opensearch.search.fetch.FetchSubPhase;
import org.opensearch.search.fetch.FetchSubPhaseProcessor;

public final class SeqNoPrimaryTermPhase
implements FetchSubPhase {
    @Override
    public FetchSubPhaseProcessor getProcessor(FetchContext context) {
        if (!context.seqNoAndPrimaryTerm()) {
            return null;
        }
        return new FetchSubPhaseProcessor(){
            NumericDocValues seqNoField = null;
            NumericDocValues primaryTermField = null;

            @Override
            public void setNextReader(LeafReaderContext readerContext) throws IOException {
                this.seqNoField = readerContext.reader().getNumericDocValues("_seq_no");
                this.primaryTermField = readerContext.reader().getNumericDocValues("_primary_term");
            }

            @Override
            public void process(FetchSubPhase.HitContext hitContext) throws IOException {
                int docId = hitContext.docId();
                long seqNo = -2L;
                long primaryTerm = 0L;
                if (this.primaryTermField != null && this.primaryTermField.advanceExact(docId)) {
                    boolean found = this.seqNoField.advanceExact(docId);
                    assert (found) : "found seq no for " + docId + " but not a primary term";
                    seqNo = this.seqNoField.longValue();
                    primaryTerm = this.primaryTermField.longValue();
                }
                hitContext.hit().setSeqNo(seqNo);
                hitContext.hit().setPrimaryTerm(primaryTerm);
            }
        };
    }
}

