/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.fetch;

import java.io.IOException;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.SearchPhaseResult;
import org.opensearch.search.SearchShardTarget;
import org.opensearch.search.internal.ShardSearchContextId;
import org.opensearch.search.query.QuerySearchResult;

@PublicApi(since="1.0.0")
public final class FetchSearchResult
extends SearchPhaseResult {
    private SearchHits hits;
    private transient int counter;

    public FetchSearchResult() {
    }

    public FetchSearchResult(StreamInput in) throws IOException {
        super(in);
        this.contextId = new ShardSearchContextId(in);
        this.hits = new SearchHits(in);
    }

    public FetchSearchResult(ShardSearchContextId id, SearchShardTarget shardTarget) {
        this.contextId = id;
        this.setSearchShardTarget(shardTarget);
    }

    @Override
    public QuerySearchResult queryResult() {
        return null;
    }

    @Override
    public FetchSearchResult fetchResult() {
        return this;
    }

    public void hits(SearchHits hits) {
        assert (this.assertNoSearchTarget(hits));
        this.hits = hits;
    }

    private boolean assertNoSearchTarget(SearchHits hits) {
        for (SearchHit hit : hits.getHits()) {
            assert (hit.getShard() == null) : "expected null but got: " + hit.getShard();
        }
        return true;
    }

    public SearchHits hits() {
        return this.hits;
    }

    public FetchSearchResult initCounter() {
        this.counter = 0;
        return this;
    }

    public int counterGetAndIncrement() {
        return this.counter++;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.contextId.writeTo(out);
        this.hits.writeTo(out);
    }
}

