/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.repositories;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.repositories.IndexId;
import org.opensearch.snapshots.SnapshotId;

@PublicApi(since="1.0.0")
public final class IndexMetaDataGenerations {
    public static final IndexMetaDataGenerations EMPTY = new IndexMetaDataGenerations(Collections.emptyMap(), Collections.emptyMap());
    final Map<SnapshotId, Map<IndexId, String>> lookup;
    final Map<String, String> identifiers;

    IndexMetaDataGenerations(Map<SnapshotId, Map<IndexId, String>> lookup, Map<String, String> identifiers) {
        assert (identifiers.keySet().equals(lookup.values().stream().flatMap(m -> m.values().stream()).collect(Collectors.toSet()))) : "identifier mappings " + identifiers + " don't track the same blob ids as the lookup map " + lookup;
        assert (lookup.values().stream().noneMatch(Map::isEmpty)) : "Lookup contained empty map [" + lookup + "]";
        this.lookup = Collections.unmodifiableMap(lookup);
        this.identifiers = Collections.unmodifiableMap(identifiers);
    }

    public boolean isEmpty() {
        return this.identifiers.isEmpty();
    }

    @Nullable
    public String getIndexMetaBlobId(String metaIdentifier) {
        return this.identifiers.get(metaIdentifier);
    }

    public String indexMetaBlobId(SnapshotId snapshotId, IndexId indexId) {
        String identifier = (String)this.lookup.getOrDefault(snapshotId, Collections.emptyMap()).get(indexId);
        if (identifier == null) {
            return snapshotId.getUUID();
        }
        return this.identifiers.get(identifier);
    }

    public IndexMetaDataGenerations withAddedSnapshot(SnapshotId snapshotId, Map<IndexId, String> newLookup, Map<String, String> newIdentifiers) {
        HashMap<SnapshotId, Map<IndexId, String>> updatedIndexMetaLookup = new HashMap<SnapshotId, Map<IndexId, String>>(this.lookup);
        HashMap<String, String> updatedIndexMetaIdentifiers = new HashMap<String, String>(this.identifiers);
        updatedIndexMetaIdentifiers.putAll(newIdentifiers);
        updatedIndexMetaLookup.compute(snapshotId, (snId, lookup) -> {
            if (lookup == null) {
                if (newLookup.isEmpty()) {
                    return null;
                }
                return Collections.unmodifiableMap(new HashMap(newLookup));
            }
            HashMap updated = new HashMap(lookup);
            updated.putAll(newLookup);
            return Collections.unmodifiableMap(updated);
        });
        return new IndexMetaDataGenerations(updatedIndexMetaLookup, updatedIndexMetaIdentifiers);
    }

    public IndexMetaDataGenerations withRemovedSnapshots(Collection<SnapshotId> snapshotIds) {
        HashMap<SnapshotId, Map<IndexId, String>> updatedIndexMetaLookup = new HashMap<SnapshotId, Map<IndexId, String>>(this.lookup);
        updatedIndexMetaLookup.keySet().removeAll(snapshotIds);
        HashMap<String, String> updatedIndexMetaIdentifiers = new HashMap<String, String>(this.identifiers);
        updatedIndexMetaIdentifiers.keySet().removeIf(k -> updatedIndexMetaLookup.values().stream().noneMatch(identifiers -> identifiers.containsValue(k)));
        return new IndexMetaDataGenerations(updatedIndexMetaLookup, updatedIndexMetaIdentifiers);
    }

    public int hashCode() {
        return Objects.hash(this.identifiers, this.lookup);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof IndexMetaDataGenerations)) {
            return false;
        }
        IndexMetaDataGenerations other = (IndexMetaDataGenerations)that;
        return this.lookup.equals(other.lookup) && this.identifiers.equals(other.identifiers);
    }

    public String toString() {
        return "IndexMetaDataGenerations{lookup:" + this.lookup + "}{identifier:" + this.identifiers + "}";
    }

    public static String buildUniqueIdentifier(IndexMetadata indexMetaData) {
        return indexMetaData.getIndexUUID() + "-" + indexMetaData.getSettings().get("index.history.uuid", "_na_") + "-" + indexMetaData.getSettingsVersion() + "-" + indexMetaData.getMappingVersion() + "-" + indexMetaData.getAliasesVersion();
    }
}

