/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ratelimitting.admissioncontrol;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.node.ResourceUsageCollectorService;
import org.opensearch.ratelimitting.admissioncontrol.AdmissionControlSettings;
import org.opensearch.ratelimitting.admissioncontrol.controllers.AdmissionController;
import org.opensearch.ratelimitting.admissioncontrol.controllers.CpuBasedAdmissionController;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.opensearch.ratelimitting.admissioncontrol.stats.AdmissionControlStats;
import org.opensearch.ratelimitting.admissioncontrol.stats.AdmissionControllerStats;
import org.opensearch.threadpool.ThreadPool;

public class AdmissionControlService {
    private final ThreadPool threadPool;
    public final AdmissionControlSettings admissionControlSettings;
    private final ConcurrentMap<String, AdmissionController> admissionControllers;
    private static final Logger logger = LogManager.getLogger(AdmissionControlService.class);
    private final ClusterService clusterService;
    private final Settings settings;
    private final ResourceUsageCollectorService resourceUsageCollectorService;

    public AdmissionControlService(Settings settings, ClusterService clusterService, ThreadPool threadPool, ResourceUsageCollectorService resourceUsageCollectorService) {
        this.threadPool = threadPool;
        this.admissionControlSettings = new AdmissionControlSettings(clusterService.getClusterSettings(), settings);
        this.admissionControllers = new ConcurrentHashMap<String, AdmissionController>();
        this.clusterService = clusterService;
        this.settings = settings;
        this.resourceUsageCollectorService = resourceUsageCollectorService;
        this.initialise();
    }

    private void initialise() {
        this.registerAdmissionController("global_cpu_usage");
    }

    public void applyTransportAdmissionControl(String action, AdmissionControlActionType admissionControlActionType) {
        this.admissionControllers.forEach((name, admissionController) -> admissionController.apply(action, admissionControlActionType));
    }

    public void registerAdmissionController(String admissionControllerName) {
        AdmissionController admissionController = this.controllerFactory(admissionControllerName);
        this.admissionControllers.put(admissionControllerName, admissionController);
    }

    private AdmissionController controllerFactory(String admissionControllerName) {
        switch (admissionControllerName) {
            case "global_cpu_usage": {
                return new CpuBasedAdmissionController(admissionControllerName, this.resourceUsageCollectorService, this.clusterService, this.settings);
            }
        }
        throw new IllegalArgumentException("Not Supported AdmissionController : " + admissionControllerName);
    }

    public List<AdmissionController> getAdmissionControllers() {
        return new ArrayList<AdmissionController>(this.admissionControllers.values());
    }

    public AdmissionController getAdmissionController(String controllerName) {
        return this.admissionControllers.getOrDefault(controllerName, null);
    }

    public AdmissionControlStats stats() {
        ArrayList<AdmissionControllerStats> statsList = new ArrayList<AdmissionControllerStats>();
        if (this.admissionControllers.size() > 0) {
            this.admissionControllers.forEach((controllerName, admissionController) -> {
                AdmissionControllerStats admissionControllerStats = new AdmissionControllerStats((AdmissionController)admissionController);
                statsList.add(admissionControllerStats);
            });
            return new AdmissionControlStats(statsList);
        }
        return null;
    }
}

