/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ingest;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.Version;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.Diff;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ContextParser;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;

@PublicApi(since="1.0.0")
public final class PipelineConfiguration
extends AbstractDiffable<PipelineConfiguration>
implements ToXContentObject {
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("pipeline_config", true, () -> new Builder());
    private final String id;
    private final BytesReference config;
    private final MediaType mediaType;

    public static ContextParser<Void, PipelineConfiguration> getParser() {
        return (parser, context) -> ((Builder)PARSER.apply(parser, null)).build();
    }

    public PipelineConfiguration(String id, BytesReference config, MediaType mediaType) {
        this.id = Objects.requireNonNull(id);
        this.config = Objects.requireNonNull(config);
        this.mediaType = Objects.requireNonNull(mediaType);
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getConfigAsMap() {
        return (Map)XContentHelper.convertToMap(this.config, true, this.mediaType).v2();
    }

    MediaType getMediaType() {
        return this.mediaType;
    }

    BytesReference getConfig() {
        return this.config;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("id", this.id);
        builder.field("config", this.getConfigAsMap());
        builder.endObject();
        return builder;
    }

    public static PipelineConfiguration readFrom(StreamInput in) throws IOException {
        return new PipelineConfiguration(in.readString(), in.readBytesReference(), in.getVersion().onOrAfter(Version.V_2_10_0) ? in.readMediaType() : (MediaType)in.readEnum(XContentType.class));
    }

    public static Diff<PipelineConfiguration> readDiffFrom(StreamInput in) throws IOException {
        return PipelineConfiguration.readDiffFrom(PipelineConfiguration::readFrom, in);
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeBytesReference(this.config);
        if (out.getVersion().onOrAfter(Version.V_2_10_0)) {
            this.mediaType.writeTo(out);
        } else {
            out.writeEnum((Enum)((XContentType)this.mediaType));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PipelineConfiguration that = (PipelineConfiguration)o;
        if (!this.id.equals(that.id)) {
            return false;
        }
        return this.getConfigAsMap().equals(that.getConfigAsMap());
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.getConfigAsMap().hashCode();
        return result;
    }

    static {
        PARSER.declareString(Builder::setId, new ParseField("id", new String[0]));
        PARSER.declareField((parser, builder, aVoid) -> {
            XContentBuilder contentBuilder = XContentBuilder.builder((XContent)parser.contentType().xContent());
            contentBuilder.generator().copyCurrentStructure(parser);
            builder.setConfig(BytesReference.bytes((XContentBuilder)contentBuilder), contentBuilder.contentType());
        }, new ParseField("config", new String[0]), ObjectParser.ValueType.OBJECT);
    }

    private static class Builder {
        private String id;
        private BytesReference config;
        private MediaType mediaType;

        private Builder() {
        }

        void setId(String id) {
            this.id = id;
        }

        void setConfig(BytesReference config, MediaType mediaType) {
            if (!(mediaType instanceof XContentType)) {
                throw new IllegalArgumentException("PipelineConfiguration does not support media type [" + mediaType.getClass() + "]");
            }
            this.config = config;
            this.mediaType = mediaType;
        }

        PipelineConfiguration build() {
            return new PipelineConfiguration(this.id, this.config, this.mediaType);
        }
    }
}

